<?php 
include("connect.php");
include("session.php");

$order = new Order($_REQUEST['order']);

//validate so the user can't see other customers orders
if ($_SESSION['isCustomer']) {
	$customer = new Customer($_SESSION['AccountNumber']);	
	if ($order->Customer->AccountNumber != $customer->AccountNumber) {
		header("Location: index.php");
	}
}else {
	$salesman = new Salesman($_SESSION['SalesmanID']);
	if ($order->Salesman->ID != $salesman->ID) {
		header("Location: index.php");
	}
}

 ?>
 <!DOCTYPE html>
  <html lang="en">
    <head>
      <meta charset="utf-8">
      <meta http-equiv="X-UA-Compatible" content="IE=edge">
      <meta name="viewport" content="width=device-width, initial-scale=1">
      <title><?= $config['CompanyName'] ?></title>
  
      <!-- Bootstrap -->
      <link href="<?= $root ?>css/bootstrap.min.css" rel="stylesheet">
      <link rel="stylesheet" href="<?= $root ?>css/bootstrap-combobox.css" />
  
      <!-- HTML5 shim and Respond.js for IE8 support of HTML5 elements and media queries -->
      <!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
      <!--[if lt IE 9]>
        <script src="http://oss.maxcdn.com/html5shiv/3.7.2/html5shiv.min.js"></script>
        <script src="http://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
        <!-- jQuery (necessary for Bootstrap's JavaScript plugins) -->
            <script src="http://ajax.googleapis.com/ajax/libs/jquery/1.11.1/jquery.min.js"></script>
            <!-- Include all compiled plugins (below), or include individual files as needed -->
            <script src="<?= $root ?>js/bootstrap.min.js"></script>
        	 <script src="<?= $root ?>js/bootstrap-combobox.js"></script>
            <script type="text/javascript">
              $(document).ready(function(){
                $('.combobox').combobox();
        //        $('.grpline').css("width", "100px");
              });
            </script>
 
      <![endif]-->
 	<link rel="stylesheet" href="<?= $root ?>css/styles.css"/>
	<style>
		.TotalsSection, .TotalsSection td {
			border: none;
		}
	</style>
    </head>
    <body>
    
        <?php 
        		include("navbar.php"); 
        		
 
        ?>     
 
    
    <!-- Stack the columns on mobile by making one full-width and the other half-width -->
 <div class="container-fluid" style="padding-top: 5px;">
 	<div class="row">
 	  <div class="col-xs-5">
 	  	<img class="img-responsive" style="width: 200px;" src="<?= $root ?>img/<?= $config['Logo'] ?>" alt="" />
 	  	<p>
 	  		<b>Customer Name: </b><?= $order->Customer->Name; ?><br>
 	  		<b>City: </b><?= $order->Customer->City; ?><br>
 	  		<b>Customer #: </b><?= $order->Customer->AccountNumber ?><br />
 	  		<b>PO Number: </b><?= $order->PONumber ?><br>
 	  		<b>Delivery Method: </b><?= $order->DeliveryMethod ?><br>
 	  
 	  </p>
 	  
 	  </div>
  	  <div class="col-xs-2"></div>
 	  <div class="col-xs-5">
 		  <h3>Order Confirmation</h3>
 		  <p>
 		  	<b>Order Number: </b><span style="font-style: italic;"><?= $order->OrderID ?></span><br>
 			
 		  	<b>Order By: </b> <?= ($order->SalesmanOrder == "0")?"Customer":"Salesman" ?><br>
 		  <b>Date: </b><?= date("m/d/Y",strtotime($order->OrderDate)) ?><br>
 		  <b>Time: </b><?= date("g:i a",strtotime($order->OrderDate)) ?><br>
 		  <b>Salesman: </b> <?= $order->Salesman->ID . " - " . $order->Salesman->Name ?><br>
 		  </p>
 	  </div>
 	  <table class="table table-condensed">
 	    <thead>
 	      <tr>
 	        <th style="width: 5%">Line<br>Group</th>
 	        <th style="width: 70%">Item</th>
 	        <th style="width: 5%">Order Quantity</th>
 	        <th style="width: 5%">Price</th>
 	        <th style="width: 5%">Extension</th>
 	      </tr>
 	    </thead>
 	  	<tbody>
 	  	<?php
 	  		$query = "SELECT * FROM ORDER_DETAIL WHERE OrderID = '$order->OrderID'";
 	  		$result = mysqli_query($con, $query);
 	  		$index = 0;
 	  		while ($row = mysqli_fetch_array($result)) {
 	  	?>
 	  		<tr>
 	    			<td>
 	        			<span class="itemInfo"><?= $row['Line'] ?></span>
 	        			<span class="itemInfo"><?= $row['Group'] ?></span>
 	        		</td>
 	        		<td>
 	        			<span class="itemInfo"><b><?= $row['SKU'] ?></b></span><br />
 	        			<span class="itemInfo"><?= $row['Description'] ?></span>
 	        			<span class="itemInfo"><?= $row['Notes'] ?></span>
 	        		</td>
 	        		<td class="centered">
 	        			<?= $row['OrderQty'] ?>
 	        		</td>
 	        		<td>
 	        			<?= moneyFormat($row['Price']); ?>
 	        			<?php 
 	        				if(floatval($row['Core'])>0){
 	        					echo "<br><i><b>Core:</b> ". moneyFormat($row['Core']) . "</i>";
 	        				}
 	        			?>
 	        		</td>
 	        		<td>
 	        			<?= moneyFormat($row['OrderQty'] * $row['Price']) ?>
 	        			<?php 
 	        				if(floatval($row['Core'])>0){
 	        					echo "<br><i><b>Core:</b> ". moneyFormat($row['OrderQty'] * $row['Core']) . "</i>";
 	        				}
 	        			?>
 	        		</td>
 	      	</tr>
 	      	<?php 
 	      	$index++;	 
 	      	$tax1 = $order->OrderTotal*($order->Customer->TaxExempt1?0:$config['Tax1Rate']);
			$tax2 = $order->OrderTotal*($order->Customer->TaxExempt2?0:$config['Tax2Rate']);
 	      	}?>
 	      	<tr class="TotalsSection">
				
 	      		<td></td>
 	      		<td></td>
 	      		
 	      		<td colspan="2" style="font-weight: bold; text-align: right;"><span>Subtotal</span></td>
 	      		<td><span style="font-weight: bold;"><?= moneyFormat($order->OrderTotal) ?></span></td>
 	      	</tr>
			<tr class="TotalsSection">
 	      		<td></td>
 	      		<td></td>
 	      		
 	      		<td colspan="2" style="font-weight: bold; text-align: right;"><span><?= $config['Tax1Name'] ?></span></td>
 	      		<td><span style="font-weight: bold;"><?= moneyFormat($tax1) ?></span></td>
 	      	</tr>
			<tr class="TotalsSection">
 	      		<td></td>
 	      		<td></td>
 	      		
 	      		<td colspan="2" style="font-weight: bold; text-align: right;"><span><?= $config['Tax2Name'] ?></span></td>
 	      		<td><span style="font-weight: bold;"><?= moneyFormat($tax2) ?></span></td>
 	      	</tr>
			<tr class="TotalsSection">
 	      		<td></td>
 	      		<td></td>
 	      		
 	      		<td colspan="2" style="font-weight: bold; text-align: right;"><span>Total</span></td>
 	      		<td><span style="font-weight: bold;"><?= moneyFormat($order->OrderTotal + $tax1 + $tax2) ?></span></td>
 	      	</tr>
 	      </tr>
 	    </tbody>
 	  </table>
 	</div>
 	
 
 </div>
        <div class="panel panel-default">
          <div class="panel-body">
            <span><b>Order Notes:</b></span><br />
            <?= $order->OrderNotes ?>
          </div>
        </div>
        
      
    </body>
  </html>