<?php 
include_once("../connect.php");
include_once("../session.php");

$webTitle = "View Ticket";
$ticket = new Ticket($_REQUEST['tid']);
$ticket->User = new Administrator($ticket->Username);
 ?>
 
 <!DOCTYPE html>
 <html lang="en">
   <head>
     <meta charset="utf-8">
     <meta http-equiv="X-UA-Compatible" content="IE=edge">
     <meta name="viewport" content="width=device-width, initial-scale=1">
     <title><?= $config['CompanyName'] ?> - <?= $webTitle ?></title>
 
     <!-- Bootstrap -->
     <link href="../css/bootstrap.min.css" rel="stylesheet">
     <link rel="stylesheet" href="../css/bootstrap-combobox.css" />
 
     <!-- HTML5 shim and Respond.js for IE8 support of HTML5 elements and media queries -->
     <!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
     <!--[if lt IE 9]>
       <script src="https://oss.maxcdn.com/html5shiv/3.7.2/html5shiv.min.js"></script>
       <script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
       <!-- jQuery (necessary for Bootstrap's JavaScript plugins) -->
           <script src="https://ajax.googleapis.com/ajax/libs/jquery/1.11.1/jquery.min.js"></script>
           <!-- Include all compiled plugins (below), or include individual files as needed -->
           <script src="../js/bootstrap.min.js"></script>
       	 <script src="../js/bootstrap-combobox.js"></script>
       	 <script src="../js/excellentexport.js"></script>
           <script type="text/javascript">
             $(document).ready(function(){
       //        $('.grpline').css("width", "100px");
             });
           </script>

     <![endif]-->
	<link rel="stylesheet" href="../css/styles.css"/>
   </head>
   <body>
   
       <?php
	   //error_reporting(E_ALL);
	   include("navbar.php"); ?>     

   
   <!-- Stack the columns on mobile by making one full-width and the other half-width -->
<div class="container " style="padding-top: 10px;">
	<div class="panel panel-default">
	  <div class="panel-heading form-inline">	  	
	  	<h2 class="panel-title">Ticket <?= $ticket->TicketID ?></h2><br />
			<table class="table">
				<tbody>
					<tr>
						<td><b>Date Opened: </b></td>
						<td><?= date("m/d/Y h:m a", strtotime($ticket->TicketDate)) ?></td>
						<td><b>Opened By: </b></td>
						<td><?= $ticket->User->Name ?></td>
					</tr>
					<tr>
						<td><b>Priority: </b></td>
						<td>
							<select onchange="changePriority();" <?= ($ticket->Status==2 || $ticket->Status==-1)?"readonly disabled":"" ?> class="form-control" name="TicketPriority" id="TicketPriority">
								<option <?= $ticket->Priority==1?"selected":"" ?> value="1">Top Priority</option>
								<option <?= $ticket->Priority==2?"selected":"" ?> value="2">Normal Priority</option>
								<option <?= $ticket->Priority==3?"selected":"" ?> value="3">Low Priority</option>	
							</select>
						</td>
						<td><b>Status: </b></td>
						<td>
						<select onchange="changeStatus();" class="form-control" <?= ($ticket->Status==2 || $ticket->Status==-1)?"readonly disabled":"" ?> name="TicketStatus" id="TicketStatus">
								<option <?= $ticket->Status==0?"selected":"" ?> value="0">Open</option>
								<option <?= $ticket->Status==2?"selected":"" ?> value="2">Done</option>
								<option <?= $ticket->Status==-1?"selected":"" ?> value="-1">Deleted</option>
							</select>
						
					</tr>
				</tbody>
			</table>
			<div style="font-size: 16px;">
				
			<b>Subject: </b><?= $ticket->Subject ?><br>
			<b>Message: </b><?= $ticket->Contents ?><br>
			</div>
	  </div>
	  <div class="panel-body">
	  	<table class="table table-hover table-condensed" id="purchaseorders">
	  		<thead>
	  			<tr>
	  				<th style="width:15%;">User</th>
						<th style="width: 15%;">Date / Time</th>
						<th style="width: 65%;">Message</th>
						<th style="width: 5%;"></th>
	  			</tr>
	  		</thead>
			<tbody>
	    <?php
				foreach($ticket->Items as $key => $value){
					$item = $value;
				$user = new Administrator($item->Username);
		?>
				<tr>
					<td><?= $user->Name ?></td>
					<td><?= date("m/d/Y h:i a ", strtotime($item->PostDate)) ?></td>
					<td><pre style="white-space: pre-wrap;"><?= ($item->Comment) ?></pre></td>
					
					
					<td>
						<?php
						if($_SESSION['Username'] == $item->Username && ($ticket->Status!=2 && $ticket->Status!=-1)){
						?>
						<a onclick="deleteTicketItem(<?= $item->id ?>);" class="btn btn-danger" >Delete</a></td>
						<?php
						}
						?>
				</tr>
		<?php
		}
		if($ticket->Status!=2 && $ticket->Status!=-1){
		?>
				<tr>
					<td><?php
					$user = new Administrator($_SESSION['Username']);
					echo $user->Name;
					
					?>
					</td>
					<td>Now</td>
					<td><textarea id="newTicketItemText" class="form-control" style="width: 100%;"></textarea></td>
					
					
					<td><a href="#" onclick="createNewTicketItem();" id="SubmitNewItem" class="btn btn-success" >Submit</a></td>
					
				</tr>
				<?php
		}
				?>
			</tbody>
	     </table>
	  </div>
	  <div class="panel-footer" >
			<div class="row">
				<span class="pull-right" style="margin-right: 10px;">
					<a href="mod.php?p=ticket&a=manage" class="btn btn-primary">Go Back</a>		
				</span>
				
			</div>
			
	  	
	  </div>
	</div>

</div>       
	<script type="text/javascript">
	function changePriority(){
		$.get("mod.php",{
				"p": "ticket",
				"a": "functions",
				"f": "changePriority",
				"tid": <?= $ticket->TicketID ?>,
				"value": $('#TicketPriority').val()
			
			} , function(data){
				if(data == "true"){
					location.reload();
				}
			});
	}
	function changeStatus(){
		if(confirm("Are you sure you want to change the status to " + $('#TicketStatus option:selected').text() + "?")){
			$.get("mod.php",{
					"p": "ticket",
					"a": "functions",
					"f": "changeStatus",
					"tid": <?= $ticket->TicketID ?>,
					"value": $('#TicketStatus').val()
				
				} , function(data){
					if(data == "true"){
						location.reload();
					}
				});
		}
	}
	function createNewTicketItem(){
		var text = $('#newTicketItemText').val();
		$('#SubmitNewItem').prop('disabled', true);
		$.get('mod.php?p=ticket&a=functions&f=createNewTicketItem',
					{
						"tid": <?= $ticket->TicketID ?>,
						"comment": text
					}, function(data){
						if(data == "true"){
							
								location.reload();
							}
					});
	}
	function deleteTicketItem(id){
		
		$.get('mod.php?p=ticket&a=functions&f=deleteTicketItem',
					{
						"tiid": id
					}, function(data){
							if(data == "true"){
								location.reload();
							}
					});
	}
	</script>

   </body>
   
 </html>