<?php
include_once("../connect.php");
include_once("../session.php");




?>
<!DOCTYPE html>
 <html lang="en">
   <head>
     <meta charset="utf-8">
     <meta http-equiv="X-UA-Compatible" content="IE=edge">
     <meta name="viewport" content="width=device-width, initial-scale=1">
     <title><?= $config['CompanyName'] ?> - Ticket Archive</title>
 
     <!-- Bootstrap -->
     <link href="../css/bootstrap.min.css" rel="stylesheet">
     <link rel="stylesheet" href="../css/bootstrap-combobox.css" />
 
     <!-- HTML5 shim and Respond.js for IE8 support of HTML5 elements and media queries -->
     <!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
     <!--[if lt IE 9]>
       <script src="https://oss.maxcdn.com/html5shiv/3.7.2/html5shiv.min.js"></script>
       <script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
       <!-- jQuery (necessary for Bootstrap's JavaScript plugins) -->
           <script src="https://ajax.googleapis.com/ajax/libs/jquery/1.11.1/jquery.min.js"></script>
           <!-- Include all compiled plugins (below), or include individual files as needed -->
           <script src="../js/bootstrap.min.js"></script>
       	 <script src="../js/bootstrap-combobox.js"></script>
       	 <script src="../js/excellentexport.js"></script>
           <script type="text/javascript">
             $(document).ready(function(){
       //        $('.grpline').css("width", "100px");
             });
           </script>

     <![endif]-->
	<link rel="stylesheet" href="../css/styles.css"/>
   </head>
   <body>
   
       <?php include("navbar.php"); ?>     

   
   <!-- Stack the columns on mobile by making one full-width and the other half-width -->
   
	<div class="container " style="padding-top: 10px;">		
		<div class="panel panel-default">
			<div class="panel-heading form-inline">
				
				<h3>Eli-T Technical Support: Ticket Archive</h3>		    
			</div>
			<div class="panel-body">
				
				<div class="row">
					<h4>Archived Tickets</h4>
					<table class="table table-condensed">
						<thead>
							<tr>
								<th>TicketID</th>
								<th>Date Opened</th>
								<th>Username</th>
								<th>Subject</th>
								<th>Date Completed</th>
								<th>Priority</th>
								
							</tr>
						</thead>
						<tbody>
			<?php
			//WHERE status == done
			$query = "SELECT TicketID FROM TICKET_HEAD WHERE (`Status` = 2 || `Status` = -1) AND Archived = 1 ORDER BY `DateClosed` DESC";
			$result = mysqli_query($con, $query);
			
			while($row = mysqli_fetch_array($result)){
				$ticket = new Ticket($row['TicketID']);
				$user = new Administrator($ticket->Username);
			?>
							<tr>
								<td><a class="btn btn-default btn-sm" href="mod.php?p=ticket&a=view&tid=<?= $ticket->TicketID ?>"><?= $ticket->TicketID ?></a></td>
								<td><?= date("m/d/Y h:i a", strtotime($ticket->TicketDate)) ?></td>
								<td><?= $user->Name ?></td>
								<td><?= $ticket->Subject ?></td>
								<td><?= date("m/d/Y h:i a", strtotime($ticket->DateClosed)) ?></td>
								<td><?= $ticket->PriorityText ?></td>
								<td><?= $ticket->StatusText ?></td>
							</tr>
			<?php
			}
			?>
						</tbody>
					</table>
					<br>
				</div>
			</div>
			<div class="panel-footer" style="" >
				
			</div>
		</div>
	</div>
	<div id="CreateNewTicketModal" class="modal fade" tabindex="-1" role="dialog">
		<div class="modal-dialog" role="document">
			<div class="modal-content">
				<div class="modal-header">
					<button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
					<h4 class="modal-title">Create New Ticket</h4>
				</div>
				<div class="modal-body">
					<div class="form-group">
						<label for="subject">Subject</label>
						<input type="text" class="form-control" name="subject" id="newTicketSubject">
					</div>
					<div class="form-group">
						<label for="contents">Message</label>
						<textarea class="form-control" rows="10" name="contents" id="newTicketContents"></textarea>
					</div>
					<div class="form-group">
						<label for="priority">Priority</label>
						<select class="form-control" name="priority" id="newTicketPriority">
							<option value="1">Top Priority</option>
							<option selected value="2">Normal Priority</option>
							<option value="3">Low Priority</option>
						</select>
					</div>
				</div>
				<div class="modal-footer">
					<button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
					<button type="button" onclick="createNewTicket();" class="btn btn-primary">Submit</button>
				</div>
			</div><!-- /.modal-content -->
		</div><!-- /.modal-dialog -->
	</div><!-- /.modal -->
	<script type="text/javascript">
		function createNewTicket(){
		
		$.get('mod.php?p=ticket&a=functions&f=createNewTicket',
					{
						"subject": $('#newTicketSubject').val(),
						"contents": $('#newTicketContents').val(),
						"priority": $('#newTicketPriority').val()
					}, function(data){
						data = JSON.parse(data);
						if(data.Result == true){
							
								location.reload();
							}
					});
	}
	</script>
   
   
   </body>
 </html>