<?php
if(stripos($_SERVER['SCRIPT_NAME'],"/admin/")===false?false:true){
	include_once("../connect.php");
	include_once("../session.php");
}else{
	include_once("connect.php");
	include_once("session.php");
}
?>
 
 <!DOCTYPE html>
 <html lang="en">
   <head>
     <meta charset="utf-8">
     <meta http-equiv="X-UA-Compatible" content="IE=edge">
     <meta name="viewport" content="width=device-width, initial-scale=1">
     <title><?= $config['CompanyName'] ?></title>
 
     <!-- Bootstrap -->
     <link href="../css/bootstrap.min.css" rel="stylesheet">
     <link rel="stylesheet" href="../css/bootstrap-combobox.css" />
 
     <!-- HTML5 shim and Respond.js for IE8 support of HTML5 elements and media queries -->
     <!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
     <!--[if lt IE 9]>
       <script src="https://oss.maxcdn.com/html5shiv/3.7.2/html5shiv.min.js"></script>
       <script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
       <!-- jQuery (necessary for Bootstrap's JavaScript plugins) -->
           <script src="https://ajax.googleapis.com/ajax/libs/jquery/1.11.1/jquery.min.js"></script>
           <!-- Include all compiled plugins (below), or include individual files as needed -->
           <script src="../js/bootstrap.min.js"></script>
       	 <script src="../js/bootstrap-combobox.js"></script>
       	 <script src="../js/excellentexport.js"></script>
				 <script src="../js/functions.js"></script>
           <script type="text/javascript">
             $(document).ready(function(){
       //        $('.grpline').css("width", "100px");
             });
           </script>

     <![endif]-->
	<link rel="stylesheet" href="../css/styles.css"/>
	<link href="../css/fileinput.min.css" media="all" rel="stylesheet" type="text/css" />
		<script src="../js/fileinput.js" type="text/javascript"></script>
   </head>
   <body>
   
       <?php
		include_once("./navbar.php");						
		?>     

   
   <!-- Stack the columns on mobile by making one full-width and the other half-width -->
<div class="container" style="padding-top: 10px;">
	<div class="panel panel-default">
	  <div class="panel-heading form-inline">
		<h3 class="panel-title">Supplier Catalogs</h3>
		<button class="btn btn-success pull-right" onclick="addSupplierCatalog();">Add New Catalog</button>
		<br /><br />
	  </div>
	  <div class="panel-body">
	  	<table class="table table-hover table-condensed" id="suppliercatalogsTable">
	  		<thead>
	  			<tr>
	  				<th>Name</th>
					<th>Button</th>
	  				<th>Link</th>
					<th>Position</th>
	  			</tr>
	  		</thead>
	    <?php
			$query = "SELECT * FROM SUPPLIER_CATALOG_LINK ORDER BY Position";
			
			$result = mysqli_query($con, $query);
			while($row = mysqli_fetch_array($result)){
		?>
		<tr onclick="editSupplierCatalog(<?= $row['id'] ?>)" data-id="<?= $row['id'] ?>">
			<td><?= $row['Name'] ?></td>
			<td><?= $row['ButtonImage'] ?></td>
			<td><?= $row['Link'] ?></td>
			<td><?= $row['Position'] ?></td>		
		</tr>
		<?php
		}
		?>
	     </table>
	  </div>
	  <div class="panel-footer" style="height: 100px;" >
	  </div>
	</div>
</div>

<div class="modal fade" id="AddEditSupplierCatalog">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span>
                </button>
                <h4 class="modal-title" id="AddEditTitle">Edit Supplier Catalog</h4>
            </div>
            <div class="modal-body">
                <form class="catalogItem">
                    <input type="hidden" id="isNew" name="isNew" value="" />
                    <input type="hidden" id="SupplierCatalogID" name="SupplierCatalogID" value="" />
                    <div class="form-group">
                        <label for="SupplierCatalogName">Name</label>
                        <input class="form-control" id="SupplierCatalogTitle" name="SupplierCatalogTitle" />
                    </div>
                    <div class="form-group" id="SupplierCatalogButtonDiv">
                        <div id="imageButtonPreviewDiv" style="height:
                            150px; text-align: center; vertical-align: middle;" id="">
                            <img id="imageButtonPreview" style="max-height:
                                100%; max-width: 100%;" src="" alt="" />
                        </div>
                        <div class="alert alert-info" style="display:
                            none;" id="uploadButtonSuccess" role="alert">
                            File has been uploaded successfully!
                        </div>

                        <label for="SupplierCatalogButtonImage">Button Image</label>
                        <input type="file" class="file form-control" name="SupplierCatalogButtonImage" autocomplete="off" id="SupplierCatalogButtonImage">
                    </div>
                    <div class="form-group">
                        <label for="SupplierCatalogAdditionalText">Additional Text (bellow the Catalog Logo)</label>
                        <input type="text" class="form-control" name="SupplierCatalogAdditionalText" autocomplete="off" id="SupplierCatalogAdditionalText" value="" placeholder="ex. Aftermarket">
                    </div>
                    <div class="form-group">
                        <label for="SupplierCatalogLink">Catalog Link</label>
                        <input type="text" class="form-control" name="SupplierCatalogLink" autocomplete="off" id="SupplierCatalogLink" value="" placeholder="ex. http://www.globaldenso.com/cgi-bin/global/plug/usa/4w/maker.cgi">
                    </div>
					<div class="form-group">
                        <label for="SupplierCatalogPosition">Position</label>
                        <input type="text" class="form-control" name="SupplierCatalogPosition" autocomplete="off" id="SupplierCatalogPosition" value="" placeholder="ex. 4">
                    </div>
                    <div class="form-group">
                        <label for="SupplierCatalogTarget">Target</label>
                        <select id="SupplierCatalogTarget" name="SupplierCatalogTarget" class="form-control">
							<option value="_blank">_blank (New Window)</option>
							<option value="_self">_self (Same Window)</option>
						</select>
                    </div>
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-danger" id="deleteButton" onclick="deleteSupplierCatalog()">Delete</button>
                <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                <button type="button" class="btn btn-primary" id="saveButton" onclick="saveSupplierCatalogInfo();">Save</button>
            </div>
        </div>
        <!-- /.modal-content -->
    </div>
    <!-- /.modal-dialog -->
</div>
<!-- /.modal -->

<script type="text/javascript">
	
	$("#SupplierCatalogButtonImage").fileinput({
		'showUpload':true, 
		'showPreview': false,
		'uploadUrl':"mod.php?p=suppliercatalogs&a=upload_image",
		'fileTypeSettings':'image',
		'elErrorContainer':'#uploadError',
	});
	$('#SupplierCatalogButtonImage').on('filebatchuploadsuccess', function(event, data, previewId, index) {
		response = data.response;
		if(response.fileuploaded === true){
		console.log(response);
			$("#uploadButtonSuccess").text(response.message);
			$("#uploadButtonSuccess").css('display', "");
			$('#imageButtonPreviewDiv').css('display', '');
			$('#imageButtonPreview').attr('src', response.url);				   
		}
	});
	function clearCatalogModal(){
		$('#isNew').val("0");
		$('#SupplierCatalogID').val("-1");
		$('#SupplierCatalogTitle').val("");
		$('#imageButtonPreview').attr('src', '');
		$('#SupplierCatalogLink').val("");
		
		$('#saveButton').css('display', '');
		$('#deleteButton').css('display', '');
		$("#uploadSuccess").css('display', 'none');
		
	}
	function addSupplierCatalog(){
		clearCatalogModal();
		$('#isNew').val("1");
		$('#AddEditTitle').text('Add New Supplier Catalog');
		$('#deleteButton').css('display', 'none');
		
		$('#AddEditSupplierCatalog').modal('toggle');
	}
	function editSupplierCatalog(id){
		clearCatalogModal();
		$('#isNew').val("0");
		$('#AddEditTitle').text('Edit Supplier Catalog');
		$('#SupplierCatalogID').val(id);
		$.get('mod.php?p=suppliercatalogs&a=functions&f=getSupplierCatalogInfo&cid=' + id, function(data){
			data = JSON.parse(data);
			$('#SupplierCatalogTitle').val(data.Name);
			$('#imageButtonPreview').attr('src', "." + data.ButtonImage);
			$('#SupplierCatalogLink').val(data.Link);
			$('#SupplierCatalogPosition').val(data.Position);
			$('#SupplierCatalogTarget').val(data.Target);
			$('#SupplierCatalogAdditionalText').val(data.AdditionalText);
			$('#saveButton').css('display', '');
			$('#deleteButton').css('display', '');
			$("#uploadSuccess").css('display', 'none');
			$('#AddEditSupplierCatalog').modal('toggle');
		});
		
		
	}
	function saveSupplierCatalogInfo(){
		var data = {};
		data.IsNew = $('#isNew').val();
		data.id = $('#SupplierCatalogID').val();
		data.Name = $('#SupplierCatalogTitle').val();
		data.ButtonImage = $('#imageButtonPreview').attr('src');
		data.Link = $('#SupplierCatalogLink').val();
		data.Position = $('#SupplierCatalogPosition').val();
		data.Target = $('#SupplierCatalogTarget').val();
		data.AdditionalText = $('#SupplierCatalogAdditionalText').val();
		$.post('mod.php?p=suppliercatalogs&a=functions&f=saveSupplierCatalog', data)
			.success(function(response){
				if(response == "true"){
					$('#AddEditSupplierCatalog').modal('toggle');
					location.reload();
				}else{
					alert('An error has occurred inserting/updating the data into the table.');
				}
			})
			.fail(function(response){
				alert('An error has occurred either with the connection or the server has returned an unexpected http code.');
			});
	}
	function deleteSupplierCatalog(){
		$.get('mod.php?p=suppliercatalogs&a=functions&f=deleteSupplierCatalog&cid=' +  $('#SupplierCatalogID').val(), function(response){
			if(response == "true"){
				$('#AddEditSupplierCatalog').modal('toggle');
				location.reload();
			}else{
				alert("Error occurred, cant't delete.");
			}
		});
		
	}
</script>

   </body>
   
 </html>