<?php
include_once("../connect.php");
include_once("../session.php");

$webTitle = "Manage Purchase Orders";

 ?>

 <!DOCTYPE html>
 <html lang="en">
   <head>
     <meta charset="utf-8">
     <meta http-equiv="X-UA-Compatible" content="IE=edge">
     <meta name="viewport" content="width=device-width, initial-scale=1">
     <title><?= $config['CompanyName'] ?> - <?= $webTitle ?></title>

     <!-- Bootstrap -->
     <link href="../css/bootstrap.min.css" rel="stylesheet">
     <link rel="stylesheet" href="../css/bootstrap-combobox.css" />

     <!-- HTML5 shim and Respond.js for IE8 support of HTML5 elements and media queries -->
     <!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
     <!--[if lt IE 9]>
       <script src="https://oss.maxcdn.com/html5shiv/3.7.2/html5shiv.min.js"></script>
       <script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
       <!-- jQuery (necessary for Bootstrap's JavaScript plugins) -->
           <script src="https://ajax.googleapis.com/ajax/libs/jquery/1.11.1/jquery.min.js"></script>
           <!-- Include all compiled plugins (below), or include individual files as needed -->
           <script src="../js/bootstrap.min.js"></script>
       	 <script src="../js/bootstrap-combobox.js"></script>
       	 <script src="../js/excellentexport.js"></script>
           <script type="text/javascript">
             $(document).ready(function(){
       //        $('.grpline').css("width", "100px");
             });
           </script>

     <![endif]-->
	<link rel="stylesheet" href="../css/styles.css"/>
   </head>
   <body>

       <?php
	   error_reporting(E_ALL);
	   include("navbar.php"); ?>


   <!-- Stack the columns on mobile by making one full-width and the other half-width -->
<div class="container " style="padding-top: 10px;">
	<div class="panel panel-default">
	  <div class="panel-heading form-inline">
	  <a class="btn btn-success" role="button" style="float: right;" href="#" download="PurchaseOrders<?= "(" . date("Y.m",strtotime($fromPeriod)) . " - " . date("Y.m",strtotime($toPeriod)) . ")" ?>.xls" href="#" onclick="return ExcellentExport.excel(this, 'purchaseorders', 'Purchase Orders');" data-toggle="tooltip" data-placement="left" title="Does not work with Internet Explorer">Export To Excel</a>

	  	<div style="margin-right: 10px; float: right;">
	  			<div class="input-group">
	  			      <div id="clearButton" style="display: none;" class="input-group-addon" onclick="clearFilter()">
	  			      	<span class="glyphicon glyphicon-remove" aria-hidden="true"></span></div>
	  			      <input type="text" class="form-control" name="filter" placeholder="Purchase Order ID" value="" />
	  			      <div class="input-group-addon" onclick="filter()">
	  			      	<span class="glyphicon glyphicon-search" aria-hidden="true"></span></div>
	  			    </div>
	  	</div>
	  		    <h3 class="panel-title">Purchase Orders</h3><br />
	  </div>
	  <div class="panel-body">
	  	<table class="table table-hover table-condensed" id="purchaseorders">
	  		<thead>
	  			<tr>
	  				<th>Purchase Order ID</th>
						<th>Company Name</th>
					<th>PO Date</th>
					<th>Expected Date</th>
	  				<th>User</th>
					<th>Total</th>
					<th></th>
	  			</tr>

	  		</thead>
			<tbody>
	    <?php
		$query = "SELECT PurchaseOrderID, Name FROM PURCHASE_ORDER_HEADER LEFT JOIN VENDOR USING(VendorID) WHERE Completed = False AND PurchaseOrderID !=1 AND Void = 0 ";
		$result = mysqli_query($con,$query);
		while($row = mysqli_fetch_array($result)){
			//$invoice = new Invoice(322);
			$po = new PurchaseOrder($row['PurchaseOrderID']);
			//var_dump($row);
		?>
				<tr>
					<td>
            <!-- Split button -->
            <div class="btn-group">
              <a type="button" class="btn btn-primary" target="_blank" href="mod.php?p=purchasing&a=viewpo&id=<?= $po->PurchaseOrderID ?>"><?= $po->PurchaseOrderID ?></a>
              <button type="button" class="btn btn-primary dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                <span class="caret"></span>
                <span class="sr-only">Toggle Dropdown</span>
              </button>
              <ul class="dropdown-menu">
                <li><a target="_blank" href="mod.php?p=purchasing&a=viewporeview&id=<?= $po->PurchaseOrderID ?>">Print PO Review</a></li>

              </ul>
            </div>
            </td>
					<td><?= $row['Name'] ?></td>
					<td><?= date("m/d/Y h:i a ", strtotime($po->PODate)) ?></td>
					<td><?= date("m/d/Y", strtotime($po->ExpectedDate)) ?></td>
					<td><?= $po->Username ?></td>
					<td><?= $po->Confirmed?moneyFormat($po->getConfirmedTotal()):moneyFormat($po->Total) ?></td>
          <?php
          if($po->Sent == 0){
          ?>
          <td><a href="mod.php?p=purchasing&a=pocreate&id=<?= $po->PurchaseOrderID ?>" class="btn btn-success" target="_blank">Review</a></td>
          <?php
        }else{
          ?>
          <td><a href="mod.php?p=purchasing&a=poreview&id=<?= $po->PurchaseOrderID ?>" class="btn btn-success" target="_blank">Review</a></td>
          <?php
        }
          ?>

          <td><a href="#" onclick="deletePO('<?= $po->PurchaseOrderID ?>')" class="btn btn-danger">Delete</a></td>

				</tr>
		<?php
		}
		?>
			</tbody>
	     </table>
	  </div>
	  <div class="panel-footer" >

	  </div>
	</div>

</div>
	<script type="text/javascript">
  function deletePO(poid){
    if(confirm("Are you sure you want to delete this PO?")){
      $.get("mod.php?p=purchasing&a=functions&f=deletePO&poid=" + poid, function(data){
        if(data == "true"){
          location.reload();
        }else{
          alert("Error: " + data);
        }
      });
    }
  }
	$('[name=filter]').on('keypress', function(e) {
		if (e.which == 13) {
			filter();
		}

	});
	function clearFilter() {
		$('[name=filter]').val("");
		$('#clearButton').css('display', 'none');
		$('tr').css('display', '');

	}
	function filter() {
		var	name = $('[name=filter]').val();
		filterByName(name);
	}
	function filterByName(name) {
		$('#clearButton').css('display', '');
		var cols = $('#paymenthistory th').length;
		for (var i = 0; i < $('#paymenthistory td').length; i=i+cols) {

			var text = $($('td')[i]).text();

			var result = text.toUpperCase().indexOf(name.toUpperCase());
			if (text != name) {
				$($('tr')[i/cols+1]).css('display', 'none');
			}else {
				$($('tr')[i/cols+1]).css('display', '');
			}

		}
	}
	</script>

   </body>

 </html>
