<?php 
include_once("../connect.php");
include_once("../session.php");

$for = $_REQUEST['for'];
$title = "";
$fromDate = "";
$toDate = "";
switch ($for) {
	case "customer":
		$customer = new Customer($_REQUEST["customer"]);
		$title = " - By Customer: " . $customer->Name;
		$fromDate = $_REQUEST['fromDate'];
		$toDate = $_REQUEST['toDate'];
		break;
	case "salesman":
		$salesman = new Salesman($_REQUEST['salesman']);
		$title = " - By Salesman: " . $salesman->Name;
		$fromDate = $_REQUEST['fromDate'];
		$toDate = $_REQUEST['toDate'];
		break;
	case "date":
		$title = " - By Date: ";
		$fromDate = $_REQUEST['fromDate'];
		$toDate = $_REQUEST['toDate'];
		break;
}
 ?>
 
 <!DOCTYPE html>
 <html lang="en">
   <head>
     <meta charset="utf-8">
     <meta http-equiv="X-UA-Compatible" content="IE=edge">
     <meta name="viewport" content="width=device-width, initial-scale=1">
     <title><?= $config['CompanyName'] ?></title>
 
     <!-- Bootstrap -->
     <link href="../css/bootstrap.min.css" rel="stylesheet">
     <link rel="stylesheet" href="../css/bootstrap-combobox.css" />
 
     <!-- HTML5 shim and Respond.js for IE8 support of HTML5 elements and media queries -->
     <!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
     <!--[if lt IE 9]>
       <script src="https://oss.maxcdn.com/html5shiv/3.7.2/html5shiv.min.js"></script>
       <script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
       <!-- jQuery (necessary for Bootstrap's JavaScript plugins) -->
           <script src="https://ajax.googleapis.com/ajax/libs/jquery/1.11.1/jquery.min.js"></script>
           <!-- Include all compiled plugins (below), or include individual files as needed -->
           <script src="../js/bootstrap.min.js"></script>
       	 <script src="../js/bootstrap-combobox.js"></script>
       	 <script src="../js/excellentexport.js"></script>
           <script type="text/javascript">
             $(document).ready(function(){
       //        $('.grpline').css("width", "100px");
             });
           </script>

     <![endif]-->
	<link rel="stylesheet" href="../css/styles.css"/>
   </head>
   <body>
   
       <?= include("navbar.php"); ?>     

   
   <!-- Stack the columns on mobile by making one full-width and the other half-width -->
<div class="container " style="padding-top: 10px;">
	<div class="panel panel-default">
	  <div class="panel-heading form-inline">
	  <a class="btn btn-success" role="button" style="float: right;" href="#" download="CPDPayments<?= $title . "(" . date("m.d.Y",strtotime($fromDate)) . " - " . date("m.d.Y",strtotime($toDate)) . ")" ?>.xls" href="#" onclick="return ExcellentExport.excel(this, 'orderhistory', 'Order History');" data-toggle="tooltip" data-placement="left" title="Does not work with Internet Explorer">Export To Excel</a>
	  
	  	<div style="margin-right: 10px; float: right;">
	  			<div class="input-group">
	  			      <div id="clearButton" style="display: none;" class="input-group-addon" onclick="clearFilter()">
	  			      	<span class="glyphicon glyphicon-remove" aria-hidden="true"></span></div>
	  			      <input type="text" class="form-control" name="filter" placeholder="Payment ID" value="" />
	  			      <div class="input-group-addon" onclick="filter()">
	  			      	<span class="glyphicon glyphicon-search" aria-hidden="true"></span></div>
	  			    </div>
	  	</div>
	  		    <h3 class="panel-title"><?= ($cashBox)?"Cash Box":"Payment History" ?><?= $title . " - <i>From: " . date("m/d/Y",strtotime($fromDate)) . " To: " . date("m/d/Y",strtotime($toDate)) . "</i>"?></h3><br />
	    
	  </div>
	  <div class="panel-body">
	  	<table class="table table-hover table-condensed" id="paymenthistory">
	  		<thead>
	  			<tr>
	  				<th>Payment ID</th>
	  				<?= ($for != "customer") ? "<th>Customer</th>\n" : "" ?>
					<?= ($for != "salesman") ? "<th>Salesman</th>\n" : "" ?>
	  				<th>CPD Date</th>
					<th>In Progress</th>
	  				<th style="text-align: center;">Total</th>
	  				
	  			</tr>
	  			
	  		</thead>
	    <?php
		
		
	    if($for == "salesman") {
	    	$query = "SELECT PAYMENT_HEAD.*, CUSTOMER.Name, PAYMENT_HEAD.id as PaymentID FROM PAYMENT_HEAD, CUSTOMER WHERE PAYMENT_HEAD.SalesmanID LIKE '" . $salesman->ID . "' AND DATE(CPDDate) BETWEEN '$fromDate' AND '$toDate' AND CUSTOMER.AccountNumber = PAYMENT_HEAD.AccountNumber AND CPD = 1 AND Processed = 0 ORDER BY PAYMENT_HEAD.CPDDate DESC";
	    }elseif ($for == "date") {
	    	$query = "SELECT PAYMENT_HEAD.*, SALESMAN.FullName as SalesmanName, CUSTOMER.Name, PAYMENT_HEAD.id as PaymentID FROM PAYMENT_HEAD, SALESMAN, CUSTOMER WHERE DATE(CPDDate) BETWEEN '$fromDate' AND '$toDate' AND SALESMAN.ID = PAYMENT_HEAD.SalesmanID AND CUSTOMER.AccountNumber = PAYMENT_HEAD.AccountNumber AND CPD = 1 AND Processed = 0 ORDER BY PAYMENT_HEAD.CPDDate DESC";
	    	
	    }
		
		$result = mysqli_query($con, $query);
	   	$total = 0;
		$totalCash = 0;
		$totalCheck = 0;
		$totalCPD = 0;
	   	while ($row = mysqli_fetch_array($result)) {
			
			if($row['CPD']){
				$totalCPD += $row['CheckAmount'];
				$total += $row['CashAmount']+$row['CheckAmount'];
			}else{
				$total += $row['CashAmount']+$row['CheckAmount'];
				$totalCash += $row['CashAmount'];
				$totalCheck += $row['CheckAmount'];
			}
	   	?>
	   		<tr>
	   			<td><button class="btn btn-default" onclick="window.location = 'mod.php?p=payment&a=admin.viewpayment&id=<?= $row['PaymentID'] ?>'"><?= $row['PaymentID'] ?></button></td>
	   			<?= ($for != "customer") ? "<td>" . $row['Name'] . "</td>" : "" ?>
				<?= ($for != "salesman") ? "<td>" . $row['SalesmanName'] . "</td>" : ""
				?>
	   			<td><?= date("m/d/Y",strtotime($row['CPDDate'])) ?></td>
				<td id="processCell-<?=$row['PaymentID'] ?>">
				<?php
					$cpdDate = strtotime($row['CPDDate']);
					$today = time();
					$enabled = ($cpdDate < $today);
				?>
				<input type="button" class="btn btn-warning" <?= $enabled?"":"disabled" ?> onclick="processPayment(<?=$row['PaymentID'] ?>)" value="CPD" />
				</td>
				<td style="text-align: right;"><?= moneyFormat($row['CashAmount']+$row['CheckAmount']) ?></td>
	   		</tr>
	   	<?php
	   	}
	     ?>
	     </table>
	  </div>
	  <div class="panel-footer" >
	  	<span style="text-align: left;">
			<strong>CPD Total: </strong><i><?= moneyFormat($totalCPD) ?></i>
	  	</span>	
	  	<span  style="float: right; text-align: right;">
	  		<strong>Total: </strong><i><?= moneyFormat($total) ?></i>
	  	</span>	
	  </div>
	</div>

</div>       
<script type="text/javascript">

$('[name=filter]').on('keypress', function(e) {
	if (e.which == 13) {
		filter();
	}

});
function clearFilter() {
	$('[name=filter]').val("");
	$('#clearButton').css('display', 'none');
	$('tr').css('display', '');
	
}
function filter() {
	var	name = $('[name=filter]').val();
	filterByName(name);
}
function filterByName(name) {
	$('#clearButton').css('display', '');
	for (var i = 0; i < $('td').length; i=i+6) {
	
		var text = $($('td')[i]).text();
		
		var result = text.toUpperCase().indexOf(name.toUpperCase());
		if (text != name) {
			$($('tr')[i/6+1]).css('display', 'none');
		}else {
			$($('tr')[i/6+1]).css('display', '');
		}
		
	}
}
function processPayment(paymentID) {
	$.get("mod.php?p=payment&a=functions&f=processPayment&pid=" + paymentID, function(data){
		$('#processCell-' + paymentID).html('');
		var processDate = new Date(data);
		var ampm = Math.floor(processDate.getHours()/12);
		if(ampm == 0){
			ampm = "am";
		}else{
			ampm = "pm";
		}
		$('#processCell-' + paymentID).html((processDate.getMonth()+1) + "/" + (processDate.getDate()) + "/" + processDate.getFullYear() + " " + processDate.getHours()%12 + ":" + ('00'+processDate.getMinutes()).substring(processDate.getMinutes().toString().length) + " " + ampm);

	});
}


</script>

	<div class="modal fade" id="EditOrderModal">
	  <div class="modal-dialog">
	    <div class="modal-content">
	      <div class="modal-header">
	        <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
	        <h4 class="modal-title" id="EditOrderTitle">Edit Order</h4>
	      </div>
	      <div class="modal-body">
	      	<input type="hidden" name="EditModalOrderID" id="EditModalOrderID" value="" />
			<table class="table table-hover table-condensed" id="orderhistory">
				<thead>
					<tr>
						<th>Group<br />Line</th>
						<th>SKU</th>
						<th>Description</th>
						
						<th>Qty</th>
						<th>Price</th>
						<th style="text-align: center;">Extension</th>
					</tr>
					
				</thead>
				<tbody id="EditOrderModalBody">
				</tbody>
				</table>
	      	
	      </div>
	      <div class="modal-footer">
	        <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
	        <button type="button" class="btn btn-primary" id="saveButton" onclick="saveOrderInfo()">Save</button>
	      </div>
	    </div><!-- /.modal-content -->
	  </div><!-- /.modal-dialog -->
	</div><!-- /.modal -->
	


   </body>
   
 </html>