<?php
if(stripos($_SERVER['SCRIPT_NAME'],"/admin/")===false?false:true){
	include_once("../connect.php");
	include_once("../session.php");
}else{
	include_once("connect.php");
	include_once("session.php");
}
?>
<!doctype html>
<html>
	<head>
		<meta http-equiv="content-type" content="text/html; charset=utf-8" />
		<meta name="viewport" content="width=device-width, initial-scale=1">
		<title>Physical Count</title>
		
		
		<link href="../css/bootstrap.min.css" rel="stylesheet">
		<link rel="stylesheet" href="../css/bootstrap-combobox.css" />
		<style>
			input[type="color"],
			input[type="date"],
			input[type="datetime"],
			input[type="datetime-local"],
			input[type="email"],
			input[type="month"],
			input[type="number"],
			input[type="password"],
			input[type="search"],
			input[type="tel"],
			input[type="text"],
			input[type="time"],
			input[type="url"],
			input[type="week"],
			select:focus,
			textarea {
			  font-size: 16px;
			}
		</style>
		<script src="https://ajax.googleapis.com/ajax/libs/jquery/1.11.1/jquery.min.js"></script>
		<script type="text/javascript" charset="utf-8" src="../js/bootstrap.min.js"></script>
		
	</head>
	<body class="bootstrap">
		
       <?php
		include_once("./navbar.php");						
		?>
		<br>
		<br>
		<br>
		
		<h2>
			Physical Count
			</h2>
		<br>
		<div class="container">
			<div class="row">
				<div class="col-sm-6">
					<div class="form-horizontal">
						<div class="form-group">
						  <label for="ProductUPC" class="col-sm-2 control-label">UPC or SKU</label>
						  <div class="col-sm-10">
							<input type="text" class="form-control" id="ProductUPC" placeholder="UPC or SKU">
						  </div>
						</div>
						<div class="form-group">
						  <div class="col-sm-offset-2 col-sm-10">
							<button type="button" id="setNewItem" class="btn btn-default">New Item</button>
						  </div>
						</div>
					</div>
				</div>
				<div class="col-sm-6">
					<span style="" id="currUPC"></span>
					<h4 class="statusTitle">Current Item: <span id="currItem">Not Set</span></h4>
					<h4 class="statusTitle"><span id="currItemDescription"></span></h4>
					<h5 class="statusTitle"><span id="saveStatus"></span></h5>
					
				</div>
				<div class="col-sm-12">
					<table class="table">
					<thead>
						<tr>
							<th></th>
							<th></th>
							<th></th>	
						</tr>
					</thead>
					<tbody>
						<tr>
							<td>Qty</td>
							<td><input type="number" class="form-control" id="OnHand"  name="OnHand" /></td>
							<td><button class="btn btn-primary" onclick="saveQtyByUPC()">Save</button></td>
						</tr>
						<tr>
							<td id="Locations">Locations</td>
							<td>
								<table class="table" style="border: none;">
									<thead>
										<tr>
											<th></th>
											<th></th>
										</tr>
									</thead>
									<tbody id="LocationsTBody">
										
									</tbody>
								</table>
								
							</td>
							
						</tr>
						
					</tbody>
				  </table>
				</div>
			</div>
		</div>
		<!-- Location Select Modal 
		<div class="modal fade" id="locationSlotSelect" tabindex="-1" role="dialog">
			<div class="modal-dialog" role="document">
			  <div class="modal-content">
				<div class="modal-header">
				  <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
				  <h4 class="modal-title">Select Location</h4>
				</div>
				<div class="modal-body">
					This item already has a location defined. Please select the location slot in which you would like to store this location information. if you select a slot with a location number already, the system will overwrite it. 
				  <table class="table">
					<thead>
						<tr>
							<th>Location Slot</th>
							<th>Location ID</th>
							<th></th>
							<th></th>	
						</tr>
					</thead>
					<tbody>
						<tr>
							<td>Loc A</td>
							<td id="locationSlotA"></td>
							<td><button class="btn btn-primary" onclick="selectSlot('Location');" id="selectSlotA"><span class="glyphicon glyphicon-ok" aria-hidden="true"></span></button></td>
							<td><button class="btn btn-danger" onclick="deleteSlot('Location');" id="deleteSlotA"><span class="glyphicon glyphicon-trash" aria-hidden="true"></span></button></td>
						</tr>
						<tr>
							<td>Loc B</td>
							<td id="locationSlotB"></td>
							<td><button class="btn btn-primary" onclick="selectSlot('LocationB');" id="selectSlotB"><span class="glyphicon glyphicon-ok" aria-hidden="true"></span></button></td>
							<td><button class="btn btn-danger" onclick="deleteSlot('LocationB');" id="deleteSlotB"><span class="glyphicon glyphicon-trash" aria-hidden="true"></span></button></td>
						</tr>
						<tr>
							<td>Loc C</td>
							<td id="locationSlotC"></td>
							<td><button class="btn btn-primary" onclick="selectSlot('LocationC');" id="selectSlotC"><span class="glyphicon glyphicon-ok" aria-hidden="true"></span></button></td>
							<td><button class="btn btn-danger" onclick="deleteSlot('LocationC');" id="deleteSlotC"><span class="glyphicon glyphicon-trash" aria-hidden="true"></span></button></td>
						</tr>
						<tr>
							<td>Loc D</td>
							<td id="locationSlotD"></td>
							<td><button class="btn btn-primary" onclick="selectSlot('LocationD');" id="selectSlotD"><span class="glyphicon glyphicon-ok" aria-hidden="true"></span></button></td>
							<td><button class="btn btn-danger" onclick="deleteSlot('LocationD');" id="deleteSlotD"><span class="glyphicon glyphicon-trash" aria-hidden="true"></span></button></td>
						</tr>
						<tr>
							<td>Loc E</td>
							<td id="locationSlotE"></td>
							<td><button class="btn btn-primary" onclick="selectSlot('LocationE');" id="selectSlotE"><span class="glyphicon glyphicon-ok" aria-hidden="true"></span></button></td>
							<td><button class="btn btn-danger" onclick="deleteSlot('LocationE');" id="deleteSlotE"><span class="glyphicon glyphicon-trash" aria-hidden="true"></span></button></td>
						</tr>
					</tbody>
				  </table>
				</div>
				<div class="modal-footer">
				  <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
				</div>
			  </div><!-- /.modal-content - ->
			</div><!-- /.modal-dialog - ->
		</div><!-- /.modal -->
		
		
		<!-- Assign UPC Modal -->
		<div class="modal fade" id="AssignUPCModal" tabindex="-1" role="dialog">
			<div class="modal-dialog" role="document">
			  <div class="modal-content">
				<div class="modal-header">
				  <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
				  <h4 class="modal-title">Assing UPC to Existing Product</h4>
				</div>
				<div class="modal-body">
					This UPC code is not recognized, please assing this UPC to an existing item in the following form.
					<br>
					<div class="">
					  <div class="form-horizontal">
						  <div class="form-group">
							<label for="AssingUPCSKU" class="col-sm-2 control-label">SKU</label>
							<div class="col-sm-10">
							  <input type="text" class="form-control" id="AssingUPCSKU" placeholder="SKU">
							</div>
						  </div>
						  <div class="form-group">
							<label for="AssingUPCLine" class="col-sm-2 control-label">Line</label>
							<div class="col-sm-10">
							  <input type="text" class="form-control" id="AssingUPCLine" placeholder="Line">
							</div>
						  </div>
						  <div class="form-group">
							<label for="AssingUPCQty" class="col-sm-2 control-label">Qty</label>
							<div class="col-sm-10">
							  <input type="text" class="form-control" value="1" id="AssingUPCQty" placeholder="Qty">
							</div>
						  </div>
					  </div>
				  </div>
				</div>
				<div class="modal-footer">
					<button type="button" onclick="saveAssingUPC();" class="btn btn-primary">Save</button>
					<button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
				</div>
			  </div><!-- /.modal-content -->
			</div><!-- /.modal-dialog -->
		</div><!-- /.modal -->
		
		<script type="text/javascript">
			$(document).ready(function(){
				$('#ProductUPC').focus();
				});
			
			function deleteSlot(locationSlot){
				var upc = $('#currUPC').text();
				
				if(confirm("Are you sure you want to delete the location?") ){
				
					$.get('mod.php?p=inventorymanage&a=functions&f=deleteLocationByUPC&UPC=' + upc + "&slot=" + locationSlot, function(data){
							data = JSON.parse(data);
							if(data.Result){
								
								var tableRows = "";
								if(data.Data[0]){
									tableRows += "<tr><td></td><td>" + data.Data[0] + '</td><td><button class="btn btn-danger" onclick="deleteSlot(\'Location\');" id="deleteSlotA"><span class="glyphicon glyphicon-trash" aria-hidden="true"></span></button></td>';
								}
								if(data.Data[1]){
									tableRows += "<tr><td></td><td>" + data.Data[1] + '</td><td><button class="btn btn-danger" onclick="deleteSlot(\'LocationB\');" id="deleteSlotB"><span class="glyphicon glyphicon-trash" aria-hidden="true"></span></button></td>';
								}
								if(data.Data[2]){
									tableRows += "<tr><td></td><td>" + data.Data[2] + '</td><td><button class="btn btn-danger" onclick="deleteSlot(\'LocationC\');" id="deleteSlotC"><span class="glyphicon glyphicon-trash" aria-hidden="true"></span></button></td>';
								}
								if(data.Data[3]){
									tableRows += "<tr><td></td><td>" + data.Data[3] + '</td><td><button class="btn btn-danger" onclick="deleteSlot(\'LocationD\');" id="deleteSlotD"><span class="glyphicon glyphicon-trash" aria-hidden="true"></span></button></td>';
								}
								if(data.Data[4]){
									tableRows += "<tr><td></td><td>" + data.Data[4] + '</td><td><button class="btn btn-danger" onclick="deleteSlot(\'LocationE\');" id="deleteSlotE"><span class="glyphicon glyphicon-trash" aria-hidden="true"></span></button></td>';
								}
								$('#LocationsTBody').html(tableRows);
							}else{
								alert(data.Error);
							}
							
							
					});	
				}
				
			}
			function getProductByUPC(){
				var upc = $('#ProductUPC').val();
				
				$.get('mod.php?p=inventorymanage&a=functions&f=getItemByUPC&UPC=' + upc, function(data){
					data = JSON.parse(data);
					if(data.Result){
						$('#currUPC').html(upc);
						$('#currItem').html(data.Data.SKU);
						$('#currItemDescription').html(data.Data.Description);
						$('#ProductUPC').val('');
						$('#ProductUPC').focus();
						
						$('#OnHand').val(data.Data.Qty);
						var tableRows = "";
						if(data.Data.Location){
							tableRows += "<tr><td></td><td>" + data.Data.Location + '</td><td><button class="btn btn-danger" onclick="deleteSlot(\'Location\');" id="deleteSlotA"><span class="glyphicon glyphicon-trash" aria-hidden="true"></span></button></td>';
						}
						if(data.Data.LocationB){
							tableRows += "<tr><td></td><td>" + data.Data.LocationB + '</td><td><button class="btn btn-danger" onclick="deleteSlot(\'LocationB\');" id="deleteSlotB"><span class="glyphicon glyphicon-trash" aria-hidden="true"></span></button></td>';
						}
						if(data.Data.LocationC){
							tableRows += "<tr><td></td><td>" + data.Data.LocationC + '</td><td><button class="btn btn-danger" onclick="deleteSlot(\'LocationC\');" id="deleteSlotC"><span class="glyphicon glyphicon-trash" aria-hidden="true"></span></button></td>';
						}
						if(data.Data.LocationD){
							tableRows += "<tr><td></td><td>" + data.Data.LocationD + '</td><td><button class="btn btn-danger" onclick="deleteSlot(\'LocationD\');" id="deleteSlotD"><span class="glyphicon glyphicon-trash" aria-hidden="true"></span></button></td>';
						}
						if(data.Data.LocationE){
							tableRows += "<tr><td></td><td>" + data.Data.LocationE + '</td><td><button class="btn btn-danger" onclick="deleteSlot(\'LocationE\');" id="deleteSlotE"><span class="glyphicon glyphicon-trash" aria-hidden="true"></span></button></td>';
						}
						$('#LocationsTBody').html(tableRows);
						$('html,body').animate({
								scrollTop: $("#currItem").offset().top
							 });
						
					}else{
						if(data.Error == 'upc_not_exists'){
							$('#AssignUPCModal').modal();
							$('#AssingUPCSKU').val('');
							$('#AssingUPCLine').val('');
							$('#AssingUPCQty').val('1');
							setTimeout(function(){
								$('#AssingUPCSKU').focus();
								$('#AssingUPCSKU').select();	
							}, 500);
							
							
						}
						
					}
				});	
			}
			$('#AssingUPCSKU').on("change", function(){
				$.get("mod.php?p=inventorymanage&a=functions&f=getItemLineBySKU&sku=" + $('#AssingUPCSKU').val(), function(data){
					$('#AssingUPCLine').val(data);
					$('#AssingUPCQty').focus();
				});
			});
			$('#ProductUPC').on('keyup', function(e){
				if($('#ProductLocation').val() == ""){
					
				}
				if(e.keyCode == 13 || e.keyCode == 0){
					getProductByUPC();
				}
				});
			
			
			$('#setNewItem').on('click', function(){
				$('#currItem').html('');
				$('#ProductUPC').val('');
				$('#ProductUPC').focus();
				$('#OnHand').val('');
			});
			function saveQtyByUPC(){
				var upc = $('#currUPC').text();
				var qty = $('#OnHand').val();
				$('#saveStatus').text('Saving...');
				$.get('mod.php?p=inventorymanage&a=functions&f=saveQtyByUPC&UPC=' + upc + '&qty=' + qty, function(data){
					data = JSON.parse(data);
					if(data.Result){
						$('#ProductUPC').focus();
						$('#saveStatus').text('Product Updated Successfully!');
						setTimeout(function(){
							$('#saveStatus').text('');	
						}, 2500);
					}
				});
			}
			function saveAssingUPC(){
				var SKU = $('#AssingUPCSKU').val();
				var Line = $('#AssingUPCLine').val();
				var Qty = $('#AssingUPCQty').val();
				var UPC = $('#ProductUPC').val();
				$.get('mod.php?p=inventorymanage&a=functions&f=addUPCtoItem&line=' + Line + '&sku=' + SKU + "&upc=" + UPC + "&qty=" + Qty, function(data){
					data = JSON.parse(data);
					if(data.Result){
						getProductByUPC();
						$('#AssignUPCModal').modal('hide');
						
						
					}else{
						alert(data.Error);
					}
				});
			}
			function selectSlot(locationSlot){
				var upc = $('#ProductUPC').val();
				var loc = $('#currLocation').text();
				
				$.get('mod.php?p=inventorymanage&a=functions&f=assignLocationByUPC&UPC=' + upc + '&loc=' + loc + "&slot=" + locationSlot, function(data){
						data = JSON.parse(data);
						if(data.Result){
							$('#currItem').html(data.Data.SKU + " - " + data.Data.Description + "<br>" + "<B>Product Updated Successfully</B>");
							$('#locationSlotSelect').modal('hide');
							$('#ProductUPC').val('');
							$('#ProductUPC').focus();
						}else{
							alert(data.Error);
						}
					});
			}
		</script>
	</body>
</html>
