<?php
if(stripos($_SERVER['SCRIPT_NAME'],"/admin/")===false?false:true){
	include_once("../connect.php");
	include_once("../session.php");
}else{
	include_once("connect.php");
	include_once("session.php");
}
?>
<!doctype html>
<html>
	<head>
		<meta http-equiv="content-type" content="text/html; charset=utf-8" />

		<title>INVENTORY</title>


		<link href="../css/bootstrap.min.css" rel="stylesheet">
		<link rel="stylesheet" href="../css/bootstrap-combobox.css" />
		<link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/v/bs/jqc-1.12.3/moment-2.18.1/dt-1.10.16/b-1.5.1/b-html5-1.5.1/fh-3.1.3/sl-1.2.5/datatables.min.css">
		<link rel="stylesheet" type="text/css" href="../css/generator-base.css">
		<link rel="stylesheet" type="text/css" href="../css/editor.bootstrap.min.css">

		<!--<script src="https://ajax.googleapis.com/ajax/libs/jquery/1.11.1/jquery.min.js"></script>-->

		<script type="text/javascript" charset="utf-8" src="https://cdn.datatables.net/v/bs/jqc-1.12.3/moment-2.18.1/dt-1.10.16/b-1.5.1/b-html5-1.5.1/fh-3.1.3/sl-1.2.5/datatables.min.js"></script>
		<script type="text/javascript" charset="utf-8" src="../js/jszip.min.js"></script>

		<script type="text/javascript" charset="utf-8" src="../js/pdfmake.min.js"></script>
		<script type="text/javascript" charset="utf-8" src="../js/vfs_fonts.js"></script>
		<script type="text/javascript" charset="utf-8" src="../js/bootstrap.min.js"></script>
		<script type="text/javascript" charset="utf-8" src="../js/functions.js"></script>
		<script type="text/javascript" charset="utf-8" src="../js/dataTables.editor.min.js"></script>
		<script type="text/javascript" charset="utf-8" src="../js/editor.bootstrap.min.js"></script>
		<script type="text/javascript">

			/*
			 * Editor client script for DB table INVENTORY
			 * Created by http://editor.datatables.net/generator
			 */

			(function($){

			$(document).ready(function() {
				var editor = new $.fn.dataTable.Editor( {
					ajax: '../modules/inventorymanage/table.INVENTORY.php',
					table: '#INVENTORY',
					fields: [
						{
							"label": "Description:",
							"name": "Description"
						},
						{
							"label": "OnHand:",
							"name": "Qty"
						},
						{
							"label": "Cost:",
							"name": "AvgCost"
						},
						{
							"label": "PriceA:",
							"name": "PriceA"
						},
						{
							"label": "PriceB:",
							 "name": "PriceB"
						},
						{
							"label": "Commission:",
							"name": "CommissionRate"
						},
						{
							"label": "Location:",
							"name": "Location"
						},
						{
							"label": "Location B:",
							"name": "LocationB"
						},
						{
							"label": "Location C:",
							"name": "LocationC"
						},
						{
							"label": "Discontinued",
							"name": "Discontinued"
						},
						{
							label:     "Active:",
            	name:      "Active",
            	type:      "checkbox",
            	separator: "|",
            	ipOpts:    [
              	{ label: '', value: 1 }
            	]
						}
					]
				} );
				$('#INVENTORY').on( 'click', 'tbody td:not(:first-child)', function () {
					editor.inline( this );
				} );
				var table = $('#INVENTORY').DataTable( {
					ajax: '../modules/inventorymanage/table.INVENTORY.php',
					columns: [
						{
							"data": "Line"
						},

						{
							"data": "SKU"
						},
						{
							"data": "Description"
						},
						{
							"data": "Qty"
						},
						<?php
							if($_SESSION['Level'] <= 1){
						?>
						{
							"data": "AvgCost"
						},
						<?php
							}
						?>
						{
							"data": "PriceA"
						},
						<?php
							if($_SESSION['Level'] <= 1){
						?>
						{
							"data": "PM_A"
						},
						<?php
							}
						?>
						{
							"data": "PriceB"
						},
						<?php
							if($_SESSION['Level'] <= 1){
						?>
						{
							"data": "PM_B"
						},
						<?php
							}
						?>
						{
							"data": "CommissionRate"
						},
						{
							"data": "Location"
						},
						{
							"data": "LocationB"
						},
						{
							"data": "LocationC"
						},
						{
							"data": "Discontinued"
						},
						{
							"data": "Active",
							render: function ( data, type, row ) {
			        	if ( type === 'display' ) {
			          	return '<input type="checkbox" class="editor-active">';
			        	}
			        	return data;
			    		},
			    		className: "dt-body-center"
						}
					],
					rowCallback: function ( row, data ) {
        		// Set the checked state of the checkbox in the table
        		$('input.editor-active', row).prop( 'checked', data.Active == 1 );
					},
					select: true,
					lengthChange: false,
					paging: false,
					scrollY: 500,
					dom: 'Bfrtip',
					buttons: [

						'excelHtml5',
						'copy',
						'pdf',
						'colvis'
					]

				} );
				table.buttons().container().appendTo( $('#exportButtons', table.table().container() ) );


			} );

			}(jQuery));
			$('#INVENTORY').on( 'change', 'input.editor-active', function () {
			    editor
			        .edit( $(this).closest('tr'), false )
			        .set( 'Active', $(this).prop( 'checked' ) ? 1 : 0 )
			        .submit();
			} );
		</script>
		<script type="text/javascript" charset="utf-8" src="https://cdn.datatables.net/buttons/1.5.1/js/buttons.colVis.min.js"></script>

	</head>
	<body class="bootstrap">

       <?php
		include_once("./navbar.php");
		?>
		<br>
		<br>

		<div class="container" width="100%">
			<div id="exportButtons" style="text-align: right;">

			<button class="btn btn-primary" onclick="$('#inventoryStatisticsModal').modal('toggle');">
				Inventory Statistics
			</button>
		</div>
			<h1>
				<span>Quick Inventory Manage</span>
			</h1>

			<table cellpadding="0" cellspacing="0" border="0" class="table table-striped table-bordered cell-border" id="INVENTORY" width="100%">
				<thead>
					<tr>
						<th>Line</th>
						<th>SKU</th>
						<th>Description</th>
						<th>OnHand</th>
						<th>Repl. Cost</th>

						<th>PriceA</th>
						<th>PM% A</th>
						<th>PriceB</th>
						<th>PM% B</th>
						<th>CommissionRate</th>

						<th>Location</th>
						<th>Location B</th>
						<th>Location C</th>
						<th>Discontinued</th>
						<th>Active</th>
					</tr>
				</thead>
			</table>

		</div>

		<div id="inventoryStatisticsModal" class="modal fade">
			<div class="modal-dialog">
				<div class="modal-content">
					<div class="modal-header">
						<button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
						<h4 class="modal-title">Inventory Statistics</h4>
					</div>
					<div class="modal-body">
						<div class="form-inline">
							<div class="form-group">
							  <label for="inventoryStatsLine">Line</label>
							  <select  style="width: 150px;"  class="form-control" id="inventoryStatsLine">

								<option value="%">---ALL---</option>
							  <?php
								$query = "SELECT DISTINCT(Line) Code, `Name` FROM INVENTORY LEFT JOIN `LINE` ON(LINE.Code = INVENTORY.Line) ORDER BY Line;";
								$result = mysqli_query($con, $query);
								while($row=mysqli_fetch_array($result)){
							 ?>
								<option value="<?= $row['Code'] ?>"><?= $row['Code'] . " - " . $row['Name'] ?></option>
							 <?php
								}
							  ?>
							  </select>
							  <!--<input type="text" class="form-control" id="inventoryStatsLine" placeholder="Line">-->
							</div>
							<div class="form-group">
							  <label for="inventoryStatsGroup">Group</label>
							  <select style="width: 150px;" class="form-control" id="inventoryStatsGroup">

							  <option value="%">---ALL---</option>
							  <?php
								$query = "SELECT DISTINCT(`Group`) Code, `Name` FROM INVENTORY LEFT JOIN `GROUP` ON(GROUP.Code = INVENTORY.Group) ORDER BY `Group`;";
								$result = mysqli_query($con, $query);
								while($row=mysqli_fetch_array($result)){
							 ?>
								<option value="<?= $row['Code'] ?>"><?= $row['Code'] . " - " . $row['Name'] ?></option>
							 <?php
								}
							  ?>
							  </select>
							  <!--<input type="text" class="form-control" id="inventoryStatsGroup" placeholder="Group">-->
							</div>
							<button class="btn btn-primary" onclick="fillInventoryStats();">Go</button>
						</div>

						<table class="table table-condensed">
							<thead>
								<tr>
									<th>Total Qty</th>
									<th>Total Cost</th>
									<th>Total Price</th>
								</tr>
							</thead>
							<tbody id="inventoryStatisticsTbody">

							</tbody>
						</table>
					</div>
					<div class="modal-footer">
						<button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
					</div>
				</div>
			</div>
			<script type="text/javascript">
				function fillInventoryStats(){
					$.get('mod.php?p=inventorymanage&a=functions&f=getInventoryStatistics', {
							"line" : $('#inventoryStatsLine').val(),
							"group" : $('#inventoryStatsGroup').val(),
						}, function(data){
							data = JSON.parse(data);
							$('#inventoryStatisticsTbody').html("<tr><td>" + data.TotalQty + "</td><td>" + moneyFormat(data.TotalCost) + "</td><td>" + moneyFormat(data.TotalPrice) + "</td></tr>");
						});
				}

			</script>
		</div>
	</body>
</html>
