<?php
class Warehouse {

	private $hasQuotes, $PRIVATE_KEY, $TABLE_NAME;
	public function __construct($ID){

		global $con;
		//
		//	Private Key
		//
		$this->PRIVATE_KEY = "WarehouseID";
		//
		// Table name
		//
		$this->TABLE_NAME = "MULTIPLE_WAREHOUSE";
		//
		// Get Table Column and add to object.
		//
		$query = "SELECT * FROM `{$this->TABLE_NAME}` WHERE `{$this->PRIVATE_KEY}` = $ID";
		$result = mysqli_query($con, $query);
		$row = mysqli_fetch_array($result, MYSQLI_ASSOC);
		foreach($row as $key => $value){
				$this->$key = $value;
		}
		//
		// Get Columns Names and either if they need quotes in a query or not.
		//
		$this->hasQuotes = [];
		$query = "SHOW COLUMNS FROM `{$this->TABLE_NAME}`";
		$result = mysqli_query($con,$query);
		while($row = mysqli_fetch_array($result, MYSQLI_ASSOC)){
			if(stripos($row['Type'], "int") === 0 || stripos($row['Type'], "double") === 0 || stripos($row['Type'], "tinyint") === 0 || stripos($row['Type'], "numeric") === 0 || stripos($row['Type'], "double") === 0 || stripos($row['Type'], "decimal") === 0 || stripos($row['Type'], "float") === 0 || stripos($row['Type'], "bigint") === 0 || stripos($row['Type'], "real") === 0 || stripos($row['Type'], "bool") === 0){
				$this->hasQuotes[$row['Field']] = false;
			}else{
				$this->hasQuotes[$row['Field']] = true;
			}
		}

	}
	public function getWarehouseItems(){
		global $con;
		$this->Items = [];
		$this->ItemIndex = [];
		$queryItems = "SELECT * FROM MULTIPLE_WH_INVENTORY WHERE `{$this->PRIVATE_KEY}` = $this->WarehouseID";
		//var_dump($queryItems);
		$resultItems = mysqli_query($con, $queryItems);
		while($rowItems = mysqli_fetch_array($resultItems, MYSQLI_ASSOC)){
			// $invItem = new Item("%", $rowItems['Line'], $rowItems['SKU']);
			// $rowItems['InventoryItem'] = $invItem;
			array_push($this->ItemIndex, $rowItems['Line'] . "-" . $rowItems['SKU']);
			array_push($this->Items, $rowItems);
		}
	}
	public function getWarehouseItemBySKU($Line,  $SKU){
		$index = array_search($Line . "-" . $SKU, $this->ItemIndex);
		if($index !== false){
			return $this->Items[$index];
		}
	}
	//
	// Function to create a "column = value" string usable by mysql query;
	//
	private function saveString($Column, $Value){
		if(is_null($Value)){
			$returnValue = "NULL";
		}else{
			$returnValue = ($this->hasQuotes[$Column])?"'$Value'":"$Value";
		}
		return " `$Column` = $returnValue ";
	}
	//
	// function to save all the values in the object to the table.
	//
	public function save(){
		global $con;
		$query = "UPDATE `{$this->TABLE_NAME}` SET ";
		$saveQuery = [];
		foreach($this->hasQuotes as $fieldName => $quotes){
			if($fieldName != $this->PRIVATE_KEY){
				$saveQuery[] = $this->saveString($fieldName, $this->$fieldName);
			}
		}
		$query .= implode(", ", $saveQuery) . " WHERE `{$this->PRIVATE_KEY}` = " . $this->{$this->PRIVATE_KEY};
		return mysqli_query($con, $query);
	}
	public function addItem($Line, $SKU, $Qty, $NormalStock = 0){
		global $con;
		$query = "INSERT INTO MULTIPLE_WH_INVENTORY (WarehouseID, `Line`, SKU, Qty, StockLevel) VALUES ('{$this->WarehouseID}', '{$Line}', '{$SKU}', $Qty, $NormalStock	) ON DUPLICATE KEY UPDATE Qty = Qty + $Qty";
		if(mysqli_query($con, $query)){
			return mysqli_insert_id($con);
		}else{
			error_log(mysqli_error($con));
			return false;
		}
	}
}
class WarehouseItem {
	private $hasQuotes, $PRIVATE_KEY, $TABLE_NAME;
	public function __construct($ID){
		global $con;
		//
		//	Private Key
		//
		$this->PRIVATE_KEY = "id";
		//
		// Table name
		//
		$this->TABLE_NAME = "MULTIPLE_WH_INVENTORY";
		//
		// Get Table Column and add to object.
		//
		$query = "SELECT * FROM `{$this->TABLE_NAME}` WHERE `{$this->PRIVATE_KEY}` = $ID";
		$result = mysqli_query($con, $query);
		$row = mysqli_fetch_array($result, MYSQLI_ASSOC);
		foreach($row as $key => $value){
				$this->$key = $value;
		}
		$this->InventoryItem = new Item("%", $row['Line'], $row['SKU']);
		//
		// Get Columns Names and either if they need quotes in a query or not.
		//
		$this->hasQuotes = [];
		$query = "SHOW COLUMNS FROM `{$this->TABLE_NAME}`";
		$result = mysqli_query($con,$query);
		while($row = mysqli_fetch_array($result, MYSQLI_ASSOC)){
			if(stripos($row['Type'], "int") === 0 || stripos($row['Type'], "double") === 0 || stripos($row['Type'], "tinyint") === 0 || stripos($row['Type'], "numeric") === 0 || stripos($row['Type'], "double") === 0 || stripos($row['Type'], "decimal") === 0 || stripos($row['Type'], "float") === 0 || stripos($row['Type'], "bigint") === 0 || stripos($row['Type'], "real") === 0 || stripos($row['Type'], "bool") === 0){
				$this->hasQuotes[$row['Field']] = false;
			}else{
				$this->hasQuotes[$row['Field']] = true;
			}
		}
	}
	//
	// Function to create a "column = value" string usable by mysql query;
	//
	private function saveString($Column, $Value){
		if(is_null($Value)){
			$returnValue = "NULL";
		}else{
			$returnValue = ($this->hasQuotes[$Column])?"'$Value'":"$Value";
		}
		return " `$Column` = $returnValue ";
	}
	//
	// function to save all the values in the object to the table.
	//
	public function save(){
		global $con;
		$query = "UPDATE `{$this->TABLE_NAME}` SET ";
		$saveQuery = [];
		foreach($this->hasQuotes as $fieldName => $quotes){
			if($fieldName != $this->PRIVATE_KEY){
				$saveQuery[] = $this->saveString($fieldName, $this->$fieldName);
			}
		}
		$query .= implode(", ", $saveQuery) . " WHERE `{$this->PRIVATE_KEY}` = " . $this->{$this->PRIVATE_KEY};
		return mysqli_query($con, $query);
	}
}


?>
