<?php

class Item {
	public $Group, $Line, $SKU, $Description, $Notes, $Interchange, $Price, $Cost, $AvgCost, $LastCost, $Core, $AvailableQty, $UPC, $Taxable1, $Taxable2;
	public function __construct($Group, $Line, $SKU, $PriceListId = null) {
		$Group = trim($Group);
		$Line = trim($Line);
		$SKU = trim($SKU);
		$query = "SELECT * FROM INVENTORY WHERE `Line` LIKE '$Line' AND `SKU` LIKE '$SKU'";
		global $con;
		$result = mysqli_query($con, $query);
		if(mysqli_num_rows($result)){
			$this->Exists = true;
		}else{
			$this->Exists = false;
		}
		$row = mysqli_fetch_array($result);
		foreach($row as $key => $value){
			$this->$key = $value;
		}

		$this->Core = $row['Core'];
		//$this->Group = $row['Group'];
		//$this->Line = $row['Line'];
		//$this->SKU = $row['SKU'];
		//$this->Description = $row['Description'];
		//$this->Notes = $row['Notes'];
		//
		//$this->AvgCost = $row['AvgCost'];
		//$this->Location = $row['Location'];
		//$this->ImageURL = $row['ImageURL'];
		//$this->Taxable1 = $row['Taxable1'];
		//$this->Taxable2 = $row['Taxable2'];
		//$this->ProductURL = $row['ProductURL'];
		$this->Attributes = array();
		$queryAttr = "SELECT * FROM PRODUCT_ATTRIBUTE WHERE SKU = '$SKU' AND Line = '$Line'";
		$resultAttr = mysqli_query($con, $queryAttr);
		$newArray = array();
		while($rowAttr = mysqli_fetch_array($resultAttr)){
			$pair = new stdClass();
			$pair->Name= trim($rowAttr['Name']);
			$pair->Value = $rowAttr['Value'];
			array_push($newArray, $pair);
				//array_push($this->Attributes, $pair);

			unset($pair);
		}
		if($this->ImageURL != ""){
			$pair = new stdClass();
			$pair->Name= "Stock Image";
			$pair->Value = "<img style=\"max-width: 100%;\" src=\"" . $this->ImageURL . "\" />";
			array_push($newArray, $pair);
		}
		$this->Attributes = $newArray;
		$this->Interchange = $row['Interchange'];
		if ($PriceListId) {
			$query2 = "SELECT * FROM PRICE_LIST_DETAIL WHERE `PriceListID` = $PriceListId AND TRIM(`Group`) LIKE '" . trim($Group) . "' AND TRIM(`Line`) LIKE '" . trim($Line) . "' AND TRIM(`SKU`) LIKE '" . trim($SKU) . "'";
			$result2 = mysqli_query($con, $query2);
			$row2 = mysqli_fetch_array($result2);
			$this->Price = $row2['Price'];
			$this->UPC = $row2['UPC'];
		}else {
			$this->Price = getCustomerPrice($row['Group'], $row['Line'], $row['SKU']);

		}


		$this->Core = $row['Core'];
		$this->AvailableQty = $row['Qty'];
		//get items on the way;
		$query = "SELECT SUM(ConfirmedQty) ConfirmedQty FROM PURCHASE_ORDER_HEADER JOIN PURCHASE_ORDER_DETAIL USING(PurchaseOrderID) WHERE `Line` = '{$this->Line}' AND SKU = '{$this->SKU}' AND Sent = 1 AND ConfirmedQty > 0 AND Confirmed = 1 AND `Received` = 0;";
		$result = mysqli_query($con, $query);
		$row = mysqli_fetch_array($result, MYSQLI_ASSOC);
		$this->ConfrimedQuery = $query;
		$this->ConfirmedQty = $row['ConfirmedQty'];

		$this->hasQuotes = [];
		$query = "SHOW COLUMNS FROM `INVENTORY`";
		$result = mysqli_query($con,$query);
		while($row = mysqli_fetch_array($result, MYSQLI_ASSOC)){
			if(stripos($row['Type'], "int") === 0 || stripos($row['Type'], "double") === 0 || stripos($row['Type'], "tinyint") === 0 || stripos($row['Type'], "numeric") === 0 || stripos($row['Type'], "double") === 0 || stripos($row['Type'], "decimal") === 0 || stripos($row['Type'], "float") === 0 || stripos($row['Type'], "bigint") === 0 || stripos($row['Type'], "real") === 0 || stripos($row['Type'], "bool") === 0){
				$this->hasQuotes[$row['Field']] = false;
			}else{
				$this->hasQuotes[$row['Field']] = true;
			}
		}
	}
	//
	// Function to create a "column = value" string usable by mysql query;
	//
	private function saveString($Column, $Value){

		if(is_null($Value)){
			$returnValue = "NULL";
		}else{
			$returnValue = ($this->hasQuotes[$Column])?"'$Value'":"$Value";
		}
		return " `$Column` = $returnValue ";
	}
	//
	// function to save all the values in the object to the table.
	//
	public function save(){
		global $con;

		$query = "UPDATE `INVENTORY` SET ";
		$saveQuery = [];
		foreach($this->hasQuotes as $fieldName => $quotes){
			if($fieldName != $this->PRIVATE_KEY){
				$saveQuery[] = $this->saveString($fieldName, $this->$fieldName);
			}
		}
		$query .= implode(", ", $saveQuery) . " WHERE `Line` = '" . $this->Line . "' AND SKU = '" . $this->SKU . "'";
		return mysqli_query($con, $query);
	}
	public function getLocations(){
		$locationsArray = [];
		array_push($locationsArray, $this->Location);
		array_push($locationsArray, $this->LocationB);
		array_push($locationsArray, $this->LocationC);
		array_push($locationsArray, $this->LocationD);
		array_push($locationsArray, $this->LocationE);
		return $locationsArray;

	}
	public function getCommittedQty(){
		global $con;
		$query = "SELECT SUM(`CommittedQty`) TotalCommitted FROM (SELECT SUM(OrderQty) `CommittedQty` FROM ORDER_HEAD JOIN ORDER_DETAIL USING(OrderID) WHERE Processed = 0 AND DeleteOrder = 0 AND Line = '{$this->Line}' AND SKU = '{$this->SKU}' UNION
				SELECT SUM(OrderQty) `CommittedQty` FROM INVOICE_HEAD JOIN INVOICE_DETAIL USING(InvoiceID) WHERE `Status` = 0 AND Void = 0 AND Line = '{$this->Line}' AND SKU = '{$this->SKU}') t";
		$result = mysqli_query($con, $query);
		$row = mysqli_fetch_array($result);
		return $row['TotalCommitted'];
	}
	public function organizeLocations(){
		if($this->Location == ""){
			$this->Location = $this->LocationB;
			$this->LocationB = "";
		}
		if($this->LocationB == ""){
			$this->LocationB = $this->LocationC;
			$this->LocationC = "";
		}
		if($this->LocationC == ""){
			$this->LocationC = $this->LocationD;
			$this->LocationD = "";
		}
		if($this->LocationD == ""){
			$this->LocationD = $this->LocationE;
			$this->LocationE = "";
		}
		global $con;
		$query = "UPDATE INVENTORY SET Location = '" . $this->Location . "', LocationB = '" . $this->LocationB . "', LocationC = '" . $this->LocationC . "', LocationD = '" . $this->LocationD . "', LocationE = '" . $this->LocationE . "'  WHERE `Line` = '" . $this->Line . "' AND `SKU` = '" . $this->SKU . "'";
		mysqli_query($con, $query);
	}
	public function getAttribute($name){
		global $con;
		foreach($this->Attributes as $key=>$value){

			if($value->Name == $name){
				return $value->Value;
				break;
			}
		}
	}
	public function getUPC($qty = 1){
		global $con;
		$query = "SELECT * FROM PRODUCT_UPC WHERE `Line` LIKE '" . $this->Line . "' AND SKU LIKE '" . $this->SKU . "' AND Qty = $qty ORDER BY UPC ASC";
		if($result = mysqli_query($con, $query)){
			$row = mysqli_fetch_array($result, MYSQLI_ASSOC);
		return $row['UPC'];
		}else{
			return false;
		}


	}
	public function getImage($admin = false){
		$line = $this->Line;
		$sku = $this->SKU;
		$formats = "jpg,jpeg,png,gif,bmp";
		$formats = explode(",", $formats);
		$hasImage = false;
		$prefix = ".";
		if ($admin) {
			$prefix = "..";
		}
		foreach ($formats as $key => $value) {
			$hasImage = $hasImage || file_exists($prefix . "/img/catalog/" . $line . " " . $sku . ".$value");
			if ($hasImage) {
				return $prefix . "/img/catalog/" . $line . " " . $sku . ".$value?time=" . @filemtime($prefix . "/img/catalog/" . $line . " " . $sku . ".$value");
			}
		}
		global $con;

		if($this->ImageURL){
			return $this->ImageURL;
		}else{
			return $prefix . "/img/no_image_available.png";
		}

	}

}

?>
