<?php

class Customer {
	public $Name, $Email, $AccountNumber, $Salesman, $LastLogin, $Language, $Active, $Phone, $MainNumber, $PriceLevel, $Contact, $DisableCheck, $CreditLimit, $DiscountDays, $Comments, $WaiveShipping, $SendOrderEmail;
	public $Address1, $Address2, $ZipCode, $State, $TaxID1, $TaxID2, $TaxIDExpiration1, $TaxIDExpiration2, $hasQuotes;
	public function __construct($AccountNumber) {
		if($AccountNumber == "" || is_null($AccountNumber)){
			//return false;
		}
		$query = "SELECT * FROM CUSTOMER WHERE AccountNumber LIKE '$AccountNumber'";
		if (stripos($AccountNumber, "-")>-1) {
			$this->MainNumber = explode("-", $AccountNumber);
			$this->MainNumber = $this->MainNumber[0];
		}else {
			$this->MainNumber = $AccountNumber;
		}
		global $con;
		if($AccountNumber == "" || is_null($AccountNumber)){

		}else{
			$result = mysqli_query($con, $query);
			$row = mysqli_fetch_array($result);
			$this->OriginalColumns = array();
			foreach($row as $key => $value){
				$this->$key = $value;
				array_push($this->OriginalColumns, $key);
			}
		}



		$this->SalesmanID = $this->Salesman;
		$this->Salesman = new Salesman($this->Salesman);
		$this->TaxExempt1 = $this->TaxExempt1 && ($row['TaxID1'] != "" && strtotime($row['TaxIDExpiration1']) > time());
		$this->TaxExempt2 = $this->TaxExempt2 && ($row['TaxID2'] != "" && strtotime($row['TaxIDExpiration2']) > time());
		if($this->TaxExempt1){
			$this->TaxExempt1 = 1;
		}else{
			$this->TaxExempt1 = 0;
		}
		if($this->TaxExempt2){
			$this->TaxExempt2 = 1;
		}else{
			$this->TaxExempt2 = 0;
		}
		$this->TermsDays = 0;
		//$this->Name = $row['Name'];
		//$this->City = $row['City'];
		//$this->Phone = $row['Phone'];
		//$this->Contact = $row['Contact'];
		//$this->ContactTitle = $row['ContactTitle'];
		//$this->Email = $row['Email'];
		//$this->SendOrderEmail = $row['SendOrderEmail'];
		//$this->AccountNumber = $row['AccountNumber'];
		//$this->CreditLimit = $row['CreditLimit'];
		//$this->Address1 = $row['Address1'];
		//$this->Address2 = $row['Address2'];
		//$this->ZipCode = $row['ZipCode'];
		//$this->State = $row['State'];
		//
		//$this->ShipToAddress1 = $row['ShipToAddress1'];
		//$this->ShipToAddress2 = $row['ShipToAddress2'];
		//$this->ShipToCity = $row['ShipToCity'];
		//$this->ShipToZip = $row['ShipToZip'];
		//$this->ShipToState = $row['ShipToState'];
		//
		//$this->Terms = $row['Terms'];
		//$this->DiscountDays = $row['DiscountDays'];
		//$this->Salesman = new Salesman($row['Salesman']);
		//$this->Comments = $row['Comments'];
		//$this->LastLogin = $row['LastLogin'];
		//$this->Password = $row['Password'];
		//$this->Language = $row['Language'];
		//$this->DisableCheck = $row['DisableCheck'];
		//$this->Active = $row['Active'];
		//$this->TaxID1 = $row['TaxID1'];
		//$this->TaxID2 = $row['TaxID2'];
		//$this->TaxIDExpiration1 = $row['TaxIDExpiration1'];
		//$this->TaxIDExpiration2 = $row['TaxIDExpiration2'];
		////$this->TaxExempt1 = ($row['TaxID1'] != "" && strtotime($row['TaxIDExpiration1']) > time());
		//$this->TaxExempt1 = false;
		//$this->TaxExempt2 = ($row['TaxID2'] != "" && strtotime($row['TaxIDExpiration2']) > time());
		//$this->PriceLevel =$row['PriceLevel'];
		//$this->WaiveShipping = $row['WaiveShipping'];
		//
		//
		// Get Columns Names and either if they need quotes in a query or not.
		//
		$this->hasQuotes = [];
		$query = "SHOW COLUMNS FROM `CUSTOMER`";
		$result = mysqli_query($con,$query);
		while($row = mysqli_fetch_array($result, MYSQLI_ASSOC)){
			if(stripos($row['Type'], "int") === 0 || stripos($row['Type'], "double") === 0 || stripos($row['Type'], "tinyint") === 0 || stripos($row['Type'], "numeric") === 0 || stripos($row['Type'], "double") === 0 || stripos($row['Type'], "decimal") === 0 || stripos($row['Type'], "float") === 0 || stripos($row['Type'], "bigint") === 0 || stripos($row['Type'], "real") === 0 || stripos($row['Type'], "bool") === 0){
				$this->hasQuotes[$row['Field']] = false;
			}else{
				$this->hasQuotes[$row['Field']] = true;
			}
		}

		if(strtoupper($this->Terms) == "2/15 NET 16"){
			$this->TermsDays = 15;
		}else{
			$this->TermsDays = intval($this->Terms);
		}

	}
    public function save(){



		global $con;
		$this->Salesman = $this->SalesmanID;
		$query = "UPDATE CUSTOMER SET ";
		$saveQuery = [];
		foreach($this->hasQuotes as $fieldName => $quotes){
			if($fieldName != "AccountNumber"){
				$saveQuery[] = $this->saveString($fieldName, $this->$fieldName);
			}
		}
		$query .= implode(", ", $saveQuery) . " WHERE `AccountNumber` = '" . $this->AccountNumber . "'";
		mysqli_query($con, $query);
		//echo $query . "\n";
		$this->Salesman = new Salesman($this->SalesmanID);

	}
	private function saveString($Column, $Value){

		if(is_null($Value)){
			$returnValue = "NULL";
		}elseif(strtoupper($Value) == "NOW()"){
			$returnValue = "NOW()";
		}else{
			$returnValue = ($this->hasQuotes[$Column])?"'$Value'":"$Value";
		}
		return " `$Column` = $returnValue ";
	}

	public function getStatementKey(){
		global $config;
		//var_dump($this->AccountNumber . $config['SaltKey']);
		return substr(md5($this->AccountNumber . $config['SaltKey']),0,10);
	}
	public function getInvoices() {
		global $con;
		if($this->MainNumber != $this->AccountNumber){
			$query = "SELECT INVOICE_HEAD.*, ROUND(INVOICE_HEAD.Subtotal-SUM(PaymentAmount),2) AS Balance, PAYMENT_DETAIL.PartialPayment, ROUND(SUM(PAYMENT_DETAIL.PaymentAmount),2) as PaymentAmount  FROM INVOICE_HEAD LEFT JOIN PAYMENT_DETAIL ON INVOICE_HEAD.InvoiceID = PAYMENT_DETAIL.InvoiceID WHERE `AccountNumber`='" . $this->AccountNumber . "' AND (PartialPayment = 1 OR PartialPayment IS NULL) AND INVOICE_HEAD.Status = 1 AND INVOICE_HEAD.InvoiceID NOT IN (SELECT InvoiceID FROM PAYMENT_DETAIL WHERE PartialPayment = 0) GROUP BY InvoiceID  ORDER BY InvoiceDate ASC";

		}else{
			//$query = "SELECT INVOICE_HEAD.*, ROUND(INVOICE_HEAD.Subtotal-SUM(PaymentAmount),2) AS Balance, PAYMENT_DETAIL.PartialPayment, ROUND(SUM(PAYMENT_DETAIL.PaymentAmount),2) as PaymentAmount  FROM INVOICE_HEAD LEFT JOIN PAYMENT_DETAIL ON INVOICE_HEAD.InvoiceID = PAYMENT_DETAIL.InvoiceID WHERE `AccountNumber`='" . $this->AccountNumber . "' AND (PartialPayment = 1 OR PartialPayment IS NULL) AND INVOICE_HEAD.Status = 1 AND INVOICE_HEAD.InvoiceID NOT IN (SELECT InvoiceID FROM PAYMENT_DETAIL WHERE PartialPayment = 0) GROUP BY InvoiceID  ORDER BY InvoiceDate ASC";
			$query = "SELECT INVOICE_HEAD.*, ROUND(INVOICE_HEAD.Subtotal-SUM(PaymentAmount),2) AS Balance, PartialPayment, ROUND(SUM(DETAILED_PAYMENT.PaymentAmount),2) as PaymentAmount FROM INVOICE_HEAD LEFT JOIN DETAILED_PAYMENT USING(InvoiceID) WHERE INVOICE_HEAD.`AccountNumber`='" . $this->AccountNumber . "' AND (PartialPayment = 1 OR PartialPayment IS NULL) AND INVOICE_HEAD.Status = 1 AND INVOICE_HEAD.InvoiceID not IN (SELECT InvoiceID FROM DETAILED_PAYMENT WHERE PartialPayment = 0 and Void = 0) GROUP BY InvoiceID ORDER BY InvoiceDate ASC";
			//echo $query;
		}
		$result = mysqli_query($con, $query);
		$invoices = array();
		while ($row = mysqli_fetch_array($result, MYSQLI_ASSOC)){
			$row['Subtotal'] = ($row['Balance'] == null)?$row['Subtotal']:$row['Balance'];
			$query2 = "SELECT SUM(OverAmount) as Overpayment, GROUP_CONCAT(Reason SEPARATOR '--') as Reasons, GROUP_CONCAT(User SEPARATOR '--') as User  FROM INVOICE_ADJUST WHERE InvoiceNumber = '" . $row['InvoiceNumber'] . "' GROUP BY InvoiceNumber";
			$result2 = mysqli_query($con, $query2);
			if(mysqli_num_rows($result2) > 0){
				$row2 = mysqli_fetch_array($result2, MYSQLI_ASSOC);
				$row['Subtotal'] -= $row2['Overpayment'];
				$row['Balance'] -= $row2['Overpayment'];
				$row['Overpayment'] = $row2['Overpayment'];
				$row['Reasons'] = $row2['Reasons'];
				$row['User'] = $row2['User'];
			}
			array_push($invoices,$row);
		}
		return $invoices;
	}

	public function getStatement(){
		global $con;

			//$query = "SELECT INVOICE_HEAD.*, ROUND(INVOICE_HEAD.Subtotal-SUM(PaymentAmount),2) AS Balance, PAYMENT_DETAIL.PartialPayment, ROUND(SUM(PAYMENT_DETAIL.PaymentAmount),2) as PaymentAmount  FROM INVOICE_HEAD LEFT JOIN PAYMENT_DETAIL ON INVOICE_HEAD.InvoiceID = PAYMENT_DETAIL.InvoiceID WHERE `AccountNumber`='" . $this->AccountNumber . "' AND (PartialPayment = 1 OR PartialPayment IS NULL) AND INVOICE_HEAD.Status = 1 AND INVOICE_HEAD.InvoiceID NOT IN (SELECT InvoiceID FROM PAYMENT_DETAIL WHERE PartialPayment = 0) GROUP BY InvoiceID  ORDER BY InvoiceDate ASC";
			$query = "SELECT INVOICE_HEAD.*, ROUND(INVOICE_HEAD.Subtotal-SUM(PaymentAmount),2) AS Balance, PartialPayment, ROUND(SUM(DETAILED_PAYMENT.PaymentAmount),2) as PaymentAmount FROM INVOICE_HEAD LEFT JOIN DETAILED_PAYMENT USING(InvoiceID) WHERE INVOICE_HEAD.`AccountNumber`='" . $this->AccountNumber . "' AND (PartialPayment = 1 OR PartialPayment IS NULL) AND INVOICE_HEAD.Status = 1 AND INVOICE_HEAD.InvoiceID not IN (SELECT InvoiceID FROM DETAILED_PAYMENT WHERE PartialPayment = 0 and Void = 0) GROUP BY InvoiceID ORDER BY InvoiceDate ASC";
			$days = 35;

			$query = "(SELECT	INVOICE_HEAD.InvoiceID                               TransactionID,
        IF(INVOICE_HEAD.Subtotal>=0,\"Invoice\",\"Credit\")		`Type`,
        INVOICE_HEAD.InvoiceDate                             TransactionDate,
        Datediff(Now(), INVOICE_HEAD.InvoiceDate) 			Days,
		        INVOICE_HEAD.PONumber Reference,
        Round(INVOICE_HEAD.Subtotal
              + INVOICE_HEAD.Tax1Total
              + INVOICE_HEAD.Tax2Total - IF(( Sum(PaymentAmount) IS NULL ), 0,
                                         Sum(
                                         PaymentAmount)), 2) AS Balance,
        Round(IF(Sum(DETAILED_PAYMENT.PaymentAmount) IS NULL, 0, Sum(
                    DETAILED_PAYMENT.PaymentAmount)), 2)     AS PaymentAmount
 FROM   INVOICE_HEAD
        LEFT JOIN DETAILED_PAYMENT USING(InvoiceID)
 WHERE  INVOICE_HEAD.`AccountNumber` = '" . $this->AccountNumber . "'
    AND ( PartialPayment = 1
           OR PartialPayment IS NULL )
    AND INVOICE_HEAD.Status = 1
    AND INVOICE_HEAD.InvoiceID NOT IN (SELECT InvoiceID
                                       FROM   DETAILED_PAYMENT
                                       WHERE  PartialPayment = 0 AND Void = 0)
 GROUP  BY INVOICE_HEAD.InvoiceID
 ORDER  BY INVOICE_HEAD.InvoiceDate ASC)
UNION
(SELECT PaymentID               TransactionID,
        \"Payment\"               `Type`,
        PaymentDate             TransactionDate,
        Datediff(Now(), PaymentDate) Days,
		        GROUP_CONCAT(DISTINCT(InvoiceID)) Reference,
        NULL                    Balance,
        Round(SUM(PaymentAmount), 2) PaymentAmount
 FROM   DETAILED_PAYMENT
 WHERE  DETAILED_PAYMENT.`AccountNumber` LIKE '" . $this->AccountNumber . "'
    AND Datediff(Now(), PaymentDate) <= $days
    AND PaymentID IS NOT NULL GROUP BY PaymentID)
UNION
(SELECT INVOICE_HEAD.InvoiceID                               TransactionID,
		IF(INVOICE_HEAD.Subtotal>=0,\"Invoice\",\"Credit\")		`Type`,
        INVOICE_HEAD.InvoiceDate                             TransactionDate,
        Datediff(Now(), INVOICE_HEAD.InvoiceDate)            Days,
		        INVOICE_HEAD.PONumber Reference,
        Round(INVOICE_HEAD.Subtotal
              + INVOICE_HEAD.Tax1Total
              + INVOICE_HEAD.Tax2Total - IF(( Sum(PaymentAmount) IS NULL ), 0,
                                         Sum(
                                         PaymentAmount)), 2) AS Balance,
        Round(IF(Sum(DETAILED_PAYMENT.PaymentAmount) IS NULL, 0, Sum(
                    DETAILED_PAYMENT.PaymentAmount)), 2)     AS PaymentAmount
 FROM   INVOICE_HEAD
        LEFT JOIN DETAILED_PAYMENT USING(InvoiceID)
 WHERE  INVOICE_HEAD.`AccountNumber` = '" . $this->AccountNumber . "'
    AND Datediff(Now(), INVOICE_HEAD.InvoiceDate) <= $days
    AND INVOICE_HEAD.Status = 1
    AND INVOICE_HEAD.InvoiceID
 GROUP  BY INVOICE_HEAD.InvoiceID
 ORDER  BY INVOICE_HEAD.InvoiceDate ASC) ORDER BY TransactionDate";

		$result = mysqli_query($con, $query);
		$transactions = array();
		while ($row = mysqli_fetch_array($result, MYSQLI_ASSOC)){

			array_push($transactions,$row);
		}
		return $transactions;
	}
	public function getStatementURL(){
		global $con, $config;
		global $root;
		return "mod.php?p=payment&a=statement&an=" . $this->AccountNumber . "&key=" . $this->getStatementKey();

	}
	public function sendStatementEmail(){
		global $con, $config;
		global $root;

		$companyName = $this->Name;

		$emailText = <<<EOF


		<!DOCTYPE HTML PUBLIC "-//W3C//DTD XHTML 1.0 Transitional //EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd"><html xmlns="http://www.w3.org/1999/xhtml" xmlns:v="urn:schemas-microsoft-com:vml" xmlns:o="urn:schemas-microsoft-com:office:office">
<head>
    <!--[if gte mso 9]><xml>
     <o:OfficeDocumentSettings>
      <o:AllowPNG/>
      <o:PixelsPerInch>96</o:PixelsPerInch>
     </o:OfficeDocumentSettings>
    </xml><![endif]-->
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8">
    <meta name="viewport" content="width=device-width">
    <!--[if !mso]><!--><meta http-equiv="X-UA-Compatible" content="IE=edge"><!--<![endif]-->
    <title></title>
    <!--[if !mso]><!-- -->
	<link href="https://fonts.googleapis.com/css?family=Montserrat" rel="stylesheet" type="text/css" />
	<!--<![endif]-->

    <style type="text/css" id="media-query">
      body {
  margin: 0;
  padding: 0; }

table, tr, td {
  vertical-align: top;
  border-collapse: collapse; }

.ie-browser table, .mso-container table {
  table-layout: fixed; }

* {
  line-height: inherit; }

a[x-apple-data-detectors=true] {
  color: inherit !important;
  text-decoration: none !important; }

[owa] .img-container div, [owa] .img-container button {
  display: block !important; }

[owa] .fullwidth button {
  width: 100% !important; }

[owa] .block-grid .col {
  display: table-cell;
  float: none !important;
  vertical-align: top; }

.ie-browser .num12, .ie-browser .block-grid, [owa] .num12, [owa] .block-grid {
  width: 600px !important; }

.ExternalClass, .ExternalClass p, .ExternalClass span, .ExternalClass font, .ExternalClass td, .ExternalClass div {
  line-height: 100%; }

.ie-browser .mixed-two-up .num4, [owa] .mixed-two-up .num4 {
  width: 200px !important; }

.ie-browser .mixed-two-up .num8, [owa] .mixed-two-up .num8 {
  width: 400px !important; }

.ie-browser .block-grid.two-up .col, [owa] .block-grid.two-up .col {
  width: 300px !important; }

.ie-browser .block-grid.three-up .col, [owa] .block-grid.three-up .col {
  width: 200px !important; }

.ie-browser .block-grid.four-up .col, [owa] .block-grid.four-up .col {
  width: 150px !important; }

.ie-browser .block-grid.five-up .col, [owa] .block-grid.five-up .col {
  width: 120px !important; }

.ie-browser .block-grid.six-up .col, [owa] .block-grid.six-up .col {
  width: 100px !important; }

.ie-browser .block-grid.seven-up .col, [owa] .block-grid.seven-up .col {
  width: 85px !important; }

.ie-browser .block-grid.eight-up .col, [owa] .block-grid.eight-up .col {
  width: 75px !important; }

.ie-browser .block-grid.nine-up .col, [owa] .block-grid.nine-up .col {
  width: 66px !important; }

.ie-browser .block-grid.ten-up .col, [owa] .block-grid.ten-up .col {
  width: 60px !important; }

.ie-browser .block-grid.eleven-up .col, [owa] .block-grid.eleven-up .col {
  width: 54px !important; }

.ie-browser .block-grid.twelve-up .col, [owa] .block-grid.twelve-up .col {
  width: 50px !important; }

@media only screen and (min-width: 620px) {
  .block-grid {
    width: 600px !important; }
  .block-grid .col {
    vertical-align: top; }
    .block-grid .col.num12 {
      width: 600px !important; }
  .block-grid.mixed-two-up .col.num4 {
    width: 200px !important; }
  .block-grid.mixed-two-up .col.num8 {
    width: 400px !important; }
  .block-grid.two-up .col {
    width: 300px !important; }
  .block-grid.three-up .col {
    width: 200px !important; }
  .block-grid.four-up .col {
    width: 150px !important; }
  .block-grid.five-up .col {
    width: 120px !important; }
  .block-grid.six-up .col {
    width: 100px !important; }
  .block-grid.seven-up .col {
    width: 85px !important; }
  .block-grid.eight-up .col {
    width: 75px !important; }
  .block-grid.nine-up .col {
    width: 66px !important; }
  .block-grid.ten-up .col {
    width: 60px !important; }
  .block-grid.eleven-up .col {
    width: 54px !important; }
  .block-grid.twelve-up .col {
    width: 50px !important; } }

@media (max-width: 620px) {
  .block-grid, .col {
    min-width: 320px !important;
    max-width: 100% !important;
    display: block !important; }
  .block-grid {
    width: calc(100% - 40px) !important; }
  .col {
    width: 100% !important; }
    .col > div {
      margin: 0 auto; }
  img.fullwidth, img.fullwidthOnMobile {
    max-width: 100% !important; }
  .no-stack .col {
    min-width: 0 !important;
    display: table-cell !important; }
  .no-stack.two-up .col {
    width: 50% !important; }
  .no-stack.mixed-two-up .col.num4 {
    width: 33% !important; }
  .no-stack.mixed-two-up .col.num8 {
    width: 66% !important; }
  .no-stack.three-up .col.num4 {
    width: 33% !important; }
  .no-stack.four-up .col.num3 {
    width: 25% !important; }
  .mobile_hide {
    min-height: 0px;
    max-height: 0px;
    max-width: 0px;
    display: none;
    overflow: hidden;
    font-size: 0px; } }

    </style>
</head>
<body class="clean-body" style="margin: 0;padding: 0;-webkit-text-size-adjust: 100%;background-color: #6FC1E1">
  <style type="text/css" id="media-query-bodytag">
    @media (max-width: 520px) {
      .block-grid {
        min-width: 320px!important;
        max-width: 100%!important;
        width: 100%!important;
        display: block!important;
      }

      .col {
        min-width: 320px!important;
        max-width: 100%!important;
        width: 100%!important;
        display: block!important;
      }

        .col > div {
          margin: 0 auto;
        }

      img.fullwidth {
        max-width: 100%!important;
      }
			img.fullwidthOnMobile {
        max-width: 100%!important;
      }
      .no-stack .col {
				min-width: 0!important;
				display: table-cell!important;
			}
			.no-stack.two-up .col {
				width: 50%!important;
			}
			.no-stack.mixed-two-up .col.num4 {
				width: 33%!important;
			}
			.no-stack.mixed-two-up .col.num8 {
				width: 66%!important;
			}
			.no-stack.three-up .col.num4 {
				width: 33%!important;
			}
			.no-stack.four-up .col.num3 {
				width: 25%!important;
			}
      .mobile_hide {
        min-height: 0px!important;
        max-height: 0px!important;
        max-width: 0px!important;
        display: none!important;
        overflow: hidden!important;
        font-size: 0px!important;
      }
    }
  </style>
  <!--[if IE]><div class="ie-browser"><![endif]-->
  <!--[if mso]><div class="mso-container"><![endif]-->
  <table class="nl-container" style="border-collapse: collapse;table-layout: fixed;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;vertical-align: top;min-width: 320px;Margin: 0 auto;background-color: #6FC1E1;width: 100%" cellpadding="0" cellspacing="0">
	<tbody>
	<tr style="vertical-align: top">
		<td style="word-break: break-word;border-collapse: collapse !important;vertical-align: top">
    <!--[if (mso)|(IE)]><table width="100%" cellpadding="0" cellspacing="0" border="0"><tr><td align="center" style="background-color: #6FC1E1;"><![endif]-->

    <div style="background-color:transparent;">
      <div style="Margin: 0 auto;min-width: 320px;max-width: 600px;overflow-wrap: break-word;word-wrap: break-word;word-break: break-word;background-color: transparent;" class="block-grid ">
        <div style="border-collapse: collapse;display: table;width: 100%;background-color:transparent;">
          <!--[if (mso)|(IE)]><table width="100%" cellpadding="0" cellspacing="0" border="0"><tr><td style="background-color:transparent;" align="center"><table cellpadding="0" cellspacing="0" border="0" style="width: 600px;"><tr class="layout-full-width" style="background-color:transparent;"><![endif]-->

              <!--[if (mso)|(IE)]><td align="center" width="600" style=" width:600px; padding-right: 0px; padding-left: 0px; padding-top:5px; padding-bottom:0px; border-top: 0px solid transparent; border-left: 0px solid transparent; border-bottom: 0px solid transparent; border-right: 0px solid transparent;" valign="top"><![endif]-->
            <div class="col num12" style="min-width: 320px;max-width: 600px;display: table-cell;vertical-align: top;">
              <div style="background-color: transparent; width: 100% !important;">
              <!--[if (!mso)&(!IE)]><!--><div style="border-top: 0px solid transparent; border-left: 0px solid transparent; border-bottom: 0px solid transparent; border-right: 0px solid transparent; padding-top:5px; padding-bottom:0px; padding-right: 0px; padding-left: 0px;"><!--<![endif]-->


                    <div align="center" class="img-container center  autowidth  fullwidth " style="padding-right: 0px;  padding-left: 0px;">
<!--[if mso]><table width="100%" cellpadding="0" cellspacing="0" border="0"><tr style="line-height:0px;line-height:0px;"><td style="padding-right: 0px; padding-left: 0px;" align="center"><![endif]-->
<div style="line-height:25px;font-size:1px">&#160;</div>  <img class="center  autowidth  fullwidth" align="center" border="0" src="https://d1oco4z2z1fhwp.cloudfront.net/templates/default/20/rounder-up.png" alt="Image" title="Image" style="outline: none;text-decoration: none;-ms-interpolation-mode: bicubic;clear: both;display: block !important;border: 0;height: auto;float: none;width: 100%;max-width: 600px" width="600">
<!--[if mso]></td></tr></table><![endif]-->
</div>


              <!--[if (!mso)&(!IE)]><!--></div><!--<![endif]-->
              </div>
            </div>
          <!--[if (mso)|(IE)]></td></tr></table></td></tr></table><![endif]-->
        </div>
      </div>
    </div>
    <div style="background-color:transparent;">
      <div style="Margin: 0 auto;min-width: 320px;max-width: 600px;overflow-wrap: break-word;word-wrap: break-word;word-break: break-word;background-color: #FFFFFF;" class="block-grid ">
        <div style="border-collapse: collapse;display: table;width: 100%;background-color:#FFFFFF;">
          <!--[if (mso)|(IE)]><table width="100%" cellpadding="0" cellspacing="0" border="0"><tr><td style="background-color:transparent;" align="center"><table cellpadding="0" cellspacing="0" border="0" style="width: 600px;"><tr class="layout-full-width" style="background-color:#FFFFFF;"><![endif]-->

              <!--[if (mso)|(IE)]><td align="center" width="600" style=" width:600px; padding-right: 0px; padding-left: 0px; padding-top:5px; padding-bottom:5px; border-top: 0px solid transparent; border-left: 0px solid transparent; border-bottom: 0px solid transparent; border-right: 0px solid transparent;" valign="top"><![endif]-->
            <div class="col num12" style="min-width: 320px;max-width: 600px;display: table-cell;vertical-align: top;">
              <div style="background-color: transparent; width: 100% !important;">
              <!--[if (!mso)&(!IE)]><!--><div style="border-top: 0px solid transparent; border-left: 0px solid transparent; border-bottom: 0px solid transparent; border-right: 0px solid transparent; padding-top:5px; padding-bottom:5px; padding-right: 0px; padding-left: 0px;"><!--<![endif]-->


                    <div align="center" class="img-container center  autowidth  " style="padding-right: 0px;  padding-left: 0px;">
<!--[if mso]><table width="100%" cellpadding="0" cellspacing="0" border="0"><tr style="line-height:0px;line-height:0px;"><td style="padding-right: 0px; padding-left: 0px;" align="center"><![endif]-->
  <img class="center  autowidth " align="center" border="0" src="|LOGO_URL|" alt="Image" title="Image" style="outline: none;text-decoration: none;-ms-interpolation-mode: bicubic;clear: both;display: block !important;border: 0;height: auto;float: none;width: 100%;max-width: 500px" width="500">
<!--[if mso]></td></tr></table><![endif]-->
</div>



                    <div class="">
	<!--[if mso]><table width="100%" cellpadding="0" cellspacing="0" border="0"><tr><td style="padding-right: 10px; padding-left: 10px; padding-top: 10px; padding-bottom: 10px;"><![endif]-->
	<div style="color:#555555;font-family:'Montserrat', 'Trebuchet MS', 'Lucida Grande', 'Lucida Sans Unicode', 'Lucida Sans', Tahoma, sans-serif;line-height:150%; padding-right: 10px; padding-left: 10px; padding-top: 10px; padding-bottom: 10px;">
		<div style="font-size:12px;line-height:18px;color:#555555;font-family:'Montserrat', 'Trebuchet MS', 'Lucida Grande', 'Lucida Sans Unicode', 'Lucida Sans', Tahoma, sans-serif;text-align:left;"><p style="margin: 0;font-size: 14px;line-height: 21px;text-align: center">
			Estado de Cuenta Autom&aacute;tico<br>
			Automatic Account Statement

		</p></div>
	</div>
	<!--[if mso]></td></tr></table><![endif]-->
</div>

              <!--[if (!mso)&(!IE)]><!--></div><!--<![endif]-->
              </div>
            </div>
          <!--[if (mso)|(IE)]></td></tr></table></td></tr></table><![endif]-->
        </div>
      </div>
    </div>
    <div style="background-color:transparent;">
      <div style="Margin: 0 auto;min-width: 320px;max-width: 600px;overflow-wrap: break-word;word-wrap: break-word;word-break: break-word;background-color: #FFFFFF;" class="block-grid ">
        <div style="border-collapse: collapse;display: table;width: 100%;background-color:#FFFFFF;">
          <!--[if (mso)|(IE)]><table width="100%" cellpadding="0" cellspacing="0" border="0"><tr><td style="background-color:transparent;" align="center"><table cellpadding="0" cellspacing="0" border="0" style="width: 600px;"><tr class="layout-full-width" style="background-color:#FFFFFF;"><![endif]-->

              <!--[if (mso)|(IE)]><td align="center" width="600" style=" width:600px; padding-right: 0px; padding-left: 0px; padding-top:0px; padding-bottom:5px; border-top: 0px solid transparent; border-left: 0px solid transparent; border-bottom: 0px solid transparent; border-right: 0px solid transparent;" valign="top"><![endif]-->
            <div class="col num12" style="min-width: 320px;max-width: 600px;display: table-cell;vertical-align: top;">
              <div style="background-color: transparent; width: 100% !important;">
              <!--[if (!mso)&(!IE)]><!--><div style="border-top: 0px solid transparent; border-left: 0px solid transparent; border-bottom: 0px solid transparent; border-right: 0px solid transparent; padding-top:0px; padding-bottom:5px; padding-right: 0px; padding-left: 0px;"><!--<![endif]-->


                    <div class="">
	<!--[if mso]><table width="100%" cellpadding="0" cellspacing="0" border="0"><tr><td style="padding-right: 10px; padding-left: 10px; padding-top: 10px; padding-bottom: 10px;"><![endif]-->
	<div style="color:#0D0D0D;font-family:'Montserrat', 'Trebuchet MS', 'Lucida Grande', 'Lucida Sans Unicode', 'Lucida Sans', Tahoma, sans-serif;line-height:120%; padding-right: 10px; padding-left: 10px; padding-top: 10px; padding-bottom: 10px;">
		<div style="line-height:14px;font-size:12px;color:#0D0D0D;font-family:'Montserrat', 'Trebuchet MS', 'Lucida Grande', 'Lucida Sans Unicode', 'Lucida Sans', Tahoma, sans-serif;text-align:left;"><p style="margin: 0;line-height: 14px;text-align: center;font-size: 12px"><span style="font-size: 28px; line-height: 33px;"><strong>{$companyName}</strong></span></p></div>
	</div>
	<!--[if mso]></td></tr></table><![endif]-->
</div>


                    <div align="center" class="img-container center  autowidth  " style="padding-right: 0px;  padding-left: 0px;">
<!--[if mso]><table width="100%" cellpadding="0" cellspacing="0" border="0"><tr style="line-height:0px;line-height:0px;"><td style="padding-right: 0px; padding-left: 0px;" align="center"><![endif]-->
  <img class="center  autowidth " align="center" border="0" src="https://d1oco4z2z1fhwp.cloudfront.net/templates/default/20/divider.png" alt="Image" title="Image" style="outline: none;text-decoration: none;-ms-interpolation-mode: bicubic;clear: both;display: block !important;border: 0;height: auto;float: none;width: 100%;max-width: 316px" width="316">
<!--[if mso]></td></tr></table><![endif]-->
</div>



                    <div class="">
	<!--[if mso]><table width="100%" cellpadding="0" cellspacing="0" border="0"><tr><td style="padding-right: 10px; padding-left: 10px; padding-top: 10px; padding-bottom: 10px;"><![endif]-->
	<div style="color:#555555;font-family:'Montserrat', 'Trebuchet MS', 'Lucida Grande', 'Lucida Sans Unicode', 'Lucida Sans', Tahoma, sans-serif;line-height:150%; padding-right: 10px; padding-left: 10px; padding-top: 10px; padding-bottom: 10px;">
		<div style="font-size:12px;line-height:18px;text-align:center;color:#555555;font-family:'Montserrat', 'Trebuchet MS', 'Lucida Grande', 'Lucida Sans Unicode', 'Lucida Sans', Tahoma, sans-serif;">
			<p style="margin: 0;font-size: 12px;line-height: 18px;text-align: center">
				An automatic account statement has been generated for your account. Please click <a href="|STATEMENT_URL|">here</a> to see it.<br (pATH: WestingPR).>
				For your convenience, you can make your payment via ATH Movil Business (pATH: WestingPR).
		</p></div>
	</div>
	<!--[if mso]></td></tr></table><![endif]-->
</div>


                    <div class="">
	<!--[if mso]><table width="100%" cellpadding="0" cellspacing="0" border="0"><tr><td style="padding-right: 10px; padding-left: 10px; padding-top: 10px; padding-bottom: 10px;"><![endif]-->
	<div style="color:#555555;font-family:'Montserrat', 'Trebuchet MS', 'Lucida Grande', 'Lucida Sans Unicode', 'Lucida Sans', Tahoma, sans-serif;line-height:150%; padding-right: 10px; padding-left: 10px; padding-top: 10px; padding-bottom: 10px;">
		<div style="font-size:12px;line-height:18px;color:#555555;font-family:'Montserrat', 'Trebuchet MS', 'Lucida Grande', 'Lucida Sans Unicode', 'Lucida Sans', Tahoma, sans-serif;text-align:left;"><p style="margin: 0;font-size: 12px;line-height: 18px;text-align: center">
			Se ha generado un estado de cuenta autom&aacute;tico. Haga click <a href="|STATEMENT_URL|">aqu&iacute;</a> para verlo.<br>
			Para su conveniencia, puede realizar su pago por ATH Movil Business (pATH: WestingPR).
		</p></div>
	</div>
	<!--[if mso]></td></tr></table><![endif]-->
</div>



<table border="0" cellpadding="0" cellspacing="0" width="100%" class="divider " style="border-collapse: collapse;table-layout: fixed;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;vertical-align: top;min-width: 100%;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%">
    <tbody>
        <tr style="vertical-align: top">
            <td class="divider_inner" style="word-break: break-word;border-collapse: collapse !important;vertical-align: top;padding-right: 10px;padding-left: 10px;padding-top: 30px;padding-bottom: 10px;min-width: 100%;mso-line-height-rule: exactly;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%">
                <table class="divider_content" height="0px" align="center" border="0" cellpadding="0" cellspacing="0" width="100%" style="border-collapse: collapse;table-layout: fixed;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;vertical-align: top;border-top: 0px solid transparent;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%">
                    <tbody>
                        <tr style="vertical-align: top">
                            <td style="word-break: break-word;border-collapse: collapse !important;vertical-align: top;font-size: 0px;line-height: 0px;mso-line-height-rule: exactly;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%">
                                <span>&#160;</span>
                            </td>
                        </tr>
                    </tbody>
                </table>
            </td>
        </tr>
    </tbody>
</table>

              <!--[if (!mso)&(!IE)]><!--></div><!--<![endif]-->
              </div>
            </div>
          <!--[if (mso)|(IE)]></td></tr></table></td></tr></table><![endif]-->
        </div>
      </div>
    </div>
    <div style="background-color:transparent;">
      <div style="Margin: 0 auto;min-width: 320px;max-width: 600px;overflow-wrap: break-word;word-wrap: break-word;word-break: break-word;background-color: #525252;" class="block-grid three-up ">
        <div style="border-collapse: collapse;display: table;width: 100%;background-color:#525252;">
          <!--[if (mso)|(IE)]><table width="100%" cellpadding="0" cellspacing="0" border="0"><tr><td style="background-color:transparent;" align="center"><table cellpadding="0" cellspacing="0" border="0" style="width: 600px;"><tr class="layout-full-width" style="background-color:#525252;"><![endif]-->

              <!--[if (mso)|(IE)]><td align="center" width="200" style=" width:200px; padding-right: 0px; padding-left: 0px; padding-top:0px; padding-bottom:0px; border-top: 0px solid transparent; border-left: 0px solid transparent; border-bottom: 0px solid transparent; border-right: 0px solid transparent;" valign="top"><![endif]-->
            <div class="col num4" style="max-width: 320px;min-width: 200px;display: table-cell;vertical-align: top;">
              <div style="background-color: transparent; width: 100% !important;">
              <!--[if (!mso)&(!IE)]><!--><div style="border-top: 0px solid transparent; border-left: 0px solid transparent; border-bottom: 0px solid transparent; border-right: 0px solid transparent; padding-top:0px; padding-bottom:0px; padding-right: 0px; padding-left: 0px;"><!--<![endif]-->


                    &#160;

              <!--[if (!mso)&(!IE)]><!--></div><!--<![endif]-->
              </div>
            </div>
              <!--[if (mso)|(IE)]></td><td align="center" width="200" style=" width:200px; padding-right: 0px; padding-left: 0px; padding-top:5px; padding-bottom:5px; border-top: 0px solid transparent; border-left: 0px solid transparent; border-bottom: 0px solid transparent; border-right: 0px solid transparent;" valign="top"><![endif]-->
            <div class="col num4" style="max-width: 320px;min-width: 200px;display: table-cell;vertical-align: top;">
              <div style="background-color: transparent; width: 100% !important;">
              <!--[if (!mso)&(!IE)]><!--><div style="border-top: 0px solid transparent; border-left: 0px solid transparent; border-bottom: 0px solid transparent; border-right: 0px solid transparent; padding-top:5px; padding-bottom:5px; padding-right: 0px; padding-left: 0px;"><!--<![endif]-->


                    <div class="">
	<!--[if mso]><table width="100%" cellpadding="0" cellspacing="0" border="0"><tr><td style="padding-right: 0px; padding-left: 0px; padding-top: 20px; padding-bottom: 0px;"><![endif]-->
	<div style="color:#a8bf6f;font-family:'Montserrat', 'Trebuchet MS', 'Lucida Grande', 'Lucida Sans Unicode', 'Lucida Sans', Tahoma, sans-serif;line-height:120%; padding-right: 0px; padding-left: 0px; padding-top: 20px; padding-bottom: 0px;">
		<div style="font-size:12px;line-height:14px;color:#a8bf6f;font-family:'Montserrat', 'Trebuchet MS', 'Lucida Grande', 'Lucida Sans Unicode', 'Lucida Sans', Tahoma, sans-serif;text-align:left;"><p style="margin: 0;font-size: 12px;line-height: 14px;text-align: center"><span style="color: rgb(255, 255, 255); font-size: 12px; line-height: 14px;"><span style="font-size: 12px; line-height: 14px; color: rgb(168, 191, 111);">Web:</span> {$root}</span></p></div>
	</div>
	<!--[if mso]></td></tr></table><![endif]-->
</div>

              <!--[if (!mso)&(!IE)]><!--></div><!--<![endif]-->
              </div>
            </div>
              <!--[if (mso)|(IE)]></td><td align="center" width="200" style=" width:200px; padding-right: 0px; padding-left: 0px; padding-top:5px; padding-bottom:5px; border-top: 0px solid transparent; border-left: 0px solid transparent; border-bottom: 0px solid transparent; border-right: 0px solid transparent;" valign="top"><![endif]-->
            <div class="col num4" style="max-width: 320px;min-width: 200px;display: table-cell;vertical-align: top;">
              <div style="background-color: transparent; width: 100% !important;">
              <!--[if (!mso)&(!IE)]><!--><div style="border-top: 0px solid transparent; border-left: 0px solid transparent; border-bottom: 0px solid transparent; border-right: 0px solid transparent; padding-top:5px; padding-bottom:5px; padding-right: 0px; padding-left: 0px;"><!--<![endif]-->


                    <div class="">
	<!--[if mso]><table width="100%" cellpadding="0" cellspacing="0" border="0"><tr><td style="padding-right: 0px; padding-left: 0px; padding-top: 20px; padding-bottom: 0px;"><![endif]-->
	<div style="color:#a8bf6f;font-family:'Montserrat', 'Trebuchet MS', 'Lucida Grande', 'Lucida Sans Unicode', 'Lucida Sans', Tahoma, sans-serif;line-height:120%; padding-right: 0px; padding-left: 0px; padding-top: 20px; padding-bottom: 0px;">
		<div style="font-size:12px;line-height:14px;color:#a8bf6f;font-family:'Montserrat', 'Trebuchet MS', 'Lucida Grande', 'Lucida Sans Unicode', 'Lucida Sans', Tahoma, sans-serif;text-align:left;"><p style="margin: 0;font-size: 12px;line-height: 14px;text-align: center">Email <span style="color: rgb(255, 255, 255); font-size: 12px; line-height: 14px;">{$config['OrderEmail']}</span></p></div>
	</div>
	<!--[if mso]></td></tr></table><![endif]-->
</div>

              <!--[if (!mso)&(!IE)]><!--></div><!--<![endif]-->
              </div>
            </div>
          <!--[if (mso)|(IE)]></td></tr></table></td></tr></table><![endif]-->
        </div>
      </div>
    </div>
    <div style="background-color:transparent;">
      <div style="Margin: 0 auto;min-width: 320px;max-width: 600px;overflow-wrap: break-word;word-wrap: break-word;word-break: break-word;background-color: transparent;" class="block-grid ">
        <div style="border-collapse: collapse;display: table;width: 100%;background-color:transparent;">
          <!--[if (mso)|(IE)]><table width="100%" cellpadding="0" cellspacing="0" border="0"><tr><td style="background-color:transparent;" align="center"><table cellpadding="0" cellspacing="0" border="0" style="width: 600px;"><tr class="layout-full-width" style="background-color:transparent;"><![endif]-->

              <!--[if (mso)|(IE)]><td align="center" width="600" style=" width:600px; padding-right: 0px; padding-left: 0px; padding-top:0px; padding-bottom:5px; border-top: 0px solid transparent; border-left: 0px solid transparent; border-bottom: 0px solid transparent; border-right: 0px solid transparent;" valign="top"><![endif]-->
            <div class="col num12" style="min-width: 320px;max-width: 600px;display: table-cell;vertical-align: top;">
              <div style="background-color: transparent; width: 100% !important;">
              <!--[if (!mso)&(!IE)]><!--><div style="border-top: 0px solid transparent; border-left: 0px solid transparent; border-bottom: 0px solid transparent; border-right: 0px solid transparent; padding-top:0px; padding-bottom:5px; padding-right: 0px; padding-left: 0px;"><!--<![endif]-->


                    <div align="center" class="img-container center  autowidth  fullwidth " style="padding-right: 0px;  padding-left: 0px;">
<!--[if mso]><table width="100%" cellpadding="0" cellspacing="0" border="0"><tr style="line-height:0px;line-height:0px;"><td style="padding-right: 0px; padding-left: 0px;" align="center"><![endif]-->
  <img class="center  autowidth  fullwidth" align="center" border="0" src="https://d1oco4z2z1fhwp.cloudfront.net/templates/default/20/rounder-dwn.png" alt="Image" title="Image" style="outline: none;text-decoration: none;-ms-interpolation-mode: bicubic;clear: both;display: block !important;border: 0;height: auto;float: none;width: 100%;max-width: 600px" width="600">
<!--[if mso]></td></tr></table><![endif]-->
</div>




<table border="0" cellpadding="0" cellspacing="0" width="100%" class="divider " style="border-collapse: collapse;table-layout: fixed;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;vertical-align: top;min-width: 100%;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%">
    <tbody>
        <tr style="vertical-align: top">
            <td class="divider_inner" style="word-break: break-word;border-collapse: collapse !important;vertical-align: top;padding-right: 30px;padding-left: 30px;padding-top: 30px;padding-bottom: 30px;min-width: 100%;mso-line-height-rule: exactly;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%">
                <table class="divider_content" align="center" border="0" cellpadding="0" cellspacing="0" width="100%" style="border-collapse: collapse;table-layout: fixed;border-spacing: 0;mso-table-lspace: 0pt;mso-table-rspace: 0pt;vertical-align: top;border-top: 0px solid transparent;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%">
                    <tbody>
                        <tr style="vertical-align: top">
                            <td style="word-break: break-word;border-collapse: collapse !important;vertical-align: top;mso-line-height-rule: exactly;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%">
                                <span></span>
                            </td>
                        </tr>
                    </tbody>
                </table>
            </td>
        </tr>
    </tbody>
</table>

              <!--[if (!mso)&(!IE)]><!--></div><!--<![endif]-->
              </div>
            </div>
          <!--[if (mso)|(IE)]></td></tr></table></td></tr></table><![endif]-->
        </div>
      </div>
    </div>
   <!--[if (mso)|(IE)]></td></tr></table><![endif]-->
		</td>
  </tr>
  </tbody>
  </table>
  <!--[if (mso)|(IE)]></div><![endif]-->


</body></html>




EOF;
		//$url = getStatementURL();
		$emailText = str_ireplace("|STATEMENT_URL|", $root . "/" . $this->getStatementURL(), $emailText);
		$emailText = str_ireplace("|LOGO_URL|", "{$root}/img/Logo_500.png",$emailText);
		$to = $config['OrderEmail'];
		$subject = "Westing PR, Inc. Account Statement";


		require_once './assets/PHPMailerAutoload.php';

		$results_messages = array();

		$mail = new PHPMailer(true);
		$mail->CharSet = 'utf-8';


		$customerEmail = $this->Email;
		try {
			//$mail->addAddress($to);
			$mail->addAddress("jcorrea@westingpr.com");
			if($customerEmail != ""){

				$to = explode(",",$customerEmail);
				foreach($to as $email){
					$mail->addCC($email);
				}

			}

			if($this->Salesman->Email != ""){
				$mail->addCC($this->Salesman->Email);
			}
		$mail->isMail();
		$mail->addReplyTo($config['FromEmail']);
		$mail->From       = $config['FromEmail'];
		$mail->FromName   = $config['FromEmailName'];

		$mail->Subject  = $subject;
		$title = $config["FromEmailName"];
		$body = $emailText;
		$mail->WordWrap = 78;
		$mail->msgHTML($body, dirname(__FILE__), true); //Create message bodies and embed images

		$privatekeyfile = 'dkim_private.key';
		//Make a new key pair
		//(2048 bits is the recommended minimum key length -
		//gmail won't accept less than 1024 bits)
		$pk = openssl_pkey_new(
			array(
				'private_key_bits' => 2048,
				'private_key_type' => OPENSSL_KEYTYPE_RSA
			)
		);
		openssl_pkey_export_to_file($pk, $privatekeyfile);

		$mail->DKIM_domain = 'westingpr.com';
		$mail->DKIM_private = $privatekeyfile;
		$mail->DKIM_selector = 'phpmailer';
		$mail->DKIM_passphrase = ''; //key is not encrypted
		try {
		  $mail->send();
		  unlink($privatekeyfile);
		  $results_messages[] = "Message has been sent using MAIL";
		}
		catch (phpmailerException $e) {
		  throw new phpmailerAppException('Unable to send to: ' . $to. ': '.$e->getMessage());
		}
		}
		catch (phpmailerAppException $e) {
		  $results_messages[] = $e->errorMessage();
		}


	}
	public function getAccountBalance(){
		$invoices = $this->getInvoices();
		$totalAccountDue = 0;
		$daysDue = 0;
		foreach($invoices as $oldInvoice){
			$days = ceil((time() - strtotime($oldInvoice['InvoiceDate']))/(24*60*60));
			$oldInvoiceTotal = $oldInvoice['Subtotal']+$oldInvoice['Tax1Total']+$oldInvoice['Tax2Total'];
			$totalAccountDue += $oldInvoiceTotal;
			if($oldInvoiceTotal > 0){
				$daysDue = max($days, $daysDue);
			}
		}
		return $totalAccountDue;
	}
	public function setPassword($oldPassword, $newPassword) {
		global $con;
		$query = "UPDATE CUSTOMER SET `Password` = '" . md5($newPassword) . "' WHERE AccountNumber '" . $this->AccountNumber . "' AND `Password` = '" . md5($oldPassword) . "'";
		$result = mysqli_query($query);
		if(mysqli_affected_rows($con) == 0){
			echo "Old Password may be incorrect";
		}
	}
	public function getDueDays(){
		global $con;

			$query = "SELECT AccountNumber, TIMESTAMPDIFF(DAY, MIN(INVOICE_HEAD.InvoiceDate), NOW()) AS DueDays FROM INVOICE_HEAD LEFT JOIN PAYMENT_DETAIL USING(InvoiceID) WHERE `AccountNumber` LIKE '" . $this->AccountNumber . "' AND INVOICE_HEAD.InvoiceID NOT IN (SELECT InvoiceID FROM PAYMENT_DETAIL WHERE PartialPayment = 0) GROUP BY AccountNumber";



		$result = mysqli_query($con, $query);
		$row = mysqli_fetch_array($result);
		if(!$row['DueDays']){
			$row['DueDays']= 0;
		}
		return $row['DueDays'];

	}
	public function updateDueDays(){
		global $con;
		$query = "UPDATE CUSTOMER SET DueDays = '" . $this->getDueDays() . "', DueDaysCalcDate = NOW() WHERE AccountNumber = '" . $this->AccountNumber . "'";
		$result = mysqli_query($con, $query);
		if($result){
			event_log("CRONJOB", "UPDATE CUSTOMER DUE DAYS", "AccountNumber: " . $this->AccountNumber . "\nCustomerName: " . $this->Name . "\nDueDays: " . $this->getDueDays());
		}
	}
	public function SendCollectionsEmail() {
		//TODO: Make this email generic. Currently has Company Info Hardcoded in the html.
		//$config = include_once("config.php");
		global $root, $config, $con;

		$daysQuery = "SELECT MAX(DATEDIFF(NOW(), DueDate)-1) DueDays FROM ACCOUNTS_RECEIVABLE_AGING_DELIVERY_CACHE JOIN INVOICE_HEAD USING(InvoiceID, AccountNumber) WHERE ACCOUNTS_RECEIVABLE_AGING_DELIVERY_CACHE.AccountNumber = '{$this->AccountNumber}' AND Balance > 0 AND DATEDIFF(NOW(), DueDate)-1 > 1";
		$daysResult = mysqli_query($con, $daysQuery);
		$overdueDays = mysqli_fetch_array($daysResult, MYSQLI_ASSOC);
		$overdueDays = $overdueDays['DueDays'];
		//var_dump($overdueDays);
		$to = $config['PaymentEmail'];
		$subject = "Cuenta con Balance Vencido";

		require_once '../assets/PHPMailerAutoload.php';

		$results_messages = array();

		$mail = new PHPMailer(true);
		$mail->CharSet = 'utf-8';

		$mail->isMail();
		$mail->addReplyTo($config['PaymentFromEmail']);
		$mail->From       = $config['PaymentFromEmail'];
		$mail->FromName   = $config['FromEmailName'];
			$mail->addCC("jcorrea@westingpr.com");
			$mail->addCC("esanchez@westingpr.com");
		if ($this->Salesman->Email != "" || $this->Salesman->Email != null) {
			$mail->addCC($this->Salesman->Email);
		}


		if ($this->Email != "" || $this->Email != null) {
			$mail->addAddress($this->Email);

		}

		$mail->Subject  = $subject;
		$title = $config["FromEmailName"];
		$body =
		'<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional //EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">

		<html xmlns="http://www.w3.org/1999/xhtml" xmlns:o="urn:schemas-microsoft-com:office:office" xmlns:v="urn:schemas-microsoft-com:vml">
		<head>
		<!--[if gte mso 9]><xml><o:OfficeDocumentSettings><o:AllowPNG/><o:PixelsPerInch>96</o:PixelsPerInch></o:OfficeDocumentSettings></xml><![endif]-->
		<meta content="text/html; charset=utf-8" http-equiv="Content-Type"/>
		<meta content="width=device-width" name="viewport"/>
		<!--[if !mso]><!-->
		<meta content="IE=edge" http-equiv="X-UA-Compatible"/>
		<!--<![endif]-->
		<title></title>
		<!--[if !mso]><!-->
		<link href="https://fonts.googleapis.com/css?family=Lato" rel="stylesheet" type="text/css"/>
		<!--<![endif]-->
		<style type="text/css">
				body {
					margin: 0;
					padding: 0;
				}

				table,
				td,
				tr {
					vertical-align: top;
					border-collapse: collapse;
				}

				* {
					line-height: inherit;
				}

				a[x-apple-data-detectors=true] {
					color: inherit !important;
					text-decoration: none !important;
				}
			</style>
		<style id="media-query" type="text/css">
				@media (max-width: 640px) {

					.block-grid,
					.col {
						min-width: 320px !important;
						max-width: 100% !important;
						display: block !important;
					}

					.block-grid {
						width: 100% !important;
					}

					.col {
						width: 100% !important;
					}

					.col>div {
						margin: 0 auto;
					}

					img.fullwidth,
					img.fullwidthOnMobile {
						max-width: 100% !important;
					}

					.no-stack .col {
						min-width: 0 !important;
						display: table-cell !important;
					}

					.no-stack.two-up .col {
						width: 50% !important;
					}

					.no-stack .col.num4 {
						width: 33% !important;
					}

					.no-stack .col.num8 {
						width: 66% !important;
					}

					.no-stack .col.num4 {
						width: 33% !important;
					}

					.no-stack .col.num3 {
						width: 25% !important;
					}

					.no-stack .col.num6 {
						width: 50% !important;
					}

					.no-stack .col.num9 {
						width: 75% !important;
					}

					.video-block {
						max-width: none !important;
					}

					.mobile_hide {
						min-height: 0px;
						max-height: 0px;
						max-width: 0px;
						display: none;
						overflow: hidden;
						font-size: 0px;
					}

					.desktop_hide {
						display: block !important;
						max-height: none !important;
					}
				}
			</style>
		</head>
		<body class="clean-body" style="margin: 0; padding: 0; -webkit-text-size-adjust: 100%; background-color: #FFFFFF;">
		<!--[if IE]><div class="ie-browser"><![endif]-->
		<table bgcolor="#FFFFFF" cellpadding="0" cellspacing="0" class="nl-container" role="presentation" style="table-layout: fixed; vertical-align: top; min-width: 320px; Margin: 0 auto; border-spacing: 0; border-collapse: collapse; mso-table-lspace: 0pt; mso-table-rspace: 0pt; background-color: #FFFFFF; width: 100%;" valign="top" width="100%">
		<tbody>
		<tr style="vertical-align: top;" valign="top">
		<td style="word-break: break-word; vertical-align: top;" valign="top">
		<!--[if (mso)|(IE)]><table width="100%" cellpadding="0" cellspacing="0" border="0"><tr><td align="center" style="background-color:#FFFFFF"><![endif]-->
		<div style="background-color:transparent;">
		<div class="block-grid two-up" style="Margin: 0 auto; min-width: 320px; max-width: 620px; overflow-wrap: break-word; word-wrap: break-word; word-break: break-word; background-color: transparent;">
		<div style="border-collapse: collapse;display: table;width: 100%;background-color:transparent;">
		<!--[if (mso)|(IE)]><table width="100%" cellpadding="0" cellspacing="0" border="0" style="background-color:transparent;"><tr><td align="center"><table cellpadding="0" cellspacing="0" border="0" style="width:620px"><tr class="layout-full-width" style="background-color:transparent"><![endif]-->
		<!--[if (mso)|(IE)]><td align="center" width="310" style="background-color:transparent;width:310px; border-top: 0px solid transparent; border-left: 0px solid transparent; border-bottom: 0px solid transparent; border-right: 0px solid transparent;" valign="top"><table width="100%" cellpadding="0" cellspacing="0" border="0"><tr><td style="padding-right: 10px; padding-left: 10px; padding-top:5px; padding-bottom:5px;"><![endif]-->
		<div class="col num6" style="max-width: 320px; min-width: 310px; display: table-cell; vertical-align: top; width: 310px;">
		<div style="width:100% !important;">
		<!--[if (!mso)&(!IE)]><!-->
		<div style="border-top:0px solid transparent; border-left:0px solid transparent; border-bottom:0px solid transparent; border-right:0px solid transparent; padding-top:5px; padding-bottom:5px; padding-right: 10px; padding-left: 10px;">
		<!--<![endif]-->
		<div align="center" class="img-container center autowidth fullwidth">
		<!--[if mso]><table width="100%" cellpadding="0" cellspacing="0" border="0"><tr style="line-height:0px"><td style="" align="center"><![endif]--><img align="center" alt="Image" border="0" class="center autowidth fullwidth" src="http://www.westingpr.com/img/Logo_1000.png" style="text-decoration: none; -ms-interpolation-mode: bicubic; border: 0; height: auto; width: 100%; max-width: 290px; display: block;" title="Image" width="290"/>
		<!--[if mso]></td></tr></table><![endif]-->
		</div>
		<!--[if (!mso)&(!IE)]><!-->
		</div>
		<!--<![endif]-->
		</div>
		</div>
		<!--[if (mso)|(IE)]></td></tr></table><![endif]-->
		<!--[if (mso)|(IE)]></td><td align="center" width="310" style="background-color:transparent;width:310px; border-top: 0px solid transparent; border-left: 0px solid transparent; border-bottom: 0px solid transparent; border-right: 0px solid transparent;" valign="top"><table width="100%" cellpadding="0" cellspacing="0" border="0"><tr><td style="padding-right: 10px; padding-left: 10px; padding-top:5px; padding-bottom:5px;"><![endif]-->
		<div class="col num6" style="max-width: 320px; min-width: 310px; display: table-cell; vertical-align: top; width: 310px;">
		<div style="width:100% !important;">
		<!--[if (!mso)&(!IE)]><!-->
		<div style="border-top:0px solid transparent; border-left:0px solid transparent; border-bottom:0px solid transparent; border-right:0px solid transparent; padding-top:5px; padding-bottom:5px; padding-right: 10px; padding-left: 10px;">
		<!--<![endif]-->
		<div></div>
		<!--[if (!mso)&(!IE)]><!-->
		</div>
		<!--<![endif]-->
		</div>
		</div>
		<!--[if (mso)|(IE)]></td></tr></table><![endif]-->
		<!--[if (mso)|(IE)]></td></tr></table></td></tr></table><![endif]-->
		</div>
		</div>
		</div>
		<div style="background-color:transparent;">
		<div class="block-grid" style="Margin: 0 auto; min-width: 320px; max-width: 620px; overflow-wrap: break-word; word-wrap: break-word; word-break: break-word; background-color: transparent;">
		<div style="border-collapse: collapse;display: table;width: 100%;background-color:transparent;">
		<!--[if (mso)|(IE)]><table width="100%" cellpadding="0" cellspacing="0" border="0" style="background-color:transparent;"><tr><td align="center"><table cellpadding="0" cellspacing="0" border="0" style="width:620px"><tr class="layout-full-width" style="background-color:transparent"><![endif]-->
		<!--[if (mso)|(IE)]><td align="center" width="620" style="background-color:transparent;width:620px; border-top: 0px solid transparent; border-left: 0px solid transparent; border-bottom: 0px solid transparent; border-right: 0px solid transparent;" valign="top"><table width="100%" cellpadding="0" cellspacing="0" border="0"><tr><td style="padding-right: 0px; padding-left: 0px; padding-top:5px; padding-bottom:5px;"><![endif]-->
		<div class="col num12" style="min-width: 320px; max-width: 620px; display: table-cell; vertical-align: top; width: 620px;">
		<div style="width:100% !important;">
		<!--[if (!mso)&(!IE)]><!-->
		<div style="border-top:0px solid transparent; border-left:0px solid transparent; border-bottom:0px solid transparent; border-right:0px solid transparent; padding-top:5px; padding-bottom:5px; padding-right: 0px; padding-left: 0px;">
		<!--<![endif]-->
		<table border="0" cellpadding="0" cellspacing="0" class="divider" role="presentation" style="table-layout: fixed; vertical-align: top; border-spacing: 0; border-collapse: collapse; mso-table-lspace: 0pt; mso-table-rspace: 0pt; min-width: 100%; -ms-text-size-adjust: 100%; -webkit-text-size-adjust: 100%;" valign="top" width="100%">
		<tbody>
		<tr style="vertical-align: top;" valign="top">
		<td class="divider_inner" style="word-break: break-word; vertical-align: top; min-width: 100%; -ms-text-size-adjust: 100%; -webkit-text-size-adjust: 100%; padding-top: 10px; padding-right: 10px; padding-bottom: 15px; padding-left: 10px;" valign="top">
		<table align="center" border="0" cellpadding="0" cellspacing="0" class="divider_content" role="presentation" style="table-layout: fixed; vertical-align: top; border-spacing: 0; border-collapse: collapse; mso-table-lspace: 0pt; mso-table-rspace: 0pt; border-top: 1px solid #222222; width: 100%;" valign="top" width="100%">
		<tbody>
		<tr style="vertical-align: top;" valign="top">
		<td style="word-break: break-word; vertical-align: top; -ms-text-size-adjust: 100%; -webkit-text-size-adjust: 100%;" valign="top"><span></span></td>
		</tr>
		</tbody>
		</table>
		</td>
		</tr>
		</tbody>
		</table>
		<!--[if (!mso)&(!IE)]><!-->
		</div>
		<!--<![endif]-->
		</div>
		</div>
		<!--[if (mso)|(IE)]></td></tr></table><![endif]-->
		<!--[if (mso)|(IE)]></td></tr></table></td></tr></table><![endif]-->
		</div>
		</div>
		</div>
		<div style="background-color:transparent;">
		<div class="block-grid" style="Margin: 0 auto; min-width: 320px; max-width: 620px; overflow-wrap: break-word; word-wrap: break-word; word-break: break-word; background-color: transparent;">
		<div style="border-collapse: collapse;display: table;width: 100%;background-color:transparent;">
		<!--[if (mso)|(IE)]><table width="100%" cellpadding="0" cellspacing="0" border="0" style="background-color:transparent;"><tr><td align="center"><table cellpadding="0" cellspacing="0" border="0" style="width:620px"><tr class="layout-full-width" style="background-color:transparent"><![endif]-->
		<!--[if (mso)|(IE)]><td align="center" width="620" style="background-color:transparent;width:620px; border-top: 0px solid transparent; border-left: 0px solid transparent; border-bottom: 0px solid transparent; border-right: 0px solid transparent;" valign="top"><table width="100%" cellpadding="0" cellspacing="0" border="0"><tr><td style="padding-right: 0px; padding-left: 0px; padding-top:5px; padding-bottom:5px;"><![endif]-->
		<div class="col num12" style="min-width: 320px; max-width: 620px; display: table-cell; vertical-align: top; width: 620px;">
		<div style="width:100% !important;">
		<!--[if (!mso)&(!IE)]><!-->
		<div style="border-top:0px solid transparent; border-left:0px solid transparent; border-bottom:0px solid transparent; border-right:0px solid transparent; padding-top:5px; padding-bottom:5px; padding-right: 0px; padding-left: 0px;">
		<!--<![endif]-->
		<!--[if mso]><table width="100%" cellpadding="0" cellspacing="0" border="0"><tr><td style="padding-right: 10px; padding-left: 10px; padding-top: 10px; padding-bottom: 30px; font-family: Tahoma, Verdana, sans-serif"><![endif]-->
		<div style="color:#71777D;font-family:\'Lato\', Tahoma, Verdana, Segoe, sans-serif;line-height:1.5;padding-top:10px;padding-right:10px;padding-bottom:30px;padding-left:10px;">
		<div style="font-size: 12px; line-height: 1.5; font-family: \'Lato\', Tahoma, Verdana, Segoe, sans-serif; color: #71777D; mso-line-height-alt: 18px;">
		<p style="font-size: 14px; line-height: 1.5; mso-line-height-alt: 21px; margin: 0;">Saludos ' . $this->ContactTitle . " " .  $this->Contact . ',</p>
		<p style="font-size: 14px; line-height: 1.5; mso-line-height-alt: 21px; margin: 0;"> </p>
		<p style="font-size: 14px; line-height: 1.5; mso-line-height-alt: 21px; margin: 0;">Nuestros registros indican que su cuenta ha vencido hace ' . $overdueDays . ' d&iacute;as. Puede ver su estado de cuenta haciendo <a href="https://westingpr.com/mod.php?p=payment&a=overdue&an=' . $this->AccountNumber . '&key=' . $this->getStatementKey() . '">click aqu&iacute;</a>. Es necesario saldar cualquier balance pendiente.<br/>Para realizar el pago, puede utilizar ATH Movil Business con el c&oacute;digo WestingPR. <br/>Si prefiere hacerlo por correo, favor de enviarlo a: </p>
		<p style="font-size: 14px; line-height: 1.5; mso-line-height-alt: 21px; margin: 0;"> </p>
		<p style="font-size: 12px; line-height: 1.5; mso-line-height-alt: 18px; margin: 0;"><strong>Westing PR, Inc.</strong></p>
		<p style="font-size: 12px; line-height: 1.5; mso-line-height-alt: 18px; margin: 0;">PO Box 754</p>
		<p style="font-size: 12px; line-height: 1.5; mso-line-height-alt: 18px; margin: 0;">Corozal PR 00783</p>
		</div>
		</div>
		<!--[if mso]></td></tr></table><![endif]-->
		<!--[if (!mso)&(!IE)]><!-->
		</div>
		<!--<![endif]-->
		</div>
		</div>
		<!--[if (mso)|(IE)]></td></tr></table><![endif]-->
		<!--[if (mso)|(IE)]></td></tr></table></td></tr></table><![endif]-->
		</div>
		</div>
		</div>
		<div style="background-color:transparent;">
		<div class="block-grid two-up" style="Margin: 0 auto; min-width: 320px; max-width: 620px; overflow-wrap: break-word; word-wrap: break-word; word-break: break-word; background-color: transparent;">
		<div style="border-collapse: collapse;display: table;width: 100%;background-color:transparent;">
		<!--[if (mso)|(IE)]><table width="100%" cellpadding="0" cellspacing="0" border="0" style="background-color:transparent;"><tr><td align="center"><table cellpadding="0" cellspacing="0" border="0" style="width:620px"><tr class="layout-full-width" style="background-color:transparent"><![endif]-->
		<!--[if (mso)|(IE)]><td align="center" width="310" style="background-color:transparent;width:310px; border-top: 0px solid transparent; border-left: 0px solid transparent; border-bottom: 0px solid transparent; border-right: 0px solid transparent;" valign="top"><table width="100%" cellpadding="0" cellspacing="0" border="0"><tr><td style="padding-right: 0px; padding-left: 0px; padding-top:5px; padding-bottom:5px;"><![endif]-->
		<div class="col num6" style="max-width: 320px; min-width: 310px; display: table-cell; vertical-align: top; width: 310px;">
		<div style="width:100% !important;">
		<!--[if (!mso)&(!IE)]><!-->
		<div style="border-top:0px solid transparent; border-left:0px solid transparent; border-bottom:0px solid transparent; border-right:0px solid transparent; padding-top:5px; padding-bottom:5px; padding-right: 0px; padding-left: 0px;">
		<!--<![endif]-->
		<table border="0" cellpadding="0" cellspacing="0" class="divider" role="presentation" style="table-layout: fixed; vertical-align: top; border-spacing: 0; border-collapse: collapse; mso-table-lspace: 0pt; mso-table-rspace: 0pt; min-width: 100%; -ms-text-size-adjust: 100%; -webkit-text-size-adjust: 100%;" valign="top" width="100%">
		<tbody>
		<tr style="vertical-align: top;" valign="top">
		<td class="divider_inner" style="word-break: break-word; vertical-align: top; min-width: 100%; -ms-text-size-adjust: 100%; -webkit-text-size-adjust: 100%; padding-top: 10px; padding-right: 10px; padding-bottom: 10px; padding-left: 10px;" valign="top">
		<table align="center" border="0" cellpadding="0" cellspacing="0" class="divider_content" role="presentation" style="table-layout: fixed; vertical-align: top; border-spacing: 0; border-collapse: collapse; mso-table-lspace: 0pt; mso-table-rspace: 0pt; border-top: 0px solid transparent; width: 100%;" valign="top" width="100%">
		<tbody>
		<tr style="vertical-align: top;" valign="top">
		<td style="word-break: break-word; vertical-align: top; -ms-text-size-adjust: 100%; -webkit-text-size-adjust: 100%;" valign="top"><span></span></td>
		</tr>
		</tbody>
		</table>
		</td>
		</tr>
		</tbody>
		</table>
		<!--[if (!mso)&(!IE)]><!-->
		</div>
		<!--<![endif]-->
		</div>
		</div>
		<!--[if (mso)|(IE)]></td></tr></table><![endif]-->
		<!--[if (mso)|(IE)]></td><td align="center" width="310" style="background-color:transparent;width:310px; border-top: 0px solid transparent; border-left: 0px solid transparent; border-bottom: 0px solid transparent; border-right: 0px solid transparent;" valign="top"><table width="100%" cellpadding="0" cellspacing="0" border="0"><tr><td style="padding-right: 10px; padding-left: 10px; padding-top:5px; padding-bottom:5px;"><![endif]-->
		<div class="col num6" style="max-width: 320px; min-width: 310px; display: table-cell; vertical-align: top; width: 310px;">
		<div style="width:100% !important;">
		<!--[if (!mso)&(!IE)]><!-->
		<div style="border-top:0px solid transparent; border-left:0px solid transparent; border-bottom:0px solid transparent; border-right:0px solid transparent; padding-top:5px; padding-bottom:5px; padding-right: 10px; padding-left: 10px;">
		<!--<![endif]-->
		<!--[if mso]><table width="100%" cellpadding="0" cellspacing="0" border="0"><tr><td style="padding-right: 0px; padding-left: 0px; padding-top: 15px; padding-bottom: 0px; font-family: Tahoma, Verdana, sans-serif"><![endif]-->
		<div style="color:#555555;font-family:\'Lato\', Tahoma, Verdana, Segoe, sans-serif;line-height:1.2;padding-top:15px;padding-right:0px;padding-bottom:0px;padding-left:0px;">
		<div style="font-family: \'Lato\', Tahoma, Verdana, Segoe, sans-serif; font-size: 12px; line-height: 1.2; color: #555555; mso-line-height-alt: 14px;">
		<p style="font-size: 12px; line-height: 1.2; mso-line-height-alt: 14px; margin: 0;"><br/></p>
		</div>
		</div>
		<!--[if mso]></td></tr></table><![endif]-->
		<!--[if mso]><table width="100%" cellpadding="0" cellspacing="0" border="0"><tr><td style="padding-right: 0px; padding-left: 0px; padding-top: 0px; padding-bottom: 5px; font-family: Tahoma, Verdana, sans-serif"><![endif]-->
		<div style="color:#555555;font-family:\'Lato\', Tahoma, Verdana, Segoe, sans-serif;line-height:1.2;padding-top:0px;padding-right:0px;padding-bottom:5px;padding-left:0px;">
		<div style="font-size: 12px; line-height: 1.2; font-family: \'Lato\', Tahoma, Verdana, Segoe, sans-serif; color: #555555; mso-line-height-alt: 14px;">
		<p style="font-size: 12px; line-height: 1.2; text-align: right; mso-line-height-alt: 14px; margin: 0;"><span style="font-size: 12px;">Cordialmente,</span></p>
		<p style="font-size: 12px; line-height: 1.2; text-align: right; mso-line-height-alt: 14px; margin: 0;"><span style="font-size: 12px;"> </span></p>
		<p style="font-size: 12px; line-height: 1.2; text-align: right; mso-line-height-alt: 14px; margin: 0;"><span style="font-size: 12px;">Departamento de Cobros</span></p>
		<p style="font-size: 12px; line-height: 1.2; text-align: right; mso-line-height-alt: 14px; margin: 0;"><span style="font-size: 12px;">Westing PR, Inc.</span></p>
		<p style="font-size: 12px; line-height: 1.2; text-align: right; mso-line-height-alt: 14px; margin: 0;"><span style="font-size: 12px;">(787) 547-8901.</span></p>
		</div>
		</div>
		<!--[if mso]></td></tr></table><![endif]-->
		<!--[if (!mso)&(!IE)]><!-->
		</div>
		<!--<![endif]-->
		</div>
		</div>
		<!--[if (mso)|(IE)]></td></tr></table><![endif]-->
		<!--[if (mso)|(IE)]></td></tr></table></td></tr></table><![endif]-->
		</div>
		</div>
		</div>
		<div style="background-color:transparent;">
		<div class="block-grid" style="Margin: 0 auto; min-width: 320px; max-width: 620px; overflow-wrap: break-word; word-wrap: break-word; word-break: break-word; background-color: transparent;">
		<div style="border-collapse: collapse;display: table;width: 100%;background-color:transparent;">
		<!--[if (mso)|(IE)]><table width="100%" cellpadding="0" cellspacing="0" border="0" style="background-color:transparent;"><tr><td align="center"><table cellpadding="0" cellspacing="0" border="0" style="width:620px"><tr class="layout-full-width" style="background-color:transparent"><![endif]-->
		<!--[if (mso)|(IE)]><td align="center" width="620" style="background-color:transparent;width:620px; border-top: 0px solid transparent; border-left: 0px solid transparent; border-bottom: 0px solid transparent; border-right: 0px solid transparent;" valign="top"><table width="100%" cellpadding="0" cellspacing="0" border="0"><tr><td style="padding-right: 0px; padding-left: 0px; padding-top:5px; padding-bottom:5px;"><![endif]-->
		<div class="col num12" style="min-width: 320px; max-width: 620px; display: table-cell; vertical-align: top; width: 620px;">
		<div style="width:100% !important;">
		<!--[if (!mso)&(!IE)]><!-->
		<div style="border-top:0px solid transparent; border-left:0px solid transparent; border-bottom:0px solid transparent; border-right:0px solid transparent; padding-top:5px; padding-bottom:5px; padding-right: 0px; padding-left: 0px;">
		<!--<![endif]-->
		<table border="0" cellpadding="0" cellspacing="0" class="divider" role="presentation" style="table-layout: fixed; vertical-align: top; border-spacing: 0; border-collapse: collapse; mso-table-lspace: 0pt; mso-table-rspace: 0pt; min-width: 100%; -ms-text-size-adjust: 100%; -webkit-text-size-adjust: 100%;" valign="top" width="100%">
		<tbody>
		<tr style="vertical-align: top;" valign="top">
		<td class="divider_inner" style="word-break: break-word; vertical-align: top; min-width: 100%; -ms-text-size-adjust: 100%; -webkit-text-size-adjust: 100%; padding-top: 20px; padding-right: 10px; padding-bottom: 20px; padding-left: 10px;" valign="top">
		<table align="center" border="0" cellpadding="0" cellspacing="0" class="divider_content" role="presentation" style="table-layout: fixed; vertical-align: top; border-spacing: 0; border-collapse: collapse; mso-table-lspace: 0pt; mso-table-rspace: 0pt; border-top: 1px dotted #CCCCCC; width: 100%;" valign="top" width="100%">
		<tbody>
		<tr style="vertical-align: top;" valign="top">
		<td style="word-break: break-word; vertical-align: top; -ms-text-size-adjust: 100%; -webkit-text-size-adjust: 100%;" valign="top"><span></span></td>
		</tr>
		</tbody>
		</table>
		</td>
		</tr>
		</tbody>
		</table>
		<!--[if (!mso)&(!IE)]><!-->
		</div>
		<!--<![endif]-->
		</div>
		</div>
		<!--[if (mso)|(IE)]></td></tr></table><![endif]-->
		<!--[if (mso)|(IE)]></td></tr></table></td></tr></table><![endif]-->
		</div>
		</div>
		</div>
		<div style="background-color:transparent;">
		<div class="block-grid" style="Margin: 0 auto; min-width: 320px; max-width: 620px; overflow-wrap: break-word; word-wrap: break-word; word-break: break-word; background-color: transparent;">
		<div style="border-collapse: collapse;display: table;width: 100%;background-color:transparent;">
		<!--[if (mso)|(IE)]><table width="100%" cellpadding="0" cellspacing="0" border="0" style="background-color:transparent;"><tr><td align="center"><table cellpadding="0" cellspacing="0" border="0" style="width:620px"><tr class="layout-full-width" style="background-color:transparent"><![endif]-->
		<!--[if (mso)|(IE)]><td align="center" width="620" style="background-color:transparent;width:620px; border-top: 0px solid transparent; border-left: 0px solid transparent; border-bottom: 0px solid transparent; border-right: 0px solid transparent;" valign="top"><table width="100%" cellpadding="0" cellspacing="0" border="0"><tr><td style="padding-right: 0px; padding-left: 0px; padding-top:5px; padding-bottom:5px;"><![endif]-->
		<div class="col num12" style="min-width: 320px; max-width: 620px; display: table-cell; vertical-align: top; width: 620px;">
		<div style="width:100% !important;">
		<!--[if (!mso)&(!IE)]><!-->
		<div style="border-top:0px solid transparent; border-left:0px solid transparent; border-bottom:0px solid transparent; border-right:0px solid transparent; padding-top:5px; padding-bottom:5px; padding-right: 0px; padding-left: 0px;">
		<!--<![endif]-->
		<!--[if mso]><table width="100%" cellpadding="0" cellspacing="0" border="0"><tr><td style="padding-right: 10px; padding-left: 10px; padding-top: 10px; padding-bottom: 10px; font-family: Tahoma, Verdana, sans-serif"><![endif]-->
		<div style="color:#555555;font-family:\'Lato\', Tahoma, Verdana, Segoe, sans-serif;line-height:1.2;padding-top:10px;padding-right:10px;padding-bottom:10px;padding-left:10px;">
		<div style="line-height: 1.2; font-family: \'Lato\', Tahoma, Verdana, Segoe, sans-serif; font-size: 12px; color: #555555; mso-line-height-alt: 14px;">
		<p style="line-height: 1.2; font-size: 12px; mso-line-height-alt: 14px; margin: 0;">' . date("Y") . ' - Westing PR, Inc.   -   Iluminado a Puerto Rico</p>
		</div>
		</div>
		<!--[if mso]></td></tr></table><![endif]-->
		<!--[if (!mso)&(!IE)]><!-->
		</div>
		<!--<![endif]-->
		</div>
		</div>
		<!--[if (mso)|(IE)]></td></tr></table><![endif]-->
		<!--[if (mso)|(IE)]></td></tr></table></td></tr></table><![endif]-->
		</div>
		</div>
		</div>
		<!--[if (mso)|(IE)]></td></tr></table><![endif]-->
		</td>
		</tr>
		</tbody>
		</table>
		<!--[if (IE)]></div><![endif]-->
		</body>
		</html>';
		$mail->WordWrap = 78;
		$mail->msgHTML($body, dirname(__FILE__), true); //Create message bodies and embed images
		//$mail->addAttachment('images/phpmailer_mini.png','phpmailer_mini.png');  // optional name
		//$mail->addAttachment('images/phpmailer.png', 'phpmailer.png');  // optional name

		$privatekeyfile = 'dkim_private.key';
		//Make a new key pair
		//(2048 bits is the recommended minimum key length -
		//gmail won't accept less than 1024 bits)
		$pk = openssl_pkey_new(
			array(
				'private_key_bits' => 2048,
				'private_key_type' => OPENSSL_KEYTYPE_RSA
			)
		);
		openssl_pkey_export_to_file($pk, $privatekeyfile);

		$mail->DKIM_domain = 'westingpr.com';
		$mail->DKIM_private = $privatekeyfile;
		$mail->DKIM_selector = 'phpmailer';
		$mail->DKIM_passphrase = ''; //key is not encrypted
		$resultReturn = $mail->send();
		$this->OverdueReminderSentDate = "NOW()";
		$this->save();
		unlink($privatekeyfile);
		return $resultReturn;
	}
	public function transferARToLoss(){
		$lossAccountNumber = "00000-99";
		return $this->transferAR($lossAccountNumber);
	}
	public function transferAR($AccountNumber){
		global $con;
		$query = "UPDATE INVOICE_HEAD SET AccountNumber = \"$AccountNumber\", `Notes` = CONCAT(`Notes`, ' - TRANSFER FROM " . $this->AccountNumber . " TO ACCT $AccountNumber ON " . date("m/d/Y") . "') WHERE InvoiceID IN (SELECT InvoiceID FROM ACCOUNTS_RECEIVABLE_AGING_DELIVERY_CACHE WHERE AccountNumber = '" . $this->AccountNumber . "')";
		//echo $query;
		if(mysqli_query($con,$query)){
			event_log($_SESSION['Username'], "TRANSFER ACCOUNT RECEIVABLE TO ANOTHER", "AccountNumber: " . $this->AccountNumber . "\nCustomerName: " . $this->Name . "\nNew AccountNumber: " . $AccountNumber);
			return true;
		}else{
			return mysqli_error($con);
		}


	}
}

?>
