<?php 
include("../connect.php");
include("../session.php");

$for = $_REQUEST['a'];
$title = "";
$fromDate = "";
$toDate = "";
switch ($for) {
	case "customer":
		$customer = new Customer($_REQUEST["customer"]);
		$title = " - By Customer: " . $customer->Name;
		$fromDate = $_REQUEST['fromDate'];
		$toDate = $_REQUEST['toDate'];
		break;
	case "salesman":
		$salesman = new Salesman($_REQUEST['salesman']);
		$title = " - By Salesman: " . $salesman->Name;
		$fromDate = $_REQUEST['fromDate'];
		$toDate = $_REQUEST['toDate'];
		break;
	case "date":
		$title = " - By Date: ";
		$fromDate = $_REQUEST['fromDate'];
		$toDate = $_REQUEST['toDate'];
		break;
}

function getElapsedTime($from, $to){
	$from = strtotime($from);
	$to = strtotime($to);
	return (secondsToTime($to-$from));
	
}
function secondsToTime($s)
{
    $h = floor($s / 3600);
    $s -= $h * 3600;
    $m = floor($s / 60);
    $s -= $m * 60;
    return $h.':'.sprintf('%02d', $m).':'.sprintf('%02d', $s);
}
 ?>
 
 <!DOCTYPE html>
 <html lang="en">
   <head>
     <meta charset="utf-8">
     <meta http-equiv="X-UA-Compatible" content="IE=edge">
     <meta name="viewport" content="width=device-width, initial-scale=1">
     <title><?= $config['CompanyName'] ?></title>
 
     <!-- Bootstrap -->
     <link href="../css/bootstrap.min.css" rel="stylesheet">
     <link rel="stylesheet" href="../css/bootstrap-combobox.css" />
 
     <!-- HTML5 shim and Respond.js for IE8 support of HTML5 elements and media queries -->
     <!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
     <!--[if lt IE 9]>
       <script src="https://oss.maxcdn.com/html5shiv/3.7.2/html5shiv.min.js"></script>
       <script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
       <!-- jQuery (necessary for Bootstrap's JavaScript plugins) -->
           <script src="https://ajax.googleapis.com/ajax/libs/jquery/1.11.1/jquery.min.js"></script>
           <!-- Include all compiled plugins (below), or include individual files as needed -->
           <script src="../js/bootstrap.min.js"></script>
       	 <script src="../js/bootstrap-combobox.js"></script>
       	 <script src="../js/excellentexport.js"></script>
           <script type="text/javascript">
             $(document).ready(function(){
       //        $('.grpline').css("width", "100px");
				$('.panel-heading').after($('.panel-footer').clone().addClass('hidden-print'))
             });
           </script>

     <![endif]-->
	<link rel="stylesheet" href="../css/styles.css"/>
   </head>
   <body>
   
       <?php include("navbar.php"); ?>     

   
   <!-- Stack the columns on mobile by making one full-width and the other half-width -->
<div class="container " style="padding-top: 10px;">
	<div class="panel panel-default">
	  <div class="panel-heading form-inline">
	  <a class="btn btn-success hidden-print" role="button" style="float: right;" href="#" download="OrderHistory<?= $title . "(" . date("m.d.Y",strtotime($fromDate)) . " - " . date("m.d.Y",strtotime($toDate)) . ")" ?>.xls" href="#" onclick="return ExcellentExport.excel(this, 'orderhistory', 'Order History');" data-toggle="tooltip" data-placement="left" title="Does not work with Internet Explorer">Export To Excel</a>
	  
	  	<div style="margin-right: 10px; float: right;">
	  			<div class="input-group hidden-print" >
	  			      <div id="clearButton" style="display: none;" class="input-group-addon" onclick="clearFilter()">
	  			      	<span class="glyphicon glyphicon-remove" aria-hidden="true"></span></div>
	  			      <input type="text" class="form-control" name="filter" placeholder="Order ID" value="" />
	  			      <div class="input-group-addon" onclick="filter()">
	  			      	<span class="glyphicon glyphicon-search" aria-hidden="true"></span></div>
	  			    </div>
	  	</div>
	  	
	  		    <h3 class="panel-title">Order History<?= $title . " - <i>From: " . date("m/d/Y",strtotime($fromDate)) . " To: " . date("m/d/Y",strtotime($toDate)) . "</i>"?></h3><br />
				
				<form method="get" action="" class="hidden-print">
	  		    	<select class="form-control" name="sort">
	  		    		<option value="OrderID">Order ID</option>
	  		    		<option value="Name">Customer Name</option>
	  		    		<option value="SalesmanOrder">Order By Salesman/Customer</option>
	  		    	</select>
	  		    	<select class="form-control" name="direction">
	  		    		<option <?= (isset($_REQUEST['direction']) && $_REQUEST['direction'] == "ASC")?"selected":"" ?> value="ASC">Ascending</option>
	  		    		<option <?= (isset($_REQUEST['direction']) && $_REQUEST['direction'] == "DESC")?"selected":"" ?> value="DESC">Descending</option>
	  		    	</select>
	  		    	<input type="hidden" name="a" value="<?= $_REQUEST["a"] ?>" />
	  		    	<input type="hidden" name="fromDate" value="<?= $_REQUEST["fromDate"] ?>" />
	  		    	<input type="hidden" name="toDate" value="<?= $_REQUEST["toDate"] ?>" />
	  		    	<input type="submit" class="form-control" name="" value="Sort" />
	  		    </form>
	  </div>
	  <div class="panel-body">
	  	<table class="table table-hover table-condensed" id="orderhistory">
	  		<thead>
	  			<tr>
	  				<th>Order ID</th>
	  				<?= ($for != "customer") ? "<th>Customer</th>" : "" ?>
	  				<th>Order Date/Time</th>
	  				
	  				<th class="hidden-print">PO Number<br>Offline ID</th>
	  				<th>Order By</th>
					<th>Status</th>
	  				<th style="text-align: center;">Total</th>
	  				<th></th>
	  			</tr>
	  			
	  		</thead>
			<tbody>
	    <?php 
	    if (isset($_REQUEST['sort'])) {
	    	if ($_REQUEST['sort'] != "") {
	    		$sort = $_REQUEST['sort'];
	    		$direction = $_REQUEST['direction'];
	    	}
	    }else {
	    	$sort = "OrderID";
	    	$direction = "DESC";
	    }
	    
	    if ($for == "customer") {
	    	$query = "SELECT * FROM ORDER_HEAD, CUSTOMER WHERE ORDER_HEAD.AccountNumber LIKE '" . $customer->AccountNumber . "' AND DATE(OrderDate) BETWEEN '$fromDate' AND '$toDate' AND CUSTOMER.AccountNumber = ORDER_HEAD.AccountNumber ORDER BY $sort $direction";	
	    }elseif($for == "salesman") {
	    	$query = "SELECT * FROM ORDER_HEAD, CUSTOMER WHERE ORDER_HEAD.Salesman LIKE '" . $salesman->ID . "' AND DATE(OrderDate) BETWEEN '$fromDate' AND '$toDate' AND CUSTOMER.AccountNumber = ORDER_HEAD.AccountNumber ORDER BY $sort $direction";
	    }elseif ($for == "date") {
	    	$query = "SELECT * FROM ORDER_HEAD, CUSTOMER WHERE DATE(OrderDate) BETWEEN '$fromDate' AND '$toDate' AND CUSTOMER.AccountNumber = ORDER_HEAD.AccountNumber ORDER BY $sort $direction";
	    }
		//echo $query;
		//LAST YEAR SALES INFO
		if ($for == "customer") {
	    	$queryLastYear = "SELECT SUM(OrderQty * Price) AS LastYearSales, COUNT(DISTINCT(ORDER_HEAD.OrderID)) AS `Count`, SalesmanOrder FROM ORDER_HEAD, ORDER_DETAIL WHERE ORDER_HEAD.DeleteOrder = 0 AND ORDER_HEAD.OrderID = ORDER_DETAIL.OrderID AND ORDER_HEAD.AccountNumber LIKE '" . $customer->AccountNumber . "' AND DATE(OrderDate) BETWEEN DATE_ADD('$fromDate', INTERVAL -1 YEAR) AND DATE_ADD('$toDate', INTERVAL -1 YEAR) GROUP BY SalesmanOrder";	
	    }elseif($for == "salesman") {
	    	$queryLastYear = "SELECT SUM(OrderQty * Price) AS LastYearSales, COUNT(DISTINCT(ORDER_HEAD.OrderID)) AS `Count`, SalesmanOrder FROM ORDER_HEAD, ORDER_DETAIL WHERE ORDER_HEAD.DeleteOrder = 0 AND ORDER_HEAD.OrderID = ORDER_DETAIL.OrderID AND ORDER_HEAD.Salesman LIKE '" . $salesman->ID . "' AND DATE(OrderDate) BETWEEN DATE_ADD('$fromDate', INTERVAL -1 YEAR) AND DATE_ADD('$toDate', INTERVAL -1 YEAR) GROUP BY SalesmanOrder";
	    }elseif ($for == "date") {
	    	$queryLastYear = "SELECT SUM(OrderQty * Price) AS LastYearSales, COUNT(DISTINCT(ORDER_HEAD.OrderID)) AS `Count`, SalesmanOrder FROM ORDER_HEAD, ORDER_DETAIL WHERE ORDER_HEAD.DeleteOrder = 0 AND ORDER_HEAD.OrderID = ORDER_DETAIL.OrderID AND DATE(OrderDate) BETWEEN DATE_ADD('$fromDate', INTERVAL -1 YEAR) AND DATE_ADD('$toDate', INTERVAL -1 YEAR) GROUP BY SalesmanOrder";
	    }
		$resultLastYear = mysqli_query($con, $queryLastYear);
		$lastYearData = array();
		while($rowLastYear = mysqli_fetch_array($resultLastYear)){
			$lastYearData[$rowLastYear['SalesmanOrder']] = new stdClass();
			$lastYearData[$rowLastYear['SalesmanOrder']]->Count = $rowLastYear['Count'];
			$lastYearData[$rowLastYear['SalesmanOrder']]->Sales = $rowLastYear['LastYearSales'];
			
		}
		
	   	$result = mysqli_query($con, $query);
	   	$total = 0;
		$offlineOrders = 0;
		$offlineAmount = 0;
	   	$totalCustomer = 0;
	   	$totalSalesman = 0;
		$custTransactions = 0;
		$salesmanTransactions = 0;
		$status = "";
	   	while ($row = mysqli_fetch_array($result)) {
	   		$order = new Order($row['OrderID']);
			if($row['DeleteOrder'] == 0){
				$total += $order->OrderTotal;
				if ($row['SalesmanOrder'] == true) {
					$totalSalesman += $order->OrderTotal;
					$salesmanTransactions++;
				}else {
					$totalCustomer += $order->OrderTotal;
					$custTransactions++;
				}
			}
	   		
	   		
			if($row['Processed']){
				$status = "Processed";
				$statusLabelClass = "label-success";
				$statusText = "<b>User:</b> " . $row['ProcessUser'] . "<br />";
				$statusText .= "<b>Started Processing:</b> " . date('m/d/Y h:i a', strtotime($row['InProcessDate'])) . "<br />";
				$statusText .= "<b>Done Processing:</b> " . date('m/d/Y h:i a', strtotime($row['ProcessedDate'])) . "<br />";
				$statusText .= "<b>Elapsed Time:</b> " . getElapsedTime($row['InProcessDate'], $row['ProcessedDate']) . "<br />";
			}elseif($row['DeleteOrder']){
				$status = "Deleted";
				$statusLabelClass = "label-danger";
				$statusText = "<b>User:</b> " . $row['OnHoldDeleteUser'] . "<br />";
				$statusText .= "<b>Deleted On:</b> " . date('m/d/Y h:i a', strtotime($row['DeleteOrderDate'])) . "<br />";
				$statusText .= "<b>Reason:</b> " . $row['HoldDeleteReason'] . "<br />";
			}elseif($row['InProcess']){
				$status = "In Process";
				$statusLabelClass = "label-warning";
				$statusText = "<b>User:</b> " . $row['ProcessUser'] . "<br />";
				$statusText .= "<b>Started Processing:</b> " . date('m/d/Y h:i a', strtotime($row['InProcessDate'])) . "<br />";
			}elseif($row['OnHold']){
				$status = "On Hold";
				$statusLabelClass = "label-warning";
				$statusText = "<b>User:</b> " . $row['OnHoldDeleteUser'] . "<br />";
				$statusText .= "<b>Set On Hold on:</b> " . date('m/d/Y h:i a', strtotime($row['OnHoldDate'])) . "<br />";
				$statusText .= "<b>Reason:</b> " . $row['HoldDeleteReason'] . "<br />";
			}else{
				$status = "Unprocessed";
				$statusLabelClass = "label-default";
				$statusText = "No process data available";
				
			}
	   	?>
	   		<tr>
				<td>
					<span class="visible-print-block"><?= $row['OrderID'] ?></span>
					<!-- Single button -->
					<div class="btn-group hidden-print">
					  <button type="button" class="btn btn-default dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
						<?= $row['OrderID'] ?> <span class="caret"></span>
					  </button>
					  <ul class="dropdown-menu">
						<li><a href="vieworder.php?order=<?= $row['OrderID'] ?>" target="_blank">View</a></li>
						<?php
							if($row['Processed'] == 0){
						?>
						<li><a href="#" onclick="processOrder(<?=  $row['OrderID'] ?>)">Process</a></li>	
						<?php
							}else{
						?>
						<li><a href="#" onclick="viewInvoice(<?=  $row['OrderID'] ?>)">View Invoice</a></li>	
						<?php
							}
						?>
						<li><a href="#" onclick="alert('Not implemented yet');">Void Order</a></li>
						
					  </ul>
					</div>
					
				</td>
	   			
	   			<?= ($for != "customer") ? "<td>" . $row['Name'] . "</td>" : "" ?>
	   			<td style="white-space: nowrap;"><?= date("m/d/Y g:i a",strtotime($row['OrderDate'])) ?></td>
	   			<td class="hidden-print"><?= $row['PONumber'] ?>
				<?php
					if($order->OfflineID){
						$offlineOrders++;
						$offlineAmount += $order->OrderTotal;
						echo "<br>" . $order->OfflineID;
					}
				?>
				</td>
				<td style="white-space: nowrap;"><?= ($row['SalesmanOrder'] == true)?$order->Salesman->ID . " - " . $order->Salesman->Name:$order->Salesman->ID . " - " . "Customer" ?></td>
				<td><button style="font-size:12px;" data-placement="left" data-html="true" type="button" class="label <?= $statusLabelClass ?>" data-container="body" data-toggle="popover" title="<?= $status ?>" data-content="<?= $statusText ?>"><?= $status ?></a></td>
				<td style="text-align: right;"><?= moneyFormat($order->OrderTotal) ?></td>
				<td><button class="btn btn-success hidden-print" onclick="fillEditOrder('<?= $row['OrderID'] ?>')">Edit</button></td>
	   		</tr>
	   	<?php
	   	}
	     ?>
			</tbody>
	     </table>
	  </div>
	  <div class="panel-footer" style="height: 130px;" >
	  	<span style="float: left; text-align: left;">
			<?php
				if($custTransactions === 0){
					//$custTransactions = 1;
				}
				if($salesmanTransactions === 0){
					//$salesmanTransactions = 1;
				}
			?>
	  		<strong>Orders By Customers Total: </strong><i><?= moneyFormat($totalCustomer) ?></i> <b>Average:</b> <?= @moneyFormat($totalCustomer/$custTransactions) ?><br />
			<strong>Transactions By Customer: </strong><i><?= $custTransactions ?></i><br />
	  		<strong>Orders By Salesman Total: </strong><i><?= moneyFormat($totalSalesman) ?></i> <b>Average:</b> <?= @moneyFormat($totalSalesman/$salesmanTransactions) ?><br />
			<strong>Transactions By Salesman: </strong><i><?= $salesmanTransactions ?></i><br />
			
			<strong>Offline Transactions: </strong><i><?= $offlineOrders ?></i><br>
			<strong>Offline Total: </strong><i><?= moneyFormat($offlineAmount) ?></i><br>
	  	</span>	
	  	<span  style="float: right; text-align: right;">
	  		<strong>Total Orders: </strong><i><?= moneyFormat($total) ?></i> <br /><b>Average:</b> <?= @moneyFormat($total/($custTransactions+$salesmanTransactions)) ?><br />
			<strong>Total Transactions: </strong><i><?= $custTransactions+$salesmanTransactions ?></i>
	  	</span>	
	  </div>
	  <div class="panel-footer" style="height: 125px;" >
		<h4>Last Year</h4>
	  	<span style="float: left; text-align: left;">
			<?php
				
			?>
	  		<strong>Orders By Customers Total: </strong><i><?= moneyFormat($lastYearData[0]->Sales) ?></i> <b>Average:</b> <?= @moneyFormat($lastYearData[0]->Sales/$lastYearData[0]->Count) ?><br />
			<strong>Transactions By Customer: </strong><i><?= $lastYearData[0]->Count ?></i><br />
			<strong>Orders By Salesman Total: </strong><i><?= moneyFormat($lastYearData[1]->Sales) ?></i> <b>Average:</b> <?= @moneyFormat($lastYearData[1]->Sales/$lastYearData[1]->Count) ?><br />
			<strong>Transactions By Salesman: </strong><i><?= $lastYearData[1]->Count ?></i><br />
	  	</span>	
	  	<span  style="float: right; text-align: right;">
	  		<strong>Total Orders: </strong><i><?= moneyFormat($lastYearData[0]->Sales+$lastYearData[1]->Sales) ?></i> <br /><b>Average:</b> <?= @moneyFormat(($lastYearData[0]->Sales+$lastYearData[1]->Sales)/($lastYearData[0]->Count+$lastYearData[1]->Count)) ?><br />
			<strong>Total Transactions: </strong><i><?= $lastYearData[0]->Count+$lastYearData[1]->Count ?></i>
	  	</span>	
	  </div>
	</div>

</div>       
<script type="text/javascript">

$('[name=filter]').on('keypress', function(e) {
	if (e.which == 13) {
		filter();
	}

});
function clearFilter() {
	$('[name=filter]').val("");
	$('#clearButton').css('display', 'none');
	$('tr').css('display', '');
	
}
function filter() {
	var	name = $('[name=filter]').val();
	filterByName(name);
}
function filterByName(name) {
	$('#clearButton').css('display', '');
	for (var i = 0; i < $('td').length; i=i+7) {
	
		var text = $($('td')[i]).text();
		
		var result = text.toUpperCase().indexOf(name.toUpperCase());
		if (text != name) {
			$($('tr')[i/7+1]).css('display', 'none');
		}else {
			$($('tr')[i/7+1]).css('display', '');
		}
		
	}
}
function fillEditOrder(orderID) {
	clearEditOrder(); 
	$.get("functions.php?action=getOrderDetails&orderID=" + orderID, function(data) {
		data = JSON.parse(data);
		$('#EditOrderTitle').text('Edit Order #' + data.OrderID);
		$('#EditModalOrderID').val(data.OrderID);
		for (var i = 0; i < data.Items.length; i++) {
			$('#EditOrderModalBody').append('<tr><td>' + data.Items[i].Group.toString() + '<br />' + data.Items[i].Line.toString() + '</td><td>' + data.Items[i].SKU.toString() + '</td><td>' + data.Items[i].Description + ' ' + data.Items[i].Notes.toString() + '</td><td><input class="form-control EditOrderItem" style="width: 80px;" type="text" name="' + data.Items[i].ID + '" data-Key="' + data.Items[i].Group.toString() + "-" + data.Items[i].Line.toString() + "-" + data.Items[i].SKU.toString() + '" data-OriginalQty="' + data.Items[i].OrderQty + '" value="' + data.Items[i].OrderQty + '" /></td><td>' + data.Items[i].Price + '</td><td>' + parseFloat(data.Items[i].Price)*parseInt(data.Items[i].OrderQty) + '</td></tr>');
		}
		$('#EditOrderModal').modal();

	});
}
function clearEditOrder() {
	$('#EditOrderTitle').text('Edit Order');
	$('#EditModalOrderID').val('0');
	$('#EditOrderModalBody').html('');
	
}
function saveOrderInfo() {
	var items = $('.EditOrderItem');
	var changes = new Object();
	changes.OrderID = $('#EditModalOrderID').val();
	changes.Items = new Array();
	for (var i = 0; i < items.length; i++) {
		var origQty = parseInt($($('.EditOrderItem')[i]).attr("data-OriginalQty"));
		var newQty = parseInt($($('.EditOrderItem')[i]).val());
		var itemKey = $($('.EditOrderItem')[i]).attr("data-Key")
		if (origQty != newQty) {
			var item = new Object()
			item.ID = $($('.EditOrderItem')[i]).attr('name');
			item.NewQty = newQty;
			item.OriginalQty = origQty;
			item.ItemKey = itemKey;
			changes.Items.push(item);
		}
		
	}
	$.post("functions.php?action=saveOrderDetail", changes, function(data) {
		if(data == "true"){
			location.reload();
		}
	
	});
	
}
function processOrder(orderID){
	$.get('mod.php?p=invoice&a=functions&f=processOrder&order=' + orderID, function(data){
		alert(data);
		});
}
</script>

	<div class="modal fade" id="EditOrderModal">
	  <div class="modal-dialog">
	    <div class="modal-content">
	      <div class="modal-header">
	        <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
	        <h4 class="modal-title" id="EditOrderTitle">Edit Order</h4>
	      </div>
	      <div class="modal-body">
	      	<input type="hidden" name="EditModalOrderID" id="EditModalOrderID" value="" />
			<table class="table table-hover table-condensed" id="orderhistory">
				<thead>
					<tr>
						<th>Group<br />Line</th>
						<th>SKU</th>
						<th>Description</th>
						
						<th>Qty</th>
						<th>Price</th>
						<th style="text-align: center;">Extension</th>
					</tr>
					
				</thead>
				<tbody id="EditOrderModalBody">
				</tbody>
				</table>
	      	
	      </div>
	      <div class="modal-footer">
	        <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
	        <button type="button" class="btn btn-primary" id="saveButton" onclick="saveOrderInfo()">Save</button>
	      </div>
	    </div><!-- /.modal-content -->
	  </div><!-- /.modal-dialog -->
	</div><!-- /.modal -->
	
	<script>
		$(function () {
			$('[data-toggle="popover"]').popover();
		  });	
	</script>

   </body>
   
 </html>