<div class="panel panel-default">
  <div class="panel-heading form-inline">
  	<div style="margin-right: 10px; float: right;">
  		<div class="input-group">
  			<div id="clearButton" style="display: none;" class="input-group-addon" onclick="clearFilter()">
  				<span class="glyphicon glyphicon-remove" aria-hidden="true"></span></div>
  		 	<input type="text"   class="form-control" name="filter" placeholder="Filter" value="" />
  			<div class="input-group-addon" onclick="filter()">
  		      	<span class="glyphicon glyphicon-search" aria-hidden="true"></span></div>
  		</div>
  			<button class="btn btn-primary" onclick="addReason()" >Add New Reason</button>
  	</div>
  	
    <h3 class="panel-title">Warranty Reasons</h3>
    <small>Click on a row to edit the reason definition</small>
  </div>
  <div class="panel-body">
  <table class="table table-hover">
    <thead>
    	<tr>
    		<th>Code</th>
    		<th>Name</th>    		
    	</tr>
    </thead>
   <?php 
   	$query = "SELECT * FROM `PICKUP_WARRANTY_REASON` ORDER BY `Value` ASC";
   	$result = mysqli_query($con, $query);
   	while ($row = mysqli_fetch_array($result)) {
   ?>
   		<tr onclick="editReason('<?= $row['Key'] ?>')">
   			<td><?= $row['Key'] ?></td>
   			<td><?= $row['Value'] ?></td>
   		</tr>
   <?php		
   	}
    ?>
    </table>
  </div>
</div>


<div class="modal fade" id="AddEditReason">
  <div class="modal-dialog">
    <div class="modal-content">
      <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
        <h4 class="modal-title" id="AddEditTitle">Edit Reason</h4>
      </div>
      <div class="modal-body">
      	<form>
      		<input type="hidden" id="isNew" name="isNew" value="" />
      		<div class="form-group">
      		    <label for="ReasonKey">Reason Code</label>
      		    <input type="text" class="form-control" name="ReasonCode" autocomplete="off" id="ReasonCode" placeholder="Code">
      		  </div>
      		<div class="form-group">
      		    <label for="ReasonName">Reason Name</label>
      		    <input type="text" class="form-control" name="ReasonName" autocomplete="off" id="ReasonName" placeholder="Name">
      		  </div>
           	</form>
      </div>
      <div class="modal-footer">
      	<button type="button" class="btn btn-danger" id="deleteButton" onclick="deleteReason()" data-dismiss="modal">Delete</button>
        <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
        <button type="button" class="btn btn-primary" id="saveButton" onclick="saveReasonInfo()">Save</button>
      </div>
    </div><!-- /.modal-content -->
  </div><!-- /.modal-dialog -->
</div><!-- /.modal -->
<script type="text/javascript">
	$('[name=filter]').on('keypress', function(e) {
		if (e.which == 13) {
			filter();
		}
	
	});
	$($('input[type=text]')[$('input[type=text]').length-1]).keydown(function(e){
			if(e.which == 13)
				$('#saveButton').click();
		
		});
	function clearFilter() {
		$('[name=filter]').val("");
		$('#clearButton').css('display', 'none');
		$('tr').css('display', '');
		
	}
	function filter() {
		var	name = $('[name=filter]').val();
		filterByName(name);
	}
	function filterByName(name) {
		$('#clearButton').css('display', '');
		for (var i = 0; i < $('tr').length; i++) {
			if (i != 0) {
				var result = $('tr')[i].innerText.toUpperCase().indexOf(name.toUpperCase());
				if (result < 0) {
					$($('tr')[i]).css('display', 'none');
				}else {
					$($('tr')[i]).css('display', '');
				}
			}
		}
	}
	function clearModal() {
		$('#isNew').val("0");
		$('#ReasonCode').val("");
		$('#ReasonName').val("");
		$('#ReasonCode').prop("readonly", null);
	}
	function addReason() {
		clearModal();
		$('#isNew').val("1");
		$('#AddEditTitle').text("Add Reason");
		$('#deleteButton').css('display', 'none');
		$('#AddEditReason').modal('toggle');
		$('#ReasonCode').prop("readonly", null);
	}
	function editReason(ReasonCode) {
		clearModal();
		$.get("functions.php?action=getWarrantyReasonInfo&reasonCode=" + ReasonCode, function(data){
			
			
		 	var reason = JSON.parse(data);
		 	$('#isNew').val("0");
			$('#AddEditTitle').text("Edit Reason");
			$('#ReasonCode').val(reason.Key);
			$('#ReasonName').val(reason.Value);
			$('#deleteButton').css('display', '');
			$('#ReasonCode').prop("readonly", true);
			$('#AddEditReason').modal('toggle');
			
			
		});
	}
	function saveReasonInfo() {
		var reasonData = '{ "Key" : "' + $('#ReasonCode').val() + '", "Value" 	:	"' + $('#ReasonName').val() + '", "IsNew" : "' + $('#isNew').val() + '"}';
		reasonData = JSON.parse(reasonData);
		console.log(reasonData);
		$.post( "functions.php?action=saveWarrantyReasonInfo", reasonData)
		  .done(function( data ) {
		  	data = JSON.parse(data);
		    if (data.result === true) {
		      	clearModal();
		      	$('#AddEditReason').modal('toggle')
		      	location.reload();
		      }else {
		      	alert("There has been an error saving the reason data.\r\n\r\nMySQL Error: " + data.error);
		      }
		    });
	}
	function deleteReason() {
		if (confirm("Are you sure you want to delete this pickup reason from the database? This cannot be undone.")) {
			var reasonCode = $('#ReasonCode').val();
			$.post( "functions.php?action=deleteWarrantyReason&reasonCode=" + reasonCode, null)
			  .done(function( data ) {
			  data = $.parseJSON(data);
			  console.log(data.result);
			    if (data.result == true) {
			    	clearModal();
			    	$('#AddEditReason').modal('toggle')
			    	location.reload();
			    }else {
			    	alert("There has been an error deleting the pickup reason");
			    }
			  });
		  }
		
	}
	</script>
