<div class="panel panel-default">
  <div class="panel-heading form-inline">
  	<a class="btn btn-success" role="button" style="float: right;" href="#" download="PricePlansCalculated<?= "(" . date("m.d.Y") . ")" ?>.xls" href="#" onclick="return ExcellentExport.excel(this, 'priceplanscalc', 'PricePlansCalculated');" data-toggle="tooltip" data-placement="left" title="Does not work with Internet Explorer">Export To Excel</a>
  	<div style="margin-right: 10px; float: right;">
  		<div class="input-group">
  			<div id="clearButton" style="display: none;" class="input-group-addon" onclick="clearFilter()">
  				<span class="glyphicon glyphicon-remove" aria-hidden="true"></span></div>
  		 	<input type="text"   class="form-control" name="filter" placeholder="Filter" value="" />
  			<div class="input-group-addon" onclick="filter()">
  		      	<span class="glyphicon glyphicon-search" aria-hidden="true"></span></div>
  		</div>
  			<button class="btn btn-primary" onclick="addPricePlan()" >Add New Price Plan</button>
  	</div>
  	
    <h3 class="panel-title">Price Plans - Calculated</h3>
    <small>Click on a row to edit the Price Plan definition</small>
  </div>
  <div class="panel-body">
  <table class="table table-hover">
    <thead>
    	<tr>
    		<th>Account Number</th>
    		<th>Name</th>
    		<th>City</th>
    		<th>Percent</th>
    	</tr>
    </thead>
   <?php 
   	$query = "SELECT * FROM `PRICE_PLAN_CALC` ORDER BY `AccountNumber` ASC";
   	$result = mysqli_query($con, $query);
   	while ($row = mysqli_fetch_array($result)) {
   		$customer = new Customer($row['AccountNumber']);
   ?>
   		<tr onclick="editPricePlan('<?= $row['AccountNumber'] ?>')">
   			<td><?= $customer->AccountNumber ?></td>
   			<td><?= $customer->Name ?></td>
   			<td><?= $customer->City ?></td>
   			<td><?= $row['Percent'] ?></td>
   		</tr>
   <?php		
   	}
    ?>
    </table>
  </div>
</div>


<div class="modal fade" id="AddEditPricePlan">
  <div class="modal-dialog">
    <div class="modal-content">
      <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
        <h4 class="modal-title" id="AddEditTitle">Edit Price Plan</h4>
      </div>
      <div class="modal-body">
      	<form>
      		<input type="hidden" id="isNew" name="isNew" value="" />
      		<div class="form-group">
      		    <label for="PricePlanAccountNumber">Account Number</label>
      		    <select class="form-control combobox" id="PricePlanAccountNumber" name="PricePlanAccountNumber">
      		    <option></option>
      		    <?php
      		    	$query = "SELECT * FROM CUSTOMER ORDER BY Name";
      		    	$result = mysqli_query($con, $query);
      		    	while ($row = mysqli_fetch_array($result)) {
      		    ?>
      		    	<option value="<?= $row['AccountNumber'] ?>"><?= $row['AccountNumber'] . " - " . $row['Name'] . " - " . $row['City'] ?></option>
      		    <?php
      		    	}
      		    ?>
      		    </select>
      		  </div>
      		<div class="form-group">
      		    <label for="PricePlanPercent">Percent <i>(decimal format / use [-] if discounted.) Ie. -0.10 to decrease or 0.10 to increase.</i></label>
      		    <input type="text" class="form-control small" name="PricePlanPercent" autocomplete="off" id="PricePlanPercent" placeholder="Percent">
      		  </div>
      	</form>
      </div>
      <div class="modal-footer">
      	<button type="button" class="btn btn-danger" id="deleteButton" onclick="deletePricePlan()" data-dismiss="modal">Delete</button>
        <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
        <button type="button" class="btn btn-primary" id="saveButton" onclick="savePricePlanInfo()">Save</button>
      </div>
    </div><!-- /.modal-content -->
  </div><!-- /.modal-dialog -->
</div><!-- /.modal -->
<script type="text/javascript">
	$('[name=filter]').on('keypress', function(e) {
		if (e.which == 13) {
			filter();
		}
	
	});
	$($('input[type=text]')[$('input[type=text]').length-1]).keydown(function(e){
			if(e.which == 13)
				$('#saveButton').click();
		
		});
	function clearFilter() {
		$('[name=filter]').val("");
		$('#clearButton').css('display', 'none');
		$('tr').css('display', '');
		
	}
	function filter() {
		var	name = $('[name=filter]').val();
		filterByName(name);
	}
	function filterByName(name) {
		$('#clearButton').css('display', '');
		for (var i = 0; i < $('tr').length; i++) {
			if (i != 0) {
				var result = $('tr')[i].innerText.toUpperCase().indexOf(name.toUpperCase());
				if (result < 0) {
					$($('tr')[i]).css('display', 'none');
				}else {
					$($('tr')[i]).css('display', '');
				}
			}
		}
	}
	function clearModal() {
		$('#isNew').val("0");
		$('#PricePlanAccountNumber').val("");
		$('#PricePlanPercent').val("");
		$('#PricePlanAccountNumber').prop("readonly", null);
	}
	function addPricePlan() {
		clearModal();
		$('#isNew').val("1");
		$('#AddEditTitle').text("Add Price Plan");
		$('#deleteButton').css('display', 'none');
		$('#AddEditPricePlan').modal('toggle');
		$('#PricePlanAccountNumber').prop("readonly", null);
	}
	function editPricePlan(AccountNumber) {
		clearModal();
		$.get("functions.php?action=getPricePlanCalcInfo&accountNumber=" + AccountNumber, function(data){
		 	var pricePlan = JSON.parse(data);
		 	$('#isNew').val("0");
			$('#AddEditTitle').text("Edit Price Plan");
			$('#PricePlanAccountNumber').val(pricePlan.AccountNumber);
			$('#PricePlanPercent').val(pricePlan.Percent);
			$('#deleteButton').css('display', '');
			$('#PricePlanAccountNumber').data('combobox').refresh();
			$('#AddEditPricePlan').modal('toggle');
		});
	}
	function savePricePlanInfo() {
		var pricePlanData = '{ "AccountNumber" : "' + $('#PricePlanAccountNumber').val() + '", "Percent" 	:	"' + $('#PricePlanPercent').val() + '", "IsNew" : "' + $('#isNew').val() + '"}';
		pricePlanData = JSON.parse(pricePlanData);
		$.post( "functions.php?action=savePricePlanCalcInfo", pricePlanData)
		  .done(function( data ) {
		  	data = JSON.parse(data);
		    if (data.result === true) {
		      	clearModal();
		      	$('#AddEditPricePlan').modal('toggle')
		      	location.reload();
		      }else {
		      	alert("There has been an error saving the price plan data.\r\n\r\nMySQL Error: " + data.error);
		      }
		    });
	}
	function deletePricePlan() {
		if (confirm("Are you sure you want to delete this price plan from the database? This cannot be undone.")) {
			var accountNumber = $('#PricePlanAccountNumber').val();
			$.post( "functions.php?action=deletePricePlanCalc&accountNumber=" + accountNumber, null)
			  .done(function( data ) {
			  data = $.parseJSON(data);
			  console.log(data.result);
			    if (data.result == true) {
			    	clearModal();
			    	$('#AddEditPricePlan').modal('toggle')
			    	location.reload();
			    }else {
			    	alert("There has been an error deleting the price plan");
			    }
			  });
		  }
		
	}
	$('#PricePlanAccountNumber').bscombobox();
	</script>
