<div class="panel panel-default">
  	<div class="panel-heading form-inline">
  		<a class="btn btn-success" role="button" style="float: right;" href="#" download="Lines<?= "(" . date("m.d.Y") . ")" ?>.xls" href="#" onclick="return ExcellentExport.excel(this, 'lines', 'Lines');" data-toggle="tooltip" data-placement="left" title="Does not work with Internet Explorer">Export To Excel</a>
  		<div style="margin-right: 10px; float: right;">
  			<div class="input-group">
  			      <div id="clearButton" style="display: none;" class="input-group-addon" onclick="clearFilter()">
  			      	<span class="glyphicon glyphicon-remove" aria-hidden="true"></span>
  			      </div>
  			      <input type="text"   class="form-control" name="filter" placeholder="Filter" value="" />
  			      <div class="input-group-addon" onclick="filter()">
  			      	<span class="glyphicon glyphicon-search" aria-hidden="true"></span>
  			      </div>
  			</div>
  			<button class="btn btn-primary" onclick="addLine()" >Add New Line</button>
  	</div>
  	
    <h3 class="panel-title">Inventory Lines</h3>
    <small>Click on a row to edit the line definition</small>
  </div>
  <div class="panel-body">
  <table class="table table-hover" id="lines">
    <thead>
    	<tr>
    		<th>Code</th>
    		<th>Spanish Name</th>    		
    		<th>English Name</th>
    	</tr>
    </thead>
   <?php 
   	$query = "SELECT * FROM `LINE` ORDER BY `Name` ASC";
   	$result = mysqli_query($con, $query);
   	while ($row = mysqli_fetch_array($result)) {
   ?>
   		<tr onclick="editLine('<?= $row['Code'] ?>')">
   			<td><?= $row['Code'] ?></td>
   			<td><?= $row['Name'] ?></td>
   			<td><?= $row['NameEN'] ?></td>
   		</tr>
   <?php		
   	}
    ?>
    </table>
  </div>
</div>


<div class="modal fade" id="AddEditLine">
  <div class="modal-dialog">
    <div class="modal-content">
      <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
        <h4 class="modal-title" id="AddEditTitle">Edit Line</h4>
      </div>
      <div class="modal-body">
      	<form>
      		<input type="hidden" id="isNew" name="isNew" value="" />
      		<div class="form-group">
      		    <label for="LineCode">Line Code</label>
      		    <input type="text" class="form-control" name="LineCode" autocomplete="off" id="LineCode" placeholder="Code">
      		  </div>
      		<div class="form-group">
      		    <label for="LineName">Line Name - Spanish</label>
      		    <input type="text" class="form-control" name="LineName" autocomplete="off" id="LineName" placeholder="Name">
      		  </div>
      		<div class="form-group">
      		    <label for="LineName">Line Name - English</label>
      		    <input type="text" class="form-control" name="LineNameEN" autocomplete="off" id="LineNameEN" placeholder="Name">
      		  </div>
      	</form>
      </div>
      <div class="modal-footer">
      	<button type="button" class="btn btn-danger" id="deleteButton" onclick="deleteLine()" data-dismiss="modal">Delete</button>
        <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
        <button type="button" class="btn btn-primary" onclick="saveLineInfo()">Save</button>
      </div>
    </div><!-- /.modal-content -->
  </div><!-- /.modal-dialog -->
</div><!-- /.modal -->
<script type="text/javascript">
	$('[name=filter]').on('keypress', function(e) {
		if (e.which == 13) {
			filter();
		}
	
	});
	function clearFilter() {
		$('[name=filter]').val("");
		$('#clearButton').css('display', 'none');
		$('tr').css('display', '');
		
	}
	function filter() {
		var	name = $('[name=filter]').val();
		filterByName(name);
	}
	function filterByName(name) {
		$('#clearButton').css('display', '');
		for (var i = 0; i < $('tr').length; i++) {
			if (i != 0) {
				var result = $('tr')[i].innerText.toUpperCase().indexOf(name.toUpperCase());
				if (result < 0) {
					$($('tr')[i]).css('display', 'none');
				}else {
					$($('tr')[i]).css('display', '');
				}
			}
		}
	}
	function clearModal() {
		$('#isNew').val("0");
		$('#LineCode').val("");
		$('#LineName').val("");
		$('#LineNameEN').val("");
		$('#LineCode').prop("readonly", null);
	}
	function addLine() {
		clearModal();
		$('#isNew').val("1");
		$('#AddEditTitle').text("Add Line");
		$('#deleteButton').css('display', 'none');
		$('#AddEditLine').modal('toggle');
		$('#LineCode').prop("readonly", null);
	}
	function editLine(LineCode) {
		clearModal();
		$.get("functions.php?action=getLineInfo&lineCode=" + LineCode, function(data){
		 	var line = JSON.parse(data);
		 	$('#isNew').val("0");
			$('#AddEditTitle').text("Edit Line");
			$('#LineCode').val(line.Code);
			$('#LineName').val(line.Name);
			$('#LineNameEN').val(line.NameEN);
			$('#deleteButton').css('display', '');
			$('#LineCode').prop("readonly", true);
			$('#AddEditLine').modal('toggle');
			
		});
	}
	function saveLineInfo() {
		var lineData = '{ "Code" : "' + $('#LineCode').val() + '", "Name" 	:	"' + $('#LineName').val() + '", "NameEN" 	:	"' + $('#LineNameEN').val() + '", "IsNew" : "' + $('#isNew').val() + '"}';
		lineData = JSON.parse(lineData);
		console.log(lineData);
		$.post( "functions.php?action=saveLineInfo", lineData)
		  .done(function( data ) {
		  	data = JSON.parse(data);
		    if (data.result === true) {
		      	clearModal();
		      	$('#AddEditLine').modal('toggle')
		      	location.reload();
		      }else {
		      	alert("There has been an error saving the line data.\r\n\r\nMySQL Error: " + data.error);
		      }
		    });
	}
	function deleteLine() {
		if (confirm("Are you sure you want to delete this line from the database? This cannot be undone.")) {
			var lineCode = $('#LineCode').val();
			$.post( "functions.php?action=deleteLine&lineCode=" + lineCode, null)
			  .done(function( data ) {
			  data = $.parseJSON(data);
			  console.log(data.result);
			    if (data.result == true) {
			    	clearModal();
			    	$('#AddEditLine').modal('toggle')
			    	location.reload();
			    }else {
			    	alert("There has been an error deleting the line");
			    }
			  });
		  }
		
	}
	</script>
