<div class="panel panel-default">
  <div class="panel-heading form-inline">
  		<a class="btn btn-success" role="button" style="float: right;" href="#" download="Groups<?= "(" . date("m.d.Y") . ")" ?>.xls" href="#" onclick="return ExcellentExport.excel(this, 'groups', 'Groups');" data-toggle="tooltip" data-placement="left" title="Does not work with Internet Explorer">Export To Excel</a>
  		<div style="margin-right: 10px; float: right;">
  		<div class="input-group">
  			<div id="clearButton" style="display: none;" class="input-group-addon" onclick="clearFilter()">
  				<span class="glyphicon glyphicon-remove" aria-hidden="true"></span></div>
  		 	<input type="text"   class="form-control" name="filter" placeholder="Filter" value="" />
  			<div class="input-group-addon" onclick="filter()">
  		      	<span class="glyphicon glyphicon-search" aria-hidden="true"></span></div>
  		</div>
  			<button class="btn btn-primary" onclick="addGroup()" >Add New Group</button>
  	</div>
  	
    <h3 class="panel-title">Inventory Groups</h3>
    <small>Click on a row to edit the group definition</small>
  </div>
  <div class="panel-body">
  <table class="table table-hover" id="groups">
    <thead>
    	<tr>
    		<th>Code</th>
    		<th>Spanish Name</th>    		
    		<th>English Name</th>    		
    	</tr>
    </thead>
   <?php 
   	$query = "SELECT * FROM `GROUP` ORDER BY `Name` ASC";
   	$result = mysqli_query($con, $query);
   	while ($row = mysqli_fetch_array($result)) {
   ?>
   		<tr onclick="editGroup('<?= $row['Code'] ?>')">
   			<td><?= $row['Code'] ?></td>
   			<td><?= $row['Name'] ?></td>
   			<td><?= $row['NameEN'] ?></td>
   		</tr>
   <?php		
   	}
    ?>
    </table>
  </div>
</div>


<div class="modal fade" id="AddEditGroup">
  <div class="modal-dialog">
    <div class="modal-content">
      <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
        <h4 class="modal-title" id="AddEditTitle">Edit Group</h4>
      </div>
      <div class="modal-body">
      	<form>
      		<input type="hidden" id="isNew" name="isNew" value="" />
      		<div class="form-group">
      		    <label for="GroupCode">Group Code</label>
      		    <input type="text" class="form-control" name="GroupCode" autocomplete="off" id="GroupCode" placeholder="Code">
      		  </div>
      		<div class="form-group">
      		    <label for="GroupName">Group Name - Spanish</label>
      		    <input type="text" class="form-control" name="GroupName" autocomplete="off" id="GroupName" placeholder="Name - Spanish">
      		  </div>
      		<div class="form-group">
      		    <label for="GroupName">Group Name - English</label>
      		    <input type="text" class="form-control" name="GroupNameEN" autocomplete="off" id="GroupNameEN" placeholder="Name - English">
      		  </div>
      	</form>
      </div>
      <div class="modal-footer">
      	<button type="button" class="btn btn-danger" id="deleteButton" onclick="deleteGroup()" data-dismiss="modal">Delete</button>
        <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
        <button type="button" class="btn btn-primary" onclick="saveGroupInfo()">Save</button>
      </div>
    </div><!-- /.modal-content -->
  </div><!-- /.modal-dialog -->
</div><!-- /.modal -->
<script type="text/javascript">
$('[name=filter]').on('keypress', function(e) {
	if (e.which == 13) {
		filter();
	}

});
function clearFilter() {
	$('[name=filter]').val("");
	$('#clearButton').css('display', 'none');
	$('tr').css('display', '');
	
}
function filter() {
	var	name = $('[name=filter]').val();
	filterByName(name);
}
function filterByName(name) {
	$('#clearButton').css('display', '');
	for (var i = 0; i < $('tr').length; i++) {
		if (i != 0) {
			var result = $('tr')[i].innerText.toUpperCase().indexOf(name.toUpperCase());
			if (result < 0) {
				$($('tr')[i]).css('display', 'none');
			}else {
				$($('tr')[i]).css('display', '');
			}
		}
	}
}


	function clearModal() {
		$('#isNew').val("0");
		$('#GroupCode').val("");
		$('#GroupName').val("");
		$('#GroupNameEN').val("");
		$('#GroupCode').prop("readonly", null);
	}
	function addGroup() {
		clearModal();
		$('#isNew').val("1");
		$('#AddEditTitle').text("Add Group");
		$('#deleteButton').css('display', 'none');
		$('#AddEditGroup').modal('toggle');
		$('#GroupCode').prop("readonly", null);
	}
	function editGroup(GroupCode) {
		clearModal();
		$.get("functions.php?action=getGroupInfo&groupCode=" + GroupCode, function(data){
		 	var group = JSON.parse(data);
		 	$('#isNew').val("0");
			$('#AddEditTitle').text("Edit Group");
			$('#GroupCode').val(group.Code);
			$('#GroupName').val(group.Name);
			$('#GroupNameEN').val(group.NameEN);
			$('#deleteButton').css('display', '');
			$('#GroupCode').prop("readonly", true);
			$('#AddEditGroup').modal('toggle');
			
		});
	}
	function saveGroupInfo() {
		var groupData = '{ "Code" : "' + $('#GroupCode').val() + '", "Name" : "' + $('#GroupName').val() + '", "NameEN" : "' + $('#GroupNameEN').val() + '", "IsNew" : "' + $('#isNew').val() + '"}';
		groupData = JSON.parse(groupData);
		console.log(groupData);
		$.post( "functions.php?action=saveGroupInfo", groupData)
		  .done(function( data ) {
		  	data = JSON.parse(data);
		    if (data.result === true) {
		      	clearModal();
		      	$('#AddEditGroup').modal('toggle')
		      	location.reload();
		      }else {
		      	alert("There has been an error saving the group data.\r\n\r\nMySQL Error: " + data.error);
		      }
		    });
	}
	function deleteGroup() {
		if (confirm("Are you sure you want to delete this group from the database? This cannot be undone.")) {
			var groupCode = $('#GroupCode').val();
			$.post( "functions.php?action=deleteGroup&groupCode=" + groupCode, null)
			  .done(function( data ) {
			  data = $.parseJSON(data);
			  console.log(data.result);
			    if (data.result == true) {
			    	clearModal();
			    	$('#AddEditGroup').modal('toggle')
			    	location.reload();
			    }else {
			    	alert("There has been an error deleting the group");
			    }
			  });
		  }
		
	}
	</script>
