<div class="panel panel-default">
  <div class="panel-heading form-inline">
  		<a class="btn btn-success" role="button" style="float: right;" href="#" download="Groups<?= "(" . date("m.d.Y") . ")" ?>.xls" href="#" onclick="return ExcellentExport.excel(this, 'BuyersGuideCatalogs', 'BuyersGuideCatalogs');" data-toggle="tooltip" data-placement="left" title="Does not work with Internet Explorer">Export To Excel</a>
  		<div style="margin-right: 10px; float: right;">
  		<div class="input-group">
  			<div id="clearButton" style="display: none;" class="input-group-addon" onclick="clearFilter()">
  				<span class="glyphicon glyphicon-remove" aria-hidden="true"></span></div>
  		 	<input type="text"   class="form-control" name="filter" placeholder="Filter" value="" />
  			<div class="input-group-addon" onclick="filter()">
  		      	<span class="glyphicon glyphicon-search" aria-hidden="true"></span></div>
  		</div>
  			<button class="btn btn-primary" onclick="addCatalogDefinition()" >Add New Definition</button>
  	</div>
  	
    <h3 class="panel-title">Buyer's Guide Catalog Definitions</h3>
    <small>Click on a row to edit the catalog definition</small>
  </div>
  <div class="panel-body">
  <table class="table table-hover" id="BuyersGuideCatalogs">
    <thead>
    	<tr>
    		<th>Line</th>
    		<th>Group</th>    		
    		<th>Type</th>
    		<th>CatalogID</th>
    		<th>Suppliers</th>    		
    	</tr>
    </thead>
   <?php 
   	$query = "SELECT * FROM `BUYERS_GUIDE_DEFINITIONS` ORDER BY `Line`, `Group` ASC";
   	$result = mysqli_query($con, $query);
   	while ($row = mysqli_fetch_array($result)) {
   ?>
   		<tr onclick="editCatalogDefinition('<?= $row['ID'] ?>')">
   			<td><?= $row['Line'] ?></td>
   			<td><?= $row['Group'] ?></td>
   			<td><?= $row['Type'] ?></td>
   			<td><?= $row['CatalogID'] ?></td>
   			<td><?= $row['Suppliers'] ?></td>
   		</tr>
   <?php		
   	}
    ?>
    </table>
  </div>
</div>


<div class="modal fade" id="AddEditCatalogDefinition">
  <div class="modal-dialog">
    <div class="modal-content">
      <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
        <h4 class="modal-title" id="AddEditTitle">Edit Catalog Definition</h4>
      </div>
      <div class="modal-body">
      	<form>
      		<input type="hidden" id="isNew" name="isNew" value="" />
      		<input type="hidden" id="BGID" name="BGID" value="" />
      		<div class="form-group">
      		    <label for="BGLine">Line</label>
      		    <input type="text" class="form-control" name="BGLine" autocomplete="off" id="BGLine" placeholder="Line">
      		  </div>
      		<div class="form-group">
      		    <label for="BGGroup">Group</label>
      		    <input type="text" class="form-control" name="BGGroup" autocomplete="off" id="BGGroup" placeholder="Group">
      		  </div>
      		<div class="form-group">
      		    <label for="BGType">Search Mode</label>
      		    <select class="form-control" name="BGType" id="BGType">
      		    	<option value="direct">Direct</option>
      		    	<option value="cross">Cross Reference</option>
      		    </select>
      		  </div>
      		  <div class="form-group">
      		      <label for="BGCatalogID">SMTP CatalogID</label>
      		      
								<select class="form-control" name="BGCatalogID" autocomplete="off" id="BGCatalogID">
									<option>Select ShowMeTheParts Catalog</option>
									<option value="091681">ShowMeTheParts General Catalog</option>
									
									<option value="API12345">Autopart International</option>
									<option value="98781WEB">Continental Elite</option>
									<option value="98766">EMPI</option>
									<option value="98KYB98W">KYB</option>
									
									<option value="PLEWS2182">Plews/Edelmann</option>
									<option value="PTC2182">PTC - Power Train Components</option>
									<option value="98760TY">Westar</option>
								</select>
      		    </div>
      		  <div class="form-group">
      		      <label for="BGSuppliers">Supplier(s)<br /><small><i>Comma separated values, no spaces between commas.</i></small></label>
      		      <input type="text" class="form-control" name="BGSuppliers" autocomplete="off" id="BGSuppliers" placeholder="Supplier(s)">
      		    </div>
      	</form>
      </div>
      <div class="modal-footer">
      	<button type="button" class="btn btn-danger" id="deleteButton" data-dismiss="modal">Delete</button>
        <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
        <button type="button" class="btn btn-primary" onclick="saveCatalogDefinitionInfo()">Save</button>
      </div>
    </div><!-- /.modal-content -->
  </div><!-- /.modal-dialog -->
</div><!-- /.modal -->
<script type="text/javascript">
$('[name=filter]').on('keypress', function(e) {
	if (e.which == 13) {
		filter();
	}

});
function clearFilter() {
	$('[name=filter]').val("");
	$('#clearButton').css('display', 'none');
	$('tr').css('display', '');
	
}
function filter() {
	var	name = $('[name=filter]').val();
	filterByName(name);
}
function filterByName(name) {
	$('#clearButton').css('display', '');
	for (var i = 0; i < $('tr').length; i++) {
		if (i != 0) {
			var result = $('tr')[i].innerText.toUpperCase().indexOf(name.toUpperCase());
			if (result < 0) {
				$($('tr')[i]).css('display', 'none');
			}else {
				$($('tr')[i]).css('display', '');
			}
		}
	}
}


	function clearModal() {
		$('#isNew').val("0");
		$('#BGGroup').val("");
		$('#BGLine').val("");
		$('#BGSuppliers').val("");
		$('#BGCatalogID').val("");
	}
	function addCatalogDefinition() {
		clearModal();
		$('#isNew').val("1");
		$('#AddEditTitle').text("Add New Catalog Definition");
		$('#deleteButton').css('display', 'none');
		$('#AddEditCatalogDefinition').modal('toggle');
		
	}
	function editCatalogDefinition(id){
		clearModal();
		$.get("functions.php?action=getBuyersGuideDefinition&id=" + id, function(data){
		 	var catalog = JSON.parse(data).data;
		 	$('#isNew').val("0");
			$('#AddEditTitle').text("Edit Catalog Definition");
			$('#BGID').val(catalog.ID);
			$('#BGGroup').val(catalog.Group);
			$('#BGLine').val(catalog.Line);
			$('#BGType').val(catalog.Type);
			$('#BGSuppliers').val(catalog.Suppliers);
			$('#BGCatalogID').val(catalog.CatalogID);
			$('#deleteButton').css('display', '');
			$('#deleteButton').on('click', function(){
				deleteCatalogDefinition(id);
			});
			$('#AddEditCatalogDefinition').modal('toggle');
			
			
		});
	}
	function saveCatalogDefinitionInfo(){
		var definitionData = {};
		definitionData.IsNew = $('#isNew').val();
		definitionData.ID = $('#BGID').val();
		definitionData.Group = $('#BGGroup').val();
		definitionData.Type = $('#BGType').val();
		definitionData.Line = $('#BGLine').val();
		definitionData.CatalogID = $('#BGCatalogID').val();
		definitionData.Suppliers = $('#BGSuppliers').val();
		$.post( "functions.php?action=saveBuyersGuideDefinition", definitionData)
		  .done(function( data ) {
		  	data = JSON.parse(data);
		    if (data.result === true) {
		      	clearModal();
		      	$('#AddEditCatalogDefinition').modal('toggle');
		      	location.reload();
		      }else {
		      	alert("There has been an error saving the catalog definition data.\r\n\r\nMySQL Error: " + data.error + "\r\nSQL Query: " + data.query);
		      }
		    });
	}
	function deleteCatalogDefinition(id) {
		if (confirm("Are you sure you want to delete this Catalog Definition from the database? This cannot be undone.")) {
			$.get("functions.php?action=deleteBuyersGuideDefinition&id=" + id, function(){
				$('#AddEditCatalogDefinition').modal('toggle');
				location.reload();
			});
		}
		
	}
	</script>
