<?php
include("../connect.php");
include("../session.php");

$for = $_REQUEST['a'];
$title = "";
$fromDate = "";
$toDate = "";
switch ($for) {
	case "customer":
		$customer = new Customer($_REQUEST["customer"]);
		$title = " - By Customer: " . $customer->Name;
		$fromDate = $_REQUEST['fromDate'];
		$toDate = $_REQUEST['toDate'];
		break;
	case "salesman":
		$salesman = new Salesman($_REQUEST['salesman']);
		$title = " - By Salesman: " . $salesman->Name;
		$fromDate = $_REQUEST['fromDate'];
		$toDate = $_REQUEST['toDate'];
		break;
	case "date":
		$title = " - By Date: ";
		$fromDate = $_REQUEST['fromDate'];
		$toDate = $_REQUEST['toDate'];
		break;
}

function getElapsedTime($from, $to){
	$from = strtotime($from);
	$to = strtotime($to);
	return (secondsToTime($to-$from));

}
function secondsToTime($s)
{
    $h = floor($s / 3600);
    $s -= $h * 3600;
    $m = floor($s / 60);
    $s -= $m * 60;
    return $h.':'.sprintf('%02d', $m).':'.sprintf('%02d', $s);
}
 ?>

 <!DOCTYPE html>
 <html lang="en">
   <head>
     <meta charset="utf-8">
     <meta http-equiv="X-UA-Compatible" content="IE=edge">
     <meta name="viewport" content="width=device-width, initial-scale=1">
     <title><?= $config['CompanyName'] ?></title>

     <!-- Bootstrap -->
     <link href="../css/bootstrap.min.css" rel="stylesheet">
     <link rel="stylesheet" href="../css/bootstrap-combobox.css" />

     <!-- HTML5 shim and Respond.js for IE8 support of HTML5 elements and media queries -->
     <!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
     <!--[if lt IE 9]>
       <script src="https://oss.maxcdn.com/html5shiv/3.7.2/html5shiv.min.js"></script>
       <script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
       <!-- jQuery (necessary for Bootstrap's JavaScript plugins) -->
           <script src="https://ajax.googleapis.com/ajax/libs/jquery/1.11.1/jquery.min.js"></script>
           <!-- Include all compiled plugins (below), or include individual files as needed -->
           <script src="../js/bootstrap.min.js"></script>
       	 <script src="../js/bootstrap-combobox.js"></script>
       	 <script src="../js/excellentexport.js"></script>
           <script type="text/javascript">
             $(document).ready(function(){
       //        $('.grpline').css("width", "100px");
				$('.panel-heading').after($('.panel-footer').clone().addClass('hidden-print'))
             });
           </script>

     <![endif]-->
	<link rel="stylesheet" href="../css/styles.css"/>
   </head>
   <body>

       <?php include("navbar.php"); ?>


   <!-- Stack the columns on mobile by making one full-width and the other half-width -->
<div class="container " style="padding-top: 10px;">
	<div class="panel panel-default">
	  <div class="panel-heading form-inline">
	  <a class="btn btn-success hidden-print" role="button" style="float: right;" href="#" download="OrderHistory<?= $title . "(" . date("m.d.Y",strtotime($fromDate)) . " - " . date("m.d.Y",strtotime($toDate)) . ")" ?>.xls" href="#" onclick="return ExcellentExport.excel(this, 'orderhistory', 'Order History');" data-toggle="tooltip" data-placement="left" title="Does not work with Internet Explorer">Export To Excel</a>

	  	<div style="margin-right: 10px; float: right;">
	  			<div class="input-group hidden-print" >
	  			      <div id="clearButton" style="display: none;" class="input-group-addon" onclick="clearFilter()">
	  			      	<span class="glyphicon glyphicon-remove" aria-hidden="true"></span></div>
	  			      <input type="text" class="form-control" name="filter" placeholder="Order ID" value="" />
	  			      <div class="input-group-addon" onclick="filter()">
	  			      	<span class="glyphicon glyphicon-search" aria-hidden="true"></span></div>
	  			    </div>
	  	</div>

	  		    <h3 class="panel-title">Estimate history<?= $title . " - <i>From: " . date("m/d/Y",strtotime($fromDate)) . " To: " . date("m/d/Y",strtotime($toDate)) . "</i>"?></h3><br />

				<form method="get" action="" class="hidden-print">
	  		    	<select class="form-control" name="sort">
	  		    		<option value="EstimateID">Order ID</option>
	  		    		<option value="Name">Customer Name</option>
	  		    		<option value="SalesmanOrder">Order By Salesman/Customer</option>
	  		    	</select>
	  		    	<select class="form-control" name="direction">
	  		    		<option <?= (isset($_REQUEST['direction']) && $_REQUEST['direction'] == "ASC")?"selected":"" ?> value="ASC">Ascending</option>
	  		    		<option <?= (isset($_REQUEST['direction']) && $_REQUEST['direction'] == "DESC")?"selected":"" ?> value="DESC">Descending</option>
	  		    	</select>
	  		    	<input type="hidden" name="a" value="<?= $_REQUEST["a"] ?>" />
	  		    	<input type="hidden" name="fromDate" value="<?= $_REQUEST["fromDate"] ?>" />
	  		    	<input type="hidden" name="toDate" value="<?= $_REQUEST["toDate"] ?>" />
	  		    	<input type="submit" class="form-control" name="" value="Sort" />
	  		    </form>
	  </div>
	  <div class="panel-body">
	  	<table class="table table-hover table-condensed" id="orderhistory">
	  		<thead>
	  			<tr>
	  				<th>Estimate ID</th>
	  				<?= ($for != "customer") ? "<th>Customer</th>" : "" ?>
	  				<th>Estimate Date/Time</th>
	  				<th>Salesperson</th>
					<th>Status</th>
	  				<th style="text-align: center;">Total</th>
	  				<th></th>
					<th></th>
	  			</tr>

	  		</thead>
			<tbody>
	    <?php
	    if (isset($_REQUEST['sort'])) {
	    	if ($_REQUEST['sort'] != "") {
	    		$sort = $_REQUEST['sort'];
	    		$direction = $_REQUEST['direction'];
	    	}
	    }else {
	    	$sort = "EstimateID";
	    	$direction = "DESC";
	    }

	    if ($for == "customer") {
	    	$query = "SELECT * FROM ESTIMATE_HEAD, CUSTOMER WHERE ESTIMATE_HEAD.AccountNumber LIKE '" . $customer->AccountNumber . "' AND DATE(EstimateDate) BETWEEN '$fromDate' AND '$toDate' AND CUSTOMER.AccountNumber = ESTIMATE_HEAD.AccountNumber ORDER BY $sort $direction";
	    }elseif($for == "salesman") {
	    	$query = "SELECT * FROM ESTIMATE_HEAD, CUSTOMER WHERE ESTIMATE_HEAD.Salesman LIKE '" . $salesman->ID . "' AND DATE(EstimateDate) BETWEEN '$fromDate' AND '$toDate' AND CUSTOMER.AccountNumber = ESTIMATE_HEAD.AccountNumber ORDER BY $sort $direction";
	    }elseif ($for == "date") {
	    	$query = "SELECT * FROM ESTIMATE_HEAD, CUSTOMER WHERE DATE(EstimateDate) BETWEEN '$fromDate' AND '$toDate' AND CUSTOMER.AccountNumber = ESTIMATE_HEAD.AccountNumber ORDER BY $sort $direction";
	    }
		//echo $query;
		//LAST YEAR SALES INFO
		if ($for == "customer") {
	    	$queryLastYear = "SELECT SUM(OrderQty * Price) AS LastYearSales, COUNT(DISTINCT(ESTIMATE_HEAD.EstimateID)) AS `Count`, SalesmanOrder FROM ESTIMATE_HEAD, ESTIMATE_DETAIL WHERE ESTIMATE_HEAD.DeleteOrder = 0 AND ESTIMATE_HEAD.EstimateID = ESTIMATE_DETAIL.EstimateID AND ESTIMATE_HEAD.AccountNumber LIKE '" . $customer->AccountNumber . "' AND DATE(EstimateDate) BETWEEN DATE_ADD('$fromDate', INTERVAL -1 YEAR) AND DATE_ADD('$toDate', INTERVAL -1 YEAR) GROUP BY SalesmanOrder";
	    }elseif($for == "salesman") {
	    	$queryLastYear = "SELECT SUM(OrderQty * Price) AS LastYearSales, COUNT(DISTINCT(ESTIMATE_HEAD.EstimateID)) AS `Count`, SalesmanOrder FROM ESTIMATE_HEAD, ESTIMATE_DETAIL WHERE ESTIMATE_HEAD.DeleteOrder = 0 AND ESTIMATE_HEAD.EstimateID = ESTIMATE_DETAIL.EstimateID AND ESTIMATE_HEAD.Salesman LIKE '" . $salesman->ID . "' AND DATE(EstimateDate) BETWEEN DATE_ADD('$fromDate', INTERVAL -1 YEAR) AND DATE_ADD('$toDate', INTERVAL -1 YEAR) GROUP BY SalesmanOrder";
	    }elseif ($for == "date") {
	    	$queryLastYear = "SELECT SUM(OrderQty * Price) AS LastYearSales, COUNT(DISTINCT(ESTIMATE_HEAD.EstimateID)) AS `Count`, SalesmanOrder FROM ESTIMATE_HEAD, ESTIMATE_DETAIL WHERE ESTIMATE_HEAD.DeleteOrder = 0 AND ESTIMATE_HEAD.EstimateID = ESTIMATE_DETAIL.EstimateID AND DATE(EstimateDate) BETWEEN DATE_ADD('$fromDate', INTERVAL -1 YEAR) AND DATE_ADD('$toDate', INTERVAL -1 YEAR) GROUP BY SalesmanOrder";
	    }
		$resultLastYear = mysqli_query($con, $queryLastYear);
		$lastYearData = array();
		while($rowLastYear = mysqli_fetch_array($resultLastYear)){
			$lastYearData[$rowLastYear['SalesmanOrder']] = new stdClass();
			$lastYearData[$rowLastYear['SalesmanOrder']]->Count = $rowLastYear['Count'];
			$lastYearData[$rowLastYear['SalesmanOrder']]->Sales = $rowLastYear['LastYearSales'];

		}

	   	$result = mysqli_query($con, $query);
	   	$total = 0;
		$offlineOrders = 0;
		$offlineAmount = 0;
	   	$totalCustomer = 0;
	   	$totalSalesman = 0;
		$custTransactions = 0;
		$salesmanTransactions = 0;
		$status = "";
	   	while ($row = mysqli_fetch_array($result)) {
	   		$estimate = new Estimate($row['EstimateID']);
			if(isset($_REQUEST['hideProcessed']) && $_REQUEST['hideProcessed'] == "true" && $row['Processed']){
				continue;
			}
			if($row['DeleteEstimate'] == 0){
				$total += $estimate->EstimateTotal;

					$totalSalesman += $estimate->EstimateTotal;
					$salesmanTransactions++;

			}

	   		//var_dump($row['DeleteEstimate']);
			if($row['Processed']){
				$status = "Processed";
				$statusLabelClass = "label-success";
				$statusText = "<b>User:</b> " . $row['ProcessUser'] . "<br />";
				$statusText .= "<b>Started Processing:</b> " . date('m/d/Y h:i a', strtotime($row['InProcessDate'])) . "<br />";
				$statusText .= "<b>Done Processing:</b> " . date('m/d/Y h:i a', strtotime($row['ProcessedDate'])) . "<br />";
				$statusText .= "<b>Elapsed Time:</b> " . getElapsedTime($row['InProcessDate'], $row['ProcessedDate']) . "<br />";
			}elseif($row['DeleteEstimate']){
				$status = "Deleted";
				$statusLabelClass = "label-danger";
				$statusText = "<b>User:</b> " . $row['OnHoldDeleteUser'] . "<br />";
				$statusText .= "<b>Deleted On:</b> " . date('m/d/Y h:i a', strtotime($row['DeleteEstimateDate'])) . "<br />";
				$statusText .= "<b>Reason:</b> " . $row['HoldDeleteReason'] . "<br />";
			}elseif($row['InProcess']){
				$status = "In Process";
				$statusLabelClass = "label-warning";
				$statusText = "<b>User:</b> " . $row['ProcessUser'] . "<br />";
				$statusText .= "<b>Started Processing:</b> " . date('m/d/Y h:i a', strtotime($row['InProcessDate'])) . "<br />";
			}elseif($row['OnHold']){
				$status = "On Hold";
				$statusLabelClass = "label-warning";
				$statusText = "<b>User:</b> " . $row['OnHoldDeleteUser'] . "<br />";
				$statusText .= "<b>Set On Hold on:</b> " . date('m/d/Y h:i a', strtotime($row['OnHoldDate'])) . "<br />";
				$statusText .= "<b>Reason:</b> " . $row['HoldDeleteReason'] . "<br />";
			}elseif($row['Archive']){
				$status = "Archived";
				$statusLabelClass = "label-default";
				//$statusText = "<b>User:</b> " . $row['OnHoldDeleteUser'] . "<br />";
				//$statusText .= "<b>Set On Hold on:</b> " . date('m/d/Y h:i a', strtotime($row['OnHoldDate'])) . "<br />";
				//$statusText .= "<b>Reason:</b> " . $row['HoldDeleteReason'] . "<br />";
			}else{
				$status = "Unprocessed";
				$statusLabelClass = "label-default";
				$statusText = "No process data available";

			}
			$estimate = new Estimate($row['EstimateID']);

	   	?>
	   		<tr>
	   			<td>
						<div class="dropdown">
				    <a class="btn btn-default hidden-print dropdown-toggle" data-toggle="dropdown"><?= $row['EstimateID'] ?>
				    <span class="caret"></span></a>
				    <ul class="dropdown-menu">
				      <li><a href="<?= $estimate->getViewLink(false) ?>" target="_blank">View Estimate</a></li>
				      <li><a href="#" onclick="showEstimateCustomerInfo('<?= $row['EstimateID'] ?>');">View/Edit Customer Information</a></li>
				      <li><a href="#" onclick="sendEstimateEmail('<?= $row['EstimateID'] ?>')">Resend Estimate to Email in file</a></li>
							<li><a href="#">Send Estimate to new Email</a></li>
				    </ul>
				  </div>
						<span class="visible-print-block"><?= $row['EstimateID'] ?></span>
					</td>
	   			<?= ($for != "customer") ? "<td>" . $estimate->Customer->Name . "</td>" : "" ?>
	   			<td style="white-space: nowrap;"><?= date("m/d/Y g:i a",strtotime($row['EstimateDate'])) ?></td>

				<td style="white-space: nowrap;"><?= $estimate->Salesman->Name ?></td>
				<td><button style="font-size:12px;" data-placement="left" data-html="true" type="button" class="label <?= $statusLabelClass ?>" data-container="body" data-toggle="popover" title="<?= $status ?>" data-content="<?= $statusText ?>"><?= $status ?></a></td>
				<td style="text-align: right;"><?= moneyFormat($estimate->EstimateTotal) ?></td>
				<td>
					<button class="btn btn-success hidden-print" onclick="sendToShoppingCart('<?= $row['EstimateID'] ?>')">Send to Cart</button>
					</td>
				<td>
					<button class="btn btn-success hidden-print" onclick="createOrder('<?= $row['EstimateID'] ?>')">Create Order</button>

				</td>
	   		</tr>
	   	<?php
	   	}
	     ?>
			</tbody>
	     </table>
			<script type="text/javascript">
						function sendToShoppingCart(eid){
							$.get('mod.php?p=estimate&a=functions&f=sendToShoppingCart&id=' + eid, function(){

								alert("Estimate loaded to shopping cart");

							});
						}
						function createOrder(eid){
							$.get('mod.php?p=estimate&a=functions&f=createOrder&id=' + eid, function(data){
								if(data == "false"){
									alert("Error, maybe the estimate is already processed");
								}else{
									data = JSON.parse(data);
									if(confirm("Order " + data.OrderID +  "  created, redirect to Order Queue?")){
										window.location = "mod.php?p=orderqueue&a=queue";
									}else{
										location.reload();
									}
								}


							});
						}
			</script>
	  </div>
	  <div class="panel-footer" style="height: 130px;" >

	  	<span  style="float: right; text-align: right;">
	  		<strong>Total Estimates: </strong><i><?= moneyFormat($total) ?></i> <br /><b>Average:</b> <?= @moneyFormat($total/($custTransactions+$salesmanTransactions)) ?><br />
			<strong>Total Transactions: </strong><i><?= $custTransactions+$salesmanTransactions ?></i>
	  	</span>
	  </div>

	</div>

</div>
<script type="text/javascript">

$('[name=filter]').on('keypress', function(e) {
	if (e.which == 13) {
		filter();
	}

});
function clearFilter() {
	$('[name=filter]').val("");
	$('#clearButton').css('display', 'none');
	$('tr').css('display', '');

}
function filter() {
	var	name = $('[name=filter]').val();
	filterByName(name);
}
function filterByName(name) {
	$('#clearButton').css('display', '');
	for (var i = 0; i < $('td').length; i=i+7) {

		var text = $($('td')[i]).text();

		var result = text.toUpperCase().indexOf(name.toUpperCase());
		if (text != name) {
			$($('tr')[i/7+1]).css('display', 'none');
		}else {
			$($('tr')[i/7+1]).css('display', '');
		}

	}
}
function fillEditOrder(orderID) {
	clearEditOrder();
	$.get("functions.php?action=getOrderDetails&orderID=" + orderID, function(data) {
		data = JSON.parse(data);
		$('#EditOrderTitle').text('Edit Order #' + data.EstimateID);
		$('#EditModalEstimateID').val(data.EstimateID);
		for (var i = 0; i < data.Items.length; i++) {
			$('#EditOrderModalBody').append('<tr><td>' + data.Items[i].Group.toString() + '<br />' + data.Items[i].Line.toString() + '</td><td>' + data.Items[i].SKU.toString() + '</td><td>' + data.Items[i].Description + ' ' + data.Items[i].Notes.toString() + '</td><td><input class="form-control EditOrderItem" style="width: 80px;" type="text" name="' + data.Items[i].ID + '" data-Key="' + data.Items[i].Group.toString() + "-" + data.Items[i].Line.toString() + "-" + data.Items[i].SKU.toString() + '" data-OriginalQty="' + data.Items[i].OrderQty + '" value="' + data.Items[i].OrderQty + '" /></td><td>' + data.Items[i].Price + '</td><td>' + parseFloat(data.Items[i].Price)*parseInt(data.Items[i].OrderQty) + '</td></tr>');
		}
		$('#EditOrderModal').modal();

	});
}
function clearEditOrder() {
	$('#EditOrderTitle').text('Edit Order');
	$('#EditModalEstimateID').val('0');
	$('#EditOrderModalBody').html('');

}
function saveOrderInfo() {
	var items = $('.EditOrderItem');
	var changes = new Object();
	changes.EstimateID = $('#EditModalEstimateID').val();
	changes.Items = new Array();
	for (var i = 0; i < items.length; i++) {
		var origQty = parseInt($($('.EditOrderItem')[i]).attr("data-OriginalQty"));
		var newQty = parseInt($($('.EditOrderItem')[i]).val());
		var itemKey = $($('.EditOrderItem')[i]).attr("data-Key")
		if (origQty != newQty) {
			var item = new Object()
			item.ID = $($('.EditOrderItem')[i]).attr('name');
			item.NewQty = newQty;
			item.OriginalQty = origQty;
			item.ItemKey = itemKey;
			changes.Items.push(item);
		}

	}
	$.post("functions.php?action=saveOrderDetail", changes, function(data) {
		if(data == "true"){
			location.reload();
		}

	});

}
function sendEstimateEmail(EstimateID){
	$.get('mod.php?p=estimate&a=functions&f=sendEstimateEmail&eid=' + EstimateID, function(data){
		alert(data);
	});

}
function showEstimateCustomerInfo(EstimateID){
	$.get('mod.php?p=estimate&a=functions&f=getEstimateCustomerData&eid=' + EstimateID, function(data){
		data = JSON.parse(data);
		clearEstimateCustomerInfo();
$('#estimateCustomerInformation #EstimateCompanyName').val(data.Customer.Name);
		$('#estimateCustomerInformation #EstimateContactName').val(data.Customer.Contact);
		$('#estimateCustomerInformation #EstimateContactTitle').val(data.Customer.ContactTitle);
		$('#estimateCustomerInformation #EstimateEmail').val(data.Customer.Email);
		$('#estimateCustomerInformation #EstimateTaxID2').val(data.Customer.TaxID2);
		$('#estimateCustomerInformation #EstimateTaxIDExpiration2').val(data.Customer.TaxIDExpiration2);
		$('#estimateCustomerInformation #EstimatePhone').val(data.Customer.Phone);

		$('#estimateCustomerInformation #EstimateTaxID').val(data.Customer.TaxID1);
		$('#estimateCustomerInformation #EstimateTaxIDExpiration').val(data.Customer.TaxIDExpiration1);
		$('#estimateCustomerInformation #EstimateBillToAddress1').val(data.Customer.Address1);
		$('#estimateCustomerInformation #EstimateBillToAddress2').val(data.Customer.Address2);
		$('#estimateCustomerInformation #EstimateBillToCity').val(data.Customer.City);
		$('#estimateCustomerInformation #EstimateBillToState').val(data.Customer.State);
		$('#estimateCustomerInformation #EstimateBillToZip').val(data.Customer.ZipCode);
		$('#estimateCustomerInformation #EstimateShipToAddress1').val(data.Customer.ShipToAddress1);
		$('#estimateCustomerInformation #EstimateShipToAddress2').val(data.Customer.ShipToAddress2);
		$('#estimateCustomerInformation #EstimateShipToCity').val(data.Customer.ShipToCity);
		$('#estimateCustomerInformation #EstimateShipToState').val(data.Customer.ShipToState);
		$('#estimateCustomerInformation #EstimateShipToZip').val(data.Customer.ShipToZip);


		$('#estimateCustomerInformation').modal('show');

	});

}
function clearEstimateCustomerInfo(){
	$('#estimateCustomerInformation input').val('');
}
</script>

<div class="modal fade" tabindex="-1" id="estimateCustomerInformation" role="dialog">
	<div class="modal-dialog modal-lg" role="document">
		<div class="modal-content">
		<div class="modal-header">
			<button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
			<h4 class="modal-title">Estimate Customer Information</h4>
		</div>
		<div style="min-height:150px;" class="modal-body">

			<script type="text/javascript" src="/js/jquery.mask.js"></script>
			<script type="text/javascript">
				$(document).ready(function(){
					$('#EstimatePhone').mask('(000) 000-0000');
					$('#EstimateBillToZip').mask('00000-0000');
					$('#EstimateShipToZip').mask('00000-0000');
					function validateEmail(email) {
						var filter = /^[\w\-\.\+]+\@[a-zA-Z0-9\.\-]+\.[a-zA-z0-9]{2,4}$/;
						if (filter.test(sEmail)) {
							return true;
						} else {
							return false;
						}
					}
				});
			</script>
				<h4>Contact Information</h4>
				<div  id="NewCustomerInformationForm">
				<div class="row">

					<div class="col-sm-6">
						<div class="form-group">

							<label for="EstimateCompanyName">Company Name:</label>
							<input disabled type="text" class="form-control required allcaps" autocomplete="false" value="" name="EstimateCompanyName" id="EstimateCompanyName">
						</div>

						<div class="form-group">
							<label for="EstimateContactTitle">Contact Title:</label>
							<select readonly class="form-control required" style="width: 80px;" name="EstimateContactTitle" id="EstimateContactTitle">
								<option></option>
								<option>Sr.</option>
								<option>Sra.</option>
								<option>Mr.</option>
								<option>Mrs.</option>
							</select>
						</div>

						<div class="form-group">
							<label for="EstimateContactName">Contact Name:</label>
							<input disabled type="text" style="text-transform: capitalize;" class="form-control required propercase" autocomplete="false" name="EstimateContactName" id="EstimateContactName"  value="">
						</div>
						<div class="form-group">
							<label for="EstimateTaxID">Tax ID State</label>
							<input disabled type="text" class="form-control" autocomplete="false" name="EstimateTaxID" id="EstimateTaxID" value="">
						</div>
						<div class="form-group">
							<label for="EstimateTaxIDExpiration">Tax ID State Expiration Date</label>
							<input disabled type="date" class="form-control" autocomplete="false" name="EstimateTaxIDExpiration" id="EstimateTaxIDExpiration" value="">
						</div>

					</div>
					<div class="col-sm-6">

						<div class="form-group">
							<label for="EstimatePhone">Phone</label>
							<input disabled type="text" class="form-control required" autocomplete="false" name="EstimatePhone" id="EstimatePhone" value="">
						</div>
						<div class="form-group">
							<label for="EstimateEmail">Email</label>
							<input type="text" class="form-control required alllower" autocomplete="false" name="EstimateEmail" id="EstimateEmail" value="">
						</div>
						<div class="form-group">
							<label for="EstimateTaxID2">Tax ID Municipal <i>(If left blank taxes will be charged)</i></label>
							<input type="text" class="form-control" autocomplete="false" name="EstimateTaxID2" id="EstimateTaxID2" value="">
						</div>
						<div class="form-group">
							<label for="EstimateTaxIDExpiration2">Tax ID Municipal Expiration Date</label>
							<input type="date" class="form-control" autocomplete="false" name="EstimateTaxIDExpiration2" id="EstimateTaxIDExpiration2" value="">
						</div>
					</div>
				</div>
				<div class="row">

					<div class="col-sm-6">
						<h4>Billing Address</h4>
						<div class="form-group">
							<label for="EstimateBillToAddress1">Address 1</label>
							<input disabled type="text" class="form-control required allcaps" autocomplete="false" name="EstimateBillToAddress1" id="EstimateBillToAddress1" value="">
						</div>
						<div class="form-group">
							<label for="EstimateBillToAddress2">Address 2</label>
							<input disabled type="text" class="form-control allcaps" autocomplete="false" name="EstimateBillToAddress2" id="EstimateBillToAddress2" value="">
						</div>
						<div class="row">
							<div class="col-sm-6">
								<div class="form-group">
									<label for="EstimateBillToCity">City</label>
									<input disabled type="text" class="form-control required allcaps" autocomplete="false" name="EstimateBillToCity" id="EstimateBillToCity" value="">
								</div>
							</div>
							<div class="col-sm-2">
								<div class="form-group">
									<label for="EstimateBillToState">State</label>
									<input disabled type="text" class="form-control required allcaps" autocomplete="false" name="EstimateBillToState" id="EstimateBillToState" value="">
								</div>
							</div>
							<div class="col-sm-4">
								<div class="form-group">
									<label for="EstimateBillToZip">Zip Code</label>
									<input disabled type="text" class="form-control required" autocomplete="false" name="EstimateBillToZip" id="EstimateBillToZip" value="">
								</div>
							</div>
							<div class="col-sm-4">
								<div class="form-group form-inline" style="display: inline-block;">
									<input class="form-control" style="display: inline-block;" type="checkbox" name="EstimateSameAddress" id="EstimateSameAddress" />
									<label disabled for="EstimateSameAddress" class="radio-inline">Same Address</label>
								</div>
							</div>
							<style>

							</style>
							<script>
								$('#EstimateSameAddress').on('change', function(e){
									//alert(e.target);
									//console.log($(e.target));

									if($(e.target).prop('checked')){
										$('#EstimateShipToAddress1').val($('#EstimateBillToAddress1').val());
										$('#EstimateShipToAddress2').val($('#EstimateBillToAddress2').val());
										$('#EstimateShipToCity').val($('#EstimateBillToCity').val());
										$('#EstimateShipToState').val($('#EstimateBillToState').val());
										$('#EstimateShipToZip').val($('#EstimateBillToZip').val());

									}
								});
							</script>
						</div>
					</div>

					<div class="col-sm-6">
						<h4>Shipping Address (Physical Address)</h4>
						<div class="form-group">
							<label for="EstimateShipToAddress1">Address 1</label>
							<input disabled type="text" class="form-control required" autocomplete="false" name="EstimateShipToAddress1" id="EstimateShipToAddress1" >
						</div>
						<div class="form-group">
							<label for="EstimateShipToAddress2">Address 2</label>
							<input disabled type="text" class="form-control allcaps" autocomplete="false" name="EstimateShipToAddress2" id="EstimateShipToAddress2" >
						</div>
						<div class="row">
							<div class="col-sm-6">
								<div class="form-group">
									<label for="EstimateShipToCity">City</label>
									<input disabled type="text" class="form-control required allcaps" autocomplete="false" name="EstimateShipToCity" id="EstimateShipToCity">
								</div>
							</div>
							<div class="col-sm-2">
								<div class="form-group">
									<label for="EstimateShipToState">State</label>
									<input disabled type="text" class="form-control required allcaps" autocomplete="false" name="EstimateShipToState" id="EstimateShipToState">
								</div>
							</div>
							<div class="col-sm-4">
								<div class="form-group">
									<label for="EstimateShipToZip">Zip Code</label>
									<input disabled type="text" class="form-control" autocomplete="false" name="EstimateShipToZip" id="EstimateShipToZip">
								</div>
							</div>
						</div>
					</div>
				</div>

				<hr>
				<div class="col-sm-12">

					<script type="text/javascript">
						$('#estimateImageSelect').on('change', function(){
							$('#estimateImage').val($('#estimateImageSelect').val());
						});
						function validateNewCustomerEmail(){
							if($('#EstimateEmail').val()){
								var email = $('#EstimateEmail').val().trim();
								if(email !== "" && email != "no tiene"){
									$.get("functions.php?action=verifyEmail&email=" + email, function(data){
											if(data == "false"){
												alert("The email address is not valid!");

												$('#EstimateEmail').focus();
												return false;
											}else{
												return true;
											}
									});
								}else{
									return true;
								}
							}else{
								return true;
							}
						}
						$('#EstimateEmail').on('change', function(){
							validateNewCustomerEmail();
						});
					</script>
				</div>


			</div>
		</div>
		<div class="modal-footer">
			<br>

			<button type="button" class="btn btn-danger" data-dismiss="modal">Cancel</button>
			<button type="button" name="SaveCustomerEstimate" class="btn btn-primary">Save</button>
		</div>
		</div><!-- /.modal-content -->
	</div><!-- /.modal-dialog -->
	</div><!-- /.modal -->



	<script>
		$(function () {
			$('[data-toggle="popover"]').popover();
		  });
	</script>

   </body>

 </html>
