# ************************************************************
# Sequel Pro SQL dump
# Version 4541
#
# http://www.sequelpro.com/
# https://github.com/sequelpro/sequelpro
#
# Host: westingpr.com (MySQL 5.6.41-84.1)
# Database: westingp_elite
# Generation Time: 2019-06-09 21:02:00 +0000
# ************************************************************


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;


# Dump of table ACCOUNTS_RECEIVABLE_AGING
# ------------------------------------------------------------

DROP VIEW IF EXISTS `ACCOUNTS_RECEIVABLE_AGING`;

CREATE TABLE `ACCOUNTS_RECEIVABLE_AGING` (
   `InvoiceID` INT(11) NOT NULL DEFAULT '0',
   `AccountNumber` VARCHAR(10) NOT NULL DEFAULT '',
   `ElapsedDays` INT(7) NULL DEFAULT NULL,
   `Payment` DOUBLE(19) NULL DEFAULT NULL,
   `Sale` DOUBLE(19) NULL DEFAULT NULL,
   `Balance` DOUBLE(19) NULL DEFAULT NULL,
   `0To30` DOUBLE(19) NULL DEFAULT NULL,
   `31To60` DOUBLE(19) NULL DEFAULT NULL,
   `61To90` DOUBLE(19) NULL DEFAULT NULL,
   `Over90` DOUBLE(19) NULL DEFAULT NULL
) ENGINE=MyISAM;



# Dump of table ADMIN_SHORTCUT
# ------------------------------------------------------------

DROP TABLE IF EXISTS `ADMIN_SHORTCUT`;

CREATE TABLE `ADMIN_SHORTCUT` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `Username` varchar(32) COLLATE latin1_general_ci DEFAULT NULL,
  `Link` varchar(2048) COLLATE latin1_general_ci DEFAULT NULL,
  `Title` varchar(64) COLLATE latin1_general_ci DEFAULT NULL,
  `Badge` varchar(128) COLLATE latin1_general_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci;



# Dump of table ADMINISTRATOR
# ------------------------------------------------------------

DROP TABLE IF EXISTS `ADMINISTRATOR`;

CREATE TABLE `ADMINISTRATOR` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `FullName` varchar(30) COLLATE latin1_general_ci DEFAULT NULL,
  `Username` varchar(30) COLLATE latin1_general_ci DEFAULT NULL,
  `Password` varchar(30) COLLATE latin1_general_ci DEFAULT NULL,
  `Email` varchar(35) COLLATE latin1_general_ci DEFAULT NULL,
  `Level` int(11) NOT NULL DEFAULT '1',
  `LastLogin` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci;



# Dump of table ALTAS_DETAIL
# ------------------------------------------------------------

DROP TABLE IF EXISTS `ALTAS_DETAIL`;

CREATE TABLE `ALTAS_DETAIL` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `AltaID` int(11) NOT NULL,
  `Line` varchar(3) NOT NULL,
  `Group` varchar(3) NOT NULL,
  `SKU` varchar(30) NOT NULL,
  PRIMARY KEY (`ID`),
  UNIQUE KEY `ID` (`ID`),
  KEY `Line` (`Line`,`Group`,`SKU`),
  KEY `AltaID` (`AltaID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;



# Dump of table ALTAS_HEAD
# ------------------------------------------------------------

DROP TABLE IF EXISTS `ALTAS_HEAD`;

CREATE TABLE `ALTAS_HEAD` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `Name` varchar(60) NOT NULL,
  `NameEN` varchar(60) NOT NULL,
  `DateLine` varchar(20) NOT NULL,
  `ReceiptDate` datetime NOT NULL,
  `Sort` varchar(60) NOT NULL DEFAULT 'Line, SKU',
  `Active` tinyint(1) NOT NULL,
  UNIQUE KEY `ID` (`ID`),
  KEY `ReceiptDate` (`ReceiptDate`,`Active`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;



# Dump of table APPLICATIONS_CATALOG
# ------------------------------------------------------------

DROP TABLE IF EXISTS `APPLICATIONS_CATALOG`;

CREATE TABLE `APPLICATIONS_CATALOG` (
  `part_number` varchar(32) COLLATE latin1_general_ci DEFAULT NULL,
  `label` varchar(255) COLLATE latin1_general_ci DEFAULT NULL,
  `parttype` varchar(255) COLLATE latin1_general_ci DEFAULT NULL,
  `position` varchar(255) COLLATE latin1_general_ci DEFAULT NULL,
  `qty` int(11) DEFAULT NULL,
  `notes` varchar(255) COLLATE latin1_general_ci DEFAULT NULL,
  `basevehicle` varchar(255) COLLATE latin1_general_ci DEFAULT NULL,
  `enginebase` varchar(255) COLLATE latin1_general_ci NOT NULL DEFAULT '',
  `aspiration` varchar(255) COLLATE latin1_general_ci DEFAULT NULL,
  `bedlength` varchar(255) COLLATE latin1_general_ci DEFAULT NULL,
  `bedtype` varchar(255) COLLATE latin1_general_ci DEFAULT NULL,
  `bodynumdoors` varchar(255) COLLATE latin1_general_ci DEFAULT NULL,
  `bodytype` varchar(255) COLLATE latin1_general_ci DEFAULT NULL,
  `brakeabs` varchar(255) COLLATE latin1_general_ci DEFAULT NULL,
  `brakesystem` varchar(255) COLLATE latin1_general_ci DEFAULT NULL,
  `cylinderheadtype` varchar(128) COLLATE latin1_general_ci DEFAULT NULL,
  `drivetype` varchar(255) COLLATE latin1_general_ci DEFAULT NULL,
  `enginedesignation` varchar(128) COLLATE latin1_general_ci DEFAULT NULL,
  `enginemfr` varchar(255) COLLATE latin1_general_ci DEFAULT NULL,
  `engineversion` varchar(255) COLLATE latin1_general_ci DEFAULT NULL,
  `enginevin` varchar(255) COLLATE latin1_general_ci DEFAULT NULL,
  `frontbraketype` varchar(255) COLLATE latin1_general_ci DEFAULT NULL,
  `frontspringtype` varchar(255) COLLATE latin1_general_ci DEFAULT NULL,
  `fueldeliverysubtype` varchar(255) COLLATE latin1_general_ci DEFAULT NULL,
  `fueldeliverytype` varchar(255) COLLATE latin1_general_ci DEFAULT NULL,
  `fuelsystemcontroltype` varchar(255) COLLATE latin1_general_ci DEFAULT NULL,
  `fuelsystemdesign` varchar(255) COLLATE latin1_general_ci DEFAULT NULL,
  `fueltype` varchar(255) COLLATE latin1_general_ci DEFAULT NULL,
  `ignitionsystemtype` varchar(255) COLLATE latin1_general_ci DEFAULT NULL,
  `mfrbodycode` varchar(255) COLLATE latin1_general_ci DEFAULT NULL,
  `rearbraketype` varchar(255) COLLATE latin1_general_ci DEFAULT NULL,
  `rearspringtype` varchar(255) COLLATE latin1_general_ci DEFAULT NULL,
  `region` varchar(255) COLLATE latin1_general_ci DEFAULT NULL,
  `steeringsystem` varchar(255) COLLATE latin1_general_ci DEFAULT NULL,
  `steeringtype` varchar(255) COLLATE latin1_general_ci DEFAULT NULL,
  `transmissioneleccontrolled` varchar(255) COLLATE latin1_general_ci DEFAULT NULL,
  `transmissioncontroltype` varchar(255) COLLATE latin1_general_ci DEFAULT NULL,
  `transmissionmfr` varchar(255) COLLATE latin1_general_ci DEFAULT NULL,
  `transmissionmfrcode` varchar(255) COLLATE latin1_general_ci DEFAULT NULL,
  `transmissionnumspeeds` varchar(255) COLLATE latin1_general_ci DEFAULT NULL,
  `transmissiontype` varchar(255) COLLATE latin1_general_ci DEFAULT NULL,
  `valves` varchar(255) COLLATE latin1_general_ci DEFAULT NULL,
  `vehicletype` varchar(255) COLLATE latin1_general_ci DEFAULT NULL,
  `wheelbase` varchar(255) COLLATE latin1_general_ci DEFAULT NULL,
  `liter` varchar(255) COLLATE latin1_general_ci DEFAULT NULL,
  `cc` varchar(255) COLLATE latin1_general_ci DEFAULT NULL,
  `cid` varchar(255) COLLATE latin1_general_ci DEFAULT NULL,
  `cylinders` varchar(255) COLLATE latin1_general_ci DEFAULT NULL,
  `blocktype` varchar(255) COLLATE latin1_general_ci DEFAULT NULL,
  `submodel` varchar(255) COLLATE latin1_general_ci DEFAULT NULL,
  `year` int(11) DEFAULT NULL,
  `make` varchar(128) COLLATE latin1_general_ci DEFAULT NULL,
  `model` varchar(128) COLLATE latin1_general_ci DEFAULT NULL,
  `poweroutput` varchar(128) COLLATE latin1_general_ci DEFAULT NULL,
  `brand` varchar(128) COLLATE latin1_general_ci DEFAULT NULL,
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `groupcode` varchar(3) COLLATE latin1_general_ci NOT NULL DEFAULT '',
  `linecode` varchar(3) COLLATE latin1_general_ci NOT NULL DEFAULT '',
  `dashless` varchar(32) COLLATE latin1_general_ci DEFAULT NULL,
  `enginestring` varchar(12) COLLATE latin1_general_ci DEFAULT NULL,
  `haveit` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `part_number` (`part_number`),
  KEY `year` (`year`,`model`,`make`),
  KEY `year_2` (`year`,`make`,`model`,`parttype`),
  KEY `parttype` (`parttype`),
  KEY `FullAppSearch` (`year`,`make`,`model`,`parttype`,`part_number`),
  KEY `year_3` (`year`),
  KEY `dashless` (`dashless`),
  KEY `enginestring` (`enginestring`),
  KEY `haveit` (`haveit`),
  KEY `brand` (`brand`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci;



# Dump of table BILLBOARD
# ------------------------------------------------------------

DROP TABLE IF EXISTS `BILLBOARD`;

CREATE TABLE `BILLBOARD` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `Title` varchar(128) COLLATE latin1_general_ci NOT NULL,
  `Type` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `Content` text COLLATE latin1_general_ci NOT NULL,
  `Text` text COLLATE latin1_general_ci NOT NULL,
  `Link` text COLLATE latin1_general_ci NOT NULL,
  `Button` text COLLATE latin1_general_ci NOT NULL,
  `Position` int(2) NOT NULL,
  `StartDate` datetime NOT NULL,
  `EndDate` datetime NOT NULL,
  `Active` tinyint(1) NOT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci;



# Dump of table BUYERS_GUIDE_DEFINITIONS
# ------------------------------------------------------------

DROP TABLE IF EXISTS `BUYERS_GUIDE_DEFINITIONS`;

CREATE TABLE `BUYERS_GUIDE_DEFINITIONS` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `Line` varchar(3) NOT NULL,
  `Group` varchar(3) NOT NULL,
  `Type` varchar(20) NOT NULL,
  `CatalogID` varchar(10) NOT NULL,
  `Suppliers` text NOT NULL,
  PRIMARY KEY (`ID`),
  KEY `Type` (`Type`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;



# Dump of table CART_LOG
# ------------------------------------------------------------

DROP TABLE IF EXISTS `CART_LOG`;

CREATE TABLE `CART_LOG` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `Action` varchar(256) COLLATE latin1_general_ci DEFAULT NULL,
  `Group` varchar(3) COLLATE latin1_general_ci DEFAULT NULL,
  `Line` varchar(3) COLLATE latin1_general_ci DEFAULT NULL,
  `SKU` varchar(32) COLLATE latin1_general_ci DEFAULT NULL,
  `Qty` int(11) DEFAULT NULL,
  `User` varchar(32) COLLATE latin1_general_ci DEFAULT NULL,
  `TransactionDate` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `TransactionDate` (`TransactionDate`),
  KEY `User` (`User`,`TransactionDate`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci;



# Dump of table CATALOG_CATEGORY
# ------------------------------------------------------------

DROP TABLE IF EXISTS `CATALOG_CATEGORY`;

CREATE TABLE `CATALOG_CATEGORY` (
  `CatalogID` int(11) NOT NULL AUTO_INCREMENT,
  `Name` varchar(128) NOT NULL DEFAULT '',
  `NameEN` varchar(128) NOT NULL DEFAULT '',
  `Sort` varchar(60) NOT NULL DEFAULT 'Line, SKU',
  `SortOrder` int(11) NOT NULL DEFAULT '1000',
  PRIMARY KEY (`CatalogID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;



# Dump of table CATALOG_DETAIL
# ------------------------------------------------------------

DROP TABLE IF EXISTS `CATALOG_DETAIL`;

CREATE TABLE `CATALOG_DETAIL` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `CategoryID` int(11) NOT NULL,
  `Line` varchar(3) NOT NULL,
  `SKU` varchar(30) NOT NULL,
  `Title` varchar(60) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;



# Dump of table CATALOG_ITEMS
# ------------------------------------------------------------

DROP TABLE IF EXISTS `CATALOG_ITEMS`;

CREATE TABLE `CATALOG_ITEMS` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `SKU` varchar(32) COLLATE latin1_general_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci;



# Dump of table CATALOG_LOG
# ------------------------------------------------------------

DROP TABLE IF EXISTS `CATALOG_LOG`;

CREATE TABLE `CATALOG_LOG` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `AccountNumber` varchar(12) COLLATE latin1_general_ci DEFAULT NULL,
  `SearchDate` datetime DEFAULT NULL,
  `year` int(4) DEFAULT NULL,
  `make` varchar(32) COLLATE latin1_general_ci DEFAULT NULL,
  `model` varchar(32) COLLATE latin1_general_ci DEFAULT NULL,
  `engine` varchar(32) COLLATE latin1_general_ci DEFAULT NULL,
  `parttype` varchar(128) COLLATE latin1_general_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `AccountNumber` (`AccountNumber`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci;



# Dump of table CELL_PROVIDER
# ------------------------------------------------------------

DROP TABLE IF EXISTS `CELL_PROVIDER`;

CREATE TABLE `CELL_PROVIDER` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `Name` varchar(20) COLLATE latin1_general_ci DEFAULT NULL,
  `Suffix` varchar(30) COLLATE latin1_general_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci;



# Dump of table CHECKS_DETAIL
# ------------------------------------------------------------

DROP VIEW IF EXISTS `CHECKS_DETAIL`;

CREATE TABLE `CHECKS_DETAIL` (
   `PaymentID` INT(11) NOT NULL,
   `CheckNumber` VARCHAR(16) NOT NULL,
   `Name` VARCHAR(45) NOT NULL DEFAULT '',
   `Amount` FLOAT NOT NULL,
   `CollectingUser` VARCHAR(3) NULL DEFAULT NULL,
   `PaymentDate` DATETIME NOT NULL
) ENGINE=MyISAM;



# Dump of table COMMISSION_HISTORY_HEAD
# ------------------------------------------------------------

DROP TABLE IF EXISTS `COMMISSION_HISTORY_HEAD`;

CREATE TABLE `COMMISSION_HISTORY_HEAD` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `TransactionDate` datetime NOT NULL,
  `User` varchar(20) NOT NULL,
  `Period` varchar(100) NOT NULL,
  `Notes` varchar(1000) NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `Period` (`Period`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;



# Dump of table COMMISSION_HISTORY_PAID_INVOICE_RPT
# ------------------------------------------------------------

DROP TABLE IF EXISTS `COMMISSION_HISTORY_PAID_INVOICE_RPT`;

CREATE TABLE `COMMISSION_HISTORY_PAID_INVOICE_RPT` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `RunID` int(11) NOT NULL,
  `Salesman` varchar(3) NOT NULL,
  `Branch` int(1) NOT NULL,
  `AccountNumber` varchar(10) NOT NULL,
  `CustomerName` varchar(60) NOT NULL,
  `InvoiceNumber` varchar(8) NOT NULL,
  `PaidDate` date NOT NULL,
  `PaymentAmt` decimal(12,2) NOT NULL,
  `Discount` decimal(8,2) NOT NULL,
  `Tax` decimal(8,2) NOT NULL COMMENT 'Column Named Reference',
  `Job` int(2) NOT NULL,
  `Commission` decimal(8,2) NOT NULL DEFAULT '0.00',
  `CommissionRate` decimal(8,2) DEFAULT NULL,
  `Reference` varchar(32) DEFAULT NULL,
  PRIMARY KEY (`ID`),
  KEY `Salesman` (`Salesman`,`AccountNumber`,`InvoiceNumber`),
  KEY `InvoiceNumber` (`InvoiceNumber`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;



# Dump of table COMMISSION_HISTORY_SALES_RPT
# ------------------------------------------------------------

DROP TABLE IF EXISTS `COMMISSION_HISTORY_SALES_RPT`;

CREATE TABLE `COMMISSION_HISTORY_SALES_RPT` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `RunID` int(11) NOT NULL,
  `Branch` int(3) NOT NULL,
  `Salesman` varchar(3) NOT NULL,
  `Price` double NOT NULL,
  `GrossMargin` double NOT NULL,
  `MarginPercent` double NOT NULL,
  `PartNumber` varchar(32) NOT NULL,
  `Description` text NOT NULL,
  `InvoiceNumber` varchar(8) NOT NULL,
  `AccountNumber` varchar(14) NOT NULL,
  `CustomerName` varchar(32) NOT NULL,
  `TransactionDate` varchar(12) NOT NULL,
  `LineCode` varchar(6) NOT NULL,
  `Commission` double NOT NULL,
  `CommissionRate` double NOT NULL,
  PRIMARY KEY (`ID`),
  KEY `Branch` (`Branch`,`Salesman`),
  KEY `PriceIndex` (`Price`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;



# Dump of table COMMISSION_PAID_INVOICE_RPT
# ------------------------------------------------------------

DROP TABLE IF EXISTS `COMMISSION_PAID_INVOICE_RPT`;

CREATE TABLE `COMMISSION_PAID_INVOICE_RPT` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `Salesman` varchar(3) NOT NULL,
  `Branch` int(1) NOT NULL,
  `AccountNumber` varchar(10) NOT NULL,
  `CustomerName` varchar(60) NOT NULL,
  `InvoiceNumber` varchar(8) NOT NULL,
  `PaidDate` date NOT NULL,
  `PaymentAmt` decimal(12,2) NOT NULL,
  `Discount` decimal(8,2) NOT NULL,
  `Tax` decimal(8,2) NOT NULL COMMENT 'Column Named Reference',
  `Job` int(2) NOT NULL,
  `Commission` decimal(8,2) NOT NULL DEFAULT '0.00',
  `CommissionRate` decimal(8,2) DEFAULT NULL,
  `Reference` varchar(32) DEFAULT NULL,
  PRIMARY KEY (`ID`),
  KEY `Salesman` (`Salesman`,`AccountNumber`,`InvoiceNumber`),
  KEY `Job` (`Job`),
  KEY `InvoiceNumber` (`InvoiceNumber`),
  KEY `Reference` (`Reference`),
  KEY `InvoiceNumber_2` (`InvoiceNumber`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;



# Dump of table COMMISSION_SALES_RPT
# ------------------------------------------------------------

DROP TABLE IF EXISTS `COMMISSION_SALES_RPT`;

CREATE TABLE `COMMISSION_SALES_RPT` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `Branch` int(11) NOT NULL,
  `Salesman` varchar(3) NOT NULL,
  `Price` double NOT NULL,
  `GrossMargin` double NOT NULL,
  `MarginPercent` double NOT NULL,
  `PartNumber` varchar(32) NOT NULL,
  `Description` text NOT NULL,
  `InvoiceNumber` varchar(8) NOT NULL,
  `AccountNumber` varchar(14) NOT NULL,
  `CustomerName` varchar(32) NOT NULL,
  `TransactionDate` varchar(12) NOT NULL,
  `LineCode` varchar(6) NOT NULL,
  `Commission` double NOT NULL,
  `CommissionRate` double NOT NULL,
  PRIMARY KEY (`ID`),
  UNIQUE KEY `Main` (`Branch`,`Salesman`,`PartNumber`,`InvoiceNumber`,`Price`),
  KEY `Branch` (`Branch`,`Salesman`),
  KEY `PriceIndex` (`Price`),
  KEY `AccountNumber` (`AccountNumber`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;



# Dump of table COMMISSION_SALESMAN_PAYMENT_SUBSTITUTION
# ------------------------------------------------------------

DROP TABLE IF EXISTS `COMMISSION_SALESMAN_PAYMENT_SUBSTITUTION`;

CREATE TABLE `COMMISSION_SALESMAN_PAYMENT_SUBSTITUTION` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `AccountNumber` varchar(7) NOT NULL,
  `Job` int(2) NOT NULL,
  `SalesmanID` varchar(3) NOT NULL,
  PRIMARY KEY (`ID`),
  KEY `AccountNumber` (`AccountNumber`,`Job`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;



# Dump of table COMMISSION_SELECTIVE_SPECIAL_CUSTOMER
# ------------------------------------------------------------

DROP TABLE IF EXISTS `COMMISSION_SELECTIVE_SPECIAL_CUSTOMER`;

CREATE TABLE `COMMISSION_SELECTIVE_SPECIAL_CUSTOMER` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `AccountNumber` varchar(10) NOT NULL,
  PRIMARY KEY (`ID`),
  UNIQUE KEY `AccountNumber` (`AccountNumber`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;



# Dump of table COMMISSION_SELECTIVE_SPECIAL_ITEM
# ------------------------------------------------------------

DROP TABLE IF EXISTS `COMMISSION_SELECTIVE_SPECIAL_ITEM`;

CREATE TABLE `COMMISSION_SELECTIVE_SPECIAL_ITEM` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `Line` varchar(3) NOT NULL,
  `SKU` varchar(32) NOT NULL,
  `Description` varchar(60) NOT NULL,
  `Notes` varchar(60) NOT NULL,
  PRIMARY KEY (`ID`),
  KEY `Line` (`Line`,`SKU`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;



# Dump of table COMMISSION_SPECIAL
# ------------------------------------------------------------

DROP TABLE IF EXISTS `COMMISSION_SPECIAL`;

CREATE TABLE `COMMISSION_SPECIAL` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `Line` varchar(3) NOT NULL,
  `SKU` varchar(32) NOT NULL,
  `Description` varchar(60) NOT NULL,
  `Notes` varchar(60) NOT NULL,
  PRIMARY KEY (`ID`),
  KEY `Line` (`Line`,`SKU`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;



# Dump of table CREDIT
# ------------------------------------------------------------

DROP TABLE IF EXISTS `CREDIT`;

CREATE TABLE `CREDIT` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `ST` int(11) NOT NULL,
  `CreditDate` date DEFAULT NULL,
  `AccountNumber` varchar(9) DEFAULT NULL,
  `Job` int(11) NOT NULL,
  `CreditNumber` varchar(11) DEFAULT NULL,
  `Reference` varchar(60) DEFAULT NULL,
  `Subtotal` float(10,2) DEFAULT NULL,
  `SalesTax` float(10,2) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `InvoiceNumber` (`CreditNumber`),
  KEY `AccountNumber` (`AccountNumber`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;



# Dump of table CUSTOMER
# ------------------------------------------------------------

DROP TABLE IF EXISTS `CUSTOMER`;

CREATE TABLE `CUSTOMER` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `Name` varchar(45) COLLATE latin1_general_ci NOT NULL DEFAULT '',
  `Address1` varchar(128) COLLATE latin1_general_ci DEFAULT NULL COMMENT 'Billing Address',
  `Address2` varchar(128) COLLATE latin1_general_ci DEFAULT NULL,
  `City` varchar(30) COLLATE latin1_general_ci NOT NULL DEFAULT '',
  `State` varchar(12) COLLATE latin1_general_ci DEFAULT NULL,
  `ZipCode` varchar(10) COLLATE latin1_general_ci DEFAULT NULL,
  `Phone` varchar(14) CHARACTER SET latin1 NOT NULL,
  `PhoneExt` varchar(10) COLLATE latin1_general_ci DEFAULT NULL,
  `ContactTitle` varchar(8) COLLATE latin1_general_ci DEFAULT NULL,
  `Contact` varchar(256) COLLATE latin1_general_ci NOT NULL DEFAULT '',
  `ContactPhone` varchar(14) COLLATE latin1_general_ci DEFAULT NULL,
  `AccountNumber` varchar(12) COLLATE latin1_general_ci NOT NULL DEFAULT '',
  `PriceLevel` varchar(2) COLLATE latin1_general_ci NOT NULL DEFAULT 'B',
  `Email` varchar(50) CHARACTER SET latin1 NOT NULL DEFAULT '',
  `Salesman` varchar(11) COLLATE latin1_general_ci NOT NULL DEFAULT '',
  `CreditLimit` decimal(10,2) NOT NULL,
  `DiscountDays` int(4) NOT NULL DEFAULT '45',
  `SupplierID` varchar(32) COLLATE latin1_general_ci DEFAULT NULL COMMENT 'Our Supplier Number in customer''s database',
  `Password` varchar(32) CHARACTER SET latin1 NOT NULL DEFAULT '827ccb0eea8a706c4c34a16891f84e7b',
  `Comments` text CHARACTER SET latin1 NOT NULL,
  `Active` tinyint(1) NOT NULL DEFAULT '0',
  `Language` varchar(2) CHARACTER SET latin1 NOT NULL DEFAULT 'ES',
  `DisableCheck` tinyint(1) NOT NULL DEFAULT '0',
  `LastLogin` datetime NOT NULL,
  `CookieHash` varchar(32) CHARACTER SET latin1 NOT NULL DEFAULT '',
  `CookieExpire` datetime NOT NULL,
  `ResetHash` varchar(32) CHARACTER SET latin1 NOT NULL DEFAULT '',
  `WaiveShipping` tinyint(1) NOT NULL DEFAULT '0',
  `SendOrderEmail` tinyint(1) DEFAULT '1',
  `SendAmountDueEmail` tinyint(1) NOT NULL DEFAULT '1',
  `ShowUPCInvoice` tinyint(1) NOT NULL DEFAULT '0',
  `DueDays` int(6) DEFAULT NULL,
  `DueDaysCalcDate` datetime DEFAULT NULL,
  `TaxID1` varchar(60) COLLATE latin1_general_ci DEFAULT NULL,
  `TaxIDExpiration1` date DEFAULT NULL,
  `TaxExempt1` tinyint(1) NOT NULL DEFAULT '0',
  `TaxID2` varchar(60) COLLATE latin1_general_ci DEFAULT NULL,
  `TaxIDExpiration2` date DEFAULT NULL,
  `TaxExempt2` tinyint(1) NOT NULL DEFAULT '0',
  `Terms` varchar(20) COLLATE latin1_general_ci NOT NULL DEFAULT '15',
  `ShipToAddress1` varchar(128) COLLATE latin1_general_ci DEFAULT NULL,
  `ShipToAddress2` varchar(128) COLLATE latin1_general_ci DEFAULT NULL,
  `ShipToCity` varchar(32) COLLATE latin1_general_ci DEFAULT NULL,
  `ShipToState` varchar(12) COLLATE latin1_general_ci DEFAULT NULL,
  `ShipToZip` varchar(12) COLLATE latin1_general_ci DEFAULT NULL,
  PRIMARY KEY (`ID`),
  UNIQUE KEY `AccountNumber` (`AccountNumber`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci;



# Dump of table CUSTOMER_ACTIVITY
# ------------------------------------------------------------

DROP TABLE IF EXISTS `CUSTOMER_ACTIVITY`;

CREATE TABLE `CUSTOMER_ACTIVITY` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `AccountNumber` varchar(9) NOT NULL,
  `ReportDate` datetime NOT NULL,
  `LastOrder` datetime NOT NULL,
  `Reason` text NOT NULL,
  `Salesman` varchar(3) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `Index` (`AccountNumber`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;



# Dump of table CUSTOMER_ACTIVITY_ALERT
# ------------------------------------------------------------

DROP TABLE IF EXISTS `CUSTOMER_ACTIVITY_ALERT`;

CREATE TABLE `CUSTOMER_ACTIVITY_ALERT` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `AccountNumber` varchar(9) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `LastOrder` datetime NOT NULL,
  `AlertDate` datetime NOT NULL,
  `Salesman` varchar(3) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `AccountNumber` (`AccountNumber`,`LastOrder`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;



# Dump of table CUSTOMER_TAX_CODE
# ------------------------------------------------------------

DROP TABLE IF EXISTS `CUSTOMER_TAX_CODE`;

CREATE TABLE `CUSTOMER_TAX_CODE` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `TaxCode` varchar(32) COLLATE latin1_general_ci DEFAULT NULL,
  `PercentA` double(6,5) DEFAULT NULL,
  `PercentB` double(6,5) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `TaxCode` (`TaxCode`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci;



# Dump of table CUSTOMER_UPDATE
# ------------------------------------------------------------

DROP TABLE IF EXISTS `CUSTOMER_UPDATE`;

CREATE TABLE `CUSTOMER_UPDATE` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `AccountNumber` varchar(10) NOT NULL,
  `UpdateDate` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;



# Dump of table DELIVERY_CITY
# ------------------------------------------------------------

DROP TABLE IF EXISTS `DELIVERY_CITY`;

CREATE TABLE `DELIVERY_CITY` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `DeliveryID` int(11) DEFAULT NULL,
  `City` varchar(32) COLLATE latin1_general_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci;



# Dump of table DELIVERY_OPTION
# ------------------------------------------------------------

DROP TABLE IF EXISTS `DELIVERY_OPTION`;

CREATE TABLE `DELIVERY_OPTION` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `Name` varchar(64) DEFAULT NULL,
  `StartTime` time DEFAULT NULL,
  `Cutoff` time DEFAULT NULL,
  `Comment` varchar(256) DEFAULT NULL,
  `DeliveredBy` time DEFAULT NULL,
  `FeeRule` varchar(256) DEFAULT NULL COMMENT 'PHP code with calculation instructions: Variables: ($fee, $orderTotal)',
  `DisplayPrice` tinyint(1) NOT NULL DEFAULT '0',
  `SameDay` tinyint(1) DEFAULT '0',
  `SKU` varchar(32) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;



# Dump of table DELIVERY_ZONE
# ------------------------------------------------------------

DROP TABLE IF EXISTS `DELIVERY_ZONE`;

CREATE TABLE `DELIVERY_ZONE` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `DeliveryID` int(11) DEFAULT NULL,
  `Zone` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `DeliveryID` (`DeliveryID`,`Zone`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci;



# Dump of table DELIVERY_ZONE_CITY
# ------------------------------------------------------------

DROP TABLE IF EXISTS `DELIVERY_ZONE_CITY`;

CREATE TABLE `DELIVERY_ZONE_CITY` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `Zone` int(11) DEFAULT NULL,
  `City` varchar(32) COLLATE latin1_general_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci;



# Dump of table DETAILED_PAYMENT
# ------------------------------------------------------------

DROP VIEW IF EXISTS `DETAILED_PAYMENT`;

CREATE TABLE `DETAILED_PAYMENT` (
   `ID` INT(11) NULL DEFAULT '0',
   `PaymentID` INT(11) NULL DEFAULT NULL,
   `Processed` TINYINT(1) NOT NULL DEFAULT '0',
   `InvoiceID` VARCHAR(10) NULL DEFAULT '',
   `InvoiceDate` DATE NULL DEFAULT NULL,
   `SalesmanID` VARCHAR(3) NOT NULL,
   `Reference` VARCHAR(20) NULL DEFAULT NULL,
   `PartialPayment` TINYINT(1) NULL DEFAULT '0',
   `SubtotalAmount` FLOAT NULL DEFAULT NULL,
   `DiscountAmount` FLOAT NULL DEFAULT NULL,
   `TaxAmount` FLOAT(8) NULL DEFAULT NULL,
   `PaymentAmount` FLOAT NULL DEFAULT NULL,
   `AccountNumber` VARCHAR(10) NOT NULL,
   `Void` TINYINT(1) NOT NULL DEFAULT '0',
   `PaymentDate` DATETIME NOT NULL
) ENGINE=MyISAM;



# Dump of table EMAIL_LOG
# ------------------------------------------------------------

DROP TABLE IF EXISTS `EMAIL_LOG`;

CREATE TABLE `EMAIL_LOG` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `MailDate` datetime DEFAULT NULL,
  `ToAddress` varchar(256) COLLATE latin1_general_ci DEFAULT NULL,
  `FromAddress` varchar(256) COLLATE latin1_general_ci DEFAULT NULL,
  `Subject` varchar(256) COLLATE latin1_general_ci DEFAULT NULL,
  `Message` text COLLATE latin1_general_ci,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci;



# Dump of table ERROR_LOG
# ------------------------------------------------------------

DROP TABLE IF EXISTS `ERROR_LOG`;

CREATE TABLE `ERROR_LOG` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `Content` text COLLATE latin1_general_ci,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci;



# Dump of table ESTIMATE_CUSTOMER
# ------------------------------------------------------------

DROP TABLE IF EXISTS `ESTIMATE_CUSTOMER`;

CREATE TABLE `ESTIMATE_CUSTOMER` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `EstimateID` int(11) NOT NULL,
  `Name` varchar(60) COLLATE latin1_general_ci DEFAULT NULL,
  `Email` varchar(128) COLLATE latin1_general_ci DEFAULT NULL,
  `Phone` varchar(20) COLLATE latin1_general_ci DEFAULT NULL,
  `BillToAddress1` varchar(128) COLLATE latin1_general_ci DEFAULT NULL,
  `BillToAddress2` varchar(128) COLLATE latin1_general_ci DEFAULT NULL,
  `BillToCity` varchar(32) COLLATE latin1_general_ci DEFAULT NULL,
  `BillToState` varchar(4) COLLATE latin1_general_ci DEFAULT NULL,
  `BillToZip` varchar(12) COLLATE latin1_general_ci DEFAULT NULL,
  `ShipToAddress1` varchar(128) COLLATE latin1_general_ci DEFAULT NULL,
  `ShipToAddress2` varchar(128) COLLATE latin1_general_ci DEFAULT NULL,
  `ShipToCity` varchar(32) COLLATE latin1_general_ci DEFAULT NULL,
  `ShipToState` varchar(4) COLLATE latin1_general_ci DEFAULT NULL,
  `ShipToZip` varchar(12) COLLATE latin1_general_ci DEFAULT NULL,
  `ContactTitle` varchar(8) COLLATE latin1_general_ci DEFAULT NULL,
  `Contact` varchar(128) COLLATE latin1_general_ci DEFAULT NULL,
  `TaxID1` varchar(60) COLLATE latin1_general_ci DEFAULT NULL,
  `TaxIDExpiration1` date DEFAULT NULL,
  `TaxID2` varchar(60) COLLATE latin1_general_ci DEFAULT NULL,
  `TaxIDExpiration2` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci;



# Dump of table ESTIMATE_DETAIL
# ------------------------------------------------------------

DROP TABLE IF EXISTS `ESTIMATE_DETAIL`;

CREATE TABLE `ESTIMATE_DETAIL` (
  `EstimateID` int(11) NOT NULL,
  `Group` varchar(3) NOT NULL DEFAULT '',
  `Line` varchar(3) NOT NULL DEFAULT '',
  `SKU` varchar(20) NOT NULL,
  `Description` text NOT NULL,
  `Notes` text,
  `EstimateQty` int(11) NOT NULL,
  `AvailableQty` int(11) DEFAULT NULL,
  `Interchange` varchar(20) DEFAULT NULL,
  `Price` float(8,2) NOT NULL,
  `Core` float(8,2) DEFAULT NULL,
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`ID`),
  UNIQUE KEY `Index` (`EstimateID`,`Group`,`Line`,`SKU`),
  KEY `EstimateID` (`EstimateID`,`SKU`),
  KEY `Line_SKU` (`Line`,`SKU`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;



# Dump of table ESTIMATE_HEAD
# ------------------------------------------------------------

DROP TABLE IF EXISTS `ESTIMATE_HEAD`;

CREATE TABLE `ESTIMATE_HEAD` (
  `EstimateID` int(11) NOT NULL AUTO_INCREMENT,
  `AccountNumber` varchar(10) CHARACTER SET latin1 COLLATE latin1_general_ci NOT NULL DEFAULT '',
  `EstimateDate` datetime NOT NULL,
  `Salesman` varchar(5) CHARACTER SET latin1 COLLATE latin1_general_ci NOT NULL DEFAULT '',
  `SalesmanEstimate` tinyint(1) DEFAULT '0',
  `WarehouseID` int(4) NOT NULL DEFAULT '100',
  `EstimateNotes` text,
  `PONumber` varchar(32) DEFAULT NULL,
  `DeliveryMethod` varchar(64) DEFAULT NULL,
  `InProcess` tinyint(1) NOT NULL,
  `InProcessDate` datetime NOT NULL,
  `Processed` tinyint(1) NOT NULL,
  `ProcessedDate` datetime NOT NULL,
  `ProcessUser` varchar(20) CHARACTER SET latin1 COLLATE latin1_general_ci NOT NULL,
  `DeleteEstimate` tinyint(1) NOT NULL,
  `DeleteEstimateDate` datetime NOT NULL,
  `HoldDeleteReason` varchar(256) NOT NULL DEFAULT '',
  `OnHoldDeleteUser` varchar(20) NOT NULL,
  `OfflineEstimate` tinyint(1) NOT NULL DEFAULT '0',
  `OfflineID` varchar(30) NOT NULL DEFAULT '',
  `OfflineEstimateDate` datetime DEFAULT NULL,
  `ImageURL` varchar(1024) DEFAULT NULL,
  `IncludeProductImage` tinyint(1) DEFAULT '0',
  `Archive` tinyint(1) NOT NULL DEFAULT '0',
  `ApproveOrder` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`EstimateID`),
  KEY `AccountNumber` (`AccountNumber`),
  KEY `EstimateDate` (`EstimateDate`),
  KEY `Salesman` (`Salesman`),
  KEY `InProcess` (`InProcess`),
  KEY `Processed` (`Processed`),
  KEY `ProcessUser` (`ProcessUser`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;



# Dump of table EstimatedByMonth
# ------------------------------------------------------------

DROP VIEW IF EXISTS `EstimatedByMonth`;

CREATE TABLE `EstimatedByMonth` (
   `Line` VARCHAR(3) NOT NULL DEFAULT '',
   `Group` VARCHAR(3) NOT NULL DEFAULT '',
   `Familia` VARCHAR(32) NOT NULL DEFAULT '',
   `SKU` VARCHAR(20) NOT NULL,
   `Description` TEXT NOT NULL,
   `Estimated` DECIMAL(32) NULL DEFAULT NULL,
   `OnHand` INT(8) NULL DEFAULT '0',
   `January` DECIMAL(32) NULL DEFAULT NULL,
   `February` DECIMAL(32) NULL DEFAULT NULL,
   `March` DECIMAL(32) NULL DEFAULT NULL,
   `April` DECIMAL(32) NULL DEFAULT NULL,
   `May` DECIMAL(32) NULL DEFAULT NULL,
   `June` DECIMAL(32) NULL DEFAULT NULL,
   `July` DECIMAL(32) NULL DEFAULT NULL,
   `August` DECIMAL(32) NULL DEFAULT NULL,
   `September` DECIMAL(32) NULL DEFAULT NULL,
   `October` DECIMAL(32) NULL DEFAULT NULL,
   `November` DECIMAL(32) NULL DEFAULT NULL,
   `December` DECIMAL(32) NULL DEFAULT NULL
) ENGINE=MyISAM;



# Dump of table EVENT_LOG
# ------------------------------------------------------------

DROP TABLE IF EXISTS `EVENT_LOG`;

CREATE TABLE `EVENT_LOG` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `DATE_TIME` datetime NOT NULL,
  `USER` varchar(20) NOT NULL,
  `ACTION` varchar(60) NOT NULL,
  `DATA` text NOT NULL,
  PRIMARY KEY (`ID`),
  KEY `DATE_TIME` (`DATE_TIME`,`USER`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;



# Dump of table GROUP
# ------------------------------------------------------------

DROP TABLE IF EXISTS `GROUP`;

CREATE TABLE `GROUP` (
  `Code` varchar(3) COLLATE latin1_spanish_ci NOT NULL DEFAULT '',
  `Name` varchar(60) COLLATE latin1_spanish_ci DEFAULT NULL,
  `NameEN` varchar(60) CHARACTER SET ascii NOT NULL,
  PRIMARY KEY (`Code`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_spanish_ci;



# Dump of table INTERCHANGE
# ------------------------------------------------------------

DROP TABLE IF EXISTS `INTERCHANGE`;

CREATE TABLE `INTERCHANGE` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `SKU` varchar(64) COLLATE latin1_general_ci DEFAULT NULL,
  `Reference` varchar(64) COLLATE latin1_general_ci DEFAULT NULL,
  `Supplier` varchar(64) COLLATE latin1_general_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `SKU_3` (`SKU`,`Reference`,`Supplier`),
  KEY `Index` (`SKU`),
  KEY `Reference` (`Reference`),
  KEY `Reference_2` (`Reference`),
  KEY `SKU` (`SKU`),
  KEY `SKU_2` (`SKU`,`Reference`),
  KEY `Reference_3` (`Reference`,`SKU`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci;



# Dump of table INTERCHANGE_FINDER
# ------------------------------------------------------------

DROP TABLE IF EXISTS `INTERCHANGE_FINDER`;

CREATE TABLE `INTERCHANGE_FINDER` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `SKU` varchar(32) COLLATE latin1_general_ci DEFAULT NULL,
  `Reference` varchar(32) COLLATE latin1_general_ci DEFAULT NULL,
  `Supplier` varchar(32) COLLATE latin1_general_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `SKU` (`SKU`,`Supplier`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci;



# Dump of table INVENTORY
# ------------------------------------------------------------

DROP TABLE IF EXISTS `INVENTORY`;

CREATE TABLE `INVENTORY` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `Line` varchar(3) NOT NULL,
  `Group` varchar(3) NOT NULL DEFAULT '',
  `SKU` varchar(20) NOT NULL DEFAULT '',
  `Familia` varchar(32) NOT NULL DEFAULT '',
  `Description` text NOT NULL,
  `Notes` text NOT NULL,
  `Qty` int(8) DEFAULT '0',
  `AvgCost` float(8,2) NOT NULL,
  `Cost` float(8,2) NOT NULL COMMENT 'ReplacementCost',
  `PriceA` float(8,2) NOT NULL,
  `PriceB` float(8,2) NOT NULL,
  `PriceC` float(8,2) NOT NULL,
  `PriceD` float(8,2) NOT NULL,
  `PriceE` float(8,2) NOT NULL,
  `Core` float(8,2) NOT NULL,
  `Interchange` varchar(20) NOT NULL DEFAULT '',
  `Dashless` varchar(20) NOT NULL DEFAULT '',
  `DashlessInterchange` varchar(20) NOT NULL DEFAULT '',
  `ProductURL` varchar(2048) DEFAULT NULL,
  `ImageURL` varchar(2048) DEFAULT NULL,
  `Category` varchar(64) DEFAULT NULL,
  `Subcategory` varchar(64) DEFAULT NULL,
  `OnOrder` int(11) DEFAULT '0',
  `Location` varchar(12) DEFAULT NULL,
  `Taxable1` tinyint(1) NOT NULL DEFAULT '1',
  `Taxable2` tinyint(1) NOT NULL DEFAULT '1',
  `LocationB` varchar(12) DEFAULT NULL,
  `LocationC` varchar(12) DEFAULT NULL,
  `LocationD` varchar(12) DEFAULT NULL,
  `LocationE` varchar(12) DEFAULT NULL,
  `Active` tinyint(1) DEFAULT '1',
  `CommissionRate` float(8,2) NOT NULL DEFAULT '0.07',
  `Brand` varchar(64) NOT NULL DEFAULT '',
  `VendorID` int(11) NOT NULL,
  `VendorSKU` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `Line` (`Line`,`SKU`),
  KEY `warehouse` (`Group`,`Line`,`SKU`,`Interchange`),
  KEY `SKU` (`SKU`),
  KEY `Dashless` (`Dashless`),
  KEY `DashlessInterchange` (`DashlessInterchange`),
  KEY `Dashless_2` (`Dashless`,`DashlessInterchange`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;



# Dump of table INVENTORY_copy
# ------------------------------------------------------------

DROP TABLE IF EXISTS `INVENTORY_copy`;

CREATE TABLE `INVENTORY_copy` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `Line` varchar(3) NOT NULL,
  `Group` varchar(3) NOT NULL DEFAULT '',
  `SKU` varchar(20) NOT NULL DEFAULT '',
  `Description` text NOT NULL,
  `Notes` text NOT NULL,
  `Qty` int(8) DEFAULT '0',
  `AvgCost` float(8,2) NOT NULL,
  `Cost` float(8,2) NOT NULL COMMENT 'Price',
  `PriceA` float(8,2) NOT NULL,
  `PriceB` float(8,2) NOT NULL,
  `PriceC` float(8,2) NOT NULL,
  `PriceD` float(8,2) NOT NULL,
  `PriceE` float(8,2) NOT NULL,
  `Core` float(8,2) NOT NULL,
  `Interchange` varchar(20) NOT NULL DEFAULT '',
  `Dashless` varchar(20) NOT NULL DEFAULT '',
  `DashlessInterchange` varchar(20) NOT NULL DEFAULT '',
  `ProductURL` varchar(2048) DEFAULT NULL,
  `ImageURL` varchar(2048) DEFAULT NULL,
  `Category` varchar(64) DEFAULT NULL,
  `Subcategory` varchar(64) DEFAULT NULL,
  `OnOrder` int(11) DEFAULT '0',
  `Location` varchar(12) DEFAULT NULL,
  `Taxable1` tinyint(1) NOT NULL DEFAULT '1',
  `Taxable2` tinyint(1) NOT NULL DEFAULT '1',
  `LocationB` varchar(12) DEFAULT NULL,
  `LocationC` varchar(12) DEFAULT NULL,
  `LocationD` varchar(12) DEFAULT NULL,
  `LocationE` varchar(12) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `Line` (`Line`,`SKU`),
  KEY `warehouse` (`Group`,`Line`,`SKU`,`Interchange`),
  KEY `SKU` (`SKU`),
  KEY `Dashless` (`Dashless`),
  KEY `DashlessInterchange` (`DashlessInterchange`),
  KEY `Dashless_2` (`Dashless`,`DashlessInterchange`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;



# Dump of table INVENTORY_IMPORT
# ------------------------------------------------------------

DROP TABLE IF EXISTS `INVENTORY_IMPORT`;

CREATE TABLE `INVENTORY_IMPORT` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `Category` varchar(32) DEFAULT NULL,
  `Subcategory` varchar(32) DEFAULT NULL,
  `ProductURL` varchar(2048) DEFAULT NULL,
  `SKU` varchar(32) DEFAULT NULL,
  `ImageURL` varchar(2048) DEFAULT NULL,
  `Description` varchar(1024) DEFAULT NULL,
  `Notes` varchar(1024) DEFAULT NULL,
  `AttrName` varchar(32) DEFAULT NULL,
  `AttrValue` varchar(128) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;



# Dump of table INVOICE
# ------------------------------------------------------------

DROP TABLE IF EXISTS `INVOICE`;

CREATE TABLE `INVOICE` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `ST` int(2) DEFAULT NULL,
  `InvoiceDate` date DEFAULT NULL,
  `AccountNumber` varchar(9) CHARACTER SET latin1 DEFAULT NULL,
  `Job` int(11) DEFAULT NULL,
  `InvoiceNumber` varchar(10) CHARACTER SET latin1 DEFAULT NULL,
  `Reference` varchar(60) CHARACTER SET latin1 DEFAULT NULL,
  `Subtotal` float(10,2) DEFAULT NULL,
  `SalesTax` float(10,2) DEFAULT NULL,
  `Terms` varchar(32) CHARACTER SET latin1 DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `InvoiceNumber` (`InvoiceNumber`),
  KEY `AccountNumber` (`AccountNumber`),
  KEY `InvoiceDate` (`InvoiceDate`),
  KEY `InvoiceNumber_2` (`InvoiceNumber`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci;



# Dump of table INVOICE_ADJUST
# ------------------------------------------------------------

DROP TABLE IF EXISTS `INVOICE_ADJUST`;

CREATE TABLE `INVOICE_ADJUST` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `InvoiceNumber` varchar(10) NOT NULL,
  `User` varchar(24) NOT NULL,
  `Reason` text NOT NULL,
  `OverAmount` decimal(10,2) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `InvoiceNumber` (`InvoiceNumber`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;



# Dump of table INVOICE_CRATE
# ------------------------------------------------------------

DROP TABLE IF EXISTS `INVOICE_CRATE`;

CREATE TABLE `INVOICE_CRATE` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `InvoiceID` int(11) DEFAULT NULL,
  `CrateNumber` varchar(4) COLLATE latin1_general_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `InvoiceID` (`InvoiceID`,`CrateNumber`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci;



# Dump of table INVOICE_DETAIL
# ------------------------------------------------------------

DROP TABLE IF EXISTS `INVOICE_DETAIL`;

CREATE TABLE `INVOICE_DETAIL` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `InvoiceID` int(11) NOT NULL,
  `Group` varchar(3) COLLATE latin1_general_ci NOT NULL DEFAULT '',
  `Line` varchar(3) COLLATE latin1_general_ci NOT NULL DEFAULT '',
  `SKU` varchar(20) COLLATE latin1_general_ci NOT NULL DEFAULT '',
  `Description` text COLLATE latin1_general_ci NOT NULL,
  `Notes` text COLLATE latin1_general_ci,
  `OrderQty` int(11) NOT NULL,
  `ShippedQty` int(11) DEFAULT NULL,
  `AvgCost` float(8,2) NOT NULL,
  `Core` float(8,2) DEFAULT NULL,
  `Price` float(8,2) NOT NULL,
  `Taxable1` tinyint(1) NOT NULL,
  `Taxable2` tinyint(1) NOT NULL,
  `Reference` varchar(128) COLLATE latin1_general_ci DEFAULT NULL,
  `ReferenceType` varchar(128) COLLATE latin1_general_ci DEFAULT NULL,
  PRIMARY KEY (`ID`),
  KEY `OrderID` (`InvoiceID`,`SKU`),
  KEY `Line_SKU` (`Line`,`SKU`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci;



# Dump of table INVOICE_HEAD
# ------------------------------------------------------------

DROP TABLE IF EXISTS `INVOICE_HEAD`;

CREATE TABLE `INVOICE_HEAD` (
  `InvoiceID` int(11) NOT NULL AUTO_INCREMENT,
  `OrderID` int(11) NOT NULL,
  `AccountNumber` varchar(10) COLLATE latin1_general_ci NOT NULL DEFAULT '',
  `InvoiceDate` datetime NOT NULL,
  `Salesman` varchar(5) COLLATE latin1_general_ci NOT NULL DEFAULT '',
  `SalesmanOrder` tinyint(1) DEFAULT '0',
  `WarehouseID` int(11) NOT NULL DEFAULT '100',
  `Notes` text CHARACTER SET latin1,
  `PONumber` varchar(32) COLLATE latin1_general_ci DEFAULT NULL,
  `DeliveryMethod` varchar(64) CHARACTER SET latin1 DEFAULT NULL,
  `Status` tinyint(1) NOT NULL DEFAULT '0' COMMENT '0-Open invoice / 1-Finalized',
  `DueDate` date DEFAULT NULL,
  `SentPicking` datetime DEFAULT NULL,
  `Packed` tinyint(1) NOT NULL DEFAULT '0',
  `PackingUser` varchar(30) COLLATE latin1_general_ci DEFAULT NULL,
  `PackageCount` int(11) DEFAULT NULL,
  `CreationDate` datetime DEFAULT NULL,
  `InvoiceUser` varchar(20) COLLATE latin1_general_ci NOT NULL DEFAULT '',
  `OnHold` tinyint(1) NOT NULL DEFAULT '0',
  `OnHoldDate` datetime NOT NULL,
  `Void` tinyint(1) NOT NULL DEFAULT '0',
  `VoidDate` datetime DEFAULT NULL,
  `HoldVoidReason` varchar(256) COLLATE latin1_general_ci NOT NULL DEFAULT '',
  `HoldVoidUser` varchar(20) COLLATE latin1_general_ci NOT NULL DEFAULT '',
  `Terms` varchar(16) COLLATE latin1_general_ci DEFAULT NULL,
  `Subtotal` float(12,2) DEFAULT NULL,
  `Tax1Total` float(8,2) DEFAULT NULL,
  `Tax2Total` float(8,2) DEFAULT NULL,
  `Tax1Rate` float(5,4) DEFAULT NULL,
  `Tax2Rate` float(5,4) DEFAULT NULL,
  `ShipToName` varchar(64) COLLATE latin1_general_ci NOT NULL DEFAULT '',
  `ShipToAddress1` varchar(128) CHARACTER SET latin1 NOT NULL DEFAULT '',
  `ShipToAddress2` varchar(128) CHARACTER SET latin1 NOT NULL DEFAULT '',
  `ShipToCity` varchar(128) CHARACTER SET latin1 NOT NULL DEFAULT '',
  `ShipToState` varchar(2) CHARACTER SET latin1 NOT NULL DEFAULT '',
  `ShipToZip` varchar(32) CHARACTER SET latin1 NOT NULL DEFAULT '',
  `ShipToCountry` varchar(32) CHARACTER SET latin1 NOT NULL DEFAULT '',
  `BillToName` varchar(64) CHARACTER SET latin1 NOT NULL DEFAULT '',
  `BillToAddress1` varchar(128) CHARACTER SET latin1 NOT NULL DEFAULT '',
  `BillToAddress2` varchar(128) CHARACTER SET latin1 NOT NULL DEFAULT '',
  `BillToCity` varchar(32) CHARACTER SET latin1 NOT NULL DEFAULT '',
  `BillToState` varchar(2) CHARACTER SET latin1 DEFAULT NULL,
  `BillToZip` varchar(32) CHARACTER SET latin1 DEFAULT '',
  `BillToCountry` varchar(32) CHARACTER SET latin1 NOT NULL DEFAULT '',
  PRIMARY KEY (`InvoiceID`),
  KEY `AccountNumber` (`AccountNumber`),
  KEY `OrderDate` (`InvoiceDate`),
  KEY `Salesman` (`Salesman`),
  KEY `InProcess` (`Status`),
  KEY `Processed` (`Packed`),
  KEY `ProcessUser` (`InvoiceUser`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci;



# Dump of table ITEMS_SEARS
# ------------------------------------------------------------

DROP TABLE IF EXISTS `ITEMS_SEARS`;

CREATE TABLE `ITEMS_SEARS` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `SKU` varchar(32) COLLATE latin1_general_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci;



# Dump of table KYB_INVOICE
# ------------------------------------------------------------

DROP TABLE IF EXISTS `KYB_INVOICE`;

CREATE TABLE `KYB_INVOICE` (
  `InvoiceDate` date DEFAULT NULL,
  `InvoiceTime` varchar(12) COLLATE latin1_general_ci DEFAULT NULL,
  `AccountNumber` varchar(12) COLLATE latin1_general_ci DEFAULT NULL,
  `CustomerName` varchar(32) COLLATE latin1_general_ci DEFAULT NULL,
  `CustomerAddress1` varchar(64) COLLATE latin1_general_ci DEFAULT NULL,
  `CustomerAddress2` varchar(64) COLLATE latin1_general_ci DEFAULT NULL,
  `CustomerAddress3` varchar(64) COLLATE latin1_general_ci DEFAULT NULL,
  `Phone` varchar(18) COLLATE latin1_general_ci DEFAULT NULL,
  `Terms` varchar(32) COLLATE latin1_general_ci DEFAULT NULL,
  `Job` int(11) DEFAULT NULL,
  `ST` int(11) DEFAULT NULL,
  `InvoiceNumber` varchar(12) COLLATE latin1_general_ci DEFAULT NULL,
  `OrderNumber` varchar(12) COLLATE latin1_general_ci DEFAULT NULL,
  `Reference` varchar(32) COLLATE latin1_general_ci DEFAULT NULL,
  `PO` varchar(12) COLLATE latin1_general_ci DEFAULT NULL,
  `Salesperson` varchar(6) COLLATE latin1_general_ci DEFAULT NULL,
  `SalespersonName` varchar(64) COLLATE latin1_general_ci DEFAULT NULL,
  `Line` varchar(3) COLLATE latin1_general_ci DEFAULT NULL,
  `SKU` varchar(20) COLLATE latin1_general_ci DEFAULT NULL,
  `Description` varchar(128) COLLATE latin1_general_ci DEFAULT NULL,
  `Qty` int(11) DEFAULT NULL,
  `SoldPrice` float(10,2) DEFAULT NULL,
  `ShipToCity` varchar(32) COLLATE latin1_general_ci DEFAULT NULL,
  `ShipToAddress1` varchar(64) COLLATE latin1_general_ci DEFAULT NULL,
  `ShipToAddress2` varchar(64) COLLATE latin1_general_ci DEFAULT NULL,
  `ShipToState` varchar(4) COLLATE latin1_general_ci DEFAULT NULL,
  `ShipToZip` varchar(11) COLLATE latin1_general_ci DEFAULT NULL,
  `Difference` float(10,2) DEFAULT NULL,
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`),
  KEY `PartNumber` (`SKU`),
  KEY `Line` (`Line`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci;



# Dump of table LIMITECREDITO
# ------------------------------------------------------------

DROP TABLE IF EXISTS `LIMITECREDITO`;

CREATE TABLE `LIMITECREDITO` (
  `AccountNumber` varchar(10) NOT NULL,
  `CreditLimit` float NOT NULL,
  UNIQUE KEY `AccountNumber` (`AccountNumber`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;



# Dump of table LINE
# ------------------------------------------------------------

DROP TABLE IF EXISTS `LINE`;

CREATE TABLE `LINE` (
  `Code` varchar(3) NOT NULL DEFAULT '',
  `Name` varchar(75) DEFAULT NULL,
  `NameEN` varchar(75) NOT NULL,
  `ImageURL` varchar(1024) DEFAULT NULL,
  PRIMARY KEY (`Code`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;



# Dump of table LOGIN_LOG
# ------------------------------------------------------------

DROP TABLE IF EXISTS `LOGIN_LOG`;

CREATE TABLE `LOGIN_LOG` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `Type` varchar(12) NOT NULL,
  `Username` varchar(16) NOT NULL,
  `IPAddress` varchar(16) NOT NULL,
  `ForwardIP` varchar(16) NOT NULL,
  `LoginDate` datetime NOT NULL,
  `Result` tinyint(1) NOT NULL,
  PRIMARY KEY (`ID`),
  KEY `Username` (`Username`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;



# Dump of table LOST_SALE
# ------------------------------------------------------------

DROP TABLE IF EXISTS `LOST_SALE`;

CREATE TABLE `LOST_SALE` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `AccountNumber` varchar(10) NOT NULL,
  `SKU` varchar(64) NOT NULL,
  `Description` varchar(256) NOT NULL,
  `Qty` int(11) NOT NULL,
  `Price` decimal(10,2) NOT NULL,
  `CompetitionPrice` decimal(10,2) NOT NULL,
  `CompetitionSource` varchar(32) NOT NULL,
  `Reason` varchar(64) NOT NULL,
  `LostSaleDate` datetime NOT NULL,
  `Comments` varchar(512) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;



# Dump of table MULTIPLE_WAREHOUSE
# ------------------------------------------------------------

DROP TABLE IF EXISTS `MULTIPLE_WAREHOUSE`;

CREATE TABLE `MULTIPLE_WAREHOUSE` (
  `WarehouseID` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `WarehouseName` varchar(32) COLLATE latin1_general_ci DEFAULT NULL,
  `WarehouseType` varchar(2) COLLATE latin1_general_ci DEFAULT NULL,
  PRIMARY KEY (`WarehouseID`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci;



# Dump of table MULTIPLE_WH_INVENTORY
# ------------------------------------------------------------

DROP TABLE IF EXISTS `MULTIPLE_WH_INVENTORY`;

CREATE TABLE `MULTIPLE_WH_INVENTORY` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `WarehouseID` int(11) DEFAULT NULL,
  `Line` varchar(3) COLLATE latin1_general_ci DEFAULT NULL,
  `SKU` varchar(32) COLLATE latin1_general_ci DEFAULT NULL,
  `Qty` int(11) DEFAULT NULL,
  `StockLevel` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci;



# Dump of table NEW_COMMISSION_PAYMENT_DETAIL
# ------------------------------------------------------------

DROP TABLE IF EXISTS `NEW_COMMISSION_PAYMENT_DETAIL`;

CREATE TABLE `NEW_COMMISSION_PAYMENT_DETAIL` (
  `id` int(1) unsigned NOT NULL AUTO_INCREMENT,
  `SaleDate` date DEFAULT NULL,
  `ST` int(11) NOT NULL,
  `Salesman` varchar(3) CHARACTER SET utf8 NOT NULL,
  `Price` double NOT NULL,
  `GrossMargin` double NOT NULL,
  `MarginPercent` double NOT NULL,
  `PartNumber` varchar(32) CHARACTER SET utf8 NOT NULL,
  `Description` text CHARACTER SET utf8 NOT NULL,
  `InvoiceNumber` varchar(8) CHARACTER SET latin1 COLLATE latin1_general_ci DEFAULT NULL,
  `AccountNumber` varchar(12) CHARACTER SET latin1 COLLATE latin1_general_ci DEFAULT NULL,
  `LineCode` varchar(6) CHARACTER SET utf8 NOT NULL,
  `CommissionRate` double(4,3) DEFAULT NULL,
  `CommissionAmount` double(8,2) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `InvoiceNumber` (`InvoiceNumber`,`AccountNumber`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;



# Dump of table NEW_COMMISSION_PAYMENT_HEADER
# ------------------------------------------------------------

DROP TABLE IF EXISTS `NEW_COMMISSION_PAYMENT_HEADER`;

CREATE TABLE `NEW_COMMISSION_PAYMENT_HEADER` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `ST` int(11) DEFAULT NULL,
  `InvoiceNumber` varchar(10) COLLATE latin1_general_ci DEFAULT NULL,
  `AccountNumber` varchar(12) COLLATE latin1_general_ci DEFAULT NULL,
  `CustomerName` varchar(32) COLLATE latin1_general_ci DEFAULT NULL,
  `PaidDate` date DEFAULT NULL,
  `PaymentAmt` double DEFAULT NULL,
  `Discount` double DEFAULT NULL,
  `InvoiceTotal` double DEFAULT NULL,
  `Subtotal` double DEFAULT NULL,
  `SaleDate` date DEFAULT NULL COMMENT 'Month of the Sale',
  `TaxCode` varchar(32) COLLATE latin1_general_ci DEFAULT NULL,
  `IVU` double DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `InvoiceNumber` (`InvoiceNumber`,`AccountNumber`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci;



# Dump of table NEW_COMMISSION_RULES
# ------------------------------------------------------------

DROP TABLE IF EXISTS `NEW_COMMISSION_RULES`;

CREATE TABLE `NEW_COMMISSION_RULES` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `Line` varchar(3) COLLATE latin1_general_ci DEFAULT NULL,
  `Group` varchar(3) COLLATE latin1_general_ci DEFAULT NULL,
  `Rate` double DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `Line` (`Line`,`Group`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci;



# Dump of table NEW_CUSTOMER_REORDER
# ------------------------------------------------------------

DROP TABLE IF EXISTS `NEW_CUSTOMER_REORDER`;

CREATE TABLE `NEW_CUSTOMER_REORDER` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `Line` varchar(3) COLLATE latin1_general_ci DEFAULT NULL,
  `SKU` varchar(32) COLLATE latin1_general_ci DEFAULT NULL,
  `OrderQty` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci;



# Dump of table NEW_ORDER
# ------------------------------------------------------------

DROP TABLE IF EXISTS `NEW_ORDER`;

CREATE TABLE `NEW_ORDER` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `SKU` varchar(32) COLLATE latin1_general_ci DEFAULT NULL,
  `Line` varchar(3) COLLATE latin1_general_ci DEFAULT NULL,
  `Group` varchar(3) COLLATE latin1_general_ci DEFAULT NULL,
  `Description` varchar(128) COLLATE latin1_general_ci DEFAULT NULL,
  `Order` int(11) DEFAULT NULL,
  `UPC_SINGLE` text COLLATE latin1_general_ci,
  `UPC_MULTIPLE` text COLLATE latin1_general_ci,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci;



# Dump of table OFFLINE_SYNC_LOG
# ------------------------------------------------------------

DROP TABLE IF EXISTS `OFFLINE_SYNC_LOG`;

CREATE TABLE `OFFLINE_SYNC_LOG` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `Salesman` varchar(3) COLLATE latin1_general_ci DEFAULT NULL,
  `SyncDate` datetime DEFAULT NULL,
  `OrdersUploaded` int(11) DEFAULT NULL,
  `PaymentsUploaded` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci;



# Dump of table ORDER_DETAIL
# ------------------------------------------------------------

DROP TABLE IF EXISTS `ORDER_DETAIL`;

CREATE TABLE `ORDER_DETAIL` (
  `OrderID` int(11) NOT NULL,
  `Group` varchar(3) NOT NULL DEFAULT '',
  `Line` varchar(3) NOT NULL DEFAULT '',
  `SKU` varchar(20) NOT NULL,
  `Description` text NOT NULL,
  `Notes` text,
  `OrderQty` int(11) NOT NULL,
  `AvailableQty` int(11) DEFAULT NULL,
  `Interchange` varchar(20) DEFAULT NULL,
  `Price` float(8,2) NOT NULL,
  `Core` float(8,2) DEFAULT NULL,
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`ID`),
  UNIQUE KEY `Index` (`OrderID`,`Group`,`Line`,`SKU`),
  KEY `OrderID` (`OrderID`,`SKU`),
  KEY `Line_SKU` (`Line`,`SKU`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;



# Dump of table ORDER_DETAIL_TEST
# ------------------------------------------------------------

DROP TABLE IF EXISTS `ORDER_DETAIL_TEST`;

CREATE TABLE `ORDER_DETAIL_TEST` (
  `OrderID` int(11) NOT NULL,
  `Group` varchar(3) NOT NULL DEFAULT '',
  `Line` varchar(3) NOT NULL DEFAULT '',
  `SKU` varchar(20) NOT NULL,
  `Description` text NOT NULL,
  `Notes` text,
  `OrderQty` int(11) NOT NULL,
  `AvailableQty` int(11) DEFAULT NULL,
  `Interchange` varchar(20) DEFAULT NULL,
  `Cost` float(8,2) NOT NULL,
  `Core` float(8,2) DEFAULT NULL,
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`ID`),
  UNIQUE KEY `Index` (`OrderID`,`Group`,`Line`,`SKU`),
  KEY `OrderID` (`OrderID`,`SKU`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;



# Dump of table ORDER_HEAD
# ------------------------------------------------------------

DROP TABLE IF EXISTS `ORDER_HEAD`;

CREATE TABLE `ORDER_HEAD` (
  `OrderID` int(11) NOT NULL AUTO_INCREMENT,
  `AccountNumber` varchar(10) COLLATE latin1_general_ci NOT NULL DEFAULT '',
  `OrderDate` datetime NOT NULL,
  `Salesman` varchar(5) COLLATE latin1_general_ci NOT NULL DEFAULT '',
  `SalesmanOrder` tinyint(1) DEFAULT '0',
  `WarehouseID` int(4) NOT NULL DEFAULT '100',
  `OrderNotes` text COLLATE latin1_general_ci,
  `PONumber` varchar(32) COLLATE latin1_general_ci DEFAULT NULL,
  `DeliveryMethod` varchar(64) COLLATE latin1_general_ci DEFAULT NULL,
  `InProcess` tinyint(1) NOT NULL,
  `InProcessDate` datetime NOT NULL,
  `Processed` tinyint(1) NOT NULL,
  `ProcessedDate` datetime NOT NULL,
  `ProcessUser` varchar(20) COLLATE latin1_general_ci NOT NULL,
  `OnHold` tinyint(1) NOT NULL,
  `OnHoldDate` datetime NOT NULL,
  `DeleteOrder` tinyint(1) NOT NULL,
  `DeleteOrderDate` datetime NOT NULL,
  `HoldDeleteReason` varchar(256) COLLATE latin1_general_ci NOT NULL,
  `OnHoldDeleteUser` varchar(20) CHARACTER SET latin1 NOT NULL,
  `OfflineOrder` tinyint(1) NOT NULL DEFAULT '0',
  `OfflineID` varchar(30) CHARACTER SET latin1 NOT NULL DEFAULT '',
  `OfflineOrderDate` datetime DEFAULT NULL,
  PRIMARY KEY (`OrderID`),
  KEY `AccountNumber` (`AccountNumber`),
  KEY `OrderDate` (`OrderDate`),
  KEY `Salesman` (`Salesman`),
  KEY `InProcess` (`InProcess`),
  KEY `Processed` (`Processed`),
  KEY `ProcessUser` (`ProcessUser`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci;



# Dump of table PAID_INVOICE
# ------------------------------------------------------------

DROP TABLE IF EXISTS `PAID_INVOICE`;

CREATE TABLE `PAID_INVOICE` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `Salesman` varchar(3) NOT NULL,
  `ST` int(1) NOT NULL,
  `AccountNumber` varchar(10) NOT NULL,
  `CustomerName` varchar(60) NOT NULL,
  `InvoiceNumber` varchar(8) NOT NULL,
  `PaidDate` date NOT NULL,
  `PaymentAmt` decimal(12,2) NOT NULL,
  `Discount` decimal(8,2) NOT NULL,
  `Tax` decimal(8,2) NOT NULL COMMENT 'Column Named Reference',
  `Job` int(2) NOT NULL,
  `Reference` varchar(32) DEFAULT NULL,
  PRIMARY KEY (`ID`),
  UNIQUE KEY `ST` (`ST`,`InvoiceNumber`,`PaidDate`,`PaymentAmt`,`Reference`),
  KEY `Salesman` (`Salesman`,`AccountNumber`,`InvoiceNumber`),
  KEY `Job` (`Job`),
  KEY `InvoiceNumber` (`InvoiceNumber`),
  KEY `Reference` (`Reference`),
  KEY `InvoiceNumber_2` (`InvoiceNumber`,`AccountNumber`),
  KEY `PaidDate` (`PaidDate`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;



# Dump of table PAYMENT_CHECK
# ------------------------------------------------------------

DROP TABLE IF EXISTS `PAYMENT_CHECK`;

CREATE TABLE `PAYMENT_CHECK` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `PaymentID` int(11) NOT NULL,
  `CheckNumber` varchar(16) NOT NULL,
  `Amount` float NOT NULL,
  PRIMARY KEY (`ID`),
  KEY `Index` (`PaymentID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;



# Dump of table PAYMENT_CREDIT
# ------------------------------------------------------------

DROP TABLE IF EXISTS `PAYMENT_CREDIT`;

CREATE TABLE `PAYMENT_CREDIT` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `PaymentID` int(11) NOT NULL,
  `CreditDate` date NOT NULL,
  `CreditNumber` varchar(9) NOT NULL,
  `Reference` varchar(30) DEFAULT NULL,
  `Subtotal` float NOT NULL DEFAULT '0',
  `Tax` float NOT NULL DEFAULT '0',
  `Discount` float NOT NULL DEFAULT '0',
  `Total` float DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `Index` (`PaymentID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;



# Dump of table PAYMENT_DEPOSIT_DETAIL
# ------------------------------------------------------------

DROP TABLE IF EXISTS `PAYMENT_DEPOSIT_DETAIL`;

CREATE TABLE `PAYMENT_DEPOSIT_DETAIL` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `DepositID` int(11) DEFAULT NULL,
  `PaymentID` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci;



# Dump of table PAYMENT_DEPOSIT_HEAD
# ------------------------------------------------------------

DROP TABLE IF EXISTS `PAYMENT_DEPOSIT_HEAD`;

CREATE TABLE `PAYMENT_DEPOSIT_HEAD` (
  `DepositID` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `DepositDate` date DEFAULT NULL,
  `Username` varchar(32) COLLATE latin1_general_ci DEFAULT NULL,
  `CreationDate` datetime DEFAULT NULL,
  `TotalChecks` double(12,2) DEFAULT NULL,
  `TotalCash` double(12,2) DEFAULT NULL,
  `TotalTransfer` double(12,2) DEFAULT NULL,
  `TotalDeposit` double(12,2) DEFAULT NULL,
  `Notes` text COLLATE latin1_general_ci,
  `Depositor` varchar(32) COLLATE latin1_general_ci DEFAULT NULL,
  PRIMARY KEY (`DepositID`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci;



# Dump of table PAYMENT_DETAIL
# ------------------------------------------------------------

DROP TABLE IF EXISTS `PAYMENT_DETAIL`;

CREATE TABLE `PAYMENT_DETAIL` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `PaymentID` int(11) NOT NULL,
  `InvoiceID` varchar(10) NOT NULL DEFAULT '',
  `InvoiceDate` date NOT NULL,
  `Reference` varchar(20) NOT NULL,
  `PartialPayment` tinyint(1) NOT NULL DEFAULT '0',
  `SubtotalAmount` float NOT NULL,
  `DiscountAmount` float NOT NULL,
  `TaxAmount` float(8,2) NOT NULL,
  `PaymentAmount` float NOT NULL,
  PRIMARY KEY (`ID`),
  KEY `PaymentID` (`PaymentID`),
  KEY `InvoiceNumber` (`InvoiceID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;



# Dump of table PAYMENT_HEAD
# ------------------------------------------------------------

DROP TABLE IF EXISTS `PAYMENT_HEAD`;

CREATE TABLE `PAYMENT_HEAD` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `PaymentDate` datetime NOT NULL,
  `AccountNumber` varchar(10) NOT NULL,
  `SalesmanID` varchar(3) NOT NULL,
  `CPD` tinyint(1) NOT NULL DEFAULT '0',
  `CPDDate` date DEFAULT NULL,
  `CPDReceipt` tinyint(1) NOT NULL DEFAULT '0',
  `CPDReceiptDate` datetime DEFAULT NULL,
  `CashAmount` float NOT NULL,
  `CheckAmount` float NOT NULL,
  `TransferAmount` float DEFAULT '0',
  `ProcessDate` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `Processed` tinyint(1) NOT NULL DEFAULT '0',
  `ProcessUser` varchar(24) DEFAULT NULL,
  `Loaded` tinyint(1) NOT NULL DEFAULT '0',
  `Notes` varchar(1000) NOT NULL DEFAULT '',
  `Void` tinyint(1) NOT NULL DEFAULT '0',
  `OfflinePayment` tinyint(1) NOT NULL DEFAULT '0',
  `OfflineID` varchar(30) NOT NULL DEFAULT '',
  `OfflineDate` datetime NOT NULL,
  `Deposited` tinyint(1) DEFAULT '0',
  `CollectingUser` varchar(3) DEFAULT NULL,
  PRIMARY KEY (`ID`),
  KEY `AccountNumber` (`AccountNumber`,`SalesmanID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;



# Dump of table PAYMENT_REMINDER
# ------------------------------------------------------------

DROP TABLE IF EXISTS `PAYMENT_REMINDER`;

CREATE TABLE `PAYMENT_REMINDER` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `PaymentID` int(11) NOT NULL,
  `Reason` varchar(128) NOT NULL,
  `Notes` varchar(256) NOT NULL,
  `NextVisitDate` date NOT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;



# Dump of table PAYMENT_SALESMAN_RECONCILE_DETAIL
# ------------------------------------------------------------

DROP TABLE IF EXISTS `PAYMENT_SALESMAN_RECONCILE_DETAIL`;

CREATE TABLE `PAYMENT_SALESMAN_RECONCILE_DETAIL` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `ReconcileID` int(11) DEFAULT NULL,
  `PaymentID` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci;



# Dump of table PAYMENT_SALESMAN_RECONCILE_HEAD
# ------------------------------------------------------------

DROP TABLE IF EXISTS `PAYMENT_SALESMAN_RECONCILE_HEAD`;

CREATE TABLE `PAYMENT_SALESMAN_RECONCILE_HEAD` (
  `ReconcileID` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `SalesmanID` varchar(3) COLLATE latin1_general_ci DEFAULT NULL,
  `ReconcileDate` datetime DEFAULT NULL,
  `ReconcileUser` varchar(32) COLLATE latin1_general_ci DEFAULT NULL,
  `Notes` text COLLATE latin1_general_ci,
  PRIMARY KEY (`ReconcileID`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci;



# Dump of table PAYMENT_TAX_DETAIL
# ------------------------------------------------------------

DROP TABLE IF EXISTS `PAYMENT_TAX_DETAIL`;

CREATE TABLE `PAYMENT_TAX_DETAIL` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `ST` int(11) DEFAULT NULL,
  `InvoiceNumber` varchar(10) COLLATE latin1_general_ci DEFAULT NULL,
  `AccountNumber` varchar(12) COLLATE latin1_general_ci DEFAULT NULL,
  `CustomerName` varchar(32) COLLATE latin1_general_ci DEFAULT NULL,
  `PaidDate` date DEFAULT NULL,
  `PaymentAmt` double DEFAULT NULL,
  `Discount` double DEFAULT NULL,
  `InvoiceTotal` double DEFAULT NULL,
  `Subtotal` double DEFAULT NULL,
  `SaleDate` date DEFAULT NULL COMMENT 'Month of the Sale',
  `TaxCode` varchar(32) COLLATE latin1_general_ci DEFAULT NULL,
  `IVU` double DEFAULT NULL,
  `IVU_E` double DEFAULT NULL,
  `IVU_M` double DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci;



# Dump of table PAYMENT_TAX_DETAIL_EXCEPTIONS
# ------------------------------------------------------------

DROP TABLE IF EXISTS `PAYMENT_TAX_DETAIL_EXCEPTIONS`;

CREATE TABLE `PAYMENT_TAX_DETAIL_EXCEPTIONS` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `ST` int(11) DEFAULT NULL,
  `InvoiceNumber` varchar(10) COLLATE latin1_general_ci DEFAULT NULL,
  `AccountNumber` varchar(12) COLLATE latin1_general_ci DEFAULT NULL,
  `CustomerName` varchar(32) COLLATE latin1_general_ci DEFAULT NULL,
  `PaidDate` date DEFAULT NULL,
  `PaymentAmt` double DEFAULT NULL,
  `Discount` double DEFAULT NULL,
  `InvoiceTotal` double DEFAULT NULL,
  `Subtotal` double DEFAULT NULL,
  `SaleDate` date DEFAULT NULL COMMENT 'Month of the Sale',
  `TaxCode` varchar(32) COLLATE latin1_general_ci DEFAULT NULL,
  `IVU` double DEFAULT NULL,
  `IVU_E` double DEFAULT NULL,
  `IVU_M` double DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci;



# Dump of table PAYMENT_VOID
# ------------------------------------------------------------

DROP TABLE IF EXISTS `PAYMENT_VOID`;

CREATE TABLE `PAYMENT_VOID` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `PaymentID` int(11) NOT NULL,
  `Reason` text NOT NULL,
  `User` varchar(30) NOT NULL,
  `VoidDate` datetime NOT NULL,
  PRIMARY KEY (`ID`),
  KEY `PaymentID` (`PaymentID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;



# Dump of table PCDB
# ------------------------------------------------------------

DROP TABLE IF EXISTS `PCDB`;

CREATE TABLE `PCDB` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `PartTypeID` int(11) DEFAULT NULL,
  `PartType` varchar(64) COLLATE latin1_general_ci DEFAULT NULL,
  `CategoryName` varchar(64) COLLATE latin1_general_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci;



# Dump of table PHONES
# ------------------------------------------------------------

DROP TABLE IF EXISTS `PHONES`;

CREATE TABLE `PHONES` (
  `AccountNumber` varchar(8) NOT NULL,
  `Phone` varchar(15) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;



# Dump of table PICKING_INCENTIVE
# ------------------------------------------------------------

DROP TABLE IF EXISTS `PICKING_INCENTIVE`;

CREATE TABLE `PICKING_INCENTIVE` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `ST` int(11) NOT NULL,
  `TransactionDate` date NOT NULL,
  `PO` varchar(10) NOT NULL,
  `InvoiceNumber` varchar(10) NOT NULL,
  `LineNum` int(11) NOT NULL,
  `Description` varchar(255) NOT NULL,
  `NetSale` float NOT NULL,
  `Units` int(11) NOT NULL,
  PRIMARY KEY (`ID`),
  UNIQUE KEY `Unique` (`InvoiceNumber`,`LineNum`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;



# Dump of table PICKING_INCENTIVE_NAME
# ------------------------------------------------------------

DROP TABLE IF EXISTS `PICKING_INCENTIVE_NAME`;

CREATE TABLE `PICKING_INCENTIVE_NAME` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `Code` varchar(1) NOT NULL,
  `Name` varchar(64) NOT NULL,
  PRIMARY KEY (`ID`),
  UNIQUE KEY `Code` (`Code`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;



# Dump of table PICKUP_CART
# ------------------------------------------------------------

DROP TABLE IF EXISTS `PICKUP_CART`;

CREATE TABLE `PICKUP_CART` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `SalesmanID` varchar(9) COLLATE latin1_bin DEFAULT NULL,
  `Line` varchar(3) COLLATE latin1_bin DEFAULT NULL,
  `SKU` varchar(20) COLLATE latin1_bin DEFAULT NULL,
  `Qty` int(11) DEFAULT NULL,
  `OrderID` varchar(11) COLLATE latin1_bin DEFAULT NULL,
  `InvoiceNumber` varchar(256) COLLATE latin1_bin DEFAULT NULL,
  `Reason` varchar(3) COLLATE latin1_bin NOT NULL DEFAULT '',
  `WarrantyReason` varchar(3) COLLATE latin1_bin DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `INDEX` (`Line`,`SKU`,`SalesmanID`,`InvoiceNumber`,`Reason`),
  KEY `Account` (`SalesmanID`),
  KEY `OrderID` (`OrderID`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_bin;



# Dump of table PICKUP_DETAIL
# ------------------------------------------------------------

DROP TABLE IF EXISTS `PICKUP_DETAIL`;

CREATE TABLE `PICKUP_DETAIL` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `PickupID` int(11) NOT NULL,
  `Line` varchar(3) NOT NULL DEFAULT '',
  `SKU` varchar(20) NOT NULL DEFAULT '',
  `Qty` int(11) NOT NULL,
  `OrderID` varchar(11) NOT NULL,
  `InvoiceNumber` varchar(256) DEFAULT NULL,
  `Reason` varchar(3) NOT NULL DEFAULT '',
  `WarrantyReason` varchar(3) DEFAULT NULL,
  `Approved` tinyint(1) DEFAULT NULL,
  `StatusUser` varchar(32) DEFAULT NULL,
  `StatusDate` datetime DEFAULT NULL,
  `StatusReason` varchar(256) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;



# Dump of table PICKUP_HEAD
# ------------------------------------------------------------

DROP TABLE IF EXISTS `PICKUP_HEAD`;

CREATE TABLE `PICKUP_HEAD` (
  `PickupID` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `AccountNumber` varchar(10) NOT NULL DEFAULT '',
  `PickupDate` datetime DEFAULT NULL,
  `Salesman` varchar(3) DEFAULT NULL,
  `PickupNotes` text,
  `PickupTicket` int(11) DEFAULT NULL,
  `Packages` int(3) DEFAULT NULL,
  `RequestedBy` varchar(30) DEFAULT '',
  `Via` varchar(32) NOT NULL,
  `ToPickup` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `ToPickupUser` varchar(30) DEFAULT '',
  `AtWarehouse` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `AtWarehouseUser` varchar(30) DEFAULT '',
  `AtWarehouseNotes` varchar(1000) DEFAULT '',
  `PickupStatus` varchar(20) DEFAULT '',
  `PickupStatusUser` varchar(30) DEFAULT '',
  `PickupStatusNotes` varchar(1000) DEFAULT '',
  `Void` tinyint(1) NOT NULL DEFAULT '0',
  `Loaded` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`PickupID`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;



# Dump of table PICKUP_REASON
# ------------------------------------------------------------

DROP TABLE IF EXISTS `PICKUP_REASON`;

CREATE TABLE `PICKUP_REASON` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `Key` varchar(3) DEFAULT NULL,
  `Value` varchar(30) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;



# Dump of table PICKUP_RECEIVE_BATCH
# ------------------------------------------------------------

DROP TABLE IF EXISTS `PICKUP_RECEIVE_BATCH`;

CREATE TABLE `PICKUP_RECEIVE_BATCH` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `User` varchar(28) COLLATE latin1_general_ci DEFAULT NULL,
  `BatchCloseTime` datetime DEFAULT NULL,
  `BatchCompleted` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci;



# Dump of table PICKUP_RECEIVE_PACKAGE
# ------------------------------------------------------------

DROP TABLE IF EXISTS `PICKUP_RECEIVE_PACKAGE`;

CREATE TABLE `PICKUP_RECEIVE_PACKAGE` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `PickupID` int(11) DEFAULT NULL,
  `PackageNumber` int(11) DEFAULT NULL,
  `ReceiveDate` datetime DEFAULT NULL,
  `User` varchar(32) COLLATE latin1_general_ci DEFAULT NULL,
  `BatchID` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `PickupID` (`PickupID`,`PackageNumber`),
  KEY `PickupID_2` (`PickupID`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci;



# Dump of table PICKUP_VERIFICATION_STATUS
# ------------------------------------------------------------

DROP TABLE IF EXISTS `PICKUP_VERIFICATION_STATUS`;

CREATE TABLE `PICKUP_VERIFICATION_STATUS` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `PickupDetailID` int(11) DEFAULT NULL,
  `PickupID` int(11) DEFAULT NULL,
  `StatusReason` varchar(256) COLLATE latin1_general_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci;



# Dump of table PICKUP_VOID
# ------------------------------------------------------------

DROP TABLE IF EXISTS `PICKUP_VOID`;

CREATE TABLE `PICKUP_VOID` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `PickupID` int(11) NOT NULL,
  `Reason` text NOT NULL,
  `User` varchar(30) NOT NULL,
  `VoidDate` datetime NOT NULL,
  PRIMARY KEY (`ID`),
  KEY `PickupID` (`PickupID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;



# Dump of table PICKUP_WARRANTY_REASON
# ------------------------------------------------------------

DROP TABLE IF EXISTS `PICKUP_WARRANTY_REASON`;

CREATE TABLE `PICKUP_WARRANTY_REASON` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `Key` varchar(3) COLLATE latin1_general_ci DEFAULT NULL,
  `Value` varchar(256) COLLATE latin1_general_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci;



# Dump of table PRICE_PLAN_CALC
# ------------------------------------------------------------

DROP TABLE IF EXISTS `PRICE_PLAN_CALC`;

CREATE TABLE `PRICE_PLAN_CALC` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `AccountNumber` varchar(9) NOT NULL,
  `Percent` float NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `AccountNumber` (`AccountNumber`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;



# Dump of table PRICE_PLAN_LIST_CUSTOMER
# ------------------------------------------------------------

DROP TABLE IF EXISTS `PRICE_PLAN_LIST_CUSTOMER`;

CREATE TABLE `PRICE_PLAN_LIST_CUSTOMER` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `PriceListID` int(11) DEFAULT NULL,
  `AccountNumber` varchar(12) COLLATE latin1_general_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci;



# Dump of table PRICE_PLAN_LIST_DEF
# ------------------------------------------------------------

DROP TABLE IF EXISTS `PRICE_PLAN_LIST_DEF`;

CREATE TABLE `PRICE_PLAN_LIST_DEF` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `Name` varchar(64) COLLATE latin1_general_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `Name` (`Name`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci;



# Dump of table PRICE_PLAN_LIST_DETAIL
# ------------------------------------------------------------

DROP TABLE IF EXISTS `PRICE_PLAN_LIST_DETAIL`;

CREATE TABLE `PRICE_PLAN_LIST_DETAIL` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `PriceListID` int(11) DEFAULT NULL,
  `Line` varchar(3) COLLATE latin1_general_ci DEFAULT NULL,
  `SKU` varchar(32) COLLATE latin1_general_ci DEFAULT NULL,
  `Price` float(10,2) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `PriceListID` (`PriceListID`,`Line`,`SKU`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci;



# Dump of table PRODUCT_ATTRIBUTE
# ------------------------------------------------------------

DROP TABLE IF EXISTS `PRODUCT_ATTRIBUTE`;

CREATE TABLE `PRODUCT_ATTRIBUTE` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `Line` varchar(3) COLLATE latin1_general_ci DEFAULT NULL,
  `SKU` varchar(32) COLLATE latin1_general_ci DEFAULT NULL,
  `Name` varchar(32) CHARACTER SET utf8 DEFAULT NULL,
  `Value` varchar(128) COLLATE latin1_general_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `Line_2` (`Line`,`SKU`,`Name`),
  KEY `Line` (`Line`,`SKU`),
  KEY `SKU` (`SKU`),
  KEY `SKU_2` (`SKU`,`Name`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci;



# Dump of table PRODUCT_UPC
# ------------------------------------------------------------

DROP TABLE IF EXISTS `PRODUCT_UPC`;

CREATE TABLE `PRODUCT_UPC` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `UPC` varchar(20) COLLATE latin1_general_ci DEFAULT NULL,
  `Qty` int(11) DEFAULT NULL,
  `Line` varchar(3) COLLATE latin1_general_ci DEFAULT NULL,
  `SKU` varchar(32) COLLATE latin1_general_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `UPC` (`UPC`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci;



# Dump of table PROGRAM_PICTURE
# ------------------------------------------------------------

DROP TABLE IF EXISTS `PROGRAM_PICTURE`;

CREATE TABLE `PROGRAM_PICTURE` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `ProgramName` varchar(30) COLLATE latin1_general_ci DEFAULT NULL,
  `PictureURL` varchar(1024) COLLATE latin1_general_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci;



# Dump of table PURCHASE_ORDER_DETAIL
# ------------------------------------------------------------

DROP TABLE IF EXISTS `PURCHASE_ORDER_DETAIL`;

CREATE TABLE `PURCHASE_ORDER_DETAIL` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `PurchaseOrderID` int(11) DEFAULT NULL,
  `Line` varchar(3) COLLATE latin1_general_ci DEFAULT NULL,
  `SKU` varchar(32) COLLATE latin1_general_ci DEFAULT NULL,
  `Description` varchar(256) COLLATE latin1_general_ci DEFAULT NULL,
  `OrderQty` int(8) DEFAULT NULL,
  `ConfirmedQty` int(8) NOT NULL DEFAULT '0',
  `ReceivedQty` int(8) NOT NULL DEFAULT '0',
  `Cost` double(10,2) DEFAULT NULL,
  `Reference` varchar(1024) COLLATE latin1_general_ci DEFAULT NULL,
  `PackagesReceived` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci;



# Dump of table PURCHASE_ORDER_HEADER
# ------------------------------------------------------------

DROP TABLE IF EXISTS `PURCHASE_ORDER_HEADER`;

CREATE TABLE `PURCHASE_ORDER_HEADER` (
  `PurchaseOrderID` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `PODate` datetime DEFAULT NULL,
  `Username` varchar(32) COLLATE latin1_general_ci DEFAULT NULL,
  `VendorID` varchar(4) COLLATE latin1_general_ci DEFAULT NULL,
  `Notes` text COLLATE latin1_general_ci,
  `InvoiceNumber` varchar(30) COLLATE latin1_general_ci DEFAULT NULL,
  `Sent` tinyint(1) DEFAULT NULL,
  `SentDate` datetime DEFAULT NULL,
  `ExpectedDate` datetime DEFAULT NULL,
  `Freight` double(10,2) DEFAULT NULL,
  `Received` tinyint(1) NOT NULL DEFAULT '0',
  `Confirmed` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Already qtys from Invoice revised and adjusted. Ready to receive.',
  `ConfirmedDate` datetime DEFAULT NULL,
  `ConfirmedUser` varchar(32) COLLATE latin1_general_ci DEFAULT NULL,
  `ShipToName` varchar(32) COLLATE latin1_general_ci DEFAULT NULL,
  `ShipToAddress1` varchar(256) COLLATE latin1_general_ci DEFAULT NULL,
  `ShipToAddress2` varchar(256) COLLATE latin1_general_ci DEFAULT NULL,
  `ShipToCity` varchar(32) COLLATE latin1_general_ci DEFAULT NULL,
  `ShipToState` varchar(12) COLLATE latin1_general_ci DEFAULT NULL,
  `ShipToZip` varchar(16) COLLATE latin1_general_ci DEFAULT NULL,
  `ShipToCountry` varchar(32) COLLATE latin1_general_ci DEFAULT NULL,
  `ShippingTerms` varchar(64) COLLATE latin1_general_ci DEFAULT NULL,
  `PaymentTerms` varchar(20) COLLATE latin1_general_ci DEFAULT NULL,
  `Completed` tinyint(1) NOT NULL DEFAULT '0',
  `InvoiceDate` date DEFAULT NULL,
  `MiscCharges` double(10,2) DEFAULT NULL,
  `Packages` int(6) DEFAULT NULL,
  `PackagesReceived` int(6) DEFAULT NULL,
  `Void` tinyint(1) NOT NULL DEFAULT '0',
  `VoidReason` varchar(256) COLLATE latin1_general_ci DEFAULT NULL,
  PRIMARY KEY (`PurchaseOrderID`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci;



# Dump of table PURCHASE_ORDER_RECEIVE
# ------------------------------------------------------------

DROP TABLE IF EXISTS `PURCHASE_ORDER_RECEIVE`;

CREATE TABLE `PURCHASE_ORDER_RECEIVE` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `PurchaseOrderID` int(11) DEFAULT NULL,
  `Line` varchar(4) COLLATE latin1_general_ci DEFAULT NULL,
  `SKU` varchar(32) COLLATE latin1_general_ci DEFAULT NULL,
  `QtyScanned` int(8) DEFAULT NULL,
  `UPCScanned` varchar(20) COLLATE latin1_general_ci DEFAULT NULL,
  `Username` varchar(30) COLLATE latin1_general_ci DEFAULT NULL,
  `ScanDate` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci;



# Dump of table QUANTITY_BREAK
# ------------------------------------------------------------

DROP TABLE IF EXISTS `QUANTITY_BREAK`;

CREATE TABLE `QUANTITY_BREAK` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `Line` varchar(3) COLLATE latin1_general_ci DEFAULT NULL,
  `SKU` varchar(20) COLLATE latin1_general_ci DEFAULT NULL,
  `QtyBreak` int(11) DEFAULT NULL,
  `QtyToAdd` int(11) DEFAULT NULL,
  `DiscountRate` float(12,4) DEFAULT NULL,
  `Active` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci;



# Dump of table QUOTE_DETAIL
# ------------------------------------------------------------

DROP TABLE IF EXISTS `QUOTE_DETAIL`;

CREATE TABLE `QUOTE_DETAIL` (
  `QuoteID` int(11) NOT NULL,
  `Group` varchar(3) NOT NULL DEFAULT '',
  `Line` varchar(3) NOT NULL DEFAULT '',
  `SKU` varchar(20) NOT NULL,
  `Description` text NOT NULL,
  `Notes` text,
  `QuoteQty` int(11) NOT NULL,
  `AvailableQty` int(11) DEFAULT NULL,
  `Interchange` varchar(20) DEFAULT NULL,
  `Price` float(8,2) NOT NULL,
  `Core` float(8,2) DEFAULT NULL,
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`ID`),
  UNIQUE KEY `Index` (`QuoteID`,`Group`,`Line`,`SKU`),
  KEY `QuoteID` (`QuoteID`,`SKU`),
  KEY `Line_SKU` (`Line`,`SKU`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;



# Dump of table QUOTE_HEAD
# ------------------------------------------------------------

DROP TABLE IF EXISTS `QUOTE_HEAD`;

CREATE TABLE `QUOTE_HEAD` (
  `QuoteID` int(11) NOT NULL AUTO_INCREMENT,
  `AccountNumber` varchar(10) NOT NULL DEFAULT '',
  `QuoteDate` datetime NOT NULL,
  `Salesman` varchar(5) NOT NULL,
  `SalesmanQuote` tinyint(1) DEFAULT '0',
  `QuoteNotes` text,
  `PONumber` varchar(12) DEFAULT NULL,
  `DeliveryMethod` varchar(64) DEFAULT NULL,
  `InProcess` tinyint(1) NOT NULL,
  `InProcessDate` datetime NOT NULL,
  `Processed` tinyint(1) NOT NULL,
  `ProcessedDate` datetime NOT NULL,
  `ProcessUser` varchar(20) CHARACTER SET latin1 COLLATE latin1_general_ci NOT NULL,
  `OnHold` tinyint(1) NOT NULL,
  `OnHoldDate` datetime NOT NULL,
  `DeleteQuote` tinyint(1) NOT NULL,
  `DeleteQuoteDate` datetime NOT NULL,
  `HoldDeleteReason` varchar(256) CHARACTER SET latin1 COLLATE latin1_general_ci NOT NULL,
  `OnHoldDeleteUser` varchar(20) NOT NULL,
  `OfflineQuote` tinyint(1) NOT NULL DEFAULT '0',
  `OfflineID` varchar(30) NOT NULL DEFAULT '',
  `OfflineQuoteDate` datetime DEFAULT NULL,
  PRIMARY KEY (`QuoteID`),
  KEY `AccountNumber` (`AccountNumber`),
  KEY `QuoteDate` (`QuoteDate`),
  KEY `Salesman` (`Salesman`),
  KEY `InProcess` (`InProcess`),
  KEY `Processed` (`Processed`),
  KEY `ProcessUser` (`ProcessUser`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;



# Dump of table REORDER_SORT
# ------------------------------------------------------------

DROP TABLE IF EXISTS `REORDER_SORT`;

CREATE TABLE `REORDER_SORT` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `Familia` varchar(32) COLLATE latin1_general_ci DEFAULT NULL,
  `SortOrder` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci;



# Dump of table RevenueAndProfitByInvoice
# ------------------------------------------------------------

DROP VIEW IF EXISTS `RevenueAndProfitByInvoice`;

CREATE TABLE `RevenueAndProfitByInvoice` (
   `PaymentID` INT(11) NOT NULL,
   `InvoiceID` INT(11) NOT NULL DEFAULT '0',
   `DiscountAmount` FLOAT NOT NULL,
   `Month` INT(2) NULL DEFAULT NULL,
   `Year` INT(4) NULL DEFAULT NULL,
   `TotalCost` DOUBLE(19) NULL DEFAULT NULL,
   `TotalPrice` DOUBLE(19) NULL DEFAULT NULL,
   `PaymentAmount` FLOAT NOT NULL,
   `TotalProfit` DOUBLE(19) NULL DEFAULT NULL
) ENGINE=MyISAM;



# Dump of table RevenueAndProfitByMonth
# ------------------------------------------------------------

DROP VIEW IF EXISTS `RevenueAndProfitByMonth`;

CREATE TABLE `RevenueAndProfitByMonth` (
   `Month` INT(2) NULL DEFAULT NULL,
   `Year` INT(4) NULL DEFAULT NULL,
   `TotalCost` DOUBLE(19) NULL DEFAULT NULL,
   `TotalPrice` DOUBLE(19) NULL DEFAULT NULL,
   `TotalDiscount` DOUBLE(19) NULL DEFAULT NULL,
   `TotalProfit` DOUBLE(19) NULL DEFAULT NULL
) ENGINE=MyISAM;



# Dump of table SALES_HISTORY
# ------------------------------------------------------------

DROP TABLE IF EXISTS `SALES_HISTORY`;

CREATE TABLE `SALES_HISTORY` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `ST` int(11) DEFAULT NULL,
  `AccountNumber` varchar(12) COLLATE latin1_general_ci DEFAULT NULL,
  `Job` int(11) DEFAULT NULL,
  `InvoiceNumber` varchar(8) COLLATE latin1_general_ci DEFAULT NULL,
  `Reference` varchar(128) COLLATE latin1_general_ci DEFAULT '',
  `Subtotal` decimal(10,2) DEFAULT NULL,
  `IVU` decimal(10,2) DEFAULT NULL,
  `Month` varchar(8) COLLATE latin1_general_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `InvoiceNumber_2` (`InvoiceNumber`),
  KEY `InvoiceNumber` (`InvoiceNumber`),
  KEY `AccountNumber` (`AccountNumber`),
  KEY `InvoiceNumber_3` (`InvoiceNumber`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci;



# Dump of table SALES_HISTORY_DETAIL
# ------------------------------------------------------------

DROP TABLE IF EXISTS `SALES_HISTORY_DETAIL`;

CREATE TABLE `SALES_HISTORY_DETAIL` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `ST` int(11) NOT NULL,
  `Salesman` varchar(3) NOT NULL,
  `Price` double NOT NULL,
  `GrossMargin` double NOT NULL,
  `MarginPercent` double NOT NULL,
  `PartNumber` varchar(32) NOT NULL,
  `Description` text NOT NULL,
  `InvoiceNumber` varchar(8) NOT NULL,
  `AccountNumber` varchar(14) NOT NULL,
  `LineCode` varchar(6) NOT NULL,
  PRIMARY KEY (`ID`),
  UNIQUE KEY `Main` (`ST`,`Salesman`,`PartNumber`,`InvoiceNumber`,`Price`),
  KEY `Branch` (`ST`,`Salesman`),
  KEY `PriceIndex` (`Price`),
  KEY `AccountNumber` (`AccountNumber`),
  KEY `ST` (`ST`,`InvoiceNumber`),
  KEY `InvoiceNumber` (`InvoiceNumber`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;



# Dump of table SALES_HISTORY_HEADER
# ------------------------------------------------------------

DROP TABLE IF EXISTS `SALES_HISTORY_HEADER`;

CREATE TABLE `SALES_HISTORY_HEADER` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `ST` int(11) DEFAULT NULL,
  `AccountNumber` varchar(12) COLLATE latin1_general_ci DEFAULT NULL,
  `Job` int(11) DEFAULT NULL,
  `InvoiceNumber` varchar(8) COLLATE latin1_general_ci DEFAULT NULL,
  `Reference` varchar(128) COLLATE latin1_general_ci DEFAULT '',
  `Subtotal` decimal(10,2) DEFAULT NULL,
  `IVU` decimal(10,2) DEFAULT NULL,
  `SaleDate` date DEFAULT NULL,
  `TaxCode` varchar(32) COLLATE latin1_general_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ST` (`ST`,`InvoiceNumber`,`Subtotal`,`IVU`),
  KEY `InvoiceNumber` (`InvoiceNumber`),
  KEY `AccountNumber` (`AccountNumber`),
  KEY `TaxCode` (`TaxCode`),
  KEY `ST_2` (`ST`,`InvoiceNumber`),
  KEY `InvoiceNumber_2` (`InvoiceNumber`),
  KEY `InvoiceNumber_3` (`InvoiceNumber`,`AccountNumber`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci;



# Dump of table SALESMAN
# ------------------------------------------------------------

DROP TABLE IF EXISTS `SALESMAN`;

CREATE TABLE `SALESMAN` (
  `ID` varchar(11) COLLATE latin1_general_ci NOT NULL DEFAULT '',
  `FullName` varchar(32) COLLATE latin1_general_ci NOT NULL DEFAULT '',
  `Username` varchar(20) COLLATE latin1_general_ci NOT NULL DEFAULT '',
  `Password` varchar(32) COLLATE latin1_general_ci NOT NULL DEFAULT '827ccb0eea8a706c4c34a16891f84e7b',
  `LastLogin` datetime NOT NULL,
  `Language` varchar(2) CHARACTER SET latin1 NOT NULL DEFAULT 'ES',
  `Email` varchar(50) CHARACTER SET latin1 NOT NULL DEFAULT '',
  `CookieHash` varchar(32) CHARACTER SET latin1 DEFAULT NULL,
  `CookieExpire` datetime DEFAULT NULL,
  `CommissionRate` float(4,3) DEFAULT NULL COMMENT 'Commission for Payments',
  `SalesCommissionRate` float(4,3) DEFAULT NULL,
  `GlobalCommission` tinyint(1) NOT NULL DEFAULT '0',
  `CommissionSalesman` tinyint(4) NOT NULL DEFAULT '0',
  `Phone` varchar(10) CHARACTER SET latin1 DEFAULT NULL,
  `CellProvider` int(3) DEFAULT NULL,
  `EmailPass` varchar(32) CHARACTER SET latin1 DEFAULT NULL,
  `iPhoneConfig` varchar(128) CHARACTER SET latin1 DEFAULT NULL,
  `AllowTruckMode` tinyint(1) NOT NULL DEFAULT '0',
  `SendInventoryEmail` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  UNIQUE KEY `Username` (`Username`),
  UNIQUE KEY `CookieHash` (`CookieHash`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci;



# Dump of table SALESMAN_QUOTA
# ------------------------------------------------------------

DROP TABLE IF EXISTS `SALESMAN_QUOTA`;

CREATE TABLE `SALESMAN_QUOTA` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `Salesman` varchar(3) NOT NULL,
  `Month` int(11) NOT NULL,
  `Year` int(11) NOT NULL,
  `MTD` decimal(12,2) NOT NULL,
  `MTDPayment` double NOT NULL,
  `Goal` decimal(12,2) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `UniqueKey` (`Salesman`,`Month`,`Year`),
  KEY `Salesman` (`Salesman`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;



# Dump of table SALESMAN_QUOTA_TEMP
# ------------------------------------------------------------

DROP TABLE IF EXISTS `SALESMAN_QUOTA_TEMP`;

CREATE TABLE `SALESMAN_QUOTA_TEMP` (
  `SalesmanID` varchar(3) NOT NULL,
  `SalesmanName` varchar(32) NOT NULL,
  `MTD` double NOT NULL,
  `TransactionCounter` int(11) NOT NULL,
  `LastDate` varchar(20) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;



# Dump of table SalesmanReconciliationHistory
# ------------------------------------------------------------

DROP VIEW IF EXISTS `SalesmanReconciliationHistory`;

CREATE TABLE `SalesmanReconciliationHistory` (
   `ReconcileID` INT(11) UNSIGNED NOT NULL DEFAULT '0',
   `SalesmanID` VARCHAR(3) NULL DEFAULT NULL,
   `ReconcileDate` DATETIME NULL DEFAULT NULL,
   `ReconcileUser` VARCHAR(32) NULL DEFAULT NULL,
   `Notes` TEXT NULL DEFAULT NULL,
   `TotalAmount` DOUBLE(19) NULL DEFAULT NULL,
   `FullName` VARCHAR(30) NULL DEFAULT NULL
) ENGINE=MyISAM;



# Dump of table SAVED_CART_DETAIL
# ------------------------------------------------------------

DROP TABLE IF EXISTS `SAVED_CART_DETAIL`;

CREATE TABLE `SAVED_CART_DETAIL` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `SavedCartID` int(11) NOT NULL,
  `Group` varchar(3) COLLATE latin1_general_ci DEFAULT NULL,
  `Line` varchar(3) COLLATE latin1_general_ci DEFAULT NULL,
  `SKU` varchar(20) COLLATE latin1_general_ci DEFAULT NULL,
  `Qty` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci;



# Dump of table SAVED_CART_HEAD
# ------------------------------------------------------------

DROP TABLE IF EXISTS `SAVED_CART_HEAD`;

CREATE TABLE `SAVED_CART_HEAD` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `AccountNumber` varchar(10) COLLATE latin1_general_ci DEFAULT NULL,
  `SelectedAccount` varchar(10) COLLATE latin1_general_ci DEFAULT NULL,
  `SavedCartDate` datetime DEFAULT NULL,
  `Name` varchar(32) COLLATE latin1_general_ci DEFAULT NULL,
  `SalesmanCart` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci;



# Dump of table SEARCH_QUERY
# ------------------------------------------------------------

DROP TABLE IF EXISTS `SEARCH_QUERY`;

CREATE TABLE `SEARCH_QUERY` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `Group` varchar(3) NOT NULL,
  `Line` varchar(3) NOT NULL,
  `SKU` varchar(30) NOT NULL,
  `AccountNumber` varchar(10) NOT NULL,
  `Salesman` tinyint(1) NOT NULL,
  `QueryDate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `Group` (`Group`,`Line`,`SKU`,`AccountNumber`),
  KEY `AccountNumber` (`AccountNumber`),
  KEY `QueryDate` (`QueryDate`),
  KEY `AccountNumber_2` (`AccountNumber`,`QueryDate`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;



# Dump of table SEARS
# ------------------------------------------------------------

DROP TABLE IF EXISTS `SEARS`;

CREATE TABLE `SEARS` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `SKU` varchar(64) COLLATE latin1_general_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci;



# Dump of table SETTING
# ------------------------------------------------------------

DROP TABLE IF EXISTS `SETTING`;

CREATE TABLE `SETTING` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `SettingName` varchar(32) NOT NULL,
  `Value` varchar(32) NOT NULL,
  `Comment` varchar(64) NOT NULL,
  PRIMARY KEY (`ID`),
  UNIQUE KEY `SettingName` (`SettingName`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;



# Dump of table SHOPPING_CART
# ------------------------------------------------------------

DROP TABLE IF EXISTS `SHOPPING_CART`;

CREATE TABLE `SHOPPING_CART` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `AccountNumber` varchar(9) COLLATE latin1_bin NOT NULL,
  `Group` varchar(3) COLLATE latin1_bin DEFAULT NULL,
  `Line` varchar(3) COLLATE latin1_bin DEFAULT NULL,
  `SKU` varchar(20) COLLATE latin1_bin DEFAULT NULL,
  `Qty` int(11) DEFAULT NULL,
  `SalesmanCart` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `AccountNumber` (`AccountNumber`,`Group`,`Line`,`SKU`),
  KEY `Account` (`AccountNumber`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_bin;



# Dump of table SoldByMonth
# ------------------------------------------------------------

DROP VIEW IF EXISTS `SoldByMonth`;

CREATE TABLE `SoldByMonth` (
   `Line` VARCHAR(3) NOT NULL DEFAULT '',
   `Group` VARCHAR(3) NOT NULL DEFAULT '',
   `Familia` VARCHAR(32) NOT NULL DEFAULT '',
   `SKU` VARCHAR(20) NOT NULL DEFAULT '',
   `Description` TEXT NOT NULL,
   `Shipped` DECIMAL(32) NULL DEFAULT NULL,
   `OnHand` INT(8) NULL DEFAULT '0',
   `January` DECIMAL(32) NULL DEFAULT NULL,
   `February` DECIMAL(32) NULL DEFAULT NULL,
   `March` DECIMAL(32) NULL DEFAULT NULL,
   `April` DECIMAL(32) NULL DEFAULT NULL,
   `May` DECIMAL(32) NULL DEFAULT NULL,
   `June` DECIMAL(32) NULL DEFAULT NULL,
   `July` DECIMAL(32) NULL DEFAULT NULL,
   `August` DECIMAL(32) NULL DEFAULT NULL,
   `September` DECIMAL(32) NULL DEFAULT NULL,
   `October` DECIMAL(32) NULL DEFAULT NULL,
   `November` DECIMAL(32) NULL DEFAULT NULL,
   `December` DECIMAL(32) NULL DEFAULT NULL,
   `Year` INT(4) NULL DEFAULT NULL
) ENGINE=MyISAM;



# Dump of table SoldByMonthAll
# ------------------------------------------------------------

DROP VIEW IF EXISTS `SoldByMonthAll`;

CREATE TABLE `SoldByMonthAll` (
   `Line` VARCHAR(3) NOT NULL DEFAULT '',
   `Group` VARCHAR(3) NOT NULL DEFAULT '',
   `Familia` VARCHAR(32) NOT NULL DEFAULT '',
   `SKU` VARCHAR(20) NOT NULL DEFAULT '',
   `Description` TEXT NOT NULL,
   `Shipped` DECIMAL(32) NULL DEFAULT NULL,
   `OnHand` INT(8) NULL DEFAULT '0',
   `January` DECIMAL(32) NULL DEFAULT NULL,
   `February` DECIMAL(32) NULL DEFAULT NULL,
   `March` DECIMAL(32) NULL DEFAULT NULL,
   `April` DECIMAL(32) NULL DEFAULT NULL,
   `May` DECIMAL(32) NULL DEFAULT NULL,
   `June` DECIMAL(32) NULL DEFAULT NULL,
   `July` DECIMAL(32) NULL DEFAULT NULL,
   `August` DECIMAL(32) NULL DEFAULT NULL,
   `September` DECIMAL(32) NULL DEFAULT NULL,
   `October` DECIMAL(32) NULL DEFAULT NULL,
   `November` DECIMAL(32) NULL DEFAULT NULL,
   `December` DECIMAL(32) NULL DEFAULT NULL,
   `Year` INT(4) NULL DEFAULT NULL
) ENGINE=MyISAM;



# Dump of table SPECIAL
# ------------------------------------------------------------

DROP TABLE IF EXISTS `SPECIAL`;

CREATE TABLE `SPECIAL` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `Line` varchar(3) NOT NULL,
  `SKU` varchar(32) NOT NULL,
  `Description` varchar(60) NOT NULL,
  `Notes` varchar(60) NOT NULL,
  `RegularPrice` decimal(9,2) NOT NULL,
  PRIMARY KEY (`ID`),
  KEY `Line` (`Line`,`SKU`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;



# Dump of table SUPPLIER
# ------------------------------------------------------------

DROP TABLE IF EXISTS `SUPPLIER`;

CREATE TABLE `SUPPLIER` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `CompanyName` varchar(128) COLLATE latin1_general_ci DEFAULT NULL,
  `ContactName` varchar(128) COLLATE latin1_general_ci DEFAULT NULL,
  `PaymentTerms` int(11) DEFAULT NULL,
  `POEmail` varchar(256) COLLATE latin1_general_ci DEFAULT NULL,
  `ContactEmail` varchar(256) COLLATE latin1_general_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci;



# Dump of table SUPPLIER_CATALOG_LINK
# ------------------------------------------------------------

DROP TABLE IF EXISTS `SUPPLIER_CATALOG_LINK`;

CREATE TABLE `SUPPLIER_CATALOG_LINK` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `Name` varchar(30) COLLATE latin1_general_ci DEFAULT NULL,
  `ButtonImage` varchar(1024) COLLATE latin1_general_ci DEFAULT NULL,
  `Link` varchar(1024) COLLATE latin1_general_ci DEFAULT NULL,
  `Position` int(11) DEFAULT NULL,
  `AdditionalText` varchar(128) COLLATE latin1_general_ci DEFAULT NULL,
  `Target` varchar(32) COLLATE latin1_general_ci DEFAULT '_blank',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci;



# Dump of table SUPPLIER_INVENTORY
# ------------------------------------------------------------

DROP TABLE IF EXISTS `SUPPLIER_INVENTORY`;

CREATE TABLE `SUPPLIER_INVENTORY` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `VendorID` int(11) NOT NULL DEFAULT '100',
  `SKU` varchar(32) COLLATE latin1_general_ci DEFAULT NULL,
  `Description` varchar(128) COLLATE latin1_general_ci DEFAULT NULL,
  `Subcategory` varchar(128) COLLATE latin1_general_ci DEFAULT NULL,
  `QtyAvailable` int(11) DEFAULT NULL,
  `Active` tinyint(1) DEFAULT NULL,
  `AdditionalQty` int(11) DEFAULT NULL,
  `AdditionalDate` date DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `SKU` (`SKU`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci;



# Dump of table TEST
# ------------------------------------------------------------

DROP TABLE IF EXISTS `TEST`;

CREATE TABLE `TEST` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `SKU` varchar(32) DEFAULT NULL,
  PRIMARY KEY (`ID`),
  KEY `SKU` (`SKU`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;



# Dump of table TICKET_HEAD
# ------------------------------------------------------------

DROP TABLE IF EXISTS `TICKET_HEAD`;

CREATE TABLE `TICKET_HEAD` (
  `TicketID` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `TicketDate` datetime DEFAULT NULL,
  `Username` varchar(32) COLLATE latin1_general_ci DEFAULT NULL,
  `Subject` varchar(256) COLLATE latin1_general_ci DEFAULT NULL,
  `Contents` text COLLATE latin1_general_ci,
  `Status` tinyint(1) NOT NULL DEFAULT '0' COMMENT '0-Open / 1-Pending Review / 2-Done',
  `Priority` tinyint(1) NOT NULL DEFAULT '2' COMMENT '1-Top Priority / 2-Normal Priority / 3-Low Priority',
  `DateClosed` datetime DEFAULT NULL,
  `Archived` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`TicketID`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci;



# Dump of table TICKET_ITEM
# ------------------------------------------------------------

DROP TABLE IF EXISTS `TICKET_ITEM`;

CREATE TABLE `TICKET_ITEM` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `TicketID` int(11) DEFAULT NULL,
  `Username` varchar(32) COLLATE latin1_general_ci DEFAULT NULL,
  `PostDate` datetime DEFAULT NULL,
  `Comment` text COLLATE latin1_general_ci,
  `LastEdit` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci;



# Dump of table VENDOR
# ------------------------------------------------------------

DROP TABLE IF EXISTS `VENDOR`;

CREATE TABLE `VENDOR` (
  `VendorID` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `Name` varchar(64) COLLATE latin1_general_ci DEFAULT NULL,
  `Contact` varchar(64) COLLATE latin1_general_ci DEFAULT NULL,
  `PhysicalAddress1` varchar(128) COLLATE latin1_general_ci DEFAULT NULL,
  `PhysicalAddress2` varchar(128) COLLATE latin1_general_ci DEFAULT NULL,
  `PhysicalAddress3` varchar(128) COLLATE latin1_general_ci DEFAULT NULL,
  `PhysicalCity` varchar(32) COLLATE latin1_general_ci DEFAULT NULL,
  `PhysicalState` varchar(12) COLLATE latin1_general_ci DEFAULT NULL,
  `PhysicalZip` varchar(12) COLLATE latin1_general_ci DEFAULT NULL,
  `PhysicalCountry` varchar(32) COLLATE latin1_general_ci DEFAULT NULL,
  `PostalAddress1` varchar(128) COLLATE latin1_general_ci DEFAULT NULL,
  `PostalAddress2` varchar(128) COLLATE latin1_general_ci DEFAULT NULL,
  `PostalAddress3` varchar(128) COLLATE latin1_general_ci DEFAULT NULL,
  `PostalCity` varchar(32) COLLATE latin1_general_ci DEFAULT NULL,
  `PostalState` varchar(12) COLLATE latin1_general_ci DEFAULT NULL,
  `PostalZip` varchar(12) COLLATE latin1_general_ci DEFAULT NULL,
  `PostalCountry` varchar(30) COLLATE latin1_general_ci DEFAULT NULL,
  `ShippingTerms` varchar(12) COLLATE latin1_general_ci DEFAULT NULL,
  `PaymentTerms` varchar(12) COLLATE latin1_general_ci DEFAULT NULL,
  `MainPhone` varchar(32) COLLATE latin1_general_ci DEFAULT NULL,
  `ContactPhone` varchar(32) COLLATE latin1_general_ci DEFAULT NULL,
  `Fax` varchar(32) COLLATE latin1_general_ci DEFAULT NULL,
  `ContactEmail` varchar(64) COLLATE latin1_general_ci DEFAULT NULL,
  `OrderEmail` varchar(64) COLLATE latin1_general_ci DEFAULT NULL,
  `LeadTime` int(11) DEFAULT NULL COMMENT 'Days',
  `OurAccountNumber` varchar(20) COLLATE latin1_general_ci DEFAULT NULL,
  PRIMARY KEY (`VendorID`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci;



# Dump of table WEEKLY_PLANNER_DETAIL
# ------------------------------------------------------------

DROP TABLE IF EXISTS `WEEKLY_PLANNER_DETAIL`;

CREATE TABLE `WEEKLY_PLANNER_DETAIL` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `WPID` int(11) DEFAULT NULL,
  `Weekday` int(11) DEFAULT NULL,
  `AccountNumber` varchar(12) COLLATE latin1_general_ci DEFAULT NULL,
  `OverDue` double(10,2) DEFAULT NULL,
  `Comments` varchar(254) COLLATE latin1_general_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci;



# Dump of table WEEKLY_PLANNER_HEAD
# ------------------------------------------------------------

DROP TABLE IF EXISTS `WEEKLY_PLANNER_HEAD`;

CREATE TABLE `WEEKLY_PLANNER_HEAD` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `SalesmanID` varchar(3) COLLATE latin1_general_ci DEFAULT NULL,
  `WeekStart` date DEFAULT NULL,
  `WeekEnd` date DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `SalesmanID` (`SalesmanID`,`WeekStart`,`WeekEnd`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci;



# Dump of table WH_PL
# ------------------------------------------------------------

DROP TABLE IF EXISTS `WH_PL`;

CREATE TABLE `WH_PL` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `SKU` varchar(32) COLLATE latin1_general_ci DEFAULT NULL,
  `Description` varchar(128) COLLATE latin1_general_ci DEFAULT NULL,
  `Department` varchar(128) COLLATE latin1_general_ci DEFAULT NULL,
  `Category` varchar(128) COLLATE latin1_general_ci DEFAULT NULL,
  `Price` float(8,2) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `SKU` (`SKU`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci;





# Replace placeholder table for EstimatedByMonth with correct view syntax
# ------------------------------------------------------------

DROP VIEW `EstimatedByMonth`;

CREATE VIEW `EstimatedByMonth` AS (select `ESTIMATE_DETAIL`.`Line` AS `Line`,`ESTIMATE_DETAIL`.`Group` AS `Group`,`INVENTORY`.`Familia` AS `Familia`,`ESTIMATE_DETAIL`.`SKU` AS `SKU`,`INVENTORY`.`Description` AS `Description`,sum(`ESTIMATE_DETAIL`.`EstimateQty`) AS `Estimated`,`INVENTORY`.`Qty` AS `OnHand`,sum(if((month(`ESTIMATE_HEAD`.`EstimateDate`) = 1),`ESTIMATE_DETAIL`.`EstimateQty`,0)) AS `January`,sum(if((month(`ESTIMATE_HEAD`.`EstimateDate`) = 2),`ESTIMATE_DETAIL`.`EstimateQty`,0)) AS `February`,sum(if((month(`ESTIMATE_HEAD`.`EstimateDate`) = 3),`ESTIMATE_DETAIL`.`EstimateQty`,0)) AS `March`,sum(if((month(`ESTIMATE_HEAD`.`EstimateDate`) = 4),`ESTIMATE_DETAIL`.`EstimateQty`,0)) AS `April`,sum(if((month(`ESTIMATE_HEAD`.`EstimateDate`) = 5),`ESTIMATE_DETAIL`.`EstimateQty`,0)) AS `May`,sum(if((month(`ESTIMATE_HEAD`.`EstimateDate`) = 6),`ESTIMATE_DETAIL`.`EstimateQty`,0)) AS `June`,sum(if((month(`ESTIMATE_HEAD`.`EstimateDate`) = 7),`ESTIMATE_DETAIL`.`EstimateQty`,0)) AS `July`,sum(if((month(`ESTIMATE_HEAD`.`EstimateDate`) = 8),`ESTIMATE_DETAIL`.`EstimateQty`,0)) AS `August`,sum(if((month(`ESTIMATE_HEAD`.`EstimateDate`) = 9),`ESTIMATE_DETAIL`.`EstimateQty`,0)) AS `September`,sum(if((month(`ESTIMATE_HEAD`.`EstimateDate`) = 10),`ESTIMATE_DETAIL`.`EstimateQty`,0)) AS `October`,sum(if((month(`ESTIMATE_HEAD`.`EstimateDate`) = 11),`ESTIMATE_DETAIL`.`EstimateQty`,0)) AS `November`,sum(if((month(`ESTIMATE_HEAD`.`EstimateDate`) = 12),`ESTIMATE_DETAIL`.`EstimateQty`,0)) AS `December` from ((`ESTIMATE_DETAIL` join `ESTIMATE_HEAD` on((`ESTIMATE_DETAIL`.`EstimateID` = `ESTIMATE_HEAD`.`EstimateID`))) join `INVENTORY` on(((convert(`ESTIMATE_DETAIL`.`Group` using utf8) = `INVENTORY`.`Group`) and (convert(`ESTIMATE_DETAIL`.`Line` using utf8) = `INVENTORY`.`Line`) and (convert(`ESTIMATE_DETAIL`.`SKU` using utf8) = `INVENTORY`.`SKU`)))) where (`ESTIMATE_HEAD`.`DeleteEstimate` = 0) group by `ESTIMATE_DETAIL`.`SKU`);


# Replace placeholder table for SoldByMonth with correct view syntax
# ------------------------------------------------------------

DROP VIEW `SoldByMonth`;

CREATE VIEW `SoldByMonth` AS (select `INVOICE_DETAIL`.`Line` AS `Line`,`INVOICE_DETAIL`.`Group` AS `Group`,`INVENTORY`.`Familia` AS `Familia`,`INVOICE_DETAIL`.`SKU` AS `SKU`,`INVENTORY`.`Description` AS `Description`,sum(`INVOICE_DETAIL`.`ShippedQty`) AS `Shipped`,`INVENTORY`.`Qty` AS `OnHand`,sum(if((month(`INVOICE_HEAD`.`InvoiceDate`) = 1),`INVOICE_DETAIL`.`ShippedQty`,0)) AS `January`,sum(if((month(`INVOICE_HEAD`.`InvoiceDate`) = 2),`INVOICE_DETAIL`.`ShippedQty`,0)) AS `February`,sum(if((month(`INVOICE_HEAD`.`InvoiceDate`) = 3),`INVOICE_DETAIL`.`ShippedQty`,0)) AS `March`,sum(if((month(`INVOICE_HEAD`.`InvoiceDate`) = 4),`INVOICE_DETAIL`.`ShippedQty`,0)) AS `April`,sum(if((month(`INVOICE_HEAD`.`InvoiceDate`) = 5),`INVOICE_DETAIL`.`ShippedQty`,0)) AS `May`,sum(if((month(`INVOICE_HEAD`.`InvoiceDate`) = 6),`INVOICE_DETAIL`.`ShippedQty`,0)) AS `June`,sum(if((month(`INVOICE_HEAD`.`InvoiceDate`) = 7),`INVOICE_DETAIL`.`ShippedQty`,0)) AS `July`,sum(if((month(`INVOICE_HEAD`.`InvoiceDate`) = 8),`INVOICE_DETAIL`.`ShippedQty`,0)) AS `August`,sum(if((month(`INVOICE_HEAD`.`InvoiceDate`) = 9),`INVOICE_DETAIL`.`ShippedQty`,0)) AS `September`,sum(if((month(`INVOICE_HEAD`.`InvoiceDate`) = 10),`INVOICE_DETAIL`.`ShippedQty`,0)) AS `October`,sum(if((month(`INVOICE_HEAD`.`InvoiceDate`) = 11),`INVOICE_DETAIL`.`ShippedQty`,0)) AS `November`,sum(if((month(`INVOICE_HEAD`.`InvoiceDate`) = 12),`INVOICE_DETAIL`.`ShippedQty`,0)) AS `December`,year(`INVOICE_HEAD`.`InvoiceDate`) AS `Year` from ((`INVOICE_DETAIL` join `INVOICE_HEAD` on((`INVOICE_DETAIL`.`InvoiceID` = `INVOICE_HEAD`.`InvoiceID`))) join `INVENTORY` on(((convert(`INVOICE_DETAIL`.`Group` using utf8) = `INVENTORY`.`Group`) and (convert(`INVOICE_DETAIL`.`Line` using utf8) = `INVENTORY`.`Line`) and (convert(`INVOICE_DETAIL`.`SKU` using utf8) = `INVENTORY`.`SKU`)))) where ((`INVOICE_HEAD`.`Status` = 1) and (`INVOICE_HEAD`.`Void` = 0)) group by `INVOICE_DETAIL`.`SKU`,`Year`);


# Replace placeholder table for SoldByMonthAll with correct view syntax
# ------------------------------------------------------------

DROP VIEW `SoldByMonthAll`;

CREATE VIEW `SoldByMonthAll` AS (select `INVOICE_DETAIL`.`Line` AS `Line`,`INVOICE_DETAIL`.`Group` AS `Group`,`INVENTORY`.`Familia` AS `Familia`,`INVOICE_DETAIL`.`SKU` AS `SKU`,`INVENTORY`.`Description` AS `Description`,sum(`INVOICE_DETAIL`.`ShippedQty`) AS `Shipped`,`INVENTORY`.`Qty` AS `OnHand`,sum(if((month(`INVOICE_HEAD`.`InvoiceDate`) = 1),`INVOICE_DETAIL`.`ShippedQty`,0)) AS `January`,sum(if((month(`INVOICE_HEAD`.`InvoiceDate`) = 2),`INVOICE_DETAIL`.`ShippedQty`,0)) AS `February`,sum(if((month(`INVOICE_HEAD`.`InvoiceDate`) = 3),`INVOICE_DETAIL`.`ShippedQty`,0)) AS `March`,sum(if((month(`INVOICE_HEAD`.`InvoiceDate`) = 4),`INVOICE_DETAIL`.`ShippedQty`,0)) AS `April`,sum(if((month(`INVOICE_HEAD`.`InvoiceDate`) = 5),`INVOICE_DETAIL`.`ShippedQty`,0)) AS `May`,sum(if((month(`INVOICE_HEAD`.`InvoiceDate`) = 6),`INVOICE_DETAIL`.`ShippedQty`,0)) AS `June`,sum(if((month(`INVOICE_HEAD`.`InvoiceDate`) = 7),`INVOICE_DETAIL`.`ShippedQty`,0)) AS `July`,sum(if((month(`INVOICE_HEAD`.`InvoiceDate`) = 8),`INVOICE_DETAIL`.`ShippedQty`,0)) AS `August`,sum(if((month(`INVOICE_HEAD`.`InvoiceDate`) = 9),`INVOICE_DETAIL`.`ShippedQty`,0)) AS `September`,sum(if((month(`INVOICE_HEAD`.`InvoiceDate`) = 10),`INVOICE_DETAIL`.`ShippedQty`,0)) AS `October`,sum(if((month(`INVOICE_HEAD`.`InvoiceDate`) = 11),`INVOICE_DETAIL`.`ShippedQty`,0)) AS `November`,sum(if((month(`INVOICE_HEAD`.`InvoiceDate`) = 12),`INVOICE_DETAIL`.`ShippedQty`,0)) AS `December`,year(`INVOICE_HEAD`.`InvoiceDate`) AS `Year` from ((`INVOICE_DETAIL` join `INVOICE_HEAD` on((`INVOICE_DETAIL`.`InvoiceID` = `INVOICE_HEAD`.`InvoiceID`))) join `INVENTORY` on(((convert(`INVOICE_DETAIL`.`Group` using utf8) = `INVENTORY`.`Group`) and (convert(`INVOICE_DETAIL`.`Line` using utf8) = `INVENTORY`.`Line`) and (convert(`INVOICE_DETAIL`.`SKU` using utf8) = `INVENTORY`.`SKU`)))) where (`INVOICE_HEAD`.`Void` = 0) group by `INVOICE_DETAIL`.`SKU`,`Year`);


# Replace placeholder table for RevenueAndProfitByMonth with correct view syntax
# ------------------------------------------------------------

DROP VIEW `RevenueAndProfitByMonth`;

CREATE VIEW `RevenueAndProfitByMonth` AS (select `RevenueAndProfitByInvoice`.`Month` AS `Month`,`RevenueAndProfitByInvoice`.`Year` AS `Year`,round(sum(`RevenueAndProfitByInvoice`.`TotalCost`),2) AS `TotalCost`,round(sum(`RevenueAndProfitByInvoice`.`TotalPrice`),2) AS `TotalPrice`,round(sum(`RevenueAndProfitByInvoice`.`DiscountAmount`),2) AS `TotalDiscount`,round(sum((`RevenueAndProfitByInvoice`.`TotalProfit` - `RevenueAndProfitByInvoice`.`DiscountAmount`)),2) AS `TotalProfit` from `RevenueAndProfitByInvoice` group by `RevenueAndProfitByInvoice`.`Month`,`RevenueAndProfitByInvoice`.`Year`);


# Replace placeholder table for RevenueAndProfitByInvoice with correct view syntax
# ------------------------------------------------------------

DROP TABLE `RevenueAndProfitByInvoice`;

CREATE  VIEW `RevenueAndProfitByInvoice` AS (select `PAYMENT_DETAIL`.`PaymentID` AS `PaymentID`,`INVOICE_HEAD`.`InvoiceID` AS `InvoiceID`,`PAYMENT_DETAIL`.`DiscountAmount` AS `DiscountAmount`,month(`PAYMENT_HEAD`.`PaymentDate`) AS `Month`,year(`PAYMENT_HEAD`.`PaymentDate`) AS `Year`,round((sum((`INVOICE_DETAIL`.`ShippedQty` * `INVOICE_DETAIL`.`AvgCost`)) * (`PAYMENT_DETAIL`.`PaymentAmount` / sum((`INVOICE_DETAIL`.`ShippedQty` * `INVOICE_DETAIL`.`Price`)))),2) AS `TotalCost`,sum((`INVOICE_DETAIL`.`ShippedQty` * `INVOICE_DETAIL`.`Price`)) AS `TotalPrice`,`PAYMENT_DETAIL`.`PaymentAmount` AS `PaymentAmount`,round(((sum((`INVOICE_DETAIL`.`ShippedQty` * `INVOICE_DETAIL`.`Price`)) - sum((`INVOICE_DETAIL`.`ShippedQty` * `INVOICE_DETAIL`.`AvgCost`))) * (`PAYMENT_DETAIL`.`PaymentAmount` / sum((`INVOICE_DETAIL`.`ShippedQty` * `INVOICE_DETAIL`.`Price`)))),2) AS `TotalProfit` from (((`INVOICE_HEAD` join `INVOICE_DETAIL` on((`INVOICE_HEAD`.`InvoiceID` = `INVOICE_DETAIL`.`InvoiceID`))) join `PAYMENT_DETAIL` on((`INVOICE_HEAD`.`InvoiceID` = `PAYMENT_DETAIL`.`InvoiceID`))) join `PAYMENT_HEAD` on((`PAYMENT_DETAIL`.`PaymentID` = `PAYMENT_HEAD`.`ID`))) where ((`INVOICE_HEAD`.`Void` = 0) and (`PAYMENT_HEAD`.`Void` = 0)) group by month(`PAYMENT_HEAD`.`PaymentDate`),year(`PAYMENT_HEAD`.`PaymentDate`),`INVOICE_HEAD`.`InvoiceID`,`PAYMENT_DETAIL`.`PaymentID`);


# Replace placeholder table for DETAILED_PAYMENT with correct view syntax
# ------------------------------------------------------------

DROP VIEW `DETAILED_PAYMENT`;

CREATE VIEW `DETAILED_PAYMENT` AS (select `PAYMENT_DETAIL`.`ID` AS `ID`,`PAYMENT_DETAIL`.`PaymentID` AS `PaymentID`,`PAYMENT_HEAD`.`Processed` AS `Processed`,`PAYMENT_DETAIL`.`InvoiceID` AS `InvoiceID`,`PAYMENT_DETAIL`.`InvoiceDate` AS `InvoiceDate`,`PAYMENT_HEAD`.`SalesmanID` AS `SalesmanID`,`PAYMENT_DETAIL`.`Reference` AS `Reference`,`PAYMENT_DETAIL`.`PartialPayment` AS `PartialPayment`,`PAYMENT_DETAIL`.`SubtotalAmount` AS `SubtotalAmount`,`PAYMENT_DETAIL`.`DiscountAmount` AS `DiscountAmount`,`PAYMENT_DETAIL`.`TaxAmount` AS `TaxAmount`,`PAYMENT_DETAIL`.`PaymentAmount` AS `PaymentAmount`,`PAYMENT_HEAD`.`AccountNumber` AS `AccountNumber`,`PAYMENT_HEAD`.`Void` AS `Void`,`PAYMENT_HEAD`.`PaymentDate` AS `PaymentDate` from (`PAYMENT_HEAD` left join `PAYMENT_DETAIL` on((`PAYMENT_HEAD`.`ID` = `PAYMENT_DETAIL`.`PaymentID`))) where (`PAYMENT_HEAD`.`Void` = 0));


# Replace placeholder table for CHECKS_DETAIL with correct view syntax
# ------------------------------------------------------------

DROP VIEW `CHECKS_DETAIL`;

CREATE VIEW `CHECKS_DETAIL` AS (select `PAYMENT_CHECK`.`PaymentID` AS `PaymentID`,`PAYMENT_CHECK`.`CheckNumber` AS `CheckNumber`,`CUSTOMER`.`Name` AS `Name`,`PAYMENT_CHECK`.`Amount` AS `Amount`,`PAYMENT_HEAD`.`CollectingUser` AS `CollectingUser`,`PAYMENT_HEAD`.`PaymentDate` AS `PaymentDate` from ((`PAYMENT_CHECK` join `PAYMENT_HEAD` on((`PAYMENT_HEAD`.`ID` = `PAYMENT_CHECK`.`PaymentID`))) join `CUSTOMER` on((`PAYMENT_HEAD`.`AccountNumber` = convert(`CUSTOMER`.`AccountNumber` using utf8)))) where (`PAYMENT_HEAD`.`Void` = 0));


# Replace placeholder table for ACCOUNTS_RECEIVABLE_AGING with correct view syntax
# ------------------------------------------------------------

DROP VIEW `ACCOUNTS_RECEIVABLE_AGING`;

CREATE VIEW `ACCOUNTS_RECEIVABLE_AGING` AS (select `INVOICE_HEAD`.`InvoiceID` AS `InvoiceID`,`INVOICE_HEAD`.`AccountNumber` AS `AccountNumber`,(to_days(now()) - to_days(min(`INVOICE_HEAD`.`InvoiceDate`))) AS `ElapsedDays`,round(sum(if(isnull(`DETAILED_PAYMENT`.`PaymentAmount`),0,(`DETAILED_PAYMENT`.`PaymentAmount` + `DETAILED_PAYMENT`.`DiscountAmount`))),2) AS `Payment`,round(((`INVOICE_HEAD`.`Subtotal` + `INVOICE_HEAD`.`Tax1Total`) + `INVOICE_HEAD`.`Tax2Total`),2) AS `Sale`,(round(((`INVOICE_HEAD`.`Subtotal` + `INVOICE_HEAD`.`Tax1Total`) + `INVOICE_HEAD`.`Tax2Total`),2) - round(sum(if(isnull(`DETAILED_PAYMENT`.`PaymentAmount`),0,(`DETAILED_PAYMENT`.`PaymentAmount` + `DETAILED_PAYMENT`.`DiscountAmount`))),2)) AS `Balance`,(if(((to_days(now()) - to_days(`INVOICE_HEAD`.`InvoiceDate`)) between 0 and 30),((`INVOICE_HEAD`.`Subtotal` + `INVOICE_HEAD`.`Tax1Total`) + `INVOICE_HEAD`.`Tax2Total`),0) - round(sum(if(((to_days(now()) - to_days(`INVOICE_HEAD`.`InvoiceDate`)) between 0 and 30),if(isnull(`DETAILED_PAYMENT`.`PaymentAmount`),0,(`DETAILED_PAYMENT`.`PaymentAmount` + `DETAILED_PAYMENT`.`DiscountAmount`)),0)),2)) AS `0To30`,(if(((to_days(now()) - to_days(`INVOICE_HEAD`.`InvoiceDate`)) between 31 and 60),((`INVOICE_HEAD`.`Subtotal` + `INVOICE_HEAD`.`Tax1Total`) + `INVOICE_HEAD`.`Tax2Total`),0) - round(sum(if(((to_days(now()) - to_days(`INVOICE_HEAD`.`InvoiceDate`)) between 31 and 60),if(isnull(`DETAILED_PAYMENT`.`PaymentAmount`),0,(`DETAILED_PAYMENT`.`PaymentAmount` + `DETAILED_PAYMENT`.`DiscountAmount`)),0)),2)) AS `31To60`,(if(((to_days(now()) - to_days(`INVOICE_HEAD`.`InvoiceDate`)) between 61 and 90),((`INVOICE_HEAD`.`Subtotal` + `INVOICE_HEAD`.`Tax1Total`) + `INVOICE_HEAD`.`Tax2Total`),0) - round(sum(if(((to_days(now()) - to_days(`INVOICE_HEAD`.`InvoiceDate`)) between 61 and 90),if(isnull(`DETAILED_PAYMENT`.`PaymentAmount`),0,(`DETAILED_PAYMENT`.`PaymentAmount` + `DETAILED_PAYMENT`.`DiscountAmount`)),0)),2)) AS `61To90`,(if(((to_days(now()) - to_days(`INVOICE_HEAD`.`InvoiceDate`)) between 91 and 99999),((`INVOICE_HEAD`.`Subtotal` + `INVOICE_HEAD`.`Tax1Total`) + `INVOICE_HEAD`.`Tax2Total`),0) - round(sum(if(((to_days(now()) - to_days(`INVOICE_HEAD`.`InvoiceDate`)) between 91 and 99999),if(isnull(`DETAILED_PAYMENT`.`PaymentAmount`),0,(`DETAILED_PAYMENT`.`PaymentAmount` + `DETAILED_PAYMENT`.`DiscountAmount`)),0)),2)) AS `Over90` from (`INVOICE_HEAD` left join `DETAILED_PAYMENT` on((`INVOICE_HEAD`.`InvoiceID` = `DETAILED_PAYMENT`.`InvoiceID`))) where ((`INVOICE_HEAD`.`Void` = 0) and ((`DETAILED_PAYMENT`.`Void` = 0) or isnull(`DETAILED_PAYMENT`.`Void`)) and (`INVOICE_HEAD`.`Status` = 1)) group by `INVOICE_HEAD`.`InvoiceID`);


# Replace placeholder table for SalesmanReconciliationHistory with correct view syntax
# ------------------------------------------------------------

DROP VIEW `SalesmanReconciliationHistory`;

CREATE VIEW `SalesmanReconciliationHistory`
AS SELECT
   `PAYMENT_SALESMAN_RECONCILE_HEAD`.`ReconcileID` AS `ReconcileID`,
   `PAYMENT_SALESMAN_RECONCILE_HEAD`.`SalesmanID` AS `SalesmanID`,
   `PAYMENT_SALESMAN_RECONCILE_HEAD`.`ReconcileDate` AS `ReconcileDate`,
   `PAYMENT_SALESMAN_RECONCILE_HEAD`.`ReconcileUser` AS `ReconcileUser`,
   `PAYMENT_SALESMAN_RECONCILE_HEAD`.`Notes` AS `Notes`,round(sum(((`PAYMENT_HEAD`.`CashAmount` + `PAYMENT_HEAD`.`CheckAmount`) + `PAYMENT_HEAD`.`TransferAmount`)),2) AS `TotalAmount`,
   `ADMINISTRATOR`.`FullName` AS `FullName`
FROM (((`PAYMENT_SALESMAN_RECONCILE_HEAD` join `PAYMENT_SALESMAN_RECONCILE_DETAIL` on((`PAYMENT_SALESMAN_RECONCILE_HEAD`.`ReconcileID` = `PAYMENT_SALESMAN_RECONCILE_DETAIL`.`ReconcileID`))) join `PAYMENT_HEAD` on((`PAYMENT_HEAD`.`ID` = `PAYMENT_SALESMAN_RECONCILE_DETAIL`.`PaymentID`))) left join `ADMINISTRATOR` on((`PAYMENT_SALESMAN_RECONCILE_HEAD`.`ReconcileUser` = `ADMINISTRATOR`.`Username`))) group by `PAYMENT_SALESMAN_RECONCILE_HEAD`.`ReconcileID` order by `PAYMENT_SALESMAN_RECONCILE_HEAD`.`ReconcileID`;

/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;
/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
