<?php 
include("connect.php");
include("session.php");

 ?>
 
 <!DOCTYPE html>
 <html lang="en">
   <head>
     <meta charset="utf-8">
     <meta http-equiv="X-UA-Compatible" content="IE=edge">
     <meta name="viewport" content="width=device-width, initial-scale=1">
     <title><?= $config['CompanyName'] ?></title>
 
     <!-- Bootstrap -->
     <link href="css/bootstrap.min.css" rel="stylesheet">
     <link rel="stylesheet" href="css/bootstrap-combobox.css" />
 
     <!-- HTML5 shim and Respond.js for IE8 support of HTML5 elements and media queries -->
     <!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
     <!--[if lt IE 9]>
       <script src="https://oss.maxcdn.com/html5shiv/3.7.2/html5shiv.min.js"></script>
       <script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
       <!-- jQuery (necessary for Bootstrap's JavaScript plugins) -->
           <script src="https://ajax.googleapis.com/ajax/libs/jquery/1.11.1/jquery.min.js"></script>
           <!-- Include all compiled plugins (below), or include individual files as needed -->
           <script src="js/bootstrap.min.js"></script>
       	 <script src="js/bootstrap-combobox.js"></script>
           <script type="text/javascript">
             $(document).ready(function(){
     
             });
           </script>

     <![endif]-->
	<link rel="stylesheet" href="css/styles.css"/>
   </head>
   <body>
   
       <?= include("navbar.php"); ?>     

   
   <!-- Stack the columns on mobile by making one full-width and the other half-width -->
<div class="container " style="padding-top: 10px;">
	<div class="panel panel-default">
	  <div class="panel-heading">
	    <h3 class="panel-title">Pickup History (Year to Date) - <?= $_SESSION['Name'] ?></h3>
	  </div>
	  <div class="panel-body">
	  	<table class="table table-hover">
	  		<thead>
	  			<tr>
	  				<th>Pickup ID</th>
	  				<?= ($_SESSION['isCustomer'] != true) ? "<th>Customer</th>" : "" ?>
	  				<th>Pickup Date/Time</th>
	  				<!--<th>Pickup Number</th>-->
	  				<th>Requested By</th>
	  				<th>Packages</th>
						<th>Via</th>
	  				<th>A Recoger</th>
	  				<th>At Warehouse</th>
	  				<th>Status</th>
	  			</tr>
	  			
	  		</thead>
	    <?php 
	    if ($_SESSION['isCustomer']) {
	    	$query = "SELECT * FROM PICKUP_HEAD WHERE AccountNumber LIKE '" . $_SESSION['AccountNumber'] . "' AND PickupDate BETWEEN DATE_ADD(PickupDate,INTERVAL -1 YEAR) AND DATE_ADD(CURDATE(),INTERVAL 1 DAY) AND PickupID NOT IN (SELECT PickupID FROM PICKUP_DETAIL WHERE `Line` = \"KYB\" OR `Line` = \"DHI\") ORDER BY PickupID DESC";	
	    }else {
	    	$query = "SELECT * FROM PICKUP_HEAD WHERE Salesman LIKE '" . $_SESSION['SalesmanID'] . "' AND PickupDate BETWEEN DATE_ADD(PickupDate,INTERVAL -1 YEAR) AND DATE_ADD(CURDATE(),INTERVAL 1 DAY) ORDER BY PickupID DESC";
	    }
	   	$result = mysqli_query($con, $query);
	   	while ($row = mysqli_fetch_array($result)) {
	   		$pickup = new Pickup($row['PickupID']);
	   		$key = md5($row['PickupID'] . "EV");
	   		$key = substr($key, -16);
	   		
	   	?>
	   		<tr>
	   			<td><button class="btn btn-primary pickupBtn" onclick="printReceipt(<?= $row['PickupID'] ?>)"><?= $row['PickupID'] ?></button></td>
	   			<?= ($_SESSION['isCustomer'] != true) ? "<td>" . trim($pickup->Customer->Name) . "</td>" : "" ?>
	   			<td><?= date("m/d/Y g:i a",strtotime($row['PickupDate'])) ?></td>
	   			<!--<td><?= $row['PickupTicket'] ?></td>-->
	   			<td><?= $row['RequestedBy'] ?></td>
	   			<td><?= $row['Packages'] ?></td>
					<td><?= $row['Via'] ?></td>
	   			<td><?= ($row['ToPickup'] == "0000-00-00 00:00:00")?"En Proceso":date("m/d/Y",strtotime($row['ToPickup'])) ?></td>
	   			<td><?= ($row['AtWarehouse'] == "0000-00-00 00:00:00")?"En Proceso":date("m/d/Y",strtotime($row['AtWarehouse'])) ?></td>
	   			<?php 
	   				$pickupStatus = $row['PickupStatus'];
	   				$emptyPickupStatus = ($pickupStatus=="")?true:false;
	   				switch ($pickupStatus) {
	   					case "Aceptado":
	   						$buttonType = "btn-success";		
	   						break;
	   					case "Aceptado Parcial":
	   						$buttonType = "btn-warning";		
	   						break;
	   					case "Denegado":
	   						$buttonType = "btn-danger";		
	   						break;
	   					default:
	   						//$buttonType = "btn-default";
								$buttonType = "";	
	   						break;	
	   				}
	   				
	   			?>
	   			<td><?= ($emptyPickupStatus)?"En Proceso":"<button type=\"button\" class=\"statusButton btn $buttonType\" data-toggle=\"tooltip\" data-placement=\"bottom\" title=\"" . (($row['PickupStatusNotes'] != "")?$row['PickupStatusNotes']:"No hay comentarios") . "\">" . $row['PickupStatus'] . "</button>" ?></td>
	   		</tr>
	   	<?php
	   	}
	     ?>
	     </table>
	  </div>
	</div>

</div>
   
   <script type="text/javascript">
   	$('.statusButton').tooltip();
   </script>   
    <script type="text/javascript">
	  function printReceipt(pickupID) {
        var receiptWin = window.open("pickupreceipt.php?reprint=true&id=" + pickupID, pickupID ,'toolbar=no,width=415,height=1000');					
		if(!receiptWin || receiptWin.closed || typeof receiptWin.closed=='undefined') {
			window.open("pickupreceipt.php?reprint=true&id=" + pickupID, pickupID ,'toolbar=no,width=415,height=1000');					
		}
      }
	  
		
	 </script>
	
   </body>
 </html>