function moneyFormat(amt) {
	amt = parseFloat(amt);
	return "$" + amt.toFixed(2).replace(/\d(?=(\d{3})+\.)/g, '$&,');

}
function pad(n, width, z) {
  z = z || '0';
  n = n + '';
  return n.length >= width ? n : new Array(width - n.length + 1).join(z) + n;
}
$(document).ready(function(){
	$('.allcaps').css("text-transform", "uppercase");
	
	$('.alllower').css("text-transform", "lowercase");
});
function playSound(type){
	var sound = new Audio("/assets/audio/" + type + ".mp3");
	sound.play();
}
function alertBox(type, message, selector){
	var idSelector = makeid();
	idSelector = idSelector.toUpperCase()
	var alertCode = $([
		'<div class="alert alert-' + type + ' alert-dismissible" id="'+idSelector+'" role="alert">',
		'	<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>',
		message,
		'<script type="text/javascript">',
		'	setTimeout(function(){',
		'		$("#' + idSelector + '").remove();',
		'	}, 2000);',
		'</script>',
		'</div>',
		
	].join('\n'));
	
	$(selector).prepend(alertCode);
}

function makeid() {
  var text = "";
  var possible = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789";

  for (var i = 0; i < 5; i++)
    text += possible.charAt(Math.floor(Math.random() * possible.length));

  return text;
}
function HashTable(obj)
{
	this.length = 0;
	this.items = {};
	for (var p in obj) {
		if (obj.hasOwnProperty(p)) {
			this.items[p] = obj[p];
			this.length++;
		}
	}

	this.setItem = function(key, value)
	{
		var previous = undefined;
		if (this.hasItem(key)) {
			previous = this.items[key];
		}
		else {
			this.length++;
		}
		this.items[key] = value;
		return previous;
	}

	this.getItem = function(key) {
		return this.hasItem(key) ? this.items[key] : undefined;
	}

	this.hasItem = function(key)
	{
		return this.items.hasOwnProperty(key);
	}
   
	this.removeItem = function(key)
	{
		if (this.hasItem(key)) {
			previous = this.items[key];
			this.length--;
			delete this.items[key];
			return previous;
		}
		else {
			return undefined;
		}
	}

	this.keys = function()
	{
		var keys = [];
		for (var k in this.items) {
			if (this.hasItem(k)) {
				keys.push(k);
			}
		}
		return keys;
	}

	this.values = function()
	{
		var values = [];
		for (var k in this.items) {
			if (this.hasItem(k)) {
				values.push(this.items[k]);
			}
		}
		return values;
	}

	this.each = function(fn) {
		for (var k in this.items) {
			if (this.hasItem(k)) {
				fn(k, this.items[k]);
			}
		}
	}

	this.clear = function()
	{
		this.items = {}
		this.length = 0;
	}
}
