 <!DOCTYPE html>
 <html lang="en">
   <head>
     <meta charset="utf-8">
     <meta http-equiv="X-UA-Compatible" content="IE=edge">
     <!--<meta name="viewport" content="width=device-width, initial-scale=1">-->
     <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no">
     <title><?= $config['CompanyName'] ?></title>
 
     <!-- Bootstrap -->
     <link href="../css/bootstrap.min.css" rel="stylesheet">
     <link rel="stylesheet" href="../css/bootstrap-combobox.css" />
 
     <!-- HTML5 shim and Respond.js for IE8 support of HTML5 elements and media queries -->
     <!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
     <!--[if lt IE 9]>
       <script src="https://oss.maxcdn.com/html5shiv/3.7.2/html5shiv.min.js"></script>
       <script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
       <script src="../js/functions.js"></script>
       <!-- jQuery (necessary for Bootstrap's JavaScript plugins) -->
       <script src="../js/functions.js"></script>
           <script src="https://ajax.googleapis.com/ajax/libs/jquery/1.11.1/jquery.min.js"></script>
           <!-- Include all compiled plugins (below), or include individual files as needed -->
           <script src="../js/bootstrap.min.js"></script>
       	 <script src="../js/bootstrap-combobox.js"></script>
       	 <script src="../js/excellentexport.js"></script>
           <script type="text/javascript">
             $(document).ready(function(){
             
             });
           </script>
					<link rel="stylesheet" href="../css/jquery.filthypillow.css" type="text/css" />
					<script src="../js/jquery.filthypillow.min.js" type="text/javascript"></script>
					<script src="../js/moment.js" type="text/javascript"></script>
     <![endif]-->
	<link rel="stylesheet" href="../css/styles.css"/>
   </head>
   <body>
<?php 
	include("navbar.php");
?>
        <br /><br />
   <!-- Stack the columns on mobile by making one full-width and the other half-width -->
    
	<div class="container" style="padding-top: 10px;">
		<link href="../css/fileinput.min.css" media="all" rel="stylesheet" type="text/css" />
		<script src="../js/fileinput.js" type="text/javascript"></script>
		
		<div class="panel panel-default">
			<div class="panel-heading form-inline">
				<a class="btn btn-success" role="button" style="float: right;" href="#" download="QuantityBreaks<?= "(" . date("m.d.Y") . ")" ?>.xls" href="#" onclick="return ExcellentExport.excel(this, 'QtyBreakTable', 'Quantity Breaks');" data-toggle="tooltip" data-placement="left" title="Does not work with Internet Explorer">Export To Excel</a>
				<div style="margin-right: 10px; float: right;">
					<div class="input-group">
						<div id="clearButton" style="display: none;" class="input-group-addon" onclick="clearFilter()">
							<span class="glyphicon glyphicon-remove" aria-hidden="true"></span>
						</div>
						<input type="text"   class="form-control" name="filter" placeholder="Filter" value="" />
						<div class="input-group-addon" onclick="filter()">
							<span class="glyphicon glyphicon-search" aria-hidden="true"></span>
						</div>
					</div>
					<button class="btn btn-primary" onclick="addQtyBreak()" >Add New Quantity Break</button>
				</div>
				<h3 class="panel-title">Quantity Breaks</h3>
				<small>Click on a row to edit the Item</small>
			</div>
			<div class="panel-body">
				<table id="QtyBreakTable" class="table table-hover">
					<thead>
						<tr>
							<th>Line</th>
							<th>SKU</th>
							<th>Qty Break</th>
							<th>QtyToAdd</th>
							<th>Discount Rate</th>
							<th>Net Price (Default)</th>
							<th>Active</th>
						</tr>
					</thead>
					<tbody>
						<?php 
						 $query = "SELECT * FROM `QUANTITY_BREAK` ORDER BY Line, SKU ASC";
						 $result = mysqli_query($con, $query);
						 while ($row = mysqli_fetch_array($result)) {
							$item = new Item('', $row['Line'], str_ireplace("_", "", $row['SKU']));
						?>
							 <tr onclick="editQtyBreak('<?= $row['id'] ?>')">
								 <td><?= $row['Line'] ?></td>
								 <td><?= $row['SKU'] ?></td>
								 <td><?= $row['QtyBreak'] ?></td>
								 <td><?= $row['QtyToAdd'] ?></td>
								 <td><?= $row['DiscountRate'] ?></td>
								 <td><?= moneyFormat((($item->Price*$row['QtyBreak'])/($row['QtyBreak']+$row['QtyToAdd']))*(1-$row['DiscountRate'])) ?></td>
								 <td><?= $row['Active']?"Yes":"No" ?></td>
								 <!--  -->
							 </tr>
						<?php		
						 }
						 ?>
					</tbody>
				</table>
			</div>
		</div>
	</div>
	
	
	<div class="modal fade" id="AddEditQtyBreak">
		 <div class="modal-dialog">
		   <div class="modal-content">
			 <div class="modal-header">
			   <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
			   <h4 class="modal-title" id="AddEditTitle">Edit Qty Break Item</h4>
			 </div>
			 <div class="modal-body">
			   <form class="catalogItem">
				   <input type="hidden" id="isNew" name="isNew" value="" />
				   <input type="hidden" id="QtyBreakID" name="QtyBreakID" value="" />
				   <div class="form-group">
					   <label for="QtyBreakLine">Line</label>
						 <input class="form-control" id="QtyBreakLine" name="QtyBreakLine" />
				   </div>
					 
					 <div class="form-group">
					 <label for="QtyBreakSKU">SKU</label>
					   <input type="text" class="form-control" name="QtyBreakSKU" autocomplete="off" id="QtyBreakSKU" placeholder="">
					 </div>
					 <div class="form-group">
					 <label for="QtyBreakQtyBreak">Quantity Break <i>(Amount)</i></label>
					   <input type="text" class="form-control" name="QtyBreakQtyBreak" autocomplete="off" id="QtyBreakQtyBreak" value="" placeholder="">
					 </div>
					 
					 <div class="form-group">
					 <label for="QtyBreakQtyToAdd">Quantity To Add</label>
					   <input type="text" class="form-control" name="QtyBreakQtyToAdd" autocomplete="off" id="QtyBreakQtyToAdd" placeholder="">
					 </div>
					 <div class="form-group">
					 <label for="QtyBreakDiscountRate">Discount Rate</label>
					   <input type="text" class="form-control" name="QtyBreakDiscountRate" autocomplete="off" id="QtyBreakDiscountRate" placeholder="">
					 </div>
					 <div class="form-group">
					 <label for="QtyBreakActive">Active</label>
					   <input type="checkbox" class="form-control" name="QtyBreakActive" autocomplete="off" id="QtyBreakActive" placeholder="">
					 </div>
			   </form>
			 </div>
			 <div class="modal-footer">
			   <button type="button" class="btn btn-danger" id="deleteButton" onclick="deleteQtyBreakItem()" >Delete</button>
			   <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
			   <button type="button" class="btn btn-primary" id="saveButton" onclick="saveQtyBreakItemInfo()">Save</button>
			 </div>
		   </div><!-- /.modal-content -->
		 </div><!-- /.modal-dialog -->
	   </div><!-- /.modal -->
		 
		 
		 
		 
	   <script type="text/javascript">
		   $('[name=filter]').on('keypress', function(e) {
			   if (e.which == 13) {
				   filter();
			   }
		   
		   });
		   
		   function clearFilter() {
			   $('[name=filter]').val("");
			   $('#clearButton').css('display', 'none');
			   $('tr').css('display', '');
			   
		   }
		   function filter() {
			   var	name = $('[name=filter]').val();
			   filterByName(name);
		   }
		   function filterByName(name) {
			   $('#clearButton').css('display', '');
			   for (var i = 0; i < $('tr').length; i++) {
				   if (i != 0) {
					   var result = $('tr')[i].innerText.toUpperCase().indexOf(name.toUpperCase());
					   if (result < 0) {
						   $($('tr')[i]).css('display', 'none');
					   }else {
						   $($('tr')[i]).css('display', '');
					   }
				   }
			   }
		   }
		   function clearModal() {
			   $('#isNew').val("0");
			   $('#QtyBreakID').val("-1");
			   $('#QtyBreakLine').val("");
			   $('#QtyBreakSKU').val("");
			   $('#QtyBreakQtyBreak').val("");
			   $('#QtyBreakQtyToAdd').val("");
			   $('#QtyBreakDiscountRate').val("");
				 $('#QtyBreakActive').prop('checked', false);
			   $('#saveButton').css('display', '');
			   $('#deleteButton').css('display', '');
		   }
		   function addQtyBreak() {
			   clearModal();
			   $('#isNew').val("1");
			   $('#AddEditTitle').text("Add New Quantity Break");
			   $('#AddEditQtyBreak').modal('toggle');
		   }
		   function editQtyBreak(ID) {
			   clearModal();
			   $.get("./mod.php?p=quantitybreak&a=functions&f=getQtyBreakData&id=" + ID, function(data){
				   var qtyBreakData = JSON.parse(data);
				   $('#isNew').val("0");
				   $('#AddEditTitle').text("Edit Quantity Break Item");
				   $('#QtyBreakID').val(qtyBreakData.id);
				   $('#QtyBreakLine').val(qtyBreakData.Line);
				   $('#QtyBreakSKU').val(qtyBreakData.SKU);
				   $('#QtyBreakQtyBreak').val(qtyBreakData.QtyBreak);
				   $('#QtyBreakQtyToAdd').val(qtyBreakData.QtyToAdd);
				   $("#QtyBreakDiscountRate").val(qtyBreakData.DiscountRate);
					 $('#QtyBreakActive').prop('checked', qtyBreakData.Active == "1");
				   $('#AddEditQtyBreak').modal('toggle');
			   });
		   }
			 function deleteQtyBreakItem(){
				if(confirm('Are you sure you want to delete this Quantity Break Item')){
					var ID = $('#QtyBreakID').val();
					$.get('mod.php?p=quantitybreak&a=functions&f=deleteQtyBreak&id=' + ID, function(data){
							if(data.trim() == "true"){
								location.reload();
							}
						});	
				}
			 }
		   function saveQtyBreakItemInfo() {
				var qtyBreakItem = "";
				qtyBreakItem = '{\
				\
				"QtyBreakID" : "' + $('#QtyBreakID').val() + '",\
				"Line" : "' + $('#QtyBreakLine').val() + '", \
				"IsNew" : "' + $('#isNew').val() + '", \
				"SKU" : "' + $('#QtyBreakSKU').val() + '", \
				"QtyBreak" : "' + $('#QtyBreakQtyBreak').val() + '", \
				"QtyToAdd" : "' + $('#QtyBreakQtyToAdd').val() + '", \
				"Active" : "' + $('#QtyBreakActive').prop('checked') + '", \
				"DiscountRate" : "' + $('#QtyBreakDiscountRate').val() + '"}';
			   qtyBreakItem = JSON.parse(qtyBreakItem);
			   $.post( "mod.php?p=quantitybreak&a=functions&f=saveQtyBreakData", qtyBreakItem)
					.done(function( data ) {
						data = JSON.parse(data);
						if (data.result === true) {
							clearModal();
							$('#AddEditQuantityBreak').modal('toggle');
								location.reload();
							}else {
								alert("There has been an error saving the Quantity Break data.\r\n\r\nMySQL Error: " + data.error);
							}
				});
		   }
		   </script>
	
	 </div>    
     
   </body>
 </html>