<?php 
include_once("../connect.php");
include_once("../session.php");

$webTitle = "Receive Report";
$poid = mysqli_real_escape_string($con,$_REQUEST['poid']);
 ?>
 
 <!DOCTYPE html>
 <html lang="en">
   <head>
     <meta charset="utf-8">
     <meta http-equiv="X-UA-Compatible" content="IE=edge">
     <meta name="viewport" content="width=device-width, initial-scale=1">
     <title><?= $config['CompanyName'] ?> - <?= $webTitle ?></title>
 
     <!-- Bootstrap -->
     <link href="../css/bootstrap.min.css" rel="stylesheet">
     <link rel="stylesheet" href="../css/bootstrap-combobox.css" />
 
     <!-- HTML5 shim and Respond.js for IE8 support of HTML5 elements and media queries -->
     <!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
     <!--[if lt IE 9]>
       <script src="https://oss.maxcdn.com/html5shiv/3.7.2/html5shiv.min.js"></script>
       <script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
       <!-- jQuery (necessary for Bootstrap's JavaScript plugins) -->
           <script src="https://ajax.googleapis.com/ajax/libs/jquery/1.11.1/jquery.min.js"></script>
           <!-- Include all compiled plugins (below), or include individual files as needed -->
           <script src="../js/bootstrap.min.js"></script>
       	 <script src="../js/bootstrap-combobox.js"></script>
       	 <script src="../js/excellentexport.js"></script>
           <script type="text/javascript">
             $(document).ready(function(){
       //        $('.grpline').css("width", "100px");
             });
           </script>

     <![endif]-->
	<link rel="stylesheet" href="../css/styles.css"/>
   </head>
   <body>
   
       <?php
	   //error_reporting(E_ALL);
	   include("navbar.php"); ?>     

   
   <!-- Stack the columns on mobile by making one full-width and the other half-width -->
<div class="container " style="padding-top: 10px;">
	<div class="panel panel-default">
	  <div class="panel-heading form-inline">
	  
	  
	  	
	  		    <h3 class="panel-title">Receive Report</h3><br />
						<div class="pull-left">
						<a href="mod.php?p=purchasing&a=receive&poid=<?= $poid ?>" class="btn btn-primary">
							Go Back
						</a>
						<a href="mod.php?p=purchasing&a=printreceivereport&poid=<?= $poid ?>" class="hidden-print btn btn-primary">
							Print
						</a>
						
					</div>
	  </div>
	  <div class="panel-body">
	  	<table class="table table-hover table-condensed" id="receiveReportTable">
	  		<thead>
	  			<tr>
						<th>SKU</th>
						<th>Recevied</th>
						<th>Packages</th>
						<th>Locations</th>
						<th></th>
	  			</tr>
	  			
	  		</thead>
			<tbody>
	    <?php
		$query = "SELECT id FROM PURCHASE_ORDER_HEADER JOIN PURCHASE_ORDER_DETAIL USING(PurchaseOrderID) WHERE PurchaseOrderID = $poid";
		//echo $query;
		$result = mysqli_query($con,$query);
		while($row = mysqli_fetch_array($result)){
			//$invoice = new Invoice(322);
			$poItem = new PurchaseOrderItem($row['id']);
			$poItemObj = new Item($poItem->Group, $poItem->Line, $poItem->SKU);
			$rowClass = $poItem->ReceivedQty==$poItem->ConfirmedQty?"success":"danger";
		?>
				<tr class="<?= $rowClass ?>">
					<td>
					<?= $poItem->SKU ?></td>
					<td><?= $poItem->ReceivedQty . "/" . $poItem->ConfirmedQty ?></td>
					<td><?= $poItem->PackagesReceived ?></td>
					<td><?php
						echo implode("<br>",array_filter($poItemObj->getLocations()));
					?></td>
					<td><?php
					
					?>
					
					
					<a class="btn btn-warning" onclick="editReceivedQty('<?= $poItem->id ?>', prompt('PleaseEnter the amount received:'))" href="#">Edit</a></td>
					<?php
					
					?>
					
					
				</tr>
		<?php
		}
		?>
			</tbody>
	     </table>
	  </div>
	  <div class="panel-footer" >
			<div class="pull-left">
				<a href="mod.php?p=purchasing&a=receive&poid=<?= $poid ?>" class="btn btn-primary">
					Go Back
				</a>
				
			</div>
	  	<div class="pull-right">
				<button onclick="setReceived();" class="btn btn-primary">
					Finalize
				</button>
				
			</div>
			<br>
				<br>
	  </div>
	</div>

</div>       
	<script type="text/javascript">
		function setReceived(){
			$.post('mod.php', {
					"p"	:	"purchasing",
					"a"	:	"functions",
					"f"	:	"setPOReceived",
					"po" : "<?= $poid ?>", 
					
				}, function(data){
				if(data == "true"){
					
						window.location = "index.php";
					
				}
				
			});	
		}
	function editReceivedQty(id, qty){
		if(!isNaN(parseInt(qty))){
			
		
			$.post('mod.php', {
					"p"	:	"purchasing",
					"a"	:	"functions",
					"f"	:	"saveReviewFieldItem",
					"poid" : "<?= $poid ?>", 
					"id":	id + "-ReceivedQty",
					"value": qty,
					
				}, function(data){
				if(data != "false"){
					
						location.reload();
					
				}
				
			});
		}
	}
	$('[name=filter]').on('keypress', function(e) {
		if (e.which == 13) {
			filter();
		}
	
	});
	function clearFilter() {
		$('[name=filter]').val("");
		$('#clearButton').css('display', 'none');
		$('tr').css('display', '');
		
	}
	function filter() {
		var	name = $('[name=filter]').val();
		filterByName(name);
	}
	function filterByName(name) {
		$('#clearButton').css('display', '');
		var cols = $('#paymenthistory th').length;
		for (var i = 0; i < $('#paymenthistory td').length; i=i+cols) {
		
			var text = $($('td')[i]).text();
			
			var result = text.toUpperCase().indexOf(name.toUpperCase());
			if (text != name) {
				$($('tr')[i/cols+1]).css('display', 'none');
			}else {
				$($('tr')[i/cols+1]).css('display', '');
			}
			
		}
	}
	</script>

   </body>
   
 </html>