<?php
if(stripos($_SERVER['SCRIPT_NAME'],"/admin/")===false?false:true){
	include_once("../connect.php");
	include_once("../session.php");
}else{
	include_once("connect.php");
	include_once("session.php");
}
?>
<!doctype html>
<html>
	<head>
		<meta http-equiv="content-type" content="text/html; charset=utf-8" />
		<meta name="viewport" content="width=device-width, initial-scale=1">
		<title>Receive Inventory</title>
		
		
		<link href="../css/bootstrap.min.css" rel="stylesheet">
		<link rel="stylesheet" href="../css/bootstrap-combobox.css" />
		

		<script src="https://ajax.googleapis.com/ajax/libs/jquery/1.11.1/jquery.min.js"></script>
		
		<script src="../js/functions.js"></script>
		
		<script type="text/javascript" charset="utf-8" src="../js/bootstrap.min.js"></script>
		
		<style>
			input[type="color"],
			input[type="date"],
			input[type="datetime"],
			input[type="datetime-local"],
			input[type="email"],
			input[type="month"],
			input[type="number"],
			input[type="password"],
			input[type="search"],
			input[type="tel"],
			input[type="text"],
			input[type="time"],
			input[type="url"],
			input[type="week"],
			select:focus,
			textarea {
			  font-size: 16px;
			}
		</style>
	</head>
	<body class="bootstrap" style="">
       <?php
		include_once("./navbar.php");
		?>
		<h2>
			Receive Inventory
			</h2>
		<?php
			$po = new PurchaseOrder($_REQUEST['poid']);
		?>
			<h4><?= $po->Vendor->Name ?>
			<br>
			
			<div class="row">
				<div class="col-xs-7">
					Invoice: <?= $po->InvoiceNumber ?>
				</div>
				<div class="col-xs-5">
					PO: <?= $po->PurchaseOrderID ?>
				</div>
			</div>
			
		</h4>
		
		<div class="container">
			<div class="row">
				<div class="col-sm-6">
					<div class="form-horizontal">
						<div class="form-group">
						  <label for="ProductUPC" class="col-sm-2 control-label">UPC</label>
						  <div class="col-sm-10">
							<input type="text" class="form-control" id="ProductUPC" placeholder="UPC">
						  </div>
						</div>
						<div class="form-group">
						  <div class="col-sm-offset-2 col-sm-10">
							<button type="button" id="setNewItem" class="btn btn-default">New Item</button>
							<button type="button" id="undoLastScan" class="btn btn-default">Undo</button>
						  </div>
						</div>
					</div>
				</div>
				<div class="col-sm-12">
					<table class="table table-condensed">
						<thead>
							<tr>
								<th></th>
								<th></th>
							</tr>
						</thead>
						<tbody>
							<tr>
								<td>Current Item</td>
								<td><span style="font-size: 32px; font-weight: bold;" id="currItem">Not Set</span></td>
							</tr>
							<tr>
								<td>Received</td>
								<td><span style="font-weight: bold;" id="currItemReceived">Not Set</span></td>
							</tr>
							<tr>
								<td>Packages</td>
								<td><span style="font-weight: bold;" id="packagesStatus">Not Set</span></td>
							</tr>
						</tbody>
					</table>
					
					<div id="alertBox"></div>
				</div>
				<div class="col-sm-12">
					<a class="btn btn-default btn-block" href="mod.php?p=purchasing&a=receivereport&poid=<?= $po->PurchaseOrderID ?>">Receiving Report</a>
					<table class="table">
					<thead>
						<tr>
							<th></th>
							<th></th>
							<th></th>	
						</tr>
					</thead>
					<tbody>
						
					</tbody>
				  </table>
				</div>
			</div>
		</div>
		
		
		<!-- Assign UPC Modal -->
		<div class="modal fade" id="AssignUPCModal" tabindex="-1" role="dialog">
			<div class="modal-dialog" role="document">
			  <div class="modal-content">
				<div class="modal-header">
				  <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
				  <h4 class="modal-title">Assing UPC to Existing Product</h4>
				</div>
				<div class="modal-body">
					This UPC code is not recognized, please assing this UPC to an existing item in the following form.
					<br>
					<div class="">
					  <div class="form-horizontal">
						  <div class="form-group">
							<label for="AssingUPCSKU" class="col-sm-2 control-label">SKU</label>
							<div class="col-sm-10">
							  <input type="text" class="form-control" id="AssingUPCSKU" placeholder="SKU">
							</div>
						  </div>
						  <div class="form-group">
							<label for="AssingUPCLine" class="col-sm-2 control-label">Line</label>
							<div class="col-sm-10">
							  <input type="text" class="form-control" id="AssingUPCLine" placeholder="Line">
							</div>
						  </div>
						  <div class="form-group">
							<label for="AssingUPCQty" class="col-sm-2 control-label">Qty</label>
							<div class="col-sm-10">
							  <input type="text" class="form-control" value="1" id="AssingUPCQty" placeholder="Qty">
							</div>
						  </div>
					  </div>
				  </div>
				</div>
				<div class="modal-footer">
					<button type="button" onclick="saveAssingUPC();" class="btn btn-primary">Save</button>
					<button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
				</div>
			  </div><!-- /.modal-content -->
			</div><!-- /.modal-dialog -->
		</div><!-- /.modal -->
		
		<script type="text/javascript">
			var currentUPC = "";
			$(document).ready(function(){
				$('#ProductLocation').focus();
				});
			
			
			$('#ProductUPC').on('keyup', function(e){
				if($('#ProductLocation').val() == ""){
					
				}
				if(e.keyCode == 13 || e.keyCode == 0){
					receiveItem($('#ProductUPC').val());
					$('#ProductUPC').val('');
				}
				});
			
			
			$('#setNewItem').on('click', function(){
				//clearLocationSlotModal();
				$('#currItem').html('');
				$('#ProductUPC').val('');
				$('#ProductUPC').focus();
				
			});
			function receiveItem(upc){
				
				currentUPC = upc;
				$.get('mod.php', {
					"p"		: "purchasing",
					"a"		: "functions",
					"f" 	: "receiveByUPC",
					"poid"	: "<?= $_REQUEST['poid'] ?>",
					"upc"	: upc,
					}, function(data){
						data = JSON.parse(data);
						if(data.Result){
							$('#undoLastScan').prop('disabled', false);
							$('#currItem').text(data.Data.SKU);
							$('#currItemReceived').html(data.Data.ReceivedQty + "/" + data.Data.ConfirmedQty + " <span style=\"color: red;\">(" + ((data.Data.ConfirmedQty-data.Data.ReceivedQty)/data.Data.BoxQty).toFixed(2) + ")</span>");
							$('#packagesStatus').text(data.Data.PackagesReceived + "/" + data.Data.Packages);
							if(data.Data.ReceivedQty>data.Data.ConfirmedQty){
								alertBox("warning", "Successfully Received " + data.Data.CurrentReceivedQty + " units of the item #" + data.Data.SKU + " <br><h4>THE SCANNED QTY EXCEEDS CONFIRMED QTY</h4>", "#alertBox");
							}else{
								alertBox("success", "Successfully Received " + data.Data.CurrentReceivedQty + " units of the item #" + data.Data.SKU + "", "#alertBox");	
							}
							
						}else if(data.Error == 'upc_not_exists'){
							$('#AssignUPCModal').modal();
							$('#AssingUPCSKU').val('');
							$('#AssingUPCLine').val('');
							$('#AssingUPCQty').val('1');
							setTimeout(function(){
								$('#AssingUPCSKU').focus();
								$('#AssingUPCSKU').select();	
							}, 500);
							
							
						}
						
					
				});
				
			}
			$('#undoLastScan').on('click' , function(){
				undoReceiveItem();
			});
			function undoReceiveItem(){
				$('#undoLastScan').prop('disabled', true);
				upc = currentUPC;
				$.get('mod.php', {
					"p"		: "purchasing",
					"a"		: "functions",
					"f" 	: "receiveByUPC",
					"undo"	: "true",
					"poid"	: "<?= $_REQUEST['poid'] ?>",
					"upc"	: upc,
					}, function(data){
						data = JSON.parse(data);
						if(data.Result){
							$('#currItem').text(data.Data.SKU);
							$('#currItemReceived').html(data.Data.ReceivedQty + "/" + data.Data.ConfirmedQty);
							$('#packagesStatus').text(data.Data.PackagesReceived + "/" + data.Data.Packages);
							alertBox("success", "Successfully Undone last action " + data.Data.CurrentReceivedQty + " units of the item #" + data.Data.SKU + "", "#alertBox");
						}else if(data.Error == 'upc_not_exists'){
							$('#AssignUPCModal').modal();
							$('#AssingUPCSKU').val('');
							$('#AssingUPCLine').val('');
							$('#AssingUPCQty').val('1');
							setTimeout(function(){
								$('#AssingUPCSKU').focus();
								$('#AssingUPCSKU').select();	
							}, 500);
							
							
						}
						
					
				});
				
			}
			$('#AssingUPCSKU').on("change", function(){
				$.get("mod.php?p=inventorymanage&a=functions&f=getItemLineBySKU&sku=" + $('#AssingUPCSKU').val(), function(data){
					$('#AssingUPCLine').val(data);
					$('#AssingUPCQty').focus();
				});
			});
			function saveAssingUPC(){
				var SKU = $('#AssingUPCSKU').val();
				var Line = $('#AssingUPCLine').val();
				var Qty = $('#AssingUPCQty').val();
				var UPC = currentUPC;
				$.get('mod.php?p=inventorymanage&a=functions&f=addUPCtoItem&line=' + Line + '&sku=' + SKU + "&upc=" + UPC + "&qty=" + Qty, function(data){
					data = JSON.parse(data);
					if(data.Result){
						receiveItem(currentUPC);
						$('#AssignUPCModal').modal('hide');
						
						
					}else{
						alert(data.Error);
					}
				});
			}
			
		</script>
	</body>
</html>
