<?php
include_once("../connect.php");
include_once("../session.php");




?>
<!DOCTYPE html>
 <html lang="en">
   <head>
     <meta charset="utf-8">
     <meta http-equiv="X-UA-Compatible" content="IE=edge">
     <meta name="viewport" content="width=device-width, initial-scale=1">
     <title><?= $config['CompanyName'] ?> - Manage Vendors</title>

     <!-- Bootstrap -->
     <link href="../css/bootstrap.min.css" rel="stylesheet">
     <link rel="stylesheet" href="../css/bootstrap-combobox.css" />

     <!-- HTML5 shim and Respond.js for IE8 support of HTML5 elements and media queries -->
     <!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
     <!--[if lt IE 9]>
       <script src="https://oss.maxcdn.com/html5shiv/3.7.2/html5shiv.min.js"></script>
       <script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
       <!-- jQuery (necessary for Bootstrap's JavaScript plugins) -->
           <script src="https://ajax.googleapis.com/ajax/libs/jquery/1.11.1/jquery.min.js"></script>
           <!-- Include all compiled plugins (below), or include individual files as needed -->
           <script src="../js/bootstrap.min.js"></script>
       	 <script src="../js/bootstrap-combobox.js"></script>
       	 <script src="../js/excellentexport.js"></script>
           <script type="text/javascript">
             $(document).ready(function(){
       //        $('.grpline').css("width", "100px");
             });
           </script>

     <![endif]-->
	<link rel="stylesheet" href="../css/styles.css"/>
   </head>
   <body>

       <?php include("navbar.php"); ?>


   <!-- Stack the columns on mobile by making one full-width and the other half-width -->

	<div class="container " style="padding-top: 10px;">
		<div class="panel panel-default">
			<div class="panel-heading form-inline">
				<div style="margin-right: 10px; float: right;">
						<button id="addNewVendorButton" onclick="openCreateNewVendor();" class="btn btn-primary">Add New Vendor</button>
				</div>
				<h3>Vendors</h3>
			</div>
			<div class="panel-body">
				<div class="row">
					<p class="lead"></p>
					<table class="table table-condensed">
						<thead>
							<tr>
								<th>VendorID</th>
								<th>Vendor Name</th>
								<th>Contact</th>
								<th>Contact Phone</th>
								<th>City</th>
								<th>Our Account</th>
								<th></th>
							</tr>
						</thead>
						<tbody>

			<?php
			//WHERE status != done
			$query = "SELECT VendorID FROM VENDOR ORDER BY `Name`";
			$result = mysqli_query($con, $query);

			while($row = mysqli_fetch_array($result)){
				$vendor = new Vendor($row['VendorID']);
				//$user = new Administrator($ticket->Username);
			?>
							<tr onclick="">
								<td><a href="#" onclick="editVendor('<?= $vendor->VendorID ?>')" class="btn btn-primary"><?= $vendor->VendorID ?></a></td>
								<td><?= $vendor->Name ?></td>
								<td><?= $vendor->Contact ?></td>
								<td><?= $vendor->ContactPhone ?></td>
								<td><?= $vendor->PostalCity ?></td>
								<td><?= $vendor->OurAccountNumber ?></td>
								<td><a href="#" onclick="deleteVendor('<?= $vendor->VendorID ?>')" class="btn btn-danger"><span class="glyphicon glyphicon-trash"></span></a></td>
								<td></td>
							</tr>
			<?php
			}
			?>
						</tbody>
					</table>
				</div>
			</div>
			<div class="panel-footer" style="" >

			</div>
		</div>
	</div>
	<div id="CreateNewVendorModal" class="modal fade" tabindex="-1" role="dialog">
		<div class="modal-dialog" role="document">
			<div class="modal-content">
				<div class="modal-header">
					<button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
					<h4 class="modal-title" id="VendorModalTitle">Create New Vendor</h4>
				</div>
				<div class="modal-body">
          <div class="form-group">
						<label for="VendorModalVendorID">VendorID</label>
						<input type="text" readonly class="form-control" name="VendorModalVendorID" data-column="VendorID" id="VendorModalVendorID">
					</div>
					<div class="form-group">
						<label for="VendorModalName">Company Name</label>
						<input type="text" class="form-control" name="VendorModalName" data-column="Name" id="VendorModalName">
					</div>
					<div class="form-group">
						<label for="VendorModalContact">Contact</label>
						<input type="text" class="form-control" name="VendorModalContact" data-column="Contact" id="VendorModalContact">
					</div>
          <div class="form-group">
						<label for="VendorModalContactPhone">Contact Phone</label>
						<input type="text" class="form-control" name="VendorModalContactPhone" data-column="ContactPhone" id="VendorModalContactPhone">
					</div>
          <div class="form-group">
						<label for="VendorModalContactEmail">Contact Email</label>
						<input type="text" class="form-control" name="VendorModalContactEmail" data-column="ContactEmail" id="VendorModalContactEmail">
					</div>
          <div class="form-group">
						<label for="VendorModalOrderEmail">Order Email</label>
						<input type="text" class="form-control" name="VendorModalOrderEmail" data-column="OrderEmail" id="VendorModalOrderEmail">
					</div>
          <div class="form-group">
						<label for="VendorModalPostalAddress1">Postal Address</label>
						<input type="text" class="form-control" name="VendorModalPostalAddress1" data-column="PostalAddress1" id="VendorModalPostalAddress1">
					</div>
          <div class="form-group">
						<label for="VendorModalPostalAddress2">Postal Address 2</label>
						<input type="text" class="form-control" name="VendorModalPostalAddress2" data-column="PostalAddress2" id="VendorModalPostalAddress2">
					</div>
          <div class="form-group">
						<label for="VendorModalPostalCity">Postal City</label>
						<input type="text" class="form-control" name="VendorModalPostalCity" data-column="PostalCity" id="VendorModalPostalCity">
					</div>
          <div class="form-group">
						<label for="VendorModalPostalState">Postal State</label>
						<input type="text" class="form-control" name="VendorModalPostalState" data-column="PostalState" id="VendorModalPostalState">
					</div>
          <div class="form-group">
						<label for="VendorModalPostalZip">Postal Zip</label>
						<input type="text" class="form-control" name="VendorModalPostalZip" data-column="PostalZip" id="VendorModalPostalZip">
					</div>
          <div class="form-group">
						<label for="VendorModalOurAccountNumber">Our Account Number</label>
						<input type="text" class="form-control" name="VendorModalOurAccountNumber" data-column="OurAccountNumber" id="VendorModalOurAccountNumber">
					</div>

				</div>
				<div class="modal-footer">
					<button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
					<button type="button" onclick="saveVendor();" class="btn btn-primary">Submit</button>
				</div>
			</div><!-- /.modal-content -->
		</div><!-- /.modal-dialog -->
	</div><!-- /.modal -->
	<script type="text/javascript">
    function openCreateNewVendor(){
      $('input[id^=VendorModal]').val('');
      $('#VendorModalTitle').text('Create New Vendor');
      $('#CreateNewVendorModal').modal('toggle');

    }
    function deleteVendor(VendorID){
      var promptMessage = prompt("Are you sure you want to delete this Vendor? \n Please write YES to continue");
      if(promptMessage == "YES" || promptMessage == "yes"){
        $.post("mod.php?p=purchasing&a=functions&f=deleteVendor", {
          "vid" : VendorID

        },function(data){
          if(data == "true"){
            location.reload();
          }
        });
      }

    }
    function editVendor(VendorID){
      $.get('mod.php?p=purchasing&a=functions&f=getVendorInfo&vid=' + VendorID, function(data){
        data = JSON.parse(data);
        $('#VendorModalTitle').text('Edit Vendor');
        $('input[id^=VendorModal]').each(function(){
          $(this).val(data[$(this).data('column')]);
        });
        $('#CreateNewVendorModal').modal('toggle');
      });
    }
    function saveVendor(){
      var data = {};
      $('input[id^=VendorModal]').each(function(){ data[$(this).data('column')] = $(this).val()});
      $.post("mod.php?p=purchasing&a=functions&f=saveVendor", {
        "data" : (data)
      }, function(output){
          if(output == "true"){
            location.reload();
          }
      });
    }
	</script>


   </body>
 </html>
