<?php
include_once("../connect.php");
include_once("../session.php");


$isAdmin = $_SESSION['isAdmin'];
if (!$isAdmin) {
	header("Location: logout.php");
}



 ?>
 <!DOCTYPE html>
  <html lang="en">
    <head>
      <meta charset="utf-8">
      <meta http-equiv="X-UA-Compatible" content="IE=edge">
      <meta name="viewport" content="width=device-width, initial-scale=1">
      <title><?= $config['CompanyName'] ?></title>

      <!-- Bootstrap -->
      <link href="<?= $root ?>css/bootstrap.min.css" rel="stylesheet">
      <link rel="stylesheet" href="<?= $root ?>css/bootstrap-combobox.css" />

      <!-- HTML5 shim and Respond.js for IE8 support of HTML5 elements and media queries -->
      <!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
      <!--[if lt IE 9]>
        <script src="https://oss.maxcdn.com/html5shiv/3.7.2/html5shiv.min.js"></script>
        <script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
        <!-- jQuery (necessary for Bootstrap's JavaScript plugins) -->
            <script src="https://ajax.googleapis.com/ajax/libs/jquery/1.11.1/jquery.min.js"></script>
            <!-- Include all compiled plugins (below), or include individual files as needed -->
            <script src="<?= $root ?>js/bootstrap.min.js"></script>
        	 <script src="<?= $root ?>js/bootstrap-combobox.js"></script>
            <script type="text/javascript">
              $(document).ready(function(){
        //        $('.grpline').css("width", "100px");
              });
            </script>

      <![endif]-->
 	<link rel="stylesheet" href="<?= $root ?>css/styles.css"/>
	<style>
		.paymentSummaryHeader{
			font-weight: bold;
		}
		body{
			font-size: small;
		}

	</style>
    </head>
    <body>

        <?php
        		include("navbar.php");


        ?>


    <!-- Stack the columns on mobile by making one full-width and the other half-width -->
 <?php

 $reconciliationID = $_REQUEST['id'];

 $reconciliation = new SalesmanReconciliation($reconciliationID);



 ?>
 <div class="container-fluid" style="padding-top: 5px;">
 	<div class="row">
 	  <div class="col-xs-5">
 	  	<img class="img-responsive" style="width: 200px;" src="<?= $root ?>img/<?= $config['Logo'] ?>" alt="" />
		<?php
		$sm = new Salesman($reconciliation->SalesmanID);
		?>
		<br>
		<br>
		<span><b>Salesperson:</b> <?= $sm->Name ?></span><br>
		<b>Date: </b><?= date("m/d/Y",strtotime($reconciliation->ReconcileDate)) ?><br>
		  <b>Time: </b><?= date("h:i a",strtotime($reconciliation->ReconcileDate)) ?><br>
		  <b>Created By: </b><?= $reconciliation->ReconcileUser ?>

 	  </div>
  	  <div class="col-xs-2">

	  </div>
 	  <div class="col-xs-3 pull-right" style="margin-top: -20px;  text-align: right;">
 		  <h3>Salesperson<br>Reconciliation</h3>
 		  <p style="margin-top: -120px;">
 		  	<h1><span ><b><?= $reconciliation->ReconcileID ?></b></span></h1>
          </p>

 		  	<h1 class="hidden-print" style="margin-top: 70px;"><span ><b><?= $reconciliation->ReconcileID ?></b></span></h1>
          <?= insertPrintButton(); ?>
 	  </div>
	</div>
	<div class="row">

			<div class="col-xs-12 col-md-6">
				<h4>Payments</h4>
				<table class="table table-condensed" style="font-size: 10pt;">
				  <thead>
					<tr>
					  <th style="width: 10%">PaymentID</th>
					  <th style="width: 40%">Customer</th>
					  <th style="width: 15%">Date/Time</th>
					  <th style="width: 15%; text-align: right;">Cash</th>
					  <th style="width: 15%; text-align: right;">Check</th>
					  <th style="width: 15%; text-align: right;">Transfer</th>
					  <th style="width: 15%; text-align: right;">Total</th>
					</tr>
				  </thead>
				  <tbody>
				  <?php



						$totalChecks = 0;
						$totalCash = 0;
						$totalTransfer = 0;
						$checksCount = 0;
						$paymentCount = count($reconciliation->Payments);
						foreach($reconciliation->Payments as $paymentID){

							$payment = new Payment($paymentID);
							$totalCash += $payment->CashAmount;
							$totalChecks += $payment->CheckAmount;
							$totalTransfer += $payment->TransferAmount;
							$checksCount += count($payment->Checks);

				  ?>
					  <tr>
							  <td>
								  <span class="itemInfo"><?= $payment->PaymentID ?></span>
							  </td>
							  <td>
								  <span class="itemInfo"><?= $payment->Customer->Name ?></span>
							  </td>
							  <td>
								  <span class="itemInfo"><?= date("m/d/Y", strtotime($payment->PaymentDate)) ?></span>
							  </td>
							  <td style=" text-align: right;">
								  <span class="itemInfo"><?= moneyFormat($payment->CashAmount) ?></span>
							  </td>
							  <td  style=" text-align: right;">
								  <span class="itemInfo"><?= moneyFormat($payment->CheckAmount) ?></span>
							  </td>
							  <td style=" text-align: right;">
								  <span class="itemInfo"><?= moneyFormat($payment->TransferAmount) ?></span>
							  </td>
							  <td style=" text-align: right;">
								  <span class="itemInfo"><?= moneyFormat($payment->CashAmount+$payment->CheckAmount+$payment->TransferAmount) ?></span>
							  </td>

					  </tr>
					  <?php

					  }?>
					  <tr>
							<td></td>
						  <td><b><?= $paymentCount ?></b> <?= $paymentCount==1?"payment":"payments" ?></td>
						  <td></td>
						  <td style=" text-align: right;"><b><?= moneyFormat($totalCash) ?></b></td>
						  <td style=" text-align: right;"><b><?= moneyFormat($totalChecks) ?></b></td>
						  <td style=" text-align: right;"><b><?= moneyFormat($totalTransfer) ?></b></td>
						  <td style=" text-align: right;"><b><?= moneyFormat($totalChecks+$totalCash+$totalTransfer) ?></b></td>

					  </tr>

				  </tbody>
				</table>
			</div>

	</div>

	<div class="row">
		<div class="col-xs-8 col-md-6">
				<h4>Checks Details</h4>
				<?php
				if($checksCount){

				?>
				<table class="table table-condensed" style="font-size: 10pt;">
					<thead>
						<tr>
							<th>Customer</th>
							<th>Check No.</th>
							<th>Amount</th>
						</tr>
					</thead>
					<tbody>
						<?php
						foreach($reconciliation->Payments as $paymentID){
							$payment = new Payment($paymentID);
							foreach($payment->Checks as $check){


						?>
								<tr>
									<td><?= $payment->Customer->Name ?></td>
									<td><?= $check->CheckNumber ?></td>
									<td><?= moneyFormat($check->Amount) ?></td>
								</tr>
						<?php
							}
						}
						?>
						<tr>
							<td></td>
							<td><b><?= $checksCount ?></b> <?= $checksCount==1?"check":"checks" ?></td>
							<td><?= moneyFormat($totalChecks) ?></td>
						</tr>
					</tbody>

				</table>
				<?php
				}else{
				?>
					No checks in this reconciliation
				<?php

				}
				?>


			</div>
	</div>
	<div class="row">
		<div class="col-xs-4 col-md-6">
				<h4>Grand Total Received </h4><i>Checks and Cash</i><br>
				<span>Grand Total: <b><?= moneyFormat($totalCash+$totalChecks) ?></b></span>
			</div>
	</div>
	<br>
	<br>
     <div>
        <span><b><big>Notes: </big></b><?= $reconciliation->Notes ?></span>
     </div>
</div>

        <div class="panel panel-default">
          <div class="panel-body">


          </div>
        </div>

    </body>
  </html>
