<?php
include("../connect.php");
include("../session.php");

$for = $_REQUEST['by'];
$title = "";
$fromDate = $_REQUEST['fromDate'];
$toDate = $_REQUEST['toDate'];
switch ($for) {
	case "customer":
		$customer = new Customer($_REQUEST["customer"]);
		$title = " - By Customer: " . $customer->Name;
		break;
	case "salesman":
		$salesman = new Salesman($_REQUEST['salesman']);
		$title = " - By Salesman: " . $salesman->Name;
		break;
	case "date":
		$title = " - By Date: ";
		break;
}

function getElapsedTime($from, $to){
	$from = strtotime($from);
	$to = strtotime($to);
	return (secondsToTime($to-$from));

}
function secondsToTime($s)
{
    $h = floor($s / 3600);
    $s -= $h * 3600;
    $m = floor($s / 60);
    $s -= $m * 60;
    return $h.':'.sprintf('%02d', $m).':'.sprintf('%02d', $s);
}

 ?>

 <!DOCTYPE html>
 <html lang="en">
   <head>
     <meta charset="utf-8">
     <meta http-equiv="X-UA-Compatible" content="IE=edge">
     <meta name="viewport" content="width=device-width, initial-scale=1">
     <title><?= $config['CompanyName'] ?> - Invoice History From: <?= date('m-d-Y', strtotime($from)) ?> To: <?= date('m-d-Y', strtotime($to)) ?></title>

     <!-- Bootstrap -->
     <link href="../css/bootstrap.min.css" rel="stylesheet">
     <link rel="stylesheet" href="../css/bootstrap-combobox.css" />

     <!-- HTML5 shim and Respond.js for IE8 support of HTML5 elements and media queries -->
     <!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
     <!--[if lt IE 9]>
       <script src="https://oss.maxcdn.com/html5shiv/3.7.2/html5shiv.min.js"></script>
       <script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
       <!-- jQuery (necessary for Bootstrap's JavaScript plugins) -->
           <script src="https://ajax.googleapis.com/ajax/libs/jquery/1.11.1/jquery.min.js"></script>
           <!-- Include all compiled plugins (below), or include individual files as needed -->
           <script src="../js/bootstrap.min.js"></script>
       	 <script src="../js/bootstrap-combobox.js"></script>
       	 <script src="../js/excellentexport.js"></script>
           <script type="text/javascript">
             $(document).ready(function(){
       //        $('.grpline').css("width", "100px");
				$('.panel-heading').after($('.panel-footer').clone().addClass('hidden-print'))
             });
           </script>

     <![endif]-->
	<link rel="stylesheet" href="../css/styles.css"/>
   </head>
   <body>

       <?php include("navbar.php"); ?>


   <!-- Stack the columns on mobile by making one full-width and the other half-width -->
<div class="container " style="padding-top: 10px; width: 95%;">
	<div class="panel panel-default">
	  <div class="panel-heading form-inline">
	  <a class="btn btn-success hidden-print" role="button" style="float: right;" href="#" download="InvoiceHistory<?= $title . "(" . date("m.d.Y",strtotime($fromDate)) . " - " . date("m.d.Y",strtotime($toDate)) . ")" ?>.xls" href="#" onclick="return ExcellentExport.excel(this, 'invoicehistory', 'Invoice History');" data-toggle="tooltip" data-placement="left" title="Does not work with Internet Explorer">Export To Excel</a>

	  	<div style="margin-right: 10px; float: right;">
	  			<div class="input-group hidden-print" >
	  			      <div id="clearButton" style="display: none;" class="input-group-addon" onclick="clearFilter()">
	  			      	<span class="glyphicon glyphicon-remove" aria-hidden="true"></span></div>
	  			      <input type="text" class="form-control" name="filter" placeholder="Invoice ID" value="" />
	  			      <div class="input-group-addon" onclick="filter()">
	  			      	<span class="glyphicon glyphicon-search" aria-hidden="true"></span></div>
	  			    </div>
	  	</div>

	  		    <h3 class="panel-title">Invoice History<?= $title . " - <i>From: " . date("m/d/Y",strtotime($fromDate)) . " To: " . date("m/d/Y",strtotime($toDate)) . "</i>"?></h3><br />

				<form method="get" action="" class="hidden-print">
	  		    	<select class="form-control" name="sort">
	  		    		<option value="InvoiceID">Invoice ID</option>
	  		    		<option value="Name">Customer Name</option>

	  		    	</select>
	  		    	<select class="form-control" name="direction">
	  		    		<option <?= (isset($_REQUEST['direction']) && $_REQUEST['direction'] == "ASC")?"selected":"" ?> value="ASC">Ascending</option>
	  		    		<option <?= (isset($_REQUEST['direction']) && $_REQUEST['direction'] == "DESC")?"selected":"" ?> value="DESC">Descending</option>
	  		    	</select>
	  		    	<input type="hidden" name="a" value="<?= $_REQUEST["a"] ?>" />
	  		    	<input type="hidden" name="fromDate" value="<?= $_REQUEST["fromDate"] ?>" />
	  		    	<input type="hidden" name="toDate" value="<?= $_REQUEST["toDate"] ?>" />
	  		    	<input type="submit" class="form-control" name="" value="Sort" />
	  		    </form>
	  </div>
	  <div class="panel-body">
	  	<table class="table table-hover table-condensed" id="invoicehistory">
	  		<thead>
	  			<tr>
	  				<th>Invoice ID</th>
	  				<?= ($for != "customer") ? "<th>Customer</th>" : "" ?>
	  				<th>Invoice Date/Time</th>

	  				<th class="hidden-print">PO Number</th>
	  				<th>Salesman</th>
					<th>Status</th>
	  				<th style="text-align: center;">Total</th>
	  				<th></th>
	  			</tr>

	  		</thead>
			<tbody>
	    <?php
	    if (isset($_REQUEST['sort'])) {
	    	if ($_REQUEST['sort'] != "") {
	    		$sort = $_REQUEST['sort'];
	    		$direction = $_REQUEST['direction'];
	    	}
	    }else {
	    	$sort = "InvoiceID";
	    	$direction = "DESC";
	    }

	    if ($for == "customer") {
	    	$query = "SELECT *, IF(InvoiceID IN (SELECT InvoiceID FROM DELIVERY_RECORD WHERE DropoffDate IS NULL),1,0) InRoute FROM INVOICE_HEAD, CUSTOMER WHERE INVOICE_HEAD.AccountNumber LIKE '" . $customer->AccountNumber . "' AND DATE(CreationDate) BETWEEN '$fromDate' AND '$toDate' AND CUSTOMER.AccountNumber = INVOICE_HEAD.AccountNumber ORDER BY $sort $direction";
	    }elseif($for == "salesman") {
	    	$query = "SELECT *, IF(InvoiceID IN (SELECT InvoiceID FROM DELIVERY_RECORD WHERE DropoffDate IS NULL),1,0) InRoute FROM INVOICE_HEAD, CUSTOMER WHERE INVOICE_HEAD.Salesman LIKE '" . $salesman->ID . "' AND DATE(CreationDate) BETWEEN '$fromDate' AND '$toDate' AND CUSTOMER.AccountNumber = INVOICE_HEAD.AccountNumber ORDER BY $sort $direction";
	    }elseif ($for == "date") {
	    	$query = "SELECT *, IF(InvoiceID IN (SELECT InvoiceID FROM DELIVERY_RECORD WHERE DropoffDate IS NULL),1,0) InRoute FROM INVOICE_HEAD, CUSTOMER WHERE DATE(CreationDate) BETWEEN '$fromDate' AND '$toDate' AND CUSTOMER.AccountNumber = INVOICE_HEAD.AccountNumber ORDER BY $sort $direction";
	    }
		//echo $query;
		//LAST YEAR SALES INFO
		if ($for == "customer") {
	    	$queryLastYear = "SELECT SUM(OrderQty * Price) AS LastYearSales, COUNT(DISTINCT(ORDER_HEAD.OrderID)) AS `Count`, SalesmanOrder FROM ORDER_HEAD, ORDER_DETAIL WHERE ORDER_HEAD.DeleteOrder = 0 AND ORDER_HEAD.OrderID = ORDER_DETAIL.OrderID AND ORDER_HEAD.AccountNumber LIKE '" . $customer->AccountNumber . "' AND DATE(OrderDate) BETWEEN DATE_ADD('$fromDate', INTERVAL -1 YEAR) AND DATE_ADD('$toDate', INTERVAL -1 YEAR) GROUP BY SalesmanOrder";
	    }elseif($for == "salesman") {
	    	$queryLastYear = "SELECT SUM(OrderQty * Price) AS LastYearSales, COUNT(DISTINCT(ORDER_HEAD.OrderID)) AS `Count`, SalesmanOrder FROM ORDER_HEAD, ORDER_DETAIL WHERE ORDER_HEAD.DeleteOrder = 0 AND ORDER_HEAD.OrderID = ORDER_DETAIL.OrderID AND ORDER_HEAD.Salesman LIKE '" . $salesman->ID . "' AND DATE(OrderDate) BETWEEN DATE_ADD('$fromDate', INTERVAL -1 YEAR) AND DATE_ADD('$toDate', INTERVAL -1 YEAR) GROUP BY SalesmanOrder";
	    }elseif ($for == "date") {
	    	$queryLastYear = "SELECT SUM(OrderQty * Price) AS LastYearSales, COUNT(DISTINCT(ORDER_HEAD.OrderID)) AS `Count`, SalesmanOrder FROM ORDER_HEAD, ORDER_DETAIL WHERE ORDER_HEAD.DeleteOrder = 0 AND ORDER_HEAD.OrderID = ORDER_DETAIL.OrderID AND DATE(OrderDate) BETWEEN DATE_ADD('$fromDate', INTERVAL -1 YEAR) AND DATE_ADD('$toDate', INTERVAL -1 YEAR) GROUP BY SalesmanOrder";
	    }
		$resultLastYear = mysqli_query($con, $queryLastYear);
		$lastYearData = array();
		while($rowLastYear = mysqli_fetch_array($resultLastYear)){
			$lastYearData[$rowLastYear['SalesmanOrder']] = new stdClass();
			$lastYearData[$rowLastYear['SalesmanOrder']]->Count = $rowLastYear['Count'];
			$lastYearData[$rowLastYear['SalesmanOrder']]->Sales = $rowLastYear['LastYearSales'];

		}

	   	$result = mysqli_query($con, $query);
		$finalizedTotal = 0;
		$finalizedTransactions = 0;
		$unprocessedTotal = 0;
		$unprocessedTransactions = 0;

		$custTransactions = 0;
		$salesmanTransactions = 0;
		$status = "";
	   	while ($row = mysqli_fetch_array($result)) {
	   		$invoice = new Invoice($row['InvoiceID']);
			if($row['Void'] == 0 && $row['Status'] && $row['OnHold'] == 0){
				$finalizedTotal += $invoice->InvoiceTotal;
				$finalizedTransactions++;

			}else{
				$unprocessedTotal += $invoice->InvoiceTotal;
				$unprocessedTransactions++;
			}


			if($row['Delivered'] && $row['Status']){
				$status = "Delivered";
				$statusLabelClass = "label-success";
				$statusText = "<b>User:</b> " . $row['InvoiceUser'] . "<br />";
				$statusText .= "<b>Started Processing:</b> " . date('m/d/Y h:i a', strtotime($row['SentPicking'])) . "<br />";
				$statusText .= "<b>Done Processing:</b> " . date('m/d/Y h:i a', strtotime($row['InvoiceDate'])) . "<br />";
				$statusText .= "<b>Delivery Date:</b> " . date('m/d/Y h:i a', strtotime($row['DeliveryDate']))  . "<br />";
				$statusText .= "<b>Delivered By:</b> " . $row['DeliveryUser'] . "<br />";
			}elseif($row['Status'] && $row['InRoute']){
				$status = "In Route";
				$statusLabelClass = "label-primary";
				$statusText = "<b>Invoiced By:</b> " . $row['InvoiceUser'] . "<br />";
				$statusText .= "<b>Started Processing:</b> " . date('m/d/Y h:i a', strtotime($row['SentPicking'])) . "<br />";
				$statusText .= "<b>Done Processing:</b> " . date('m/d/Y h:i a', strtotime($row['InvoiceDate'])) . "<br />";
				$statusText .= "<b>Elapsed Time:</b> " . getElapsedTime($row['SentPicking'], $row['InvoiceDate']) . "<br />";
			}elseif($row['Status'] && !$row['InRoute']){
				$status = "Waiting to be delivered";
				$statusLabelClass = "label-warning";
				$statusText = "<b>Invoiced By:</b> " . $row['InvoiceUser'] . "<br />";
				$statusText .= "<b>Started Processing:</b> " . date('m/d/Y h:i a', strtotime($row['SentPicking'])) . "<br />";
				$statusText .= "<b>Done Processing:</b> " . date('m/d/Y h:i a', strtotime($row['InvoiceDate'])) . "<br />";
				$statusText .= "<b>Elapsed Time:</b> " . getElapsedTime($row['SentPicking'], $row['InvoiceDate']) . "<br />";
			}elseif($row['Void']){
				$status = "Void";
				$statusLabelClass = "label-danger";
				$statusText = "<b>User:</b> " . $row['HoldVoidUser'] . "<br />";
				$statusText .= "<b>Voided On:</b> " . date('m/d/Y h:i a', strtotime($row['VoidDate'])) . "<br />";
				$statusText .= "<b>Reason:</b> " . $row['HoldVoidReason'] . "<br />";
			}elseif($row['InProcess']){
				$status = "In Process";
				$statusLabelClass = "label-warning";
				$statusText = "<b>User:</b> " . $row['InvoiceUser'] . "<br />";
				$statusText .= "<b>Started Processing:</b> " . date('m/d/Y h:i a', strtotime($row['SentPicking'])) . "<br />";
			}elseif($row['OnHold']){
				$status = "On Hold";
				$statusLabelClass = "label-warning";
				$statusText = "<b>User:</b> " . $row['OnHoldDeleteUser'] . "<br />";
				$statusText .= "<b>Set On Hold on:</b> " . date('m/d/Y h:i a', strtotime($row['OnHoldDate'])) . "<br />";
				$statusText .= "<b>Reason:</b> " . $row['HoldDeleteReason'] . "<br />";
			}else{
				$status = "Unprocessed";
				$statusLabelClass = "label-default";
				$statusText = "No process data available";

			}
	   	?>
	   		<tr>
				<td style="min-width: 90px;">
					<!--<span class="visible-print-block"><?= $row['InvoiceID'] ?></span>-->
					<!-- Single button -->

					<!-- Split button -->
					<div class="btn-group">
					  <a href="mod.php?p=invoice&a=view&id=<?= $row['InvoiceID'] ?>" class="btn btn-default">
						<?= $row['InvoiceID'] ?>
					  </a>
					  <button type="button" class="btn btn-default dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
						<span class="caret"></span>
						<span class="sr-only">Toggle Dropdown</span>
					  </button>
					  <ul class="dropdown-menu">
						<li><a href="mod.php?p=invoice&a=managerview&id=<?= $row['InvoiceID'] ?>">View Manager Invoice</a></li>
						<?php
							if(!$invoice->Status){
						?>
						<li><a href="mod.php?p=invoice&a=review&id=<?= $row['InvoiceID'] ?>">Review</a></li>
						<?php
							}else{
						?>
						<li><a href="mod.php?p=invoice&a=review&id=<?= $row['InvoiceID'] ?>" onclick="alert('Añadir o remover articulos no cambiará inventario. Hacer cambios a una factura salda creará descuadre de impuestos, etc. Asegurese de que la factura no haya sido paga.')">Revise</a></li>
						<li><a href="mod.php?p=invoice&a=review&id=<?= $row['InvoiceID'] ?>" onclick="$.get('mod.php?p=invoice&a=functions&f=resendInvoice&id=<?= $row['InvoiceID'] ?>', function(data){ alert(data); }); return false;">Resend Invoice</a></li>
						<?php
							}
						?>
						<li><a href="#">Create Credit </a></li>
						<li><a href="#" onclick="setDelete('<?= $row['InvoiceID'] ?>')">Void Invoice</a></li>
					  </ul>
					</div>


					<div class="btn-group ">


					</div>

				</td>

	   			<?= ($for != "customer") ? "<td style=\"max-width: 300px; white-space: nowrap;  overflow: hidden;  text-overflow: ellipsis;\">" . $row['Name'] . "</td>" : "" ?>
	   			<td style="white-space: nowrap;"><?= date("m/d/Y g:i a",strtotime($row['InvoiceDate'])) ?></td>
	   			<td style="max-width: 100px; white-space: nowrap;  overflow: hidden;  text-overflow: ellipsis;" class="hidden-print"><?= $row['PONumber'] ?>
				</td>
				<td style="white-space: nowrap;"><?= $invoice->Salesman->ID . " - " . $invoice->Salesman->Name ?></td>
				<td><button style="font-size:12px;" data-placement="left" data-html="true" type="button" class="label <?= $statusLabelClass ?>" data-container="body" data-toggle="popover" title="<?= $status ?>" data-content="<?= $statusText ?>"><?= $status ?></a></td>
				<td style="text-align: right;"><?= moneyFormat($invoice->InvoiceTotal) ?></td>

	   		</tr>
	   	<?php
	   	}
	     ?>
			</tbody>
	     </table>
	  </div>
	  <div class="panel-footer" style="height: 130px;" >
	  	<span style="float: left; text-align: left;">
			<?php

			?>
	  		<b>Average Sale:</b> <?= @moneyFormat($finalizedTotal/$finalizedTransactions) ?><br />
			<strong>Finalized Transactions: </strong><i><?= $finalizedTransactions ?></i><br />

			<strong>Unfinalized Transactions: </strong><i><?= $unprocessedTransactions ?></i><br>

	  	</span>
	  	<span  style="float: right; text-align: right;">
	  		<strong>Finalized Total: </strong><i><?= moneyFormat($finalizedTotal) ?></i> <br>
			<strong>Unfinalized Total: </strong><i><?= moneyFormat($unprocessedTotal) ?></i> <br>

	  	</span>
	  </div>
	  <div class="panel-footer" style="height: 125px;" >
		<h4>Last Year</h4>
	  	<span style="float: left; text-align: left;">
			<?php

			?>
	  		<strong>Orders By Customers Total: </strong><i><?= moneyFormat($lastYearData[0]->Sales) ?></i> <b>Average:</b> <?= @moneyFormat($lastYearData[0]->Sales/$lastYearData[0]->Count) ?><br />
			<strong>Transactions By Customer: </strong><i><?= $lastYearData[0]->Count ?></i><br />
			<strong>Orders By Salesman Total: </strong><i><?= moneyFormat($lastYearData[1]->Sales) ?></i> <b>Average:</b> <?= @moneyFormat($lastYearData[1]->Sales/$lastYearData[1]->Count) ?><br />
			<strong>Transactions By Salesman: </strong><i><?= $lastYearData[1]->Count ?></i><br />
	  	</span>
	  	<span  style="float: right; text-align: right;">
	  		<strong>Total Orders: </strong><i><?= moneyFormat($lastYearData[0]->Sales+$lastYearData[1]->Sales) ?></i> <br /><b>Average:</b> <?= @moneyFormat(($lastYearData[0]->Sales+$lastYearData[1]->Sales)/($lastYearData[0]->Count+$lastYearData[1]->Count)) ?><br />
			<strong>Total Transactions: </strong><i><?= $lastYearData[0]->Count+$lastYearData[1]->Count ?></i>
	  	</span>
	  </div>
	</div>

</div>
<script type="text/javascript">

$('[name=filter]').on('keypress', function(e) {
	if (e.which == 13) {
		filter();
	}

});
function setDelete(InvoiceID){
		$('#DeleteReasonModal').modal('show');
		$('#DeleteOrderNumber').val(InvoiceID);

}
function submitSetDelete(){
	var InvoiceID = $('#DeleteOrderNumber').val();
	var reason = $('#SetDeleteReason').val();
	$.get('mod.php?p=invoice&a=functions&f=voidInvoice&id=' + InvoiceID + '&reason=' + reason, function(data){
		data = JSON.parse(data);
		if(data.Result === true){
			$('#DeleteReasonModal').modal('hide');
			//fillPendingOrders();

		}else{
			alert('Sorry there was an error:\n\r' + data.Error);
		}
	});
}
function clearFilter() {
	$('[name=filter]').val("");
	$('#clearButton').css('display', 'none');
	$('tr').css('display', '');

}
function filter() {
	var	name = $('[name=filter]').val();
	filterByName(name);
}
function filterByName(name) {
	$('#clearButton').css('display', '');

	for (var i = 1; i < $('tr').length; i++) {

		var text = $($('tr')[i]).text().trim();

		var result = text.toUpperCase().indexOf(name.toUpperCase());
		if (result < 0) {
			$($('tr')[i]).css('display', 'none');
		}else {
			$($('tr')[i]).css('display', '');
		}

	}
}
function fillEditOrder(orderID) {
	clearEditOrder();
	$.get("functions.php?action=getOrderDetails&orderID=" + orderID, function(data) {
		data = JSON.parse(data);
		$('#EditOrderTitle').text('Edit Order #' + data.OrderID);
		$('#EditModalOrderID').val(data.OrderID);
		for (var i = 0; i < data.Items.length; i++) {
			$('#EditOrderModalBody').append('<tr><td>' + data.Items[i].Group.toString() + '<br />' + data.Items[i].Line.toString() + '</td><td>' + data.Items[i].SKU.toString() + '</td><td>' + data.Items[i].Description + ' ' + data.Items[i].Notes.toString() + '</td><td><input class="form-control EditOrderItem" style="width: 80px;" type="text" name="' + data.Items[i].ID + '" data-Key="' + data.Items[i].Group.toString() + "-" + data.Items[i].Line.toString() + "-" + data.Items[i].SKU.toString() + '" data-OriginalQty="' + data.Items[i].OrderQty + '" value="' + data.Items[i].OrderQty + '" /></td><td>' + data.Items[i].Price + '</td><td>' + parseFloat(data.Items[i].Price)*parseInt(data.Items[i].OrderQty) + '</td></tr>');
		}
		$('#EditOrderModal').modal();

	});
}
function clearEditOrder() {
	$('#EditOrderTitle').text('Edit Order');
	$('#EditModalOrderID').val('0');
	$('#EditOrderModalBody').html('');

}
function saveOrderInfo() {
	var items = $('.EditOrderItem');
	var changes = new Object();
	changes.OrderID = $('#EditModalOrderID').val();
	changes.Items = new Array();
	for (var i = 0; i < items.length; i++) {
		var origQty = parseInt($($('.EditOrderItem')[i]).attr("data-OriginalQty"));
		var newQty = parseInt($($('.EditOrderItem')[i]).val());
		var itemKey = $($('.EditOrderItem')[i]).attr("data-Key")
		if (origQty != newQty) {
			var item = new Object()
			item.ID = $($('.EditOrderItem')[i]).attr('name');
			item.NewQty = newQty;
			item.OriginalQty = origQty;
			item.ItemKey = itemKey;
			changes.Items.push(item);
		}

	}
	$.post("functions.php?action=saveOrderDetail", changes, function(data) {
		if(data == "true"){
			location.reload();
		}

	});

}
function processOrder(orderID){
	$.get('mod.php?p=invoice&a=functions&f=processOrder&order=' + orderID, function(data){
		alert(data);
		});
}
</script>

	<div class="modal fade" id="EditOrderModal">
	  <div class="modal-dialog">
	    <div class="modal-content">
	      <div class="modal-header">
	        <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
	        <h4 class="modal-title" id="EditOrderTitle">Edit Order</h4>
	      </div>
	      <div class="modal-body">
	      	<input type="hidden" name="EditModalOrderID" id="EditModalOrderID" value="" />
			<table class="table table-hover table-condensed" id="orderhistory">
				<thead>
					<tr>
						<th>Group<br />Line</th>
						<th>SKU</th>
						<th>Description</th>

						<th>Qty</th>
						<th>Price</th>
						<th style="text-align: center;">Extension</th>
					</tr>

				</thead>
				<tbody id="EditOrderModalBody">
				</tbody>
				</table>

	      </div>
	      <div class="modal-footer">
	        <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
	        <button type="button" class="btn btn-primary" id="saveButton" onclick="saveOrderInfo()">Save</button>
	      </div>
	    </div><!-- /.modal-content -->
	  </div><!-- /.modal-dialog -->
	</div><!-- /.modal -->

	<script>
		$(function () {
			$('[data-toggle="popover"]').popover();
		  });
	</script>



	<!-- Delete Reason Modal -->
	<div class="modal fade" id="DeleteReasonModal">
		<div class="modal-dialog">
			<div class="modal-content">
				<div class="modal-header">
					<button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
					<h4 class="modal-title" id="SetDeleteTitle">Void Invoice</h4>
				</div>
				<div class="modal-body">
			<div class="form">
				<div class="form-group">
					<label for="DeleteOrderNumber">Invoice Number</label>
					<input type="text" class="form-control"  name="DeleteOrderNumber" id="DeleteOrderNumber" value="" readonly />
				</div>
				<!--<div class="form-group">
					<label for="InvoiceCustomer">Customer</label>
					<input type="text" class="form-control" readonly name="InvoiceCustomer" id="InvoiceCustomer" readonly />
				</div>-->
				<div class="form-group">
					<label for="SetDeleteReason">Reason</label>
					<textarea class="form-control" rows="5" id="SetDeleteReason"></textarea>
				</div>
			</div>

				</div>
				<div class="modal-footer">
					<button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
					<button type="button" id="submitSetDelete" class="btn btn-success" onclick="submitSetDelete();">Void</button>
				</div>
			</div><!-- /.modal-content -->
		</div><!-- /.modal-dialog -->
	</div><!-- /.modal -->

   </body>

 </html>
