<?php

/*
 * Editor server script for DB table INVENTORY
 * Created by http://editor.datatables.net/generator
 */

// DataTables PHP library and database connection

if($_POST['action'] == "edit"){
	foreach($_POST['data'] as $key => $rows){
		if(isset($_POST['data'][$key]['PriceA'])){
			$_POST['data'][$key]['PriceB'] = floatval($_POST['data'][$key]['PriceA'])*1.2;
			$_POST['data'][$key]['PriceC'] = floatval($_POST['data'][$key]['PriceA'])*1.44;
			$_POST['data'][$key]['PriceD'] = floatval($_POST['data'][$key]['PriceA'])*1.728;
			$_POST['data'][$key]['PriceE'] = floatval($_POST['data'][$key]['PriceA'])*2.0736;
		}
	}


	//var_dump($_POST);
}
include( "../../assets/DataTables/DataTables.php" );

// Alias Editor classes so they are easy to use
use
	DataTables\Editor,
	DataTables\Editor\Field,
	DataTables\Editor\Format,
	DataTables\Editor\Mjoin,
	DataTables\Editor\Options,
	DataTables\Editor\Upload,
	DataTables\Editor\Validate,
	DataTables\Editor\ValidateOptions;


// Build our Editor instance and process the data coming from _POST
Editor::inst( $db, 'INVENTORY', 'id' )
	->fields(
		Field::inst( 'Line' )
			->set( false )
			->validator( Validate::notEmpty() ),
		Field::inst( 'Group' )
			->set( false )
			->validator( Validate::notEmpty() ),
		Field::inst( 'SKU' )
			->set( false )
			->validator( Validate::notEmpty() ),
		Field::inst( 'Description' )
			->validator( Validate::notEmpty() ),
		Field::inst( 'Qty' )
			->validator( Validate::numeric() ),
		Field::inst( 'AvgCost' ),
		Field::inst( 'round(AvgCost/.85,2)', 'Cost15' ),
		Field::inst( 'PriceA' ),
		Field::inst( 'round((PriceA-AvgCost/.85)/PriceA*100,2)', 'PM_A' ),
		Field::inst( 'PriceB' )
			->set("Field::SET_EDIT"),
			//->setValue(Field::inst( 'PriceA' )->getValue()),
		Field::inst( 'round((PriceB-AvgCost/.85)/PriceB*100,2)', 'PM_B' ),
		Field::inst( 'PriceC' )
			->set("Field::SET_EDIT"),
		Field::inst( 'round((PriceC-AvgCost/.85)/PriceC*100,2)', 'PM_C' ),
		Field::inst( 'CommissionRate' ),
		Field::inst( 'Location' ),
		Field::inst( 'LocationB' ),
		Field::inst( 'LocationC' ),
		Field::inst( 'Discontinued' ),
		Field::inst( 'Active' )
			->setFormatter( function ( $val, $data, $opts ) {
							return ! $val ? 0 : 1;
					} )

	)
	->process( $_POST )
	->json();
