<?php
if(stripos($_SERVER['SCRIPT_NAME'],"/admin/")===false?false:true){
	include_once("../connect.php");
	include_once("../session.php");
}else{
	include_once("connect.php");
	include_once("session.php");
}
?>
<!doctype html>
<html>
	<head>
		<meta http-equiv="content-type" content="text/html; charset=utf-8" />
		<meta name="viewport" content="width=device-width, initial-scale=1">
		<title>Location Maintenance</title>
		
		
		<link href="../css/bootstrap.min.css" rel="stylesheet">
		<link rel="stylesheet" href="../css/bootstrap-combobox.css" />
		

		<script src="https://ajax.googleapis.com/ajax/libs/jquery/1.11.1/jquery.min.js"></script>
		
		
		
		<script type="text/javascript" charset="utf-8" src="../js/bootstrap.min.js"></script>
		
		<style>
			input[type="color"],
			input[type="date"],
			input[type="datetime"],
			input[type="datetime-local"],
			input[type="email"],
			input[type="month"],
			input[type="number"],
			input[type="password"],
			input[type="search"],
			input[type="tel"],
			input[type="text"],
			input[type="time"],
			input[type="url"],
			input[type="week"],
			select:focus,
			textarea {
			  font-size: 16px;
			}
		</style>
		
		
	</head>
	<body class="bootstrap">
		
       <?php
		include_once("./navbar.php");						
		?>
		<br>
		<br>
		<br>
		
		<h2>
			Location Maintenance
			</h2>
		<br>
		<div class="container">
			<div class="row">
				<div class="col-sm-6">
					<div class="form-horizontal">
						<div class="form-group">
						  <label for="ProductLocation" class="col-sm-2 control-label">Location</label>
						  <div class="col-sm-10">
							<input type="text" class="form-control" id="ProductLocation" placeholder="Location">
						  </div>
						</div>
						<div class="form-group">
						  <label for="ProductUPC" class="col-sm-2 control-label">UPC</label>
						  <div class="col-sm-10">
							<input type="text" class="form-control" id="ProductUPC" placeholder="UPC">
							<input type="hidden" class="form-control" id="HiddenProductUPC" placeholder="UPC">
						  </div>
						</div>
						<div class="form-group">
						  <div class="col-sm-offset-2 col-sm-10">
							<button type="button" id="setNewLocation" class="btn btn-default">Set New Location</button>
							<button type="button" id="setNewItem" class="btn btn-default">New Item</button>
						  </div>
						</div>
					</div>
				</div>
				<div class="col-sm-6">
					<h4 class="statusTitle">Current Location: <span id="currLocation">Not Set</span></h4> <br>
					<h4 class="statusTitle">Current Item: <span id="currItem">Not Set</span></h4> <br>
					
				</div>
				<div class="col-sm-12">
					<table class="table">
					<thead>
						<tr>
							<th>Location ID</th>
							<th></th>
							<th></th>	
						</tr>
					</thead>
					<tbody>
						<tr>
							<td id="locationSlotA"></td>
							<td><button class="btn btn-primary slotSelect" onclick="selectSlot('Location');" id="selectSlotA"><span class="glyphicon glyphicon-ok" aria-hidden="true"></span></button></td>
							<td><button class="btn btn-danger" onclick="deleteSlot('Location');" id="deleteSlotA"><span class="glyphicon glyphicon-trash" aria-hidden="true"></span></button></td>
						</tr>
						<tr>
							<td id="locationSlotB"></td>
							<td><button class="btn btn-primary slotSelect" onclick="selectSlot('LocationB');" id="selectSlotB"><span class="glyphicon glyphicon-ok" aria-hidden="true"></span></button></td>
							<td><button class="btn btn-danger" onclick="deleteSlot('LocationB');" id="deleteSlotB"><span class="glyphicon glyphicon-trash" aria-hidden="true"></span></button></td>
						</tr>
						<tr>
							<td id="locationSlotC"></td>
							<td><button class="btn btn-primary slotSelect" onclick="selectSlot('LocationC');" id="selectSlotC"><span class="glyphicon glyphicon-ok" aria-hidden="true"></span></button></td>
							<td><button class="btn btn-danger" onclick="deleteSlot('LocationC');" id="deleteSlotC"><span class="glyphicon glyphicon-trash" aria-hidden="true"></span></button></td>
						</tr>
						<tr>
							<td id="locationSlotD"></td>
							<td><button class="btn btn-primary slotSelect" onclick="selectSlot('LocationD');" id="selectSlotD"><span class="glyphicon glyphicon-ok" aria-hidden="true"></span></button></td>
							<td><button class="btn btn-danger" onclick="deleteSlot('LocationD');" id="deleteSlotD"><span class="glyphicon glyphicon-trash" aria-hidden="true"></span></button></td>
						</tr>
						<tr>
							<td id="locationSlotE"></td>
							<td><button class="btn btn-primary slotSelect" onclick="selectSlot('LocationE');" id="selectSlotE"><span class="glyphicon glyphicon-ok" aria-hidden="true"></span></button></td>
							<td><button class="btn btn-danger" onclick="deleteSlot('LocationE');" id="deleteSlotE"><span class="glyphicon glyphicon-trash" aria-hidden="true"></span></button></td>
						</tr>
					</tbody>
				  </table>
				</div>
			</div>
		</div>
		<!-- Location Select Modal 
		<div class="modal fade" id="locationSlotSelect" tabindex="-1" role="dialog">
			<div class="modal-dialog" role="document">
			  <div class="modal-content">
				<div class="modal-header">
				  <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
				  <h4 class="modal-title">Select Location</h4>
				</div>
				<div class="modal-body">
					This item already has a location defined. Please select the location slot in which you would like to store this location information. if you select a slot with a location number already, the system will overwrite it. 
				  <table class="table">
					<thead>
						<tr>
							<th>Location Slot</th>
							<th>Location ID</th>
							<th></th>
							<th></th>	
						</tr>
					</thead>
					<tbody>
						<tr>
							<td>Loc A</td>
							<td id="locationSlotA"></td>
							<td><button class="btn btn-primary" onclick="selectSlot('Location');" id="selectSlotA"><span class="glyphicon glyphicon-ok" aria-hidden="true"></span></button></td>
							<td><button class="btn btn-danger" onclick="deleteSlot('Location');" id="deleteSlotA"><span class="glyphicon glyphicon-trash" aria-hidden="true"></span></button></td>
						</tr>
						<tr>
							<td>Loc B</td>
							<td id="locationSlotB"></td>
							<td><button class="btn btn-primary" onclick="selectSlot('LocationB');" id="selectSlotB"><span class="glyphicon glyphicon-ok" aria-hidden="true"></span></button></td>
							<td><button class="btn btn-danger" onclick="deleteSlot('LocationB');" id="deleteSlotB"><span class="glyphicon glyphicon-trash" aria-hidden="true"></span></button></td>
						</tr>
						<tr>
							<td>Loc C</td>
							<td id="locationSlotC"></td>
							<td><button class="btn btn-primary" onclick="selectSlot('LocationC');" id="selectSlotC"><span class="glyphicon glyphicon-ok" aria-hidden="true"></span></button></td>
							<td><button class="btn btn-danger" onclick="deleteSlot('LocationC');" id="deleteSlotC"><span class="glyphicon glyphicon-trash" aria-hidden="true"></span></button></td>
						</tr>
						<tr>
							<td>Loc D</td>
							<td id="locationSlotD"></td>
							<td><button class="btn btn-primary" onclick="selectSlot('LocationD');" id="selectSlotD"><span class="glyphicon glyphicon-ok" aria-hidden="true"></span></button></td>
							<td><button class="btn btn-danger" onclick="deleteSlot('LocationD');" id="deleteSlotD"><span class="glyphicon glyphicon-trash" aria-hidden="true"></span></button></td>
						</tr>
						<tr>
							<td>Loc E</td>
							<td id="locationSlotE"></td>
							<td><button class="btn btn-primary" onclick="selectSlot('LocationE');" id="selectSlotE"><span class="glyphicon glyphicon-ok" aria-hidden="true"></span></button></td>
							<td><button class="btn btn-danger" onclick="deleteSlot('LocationE');" id="deleteSlotE"><span class="glyphicon glyphicon-trash" aria-hidden="true"></span></button></td>
						</tr>
					</tbody>
				  </table>
				</div>
				<div class="modal-footer">
				  <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
				</div>
			  </div><!-- /.modal-content - ->
			</div><!-- /.modal-dialog - ->
		</div><!-- /.modal -->
		
		
		<!-- Assign UPC Modal -->
		<div class="modal fade" id="AssignUPCModal" tabindex="-1" role="dialog">
			<div class="modal-dialog" role="document">
			  <div class="modal-content">
				<div class="modal-header">
				  <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
				  <h4 class="modal-title">Assing UPC to Existing Product</h4>
				</div>
				<div class="modal-body">
					This UPC code is not recognized, please assing this UPC to an existing item in the following form.
					<br>
					<div class="">
					  <div class="form-horizontal">
						  <div class="form-group">
							<label for="AssingUPCSKU" class="col-sm-2 control-label">SKU</label>
							<div class="col-sm-10">
							  <input type="text" class="form-control" id="AssingUPCSKU" placeholder="SKU">
							</div>
						  </div>
						  <div class="form-group">
							<label for="AssingUPCLine" class="col-sm-2 control-label">Line</label>
							<div class="col-sm-10">
							  <input type="text" class="form-control" id="AssingUPCLine" placeholder="Line">
							</div>
						  </div>
						  <div class="form-group">
							<label for="AssingUPCQty" class="col-sm-2 control-label">Qty</label>
							<div class="col-sm-10">
							  <input type="text" class="form-control" value="1" id="AssingUPCQty" placeholder="Qty">
							</div>
						  </div>
					  </div>
				  </div>
				</div>
				<div class="modal-footer">
					<button type="button" onclick="saveAssingUPC();" class="btn btn-primary">Save</button>
					<button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
				</div>
			  </div><!-- /.modal-content -->
			</div><!-- /.modal-dialog -->
		</div><!-- /.modal -->
		
		<script type="text/javascript">
			$(document).ready(function(){
				$('#ProductLocation').focus();
				});
			$('#ProductLocation').on('keyup', function(e){
					if($('#ProductLocation').val() === ""){
						return;
					}else{
						//alert(e.keyCode);
						if(e.keyCode == 13 || e.keyCode == 0){
							$('#currLocation').text($('#ProductLocation').val());
							$('#ProductUPC').val('');
							$('#HiddenProductUPC').val('');
							$('#ProductUPC').focus();	
						}
					
					}
					
					
					
				
				});
			function deleteSlot(locationSlot){
				var upc = $('#HiddenProductUPC').val();
				var loc = $('#currLocation').text();
				$.get('mod.php?p=inventorymanage&a=functions&f=deleteLocationByUPC&UPC=' + upc + '&loc=' + loc + "&slot=" + locationSlot, function(data){
						data = JSON.parse(data);
						if(data.Result){
							clearLocationSlotModal();
							$('#locationSlotA').text(data.Data[0]);
							$('#locationSlotB').text(data.Data[1]);
							$('#locationSlotC').text(data.Data[2]);
							$('#locationSlotD').text(data.Data[3]);
							$('#locationSlotE').text(data.Data[4]);
						}else{
							alert(data.Error);
						}
						
						
				});
			}
			function assignLocation(){
				$('#HiddenProductUPC').val($('#ProductUPC').val());
				$('#ProductUPC').val('');
				var upc = $('#HiddenProductUPC').val();
				var loc = $('#currLocation').text();
				if(loc == "" || loc == "Not Set"){
					$('.slotSelect').css('display', 'none');
				}else{
					$('.slotSelect').css('display', '');
				}
				
				$.get('mod.php?p=inventorymanage&a=functions&f=assignLocationByUPC&UPC=' + upc + '&loc=' + loc, function(data){
					data = JSON.parse(data);
					if(data.Result){
						$('#currItem').html(data.Data.SKU + " - " + data.Data.Description + "<br>" + "<B>Product Updated Successfully</B>");
						$('#ProductUPC').val('');
						$('#HiddenProductUPC').val('');
						$('#ProductUPC').focus();
						$('#locationSlotA').text(data.Data.Location);
						$('#locationSlotB').text(data.Data.LocationB);
						$('#locationSlotC').text(data.Data.LocationC);
						$('#locationSlotD').text(data.Data.LocationD);
						$('#locationSlotE').text(data.Data.LocationE);
						clearLocationSlotModal();
						
					}else{
						if(data.Error == "location_exists"){
							clearLocationSlotModal();
							$('#locationSlotA').text(data.Data[0]);
							$('#locationSlotB').text(data.Data[1]);
							$('#locationSlotC').text(data.Data[2]);
							$('#locationSlotD').text(data.Data[3]);
							$('#locationSlotE').text(data.Data[4]);
							$('#currItem').html(data.Item.SKU + " - " + data.Item.Description);
							$('html,body').animate({
								scrollTop: $("#currItem").offset().top
							 });
							//$('#locationSlotSelect').modal();
						}else if(data.Error == 'upc_not_exists'){
							$('#AssignUPCModal').modal();
							$('#AssingUPCSKU').val('');
							$('#AssingUPCLine').val('');
							$('#AssingUPCQty').val('1');
							setTimeout(function(){
								$('#AssingUPCSKU').focus();
								$('#AssingUPCSKU').select();	
							}, 500);
							
							
						}
						
					}
					
					
				});	
			}
			$('#AssingUPCSKU').on("change", function(){
				$.get("mod.php?p=inventorymanage&a=functions&f=getItemLineBySKU&sku=" + $('#AssingUPCSKU').val(), function(data){
					$('#AssingUPCLine').val(data);
					$('#AssingUPCQty').focus();
				});
			});
			$('#ProductUPC').on('keyup', function(e){
				if($('#ProductLocation').val() == ""){
					
				}
				if(e.keyCode == 13 || e.keyCode == 0){
					assignLocation();
				}
				});
			
			$('#setNewLocation').on('click',function(){
					$('#currLocation').text('');
					$('#ProductLocation').val('');
					$('#ProductLocation').focus();
			});
			$('#setNewItem').on('click', function(){
				clearLocationSlotModal();
				$('#currItem').html('');
				$('#ProductUPC').val('');
				$('#HiddenProductUPC').val('');
				$('#ProductUPC').focus();
				
			});
			function clearLocationSlotModal(){
				$('#locationSlotA').text('');
				$('#locationSlotB').text('');
				$('#locationSlotC').text('');
				$('#locationSlotD').text('');
				$('#locationSlotE').text('');
				
			}
			function saveAssingUPC(){
				var SKU = $('#AssingUPCSKU').val();
				var Line = $('#AssingUPCLine').val();
				var Qty = $('#AssingUPCQty').val();
				var UPC = $('#HiddenProductUPC').val();
				$.get('mod.php?p=inventorymanage&a=functions&f=addUPCtoItem&line=' + Line + '&sku=' + SKU + "&upc=" + UPC + "&qty=" + Qty, function(data){
					data = JSON.parse(data);
					if(data.Result){
						assignLocation();
						$('#AssignUPCModal').modal('hide');
						
						
					}else{
						alert(data.Error);
					}
				});
			}
			function selectSlot(locationSlot){
				var upc = $('#HiddenProductUPC').val();
				var loc = $('#currLocation').text();
				
				$.get('mod.php?p=inventorymanage&a=functions&f=assignLocationByUPC&UPC=' + upc + '&loc=' + loc + "&slot=" + locationSlot, function(data){
						data = JSON.parse(data);
						if(data.Result){
							$('#currItem').html(data.Data.SKU + " - " + data.Data.Description + "<br>" + "<B>Product Updated Successfully</B>");
							$('#locationSlotSelect').modal('hide');
							$('#locationSlotA').text(data.Data.Location);
							$('#locationSlotB').text(data.Data.LocationB);
							$('#locationSlotC').text(data.Data.LocationC);
							$('#locationSlotD').text(data.Data.LocationD);
							$('#locationSlotE').text(data.Data.LocationE);
							$('#ProductUPC').val('');
							$('#HiddenProductUPC').val('');
							$('#ProductUPC').focus();
							
							
						}else{
							alert(data.Error);
							
						}
						
						
					});
			}
		</script>
	</body>
</html>
