<?php 
include_once("../connect.php");
global $con;
include_once("../session.php");


 ?>
 
 <!DOCTYPE html>
 <html lang="en">
   <head>
     <meta charset="utf-8">
     <meta http-equiv="X-UA-Compatible" content="IE=edge">
     <!--<meta name="viewport" content="width=device-width, initial-scale=1">-->
     <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no">
     <title><?= $config['CompanyName'] ?></title>
 
     <!-- Bootstrap -->
     <link href="../css/bootstrap.min.css" rel="stylesheet">
     <link rel="stylesheet" href="../css/bootstrap-combobox.css" />
 
     <!-- HTML5 shim and Respond.js for IE8 support of HTML5 elements and media queries -->
     <!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
     <!--[if lt IE 9]>
       <script src="https://oss.maxcdn.com/html5shiv/3.7.2/html5shiv.min.js"></script>
       <script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
       <!-- jQuery (necessary for Bootstrap's JavaScript plugins) -->
           <script src="https://ajax.googleapis.com/ajax/libs/jquery/1.11.1/jquery.min.js"></script>
           <!-- Include all compiled plugins (below), or include individual files as needed -->
           <script src="../js/bootstrap.min.js"></script>
           <script src="../js/fileinput.js"></script>
       	 <script src="../js/bootstrap-combobox.js"></script>
				 <script src="../js/bootstrap-waitingfor.min.js"></script>
				 
				 <script src="../js/functions.js"></script>
           <script type="text/javascript">
             $(document).ready(function(){
               
       //        $('.grpline').css("width", "100px");
             });
           </script>

     <![endif]-->
	<link rel="stylesheet" href="../css/styles.css"/>
	<link rel="stylesheet" href="../css/fileinput.min.css"/>
   </head>
   <body>
<?php 
	include("navbar.php");

?>
        
   <!-- Stack the columns on mobile by making one full-width and the other half-width -->
	
	<div class="panel panel-default">
		<button class="btn btn-danger" style="float: right; margin-top: 35px; margin-right: 10px;" onclick="clearWorkingTables()">Clear Working Data</button>
		<h3 class="page-header">Salesman Commission Panel</h3>
		<h4 class="page-header">Step 1: Upload Files</h4>
		<div class="container-fluid">
			<div class="row">
				<div class="col-xs-5">
					<button class="btn btn-primary" onclick="openIframeModal('sales')">Upload Sales File</button>
					<button class="btn btn-primary" onclick="openIframeModal('payment');">Upload Payments File</button><br><br>
					<button class="btn btn-primary" onclick="openIframeModal('salesHeaders');">Upload Sales Headers File</button>
					<button class="btn btn-primary" onclick="openIframeModal('specials');">Upload Specials File</button>
				</div>
				<div class="col-xs-2">
					<div class="panel panel-default">
						<div class="panel-heading">
							<h3 class="panel-title">Sales Table Status</h3>
						</div>
						<div class="panel-body">
							<span><strong>Rows: </strong></span><span id="salesTableStatusRows"></span><br />
							<span><strong>Total: </strong></span><span id="salesTableStatusRevenue"></span><br /><br />
							<span><strong>Sales Header Data From: </strong></span><span id="salesTableHeaderFrom"></span><br />
							<span><strong>Sales Header Data To: </strong></span><span id="salesTableHeaderTo"></span>
						</div>
					</div>
				</div>
				<div class="col-xs-3">
					<div class="panel panel-default">
						<div class="panel-heading">
							<h3 class="panel-title">Payments Table Status</h3>
						</div>
						<div class="panel-body">
							<span><strong>Rows: </strong></span><span id="paymentsTableStatusRows"></span><br />
							<span><strong>Total Amount: </strong></span><span id="paymentsTableStatusTotalRevenue"></span><br />
							<span><strong>Total Discount: </strong></span><span id="paymentsTableStatusTotalDiscount"></span><br />
							<span><strong>Total Tax: </strong></span><span id="paymentsTableStatusTotalTax"></span><br />
							<span><strong>Total: </strong></span><span id="paymentsTableStatusTotal"></span>
						</div>
					</div>
				</div>
				<div class="col-xs-2">
					<div class="panel panel-default">
						<div class="panel-heading">
							<h3 class="panel-title">Specials Table Status<br /><small>(Zero Commission)</small></h3>
						</div>
						<div class="panel-body">
							<span><strong>Rows: </strong></span><span id="specialsTableStatusRows"></span>
						</div>
					</div>
				</div>	
			</div>
			
				<div class="row">
					<div class="col-xs-5">
						<button class="btn btn-primary" onclick="openIframeModal('specialCustomer')">Upload Customers with Special Pricing</button>
						<button class="btn btn-primary" onclick="openIframeModal('specialCustomerItems');">Upload Special Pricing Items</button>
					</div>
					<div class="col-xs-3">
						<div class="panel panel-default">
							<div class="panel-heading">
								<h3 class="panel-title">Customers with Special Pricing</h3>
							</div>
							<div class="panel-body">
								<span><strong>Rows: </strong></span><span id="specialCustomerTableStatusRows"></span><br />
								
							</div>
						</div>
					</div>
					<div class="col-xs-3">
						<div class="panel panel-default">
							<div class="panel-heading">
								<h3 class="panel-title">Special Pricing Items<br /><small>(Zero Commission)</small></h3>
							</div>
							<div class="panel-body">
								<span><strong>Rows: </strong></span><span id="specialCustomerItemsStatusRows"></span><br />
							</div>
						</div>
					</div>
				</div>
			</div>
			
		</div>
		
		
		
		<h4 class="page-header">Step 2: Process</h4>
		<div class="container-fluid">
			<div class="row">
				<div class="col-xs-6">
					
					<button class="btn btn-primary" onclick="processCommissions('sales')">Process Sales</button>
					<button class="btn btn-primary" onclick="processCommissions('payments');">Process Payments</button>
					<br /><br /><pre>PTR Line is hardcoded to pay 0% commission.</pre>
				</div>
				<div class="col-xs-3">
					<div class="panel panel-default">
						<div class="panel-heading">
							<h3 class="panel-title">Sales Table Status</h3>
						</div>
						<div class="panel-body">
							<span><strong>Total Commission: </strong></span><span id="salesTableCommissionTotal"></span><br />
							<span><strong>Average Commission Rate: </strong></span><span id="salesTableAverageCommissionRate"></span>
						</div>
					</div>
				</div>
				<div class="col-xs-3">
					<div class="panel panel-default">
						<div class="panel-heading">
							<h3 class="panel-title">Payments Table Status</h3>
						</div>
						<div class="panel-body">
							<span><strong>Total Commission: </strong></span><span id="paymentsTableCommissionTotal"></span>
						</div>
					</div>
				</div>	
			</div>
		</div>
		
		<h4 class="page-header">Step 3: Save Data</h4>
		<div class="container-fluid">
			<div class="row">
				<div class="col-xs-4">
					
					<div class="form-horizontal">
						<div class="form-group">
							<label for="commissionPeriod" class="col-sm-2 control-label">Period</label>
							<div class="col-sm-6">
								<input type="month" class="form-control" id="commissionPeriod" placeholder="Period">
							</div>
						</div>
						<div class="form-group">
							<label for="commissionNotes" class="col-sm-2 control-label">Notes</label>
							<div class="col-sm-10">
								<textarea id="commissionNotes" class="form-control" rows="3"></textarea>
							</div>
						</div>
						
						<div class="form-group">
							<div class="col-sm-offset-2 col-sm-10">
								<button onclick="saveAndViewResults();" class="btn btn-primary">Save and View Results</button>
							</div>
						</div>
					</div>
				</div>
				<div class="col-xs-3">
				</div>
				<div class="col-xs-3">
				</div>	
			</div>
		</div>
	</div>
20 
     <script type="text/javascript">
			function openIframeModal(identifier){
				if(identifier == "payment"){
					$('#iFrameModalUrl').attr('src', "mod.php?p=commission&a=import&t=payments");
				}
				if(identifier == "sales"){
					$('#iFrameModalUrl').attr('src', "mod.php?p=commission&a=import&t=sales");
				}
				if(identifier == "specials"){
					$('#iFrameModalUrl').attr('src', "mod.php?p=commission&a=import&t=specials");
				}
				if(identifier == "specialCustomer"){
					$('#iFrameModalUrl').attr('src', "mod.php?p=commission&a=import&t=specialCustomer");
				}
				if(identifier == "specialCustomerItems"){
					$('#iFrameModalUrl').attr('src', "mod.php?p=commission&a=import&t=specialCustomerItems");
				}
				if(identifier == "salesHeaders"){
					$('#iFrameModalUrl').attr('src', "mod.php?p=commission&a=import&t=salesHeaders");
				}
				$('#iFrameModal').modal();
			}
			function updateSalesStatus(){
				$.get("mod.php?p=commission&a=functions&f=getWorkingTableStatus&table=sales", function(data){
					data = JSON.parse(data);
					$('#salesTableStatusRows').text(data.Count);
					$('#salesTableStatusRevenue').text(moneyFormat(data.TotalRevenue));
					$('#salesTableCommissionTotal').text(moneyFormat(data.TotalCommission));
					$('#salesTableAverageCommissionRate').text(Math.round((data.AverageCommissionRate*10000))/100 + "%");
					$('#salesTableHeaderTo').text(data.ToMonth);
					$('#salesTableHeaderFrom').text(data.FromMonth);
				});
			}
			function getSalesCount(){
				$.get("mod.php?p=commission&a=functions&f=getWorkingTableStatus&table=salesCount", function(data){
					data = JSON.parse(data);
					alert(data.Count);
				});
			}
			function saveAndViewResults(){
				var period = $('#commissionPeriod').val();
				if(period === ""){
					alert("Please select a period (month and year");
					$('#commissionPeriod').focus();
				}else{
					data = {};
					data.period = period;
					data.notes = $('#commissionNotes').val();
					$.post('mod.php?p=commission&a=functions&f=saveWorkingTable', data, function(result){
						result = JSON.parse(result);
						window.location = "mod.php?p=commission&a=viewresult&id=" + result.RunID;
						
						});
				}
			}
			function updatePaymentsStatus(){
				$.get("mod.php?p=commission&a=functions&f=getWorkingTableStatus&table=payments", function(data){
					data = JSON.parse(data);
					$('#paymentsTableStatusRows').text(data.Count);
					$('#paymentsTableStatusTotalRevenue').text(moneyFormat(data.TotalPayments));
					$('#paymentsTableStatusTotalDiscount').text(moneyFormat(data.TotalDiscount));
					$('#paymentsTableStatusTotalTax').text(moneyFormat(data.TotalTax));
					$('#paymentsTableStatusTotal').text(moneyFormat(parseFloat(data.TotalPayments)+parseFloat(data.TotalTax)));
					
					$('#paymentsTableCommissionTotal').text(moneyFormat(data.TotalCommission));
				});
			}
			function updateSpecialsStatus(){
				$.get("mod.php?p=commission&a=functions&f=getWorkingTableStatus&table=specials", function(data){
					data = JSON.parse(data);
					$('#specialsTableStatusRows').text(data.Count);
				});
				$.get("mod.php?p=commission&a=functions&f=getWorkingTableStatus&table=selective_specials", function(data){
					data = JSON.parse(data);
					$('#specialCustomerTableStatusRows').text(data[1].CustomerCount);
					$('#specialCustomerItemsStatusRows').text(data[0].ItemCount);
				});
			}
			function refreshAll(){
					updateSalesStatus();
					updatePaymentsStatus();
					updateSpecialsStatus();
			}
			refreshAll();
			
			function processCommissions(what){
				var word = '';
				if(what == "sales"){
						word = "Sales";
				}else if(what == "payments"){
						word = "Payments";
				}				
				waitingDialog.show('Processing ' + word + ' Data');
				$.get("mod.php?p=commission&a=functions&f=processCommissions&table=" + what, function(data){
						//alert(word + " Data has been processed");
						waitingDialog.hide();
						refreshAll();
				});
			}
			function clearWorkingTables(){
				waitingDialog.show('Deleting Working Data');
				$.get("mod.php?p=commission&a=functions&f=clearWorkingTables", function(data){
						//alert(word + " Data has been processed");
						waitingDialog.hide();
						refreshAll();
				});
			}
     </script>
		 	<style>
				#iFrameModalUrl{
					width: 100%;
					height: 500px;
					border: none;
				}
				
			</style>
			<!-- Modal -->
			<div class="modal fade" id="iFrameModal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
				<div class="modal-dialog modal-lg" role="document">
					<div class="modal-content">
						<div class="modal-body">
							<iframe id="iFrameModalUrl" src=""></iframe>
						</div>
						<div class="modal-footer">
							<button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
							<button type="button" class="btn btn-primary" onclick="refreshAll();" data-dismiss="modal">Continue</button>
						</div>
					</div>
				</div>
			</div>
		 
   </body>
 </html>