<?php 
include_once("../connect.php");
include_once("../session.php");

if(isset($_REQUEST['from']) && isset($_REQUEST['to'])){
	$fromPeriod = $_REQUEST['from'];
	$toPeriod = $_REQUEST['to'];
}else{
	header('Location: index.php');
	exit();
}
$webTitle = "View Commission History";

 ?>
 
 <!DOCTYPE html>
 <html lang="en">
   <head>
     <meta charset="utf-8">
     <meta http-equiv="X-UA-Compatible" content="IE=edge">
     <meta name="viewport" content="width=device-width, initial-scale=1">
     <title><?= $config['CompanyName'] ?> - <?= $webTitle ?></title>
 
     <!-- Bootstrap -->
     <link href="../css/bootstrap.min.css" rel="stylesheet">
     <link rel="stylesheet" href="../css/bootstrap-combobox.css" />
 
     <!-- HTML5 shim and Respond.js for IE8 support of HTML5 elements and media queries -->
     <!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
     <!--[if lt IE 9]>
       <script src="https://oss.maxcdn.com/html5shiv/3.7.2/html5shiv.min.js"></script>
       <script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
       <!-- jQuery (necessary for Bootstrap's JavaScript plugins) -->
           <script src="https://ajax.googleapis.com/ajax/libs/jquery/1.11.1/jquery.min.js"></script>
           <!-- Include all compiled plugins (below), or include individual files as needed -->
           <script src="../js/bootstrap.min.js"></script>
       	 <script src="../js/bootstrap-combobox.js"></script>
       	 <script src="../js/excellentexport.js"></script>
           <script type="text/javascript">
             $(document).ready(function(){
       //        $('.grpline').css("width", "100px");
             });
           </script>

     <![endif]-->
	<link rel="stylesheet" href="../css/styles.css"/>
   </head>
   <body>
   
       <?= include("navbar.php"); ?>     

   
   <!-- Stack the columns on mobile by making one full-width and the other half-width -->
<div class="container " style="padding-top: 10px;">
	<div class="panel panel-default">
	  <div class="panel-heading form-inline">
	  <a class="btn btn-success" role="button" style="float: right;" href="#" download="CommissionHistory<?= "(" . date("Y.m",strtotime($fromPeriod)) . " - " . date("Y.m",strtotime($toPeriod)) . ")" ?>.xls" href="#" onclick="return ExcellentExport.excel(this, 'commissionhistory', 'Commission History');" data-toggle="tooltip" data-placement="left" title="Does not work with Internet Explorer">Export To Excel</a>
	  
	  	<div style="margin-right: 10px; float: right;">
	  			<div class="input-group">
	  			      <div id="clearButton" style="display: none;" class="input-group-addon" onclick="clearFilter()">
	  			      	<span class="glyphicon glyphicon-remove" aria-hidden="true"></span></div>
	  			      <input type="text" class="form-control" name="filter" placeholder="Payment ID" value="" />
	  			      <div class="input-group-addon" onclick="filter()">
	  			      	<span class="glyphicon glyphicon-search" aria-hidden="true"></span></div>
	  			    </div>
	  	</div>
	  		    <h3 class="panel-title">Commission History <?= " - <i>From: " . date("m/Y",strtotime($fromPeriod)) . " To: " . date("m/Y",strtotime($toPeriod)) . "</i>"?></h3><br />
	  </div>
	  <div class="panel-body">
	  	<table class="table table-hover table-condensed" id="commissionhistory">
	  		<thead>
	  			<tr>
	  				<th>Batch ID</th>
					<th>Processing Date</th>
	  				<th>Period</th>
					<th>User</th>
	  				<th style="text-align: center;">Notes</th>
	  			</tr>
	  			
	  		</thead>
			<tbody>
	    <?php
		$query = "SELECT COMMISSION_HISTORY_HEAD.* FROM COMMISSION_HISTORY_HEAD WHERE Period BETWEEN '$fromPeriod' AND '$toPeriod';";
		$result = mysqli_query($con,$query);
		while($row = mysqli_fetch_array($result)){
		?>
				<tr>
					<td><a class='btn btn-primary' href="mod.php?p=commission&a=viewresult&id=<?= $row['ID'] ?>"><?= $row['ID'] ?></a></td>
					<td><?= date("m/d/Y h:i a ", strtotime($row['TransactionDate'])) ?></td>
					<td><?= date("M/Y", strtotime($row['Period'])) ?></td>
					<td><?= $row['User'] ?></td>
					<td><?= $row['Notes'] ?></td>
					<td><a class="btn btn-primary" href="mod.php?p=commission&a=taxsummary&id=<?= $row['ID'] ?>">Tax Report</a></td>
				</tr>
		<?php
		}
		?>
			</tbody>
	     </table>
	  </div>
	  <div class="panel-footer" >
	  	
	  </div>
	</div>

</div>       
	<script type="text/javascript">
	
	$('[name=filter]').on('keypress', function(e) {
		if (e.which == 13) {
			filter();
		}
	
	});
	function clearFilter() {
		$('[name=filter]').val("");
		$('#clearButton').css('display', 'none');
		$('tr').css('display', '');
		
	}
	function filter() {
		var	name = $('[name=filter]').val();
		filterByName(name);
	}
	function filterByName(name) {
		$('#clearButton').css('display', '');
		var cols = $('#paymenthistory th').length;
		for (var i = 0; i < $('#paymenthistory td').length; i=i+cols) {
		
			var text = $($('td')[i]).text();
			
			var result = text.toUpperCase().indexOf(name.toUpperCase());
			if (text != name) {
				$($('tr')[i/cols+1]).css('display', 'none');
			}else {
				$($('tr')[i/cols+1]).css('display', '');
			}
			
		}
	}
	</script>

   </body>
   
 </html>