
/*
 * Editor client script for DB table INVENTORY
 * Created by http://editor.datatables.net/generator
 */

(function($){

$(document).ready(function() {
	var editor = new $.fn.dataTable.Editor( {
		ajax: '../modules/inventorymanage/table.INVENTORY.php',
		table: '#INVENTORY',
		fields: [
			{
				"label": "Description:",
				"name": "Description"
			},
			{
				"label": "OnHand:",
				"name": "Qty"
			},
			{
				"label": "Cost:",
				"name": "AvgCost"
			},
			{
				"label": "PriceA:",
				"name": "PriceA"
			},
			
			{
				"label": "Location:",
				"name": "Location"
			},
			{
				"label": "LocationB:",
				"name": "LocationB"
			},
			{
				"label": "LocationC:",
				"name": "LocationC"
			}
		]
	} );
	$('#INVENTORY').on( 'click', 'tbody td:not(:first-child)', function (e) {
        editor.inline( this );
    } );
	var table = $('#INVENTORY').DataTable( {
		ajax: '../modules/inventorymanage/table.INVENTORY.php',
		columns: [
			{
				"data": "Line"
			},
			
			{
				"data": "SKU"
			},
			{
				"data": "Description"
			},
			{
				"data": "Qty"
			},
			{
				"data": "AvgCost"
			},
			{
				"data": "PriceA"
			},
			{
				"data": "PM_A"
			},
			{
				"data": "PriceB"
			},
			{
				"data": "PM_B"
			},
			{
				"data": "PriceC"
			},
			{
				"data": "PM_C"
			},
			{
				"data": "PriceD"
			},
			{
				"data": "PM_D"
			},
			{
				"data": "PriceE"
			},
			{
				"data": "Location"
			},
			{
				"data": "LocationB"
			},
			{
				"data": "LocationC"
			}
		],
		select: true,
		lengthChange: false,
		paging: false,
		scrollY: 500,
		dom: 'Bfrtip',
		buttons: [
			
			'excelHtml5',
			'copy',
			'pdf',
			'colvis'
		]
		
	} );
	table.buttons().container().appendTo( $('#exportButtons', table.table().container() ) );
	
	
} );

}(jQuery));



