/*!
 * @copyright Copyright &copy; Kartik Visweswaran, Krajee.com, 2015
 * @version 4.1.5
 * File input styled for Bootstrap 3.0 that utilizes HTML5 File Input's advanced 
 * features including the FileReader API. 
 * Author: Kartik Visweswaran
 * Copyright: 2015, Kartik Visweswaran, Krajee.com
 */!function(e){var t=function(e){var i,t=document.createElement("div");return t.innerHTML="<!--[if IE "+e+"]><i></i><![endif]-->",i=1==t.getElementsByTagName("i").length,document.body.appendChild(t),t.parentNode.removeChild(t),i},a=function(){return window.File&&window.FileReader},n=function(){var e=document.createElement("div");return!t(9)&&("draggable"in e||"ondragstart"in e&&"ondrop"in e)},r=function(){return a&&window.FormData},l=function(e,i){e.removeClass(i).addClass(i)},o='style="width:{width};height:{height};"',s='      <param name="controller" value="true" />\n      <param name="allowFullScreen" value="true" />\n      <param name="allowScriptAccess" value="always" />\n      <param name="autoPlay" value="false" />\n      <param name="autoStart" value="false" />\n      <param name="quality" value="high" />\n',d='<div class="file-preview-other">\n       <i class="glyphicon glyphicon-file"></i>\n   </div>',c={removeIcon:'<i class="glyphicon glyphicon-trash text-danger"></i>',removeClass:"btn btn-xs btn-default",removeTitle:"Remove file",uploadIcon:'<i class="glyphicon glyphicon-upload text-info"></i>',uploadClass:"btn btn-xs btn-default",uploadTitle:"Upload file",indicatorNew:'<i class="glyphicon glyphicon-hand-down text-warning"></i>',indicatorSuccess:'<i class="glyphicon glyphicon-ok-sign file-icon-large text-success"></i>',indicatorError:'<i class="glyphicon glyphicon-exclamation-sign text-danger"></i>',indicatorLoading:'<i class="glyphicon glyphicon-hand-up text-muted"></i>',indicatorNewTitle:"Not uploaded yet",indicatorSuccessTitle:"Uploaded",indicatorErrorTitle:"Upload Error",indicatorLoadingTitle:"Uploading ..."},p={main1:'{preview}\n<div class="kv-upload-progress hide"></div>\n<div class="input-group {class}">\n   {caption}\n   <div class="input-group-btn">\n       {remove}\n       {cancel}\n       {upload}\n       {browse}\n   </div>\n</div>',main2:'{preview}\n<div class="kv-upload-progress hide"></div>\n{remove}\n{cancel}\n{upload}\n{browse}\n',preview:'<div class="file-preview {class}">\n    <div class="close fileinput-remove">&times;</div>\n    <div class="{dropClass}">\n    <div class="file-preview-thumbnails">\n    </div>\n    <div class="clearfix"></div>    <div class="file-preview-status text-center text-success"></div>\n    <div class="kv-fileinput-error"></div>\n    </div>\n</div>',icon:'<span class="glyphicon glyphicon-file kv-caption-icon"></span>',caption:'<div tabindex="-1" class="form-control file-caption {class}">\n   <span class="file-caption-ellipsis">&hellip;</span>\n   <div class="file-caption-name"></div>\n</div>',modal:'<div id="{id}" class="modal fade">\n  <div class="modal-dialog modal-lg">\n    <div class="modal-content">\n      <div class="modal-header">\n        <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>\n        <h3 class="modal-title">Detailed Preview <small>{title}</small></h3>\n      </div>\n      <div class="modal-body">\n        <textarea class="form-control" style="font-family:Monaco,Consolas,monospace; height: {height}px;" readonly>{body}</textarea>\n      </div>\n    </div>\n  </div>\n</div>',progress:'<div class="progress">\n    <div class="progress-bar progress-bar-success progress-bar-striped active" role="progressbar" aria-valuenow="{percent}" aria-valuemin="0" aria-valuemax="100" style="width:{percent}%;">\n        {percent}%\n     </div>\n</div>',footer:'<div class="file-thumbnail-footer">\n    <div class="file-caption-name" style="width:{width}">{caption}</div>\n    {actions}\n</div>',actions:'<div class="file-actions">\n    <div class="file-footer-buttons">\n        {upload}{delete}{other}    </div>\n    <div class="file-upload-indicator" tabindex="-1" title="{indicatorTitle}">{indicator}</div>\n    <div class="clearfix"></div>\n</div>',actionDelete:'<button type="button" class="kv-file-remove {removeClass}" title="{removeTitle}"{dataUrl}{dataKey}>{removeIcon}</button>\n',actionUpload:'<button type="button" class="kv-file-upload {uploadClass}" title="{uploadTitle}">{uploadIcon}</button>\n'},f=["image","html","text","video","audio","flash","object"],u={generic:'<div class="file-preview-frame{frameClass}" id="{previewId}" data-fileindex="{fileindex}">\n   {content}\n   {footer}\n</div>\n',html:'<div class="file-preview-frame{frameClass}" id="{previewId}" data-fileindex="{fileindex}">\n    <object data="{data}" type="{type}" width="{width}" height="{height}">\n       '+d+"\n    </object>\n   {footer}\n</div>",image:'<div class="file-preview-frame{frameClass}" id="{previewId}" data-fileindex="{fileindex}">\n   <img src="{data}" class="file-preview-image" title="{caption}" alt="{caption}" '+o+">\n   {footer}\n</div>\n",text:'<div class="file-preview-frame{frameClass}" id="{previewId}" data-fileindex="{fileindex}">\n   <div class="file-preview-text" title="{caption}" '+o+">\n       {data}\n   </div>\n   {footer}\n</div>\n",video:'<div class="file-preview-frame{frameClass}" id="{previewId}" data-fileindex="{fileindex}" title="{caption}" '+o+'>\n   <video width="{width}" height="{height}" controls>\n       <source src="{data}" type="{type}">\n       '+d+"\n   </video>\n   {footer}\n</div>\n",audio:'<div class="file-preview-frame{frameClass}" id="{previewId}" data-fileindex="{fileindex}" title="{caption}" '+o+'>\n   <audio controls>\n       <source src="{data}" type="{type}">\n       '+d+"\n   </audio>\n   {footer}\n</div>\n",flash:'<div class="file-preview-frame{frameClass}" id="{previewId}" data-fileindex="{fileindex}" title="{caption}" '+o+'>\n   <object type="application/x-shockwave-flash" width="{width}" height="{height}" data="{data}">\n'+s+"       "+d+"\n   </object>\n   {footer}\n</div>\n",object:'<div class="file-preview-frame{frameClass}" id="{previewId}" data-fileindex="{fileindex}" title="{caption}" '+o+'>\n    <object data="{data}" type="{type}" width="{width}" height="{height}">\n      <param name="movie" value="{caption}" />\n'+s+"           "+d+"\n   </object>\n   {footer}\n</div>",other:'<div class="file-preview-frame{frameClass}" id="{previewId}" data-fileindex="{fileindex}" title="{caption}" '+o+">\n   "+d+"\n   {footer}\n</div>"},v={image:{width:"auto",height:"160px"},html:{width:"213px",height:"160px"},text:{width:"160px",height:"160px"},video:{width:"213px",height:"160px"},audio:{width:"213px",height:"80px"},flash:{width:"213px",height:"160px"},object:{width:"160px",height:"160px"},other:{width:"160px",height:"160px"}},g={image:function(e,i){return"undefined"!=typeof e?e.match("image.*"):i.match(/\.(gif|png|jpe?g)$/i)},html:function(e,i){return"undefined"!=typeof e?"text/html"==e:i.match(/\.(htm|html)$/i)},text:function(e,i){return"undefined"!=typeof e&&e.match("text.*")||i.match(/\.(txt|md|csv|nfo|php|ini)$/i)},video:function(e,i){return"undefined"!=typeof e&&e.match(/\.video\/(ogg|mp4|webm)$/i)||i.match(/\.(og?|mp4|webm)$/i)},audio:function(e,i){return"undefined"!=typeof e&&e.match(/\.audio\/(ogg|mp3|wav)$/i)||i.match(/\.(ogg|mp3|wav)$/i)},flash:function(e,i){return"undefined"!=typeof e&&"application/x-shockwave-flash"==e||i.match(/\.(swf)$/i)},object:function(){return!0},other:function(){return!0}},h=function(i,t){return null===i||void 0===i||i==[]||""===i||t&&""===e.trim(i)},m=function(e){return Array.isArray(e)||"[object Array]"===Object.prototype.toString.call(e)},w=function(e,i){return"object"==typeof i&&e in i},b=function(i,t,a){return h(i)||h(i[t])?a:e(i[t])},C=function(){return Math.round((new Date).getTime()+100*Math.random())},y=function(e){return String(e).replace(/&/g,"&amp;").replace(/"/g,"&quot;").replace(/'/g,"&#39;").replace(/</g,"&lt;").replace(/>/g,"&gt;")},x=window.URL||window.webkitURL,$=function(i,n){this.$element=e(i),a()||t(9)?(this.init(n),this.listen()):this.$element.removeClass("file-loading")};$.prototype={constructor:$,init:function(i){var a=this,o=a.$element;for(key in i)a[key]=i[key];h(a.allowedPreviewTypes)&&(a.allowedPreviewTypes=f),a.uploadFileAttr=h(o.attr("name"))?"file_data":o.attr("name"),a.reader=null,a.formdata={},a.isIE9=t(9),a.isIE10=t(10),a.filestack=[],a.ajaxRequests=[],a.isError=!1,a.dropZoneEnabled=n()&&a.dropZoneEnabled,a.isDisabled=a.$element.attr("disabled")||a.$element.attr("readonly"),a.isUploadable=r&&!h(a.uploadUrl),a.slug="function"==typeof i.slugCallback?i.slugCallback:a.slugDefault,a.mainTemplate=a.getLayoutTemplate(a.showCaption?"main1":"main2"),a.captionTemplate=a.getLayoutTemplate("caption"),a.previewGenericTemplate=a.getPreviewTemplate("generic"),h(a.$element.attr("id"))&&a.$element.attr("id",C()),"undefined"==typeof a.$container?a.$container=a.createContainer():a.refreshContainer(),a.$progress=a.$container.find(".kv-upload-progress"),a.$btnUpload=a.$container.find(".kv-fileinput-upload"),a.$captionContainer=b(i,"elCaptionContainer",a.$container.find(".file-caption")),a.$caption=b(i,"elCaptionText",a.$container.find(".file-caption-name")),a.$previewContainer=b(i,"elPreviewContainer",a.$container.find(".file-preview")),a.$preview=b(i,"elPreviewImage",a.$container.find(".file-preview-thumbnails")),a.$previewStatus=b(i,"elPreviewStatus",a.$container.find(".file-preview-status")),a.$errorContainer=b(i,"elErrorContainer",a.$previewContainer.find(".kv-fileinput-error")),h(a.msgErrorClass)||l(a.$errorContainer,a.msgErrorClass),a.$errorContainer.hide(),a.initialPreviewContent="";var s=a.initialPreview;a.initialPreviewCount=m(s)?s.length:s.length>0?s.split(a.initialPreviewDelimiter).length:0,a.fileActionSettings=e.extend(c,i.fileActionSettings),a.previewInitId="preview-"+C(),a.initPreview(),a.initPreviewDeletes(),a.original={preview:a.$preview.html(),caption:a.$caption.html()},a.options=i,a.setFileDropZoneTitle(),a.uploadCount=0,a.uploadPercent=0,a.$element.removeClass("file-loading"),a.setEllipsis()},raise:function(e){var i=this;arguments.length>1?i.$element.trigger(e,arguments[1]):i.$element.trigger(e)},getLayoutTemplate:function(e){var i=this;return w(e,i.layoutTemplates)?i.layoutTemplates[e]:p[e]},getPreviewTemplate:function(e){var i=this;return w(e,i.previewTemplates)?i.previewTemplates[e]:u[e]},getOutData:function(){var e=this,i=arguments.length>0?arguments[0]:{},t=arguments.length>1?arguments[1]:{},a=arguments.length>2?arguments[2]:e.filestack;return{form:e.formdata,files:a,extra:e.getExtraData(),response:t,reader:e.reader,jqXHR:i}},setEllipsis:function(){var e=this,i=e.$captionContainer.find(".file-caption-ellipsis"),t=e.$caption,a=t.clone().css("height","auto").hide();e.$captionContainer.parent().before(a),a.outerWidth()>t.outerWidth()?i.show():i.hide(),a.remove()},listen:function(){var i=this,t=i.$element,a=i.$captionContainer,n=i.$btnFile;t.on("change",e.proxy(i.change,i)),e(window).on("resize",function(){i.setEllipsis()}),n.off("click").on("click",function(){i.raise("filebrowse"),i.isError&&!i.isUploadable&&i.clear(!1),a.focus()}),t.closest("form").off("reset").on("reset",e.proxy(i.reset,i)),i.$container.off("click").on("click",".fileinput-remove:not([disabled])",e.proxy(i.clear,i)).on("click",".fileinput-cancel",e.proxy(i.cancel,i)),i.isUploadable&&i.dropZoneEnabled&&i.showPreview&&i.initDragDrop(),i.isUploadable&&i.$container.find(".kv-fileinput-upload").off("click").on("click",function(t){if(i.isUploadable){t.preventDefault();var a=i.getFileStack().length;if(!i.isDisabled&&!e(this).hasClass("disabled")&&h(e(this).attr("disabled"))&&0!=a){i.resetUpload(),i.$progress.removeClass("hide"),i.uploadCount=0,i.uploadPercent=0;{var n,r=i.filestack.length;i.getLayoutTemplate("progress")}if(i.lock(),i.setProgress(0),(i.uploadAsync||1==a)&&i.showPreview){var l=i.getOutData();for(i.raise("filebatchpreupload",[l]),n=0;r>n;n++)void 0!==i.filestack[n]&&i.upload(n,i.filestack,!0);return void setTimeout(function(){e(document).ajaxStop(function(){i.setProgress(100),i.$preview.find("file-preview-frame").removeClass("file-loading"),i.unlock(),i.clearFileInput(),i.raise("filebatchuploadcomplete",[i.filestack,i.getExtraData()])})},100)}i.uploadBatch()}}})},setProgress:function(e){var i=this,t=i.getLayoutTemplate("progress"),a=Math.min(e,100);i.$progress.html(t.replace(/\{percent\}/g,a))},lock:function(){var e=this;e.resetErrors(),e.disable(),e.showRemove&&l(e.$container.find(".fileinput-remove"),"hide"),e.showCancel&&e.$container.find(".fileinput-cancel").removeClass("hide"),e.raise("filelock",[e.filestack,e.getExtraData()])},unlock:function(){var e=this;e.enable(),e.showCancel&&l(e.$container.find(".fileinput-cancel"),"hide"),e.showRemove&&e.$container.find(".fileinput-remove").removeClass("hide"),e.raise("fileunlock",[e.filestack,e.getExtraData()])},refresh:function(i){var t=this,a=t.$element,n=arguments.length?e.extend(t.options,i):t.options;a.off(),t.init(n);var r=t.$container.find(".file-drop-zone");r.off("dragenter dragover drop"),e(document).off("dragenter dragover drop"),t.listen(),t.setFileDropZoneTitle()},initDragDrop:function(){var i=this,t=i.$container.find(".file-drop-zone");t.off("dragenter dragover drop"),e(document).off("dragenter dragover drop"),t.on("dragenter dragover",function(t){t.stopPropagation(),t.preventDefault(),i.isDisabled||l(e(this),"highlighted")}),t.on("dragleave",function(t){t.stopPropagation(),t.preventDefault(),i.isDisabled||e(this).removeClass("highlighted")}),t.on("drop",function(t){t.preventDefault(),i.isDisabled||(i.change(t,"dragdrop"),e(this).removeClass("highlighted"))}),e(document).on("dragenter dragover drop",function(e){e.stopPropagation(),e.preventDefault()})},setFileDropZoneTitle:function(){var e=this,i=e.$container.find(".file-drop-zone");i.find("."+e.dropZoneTitleClass).remove(),e.isUploadable&&e.showPreview&&0!=i.length&&!(e.getFileStack().length>0)&&e.dropZoneEnabled&&(0==i.find(".file-preview-frame").length&&i.prepend('<div class="'+e.dropZoneTitleClass+'">'+e.dropZoneTitle+"</div>"),e.$container.removeClass("file-input-new"),l(e.$container,"file-input-ajax-new"))},initFileActions:function(){var i=this;i.$preview.find(".kv-file-remove").each(function(){var t=e(this),a=t.closest(".file-preview-frame"),n=a.attr("data-fileindex");t.off("click").on("click",function(){a.fadeOut("slow",function(){i.filestack[n]=void 0,i.clearObjects(a),a.remove();var e=i.getFileStack(),t=e.length,r=i.$container.find(".file-preview-initial").length;if(0==t&&0==r)i.original.preview="",i.reset();else{var l=i.initialPreviewCount+t,o=l>1?i.msgSelected.replace(/\{n\}/g,l):e[0].name;i.setCaption(o)}})})}),i.$preview.find(".kv-file-upload").each(function(){var t=e(this);t.off("click").on("click",function(){var e=t.closest(".file-preview-frame"),a=e.attr("data-fileindex");i.upload(a,i.filestack)})})},renderInitFileFooter:function(e){var i=this,t=i.initialPreviewConfig.length>0,a=i.getLayoutTemplate("footer");if(t&&!h(i.initialPreviewConfig[e])){var n=i.initialPreviewConfig[e],r="caption"in n?n.caption:"",l="width"in n?n.width:"auto",o="url"in n?n.url:!1,s="key"in n?n.key:null,d=o===!1?!0:!1,c=i.initialPreviewShowDelete?i.renderFileActions(!1,!0,d,o,s):"",p=a.replace(/\{actions\}/g,c);return p.replace(/\{caption\}/g,r).replace(/\{width\}/g,l).replace(/\{indicator\}/g,"").replace(/\{indicatorTitle\}/g,"")}return""},renderFileFooter:function(e,i){var t=this,a=t.fileActionSettings,n=t.getLayoutTemplate("footer");if(t.isUploadable){var r=n.replace(/\{actions\}/g,t.renderFileActions(!0,!0,!1,!1,!1));return r.replace(/\{caption\}/g,e).replace(/\{width\}/g,i).replace(/\{indicator\}/g,a.indicatorNew).replace(/\{indicatorTitle\}/g,a.indicatorNewTitle)}return n.replace(/\{actions\}/g,"").replace(/\{caption\}/g,e).replace(/\{width\}/g,i).replace(/\{indicator\}/g,"").replace(/\{indicatorTitle\}/g,"")},renderFileActions:function(e,i,t,a,n){if(!e&&!i)return"";var r=this,l=0==a?"":' data-url="'+a+'"',o=0==n?"":' data-key="'+n+'"',s=r.getLayoutTemplate("actionDelete"),d="",c=r.getLayoutTemplate("actions"),p=r.otherActionButtons.replace(/\{dataKey\}/g,o),f=r.fileActionSettings,u=t?f.removeClass+" disabled":f.removeClass;return s=s.replace(/\{removeClass\}/g,u).replace(/\{removeIcon\}/g,f.removeIcon).replace(/\{removeTitle\}/g,f.removeTitle).replace(/\{dataUrl\}/g,l).replace(/\{dataKey\}/g,o),e&&(d=r.getLayoutTemplate("actionUpload").replace(/\{uploadClass\}/g,f.uploadClass).replace(/\{uploadIcon\}/g,f.uploadIcon).replace(/\{uploadTitle\}/g,f.uploadTitle)),c.replace(/\{delete\}/g,s).replace(/\{upload\}/g,d).replace(/\{other\}/g,p)},getInitialPreview:function(e,i,t){var a=this,n="init_"+t,r=a.previewInitId+"-"+n;return footer=a.renderInitFileFooter(t,!1),e.replace(/\{previewId\}/g,r).replace(/\{frameClass\}/g," file-preview-initial").replace(/\{fileindex\}/g,n).replace(/\{content\}/g,i).replace(/\{footer\}/g,footer)},initPreview:function(){{var e=this,i="",t=e.initialPreview,a=e.initialPreviewCount,n=e.initialCaption.length;e.previewInitId+"-init_"+r}if(caption=n>0?e.initialCaption:e.msgSelected.replace(/\{n\}/g,a),m(t)&&a>0){for(var r=0;a>r;r++)i+=e.getInitialPreview(e.previewGenericTemplate,t[r],r);a>1&&0==n&&(caption=e.msgSelected.replace(/\{n\}/g,a))}else{if(!(a>0))return n>0?void e.setCaption(caption):void 0;for(var r=(t.split(e.initialPreviewDelimiter),0);a>r;r++)i+=e.getInitialPreview(e.previewGenericTemplate,t[r],r);a>1&&0==n&&(caption=e.msgSelected.replace(/\{n\}/g,a))}e.initialPreviewContent=i,e.$preview.html(i),e.setCaption(caption),e.$container.removeClass("file-input-new")},initPreviewDeletes:function(){var i=this,t=function(){0==i.$preview.find(".kv-file-remove").length&&i.reset()};i.$preview.find(".kv-file-remove").each(function(){{var a=e(this),n=a.closest(".file-preview-frame"),r=a.attr("data-url"),o=a.attr("data-key");e(i.initialPreviewContent)}void 0!==r&&void 0!==o&&a.off("click").on("click",function(){e.ajax({url:r,type:"POST",dataType:"json",data:{key:o},beforeSend:function(e){l(n,"file-uploading"),l(a,"disabled"),i.raise("filepredelete",[o,e])},success:function(r,l,s){"undefined"==typeof r.error?i.raise("filedeleted",[o,s]):(i.showError(r.error,null,a.attr("id"),key,"filedeleteerror",s),t()),n.removeClass("file-uploading").addClass("file-deleted"),n.fadeOut("slow",function(){i.clearObjects(n),n.remove();var a=e(document.createElement("div")).html(i.original.preview);a.find(".file-preview-frame").each(function(){var i=e(this);i.find(".kv-file-remove").attr("data-key")==o&&i.remove()}),i.initialPreviewContent=a.html(),i.initialPreviewCount>0&&i.initialPreviewCount--;var r=i.initialCaption.length>0?i.initialCaption:i.msgSelected.replace(/\{n\}/g,i.initialPreviewCount);i.original.preview=a.html(),i.setCaption(r),i.original.caption=i.$caption.html(),a.remove(),t()})},error:function(e,r,l){i.showError(l,null,a.attr("id"),key,"filedeleteerror",e),n.removeClass("file-uploading"),t()}})})})},clearObjects:function(i){i.find("video audio").each(function(){this.pause(),delete this,e(this).remove()}),i.find("img object div").each(function(){delete this,e(this).remove()})},clearFileInput:function(){var i=this,t=i.$element;if(!h(t.val()))if(i.isIE9||i.isIE10){var a=t.closest("form"),n=e(document.createElement("form")),r=e(document.createElement("div"));t.before(r),a.length?a.after(n):r.after(n),n.append(t).trigger("reset"),r.before(t).remove(),n.remove()}else t.val("")},resetUpload:function(){var e=this;e.uploadCount=0,e.uploadPercent=0,e.$btnUpload.removeAttr("disabled"),e.setProgress(0),l(e.$progress,"hide"),e.resetErrors(!1),e.ajaxRequests=[]},cancel:function(){var t=this,a=t.ajaxRequests,n=a.length;if(n>0){for(i=0;n>i;i++)a[i].abort();t.$preview.find("file-preview-frame").each(function(){$thumb=e(this),ind=$thumb.attr("data-fileindex"),$thumb.removeClass("file-uploading"),void 0!==t.filestack[ind]&&($thumb.find(".kv-file-upload").removeClass("disabled"),$thumb.find(".kv-file-upload").removeClass("disabled"))}),t.unlock()}},clear:function(){var i=this,t=arguments.length>0&&arguments[0];if(!i.isIE9&&i.reader instanceof FileReader&&i.reader.abort(),i.$btnUpload.removeAttr("disabled"),i.resetUpload(),i.filestack=[],i.clearFileInput(),i.resetErrors(!0),t!==!1&&(i.raise("change"),i.raise("fileclear")),i.overwriteInitial&&(i.initialPreviewCount=0,i.initialPreviewContent=""),!i.overwriteInitial&&i.initialPreviewContent.length>0)i.showFileIcon(),i.$preview.html(i.original.preview),i.$caption.html(i.original.caption),i.setEllipsis(),i.initPreviewDeletes(),i.$container.removeClass("file-input-new");else{i.$preview.find(".file-preview-frame").each(function(){i.clearObjects(e(this))}),i.$preview.html("");var a=!i.overwriteInitial&&i.initialCaption.length>0?i.original.caption:"";i.$caption.html(a),i.setEllipsis(),i.$caption.attr("title",""),l(i.$container,"file-input-new")}0==i.$container.find(".file-preview-frame").length&&(i.initialCaption="",i.original.caption="",i.$caption.html(""),i.setEllipsis(),i.$captionContainer.find(".kv-caption-icon").hide()),i.hideFileIcon(),i.raise("filecleared"),i.$captionContainer.focus(),i.setFileDropZoneTitle()},reset:function(){var e=this;e.clear(!1),e.$preview.html(e.original.preview),e.$caption.html(e.original.caption),e.setEllipsis(),e.$container.find(".fileinput-filename").text(""),e.raise("filereset"),e.initialPreview.length>0&&e.$container.removeClass("file-input-new"),e.setFileDropZoneTitle(),e.isUploadable&&e.resetUpload(),e.filestack=[],e.formdata={}},disable:function(){var e=this;e.isDisabled=!0,e.$element.attr("disabled","disabled"),e.$container.find(".kv-fileinput-caption").addClass("file-caption-disabled"),e.$container.find(".btn-file, .fileinput-remove, .kv-fileinput-upload").attr("disabled",!0),e.initDragDrop()},enable:function(){var e=this;e.isDisabled=!1,e.$element.removeAttr("disabled"),e.$container.find(".kv-fileinput-caption").removeClass("file-caption-disabled"),e.$container.find(".btn-file, .fileinput-remove, .kv-fileinput-upload").removeAttr("disabled"),e.initDragDrop()},getExtraData:function(){var e=this,i=e.uploadExtraData;return"function"==typeof e.uploadExtraData&&(i=e.uploadExtraData()),i},uploadExtra:function(i){var t=this,a=t.getExtraData();0!=a.length&&e.each(a,function(e,t){h(e)||h(t)||i.append(e,t)})},initXhr:function(e,i){var t=this;return e.upload&&e.upload.addEventListener("progress",function(e){var a=0,n=e.loaded||e.position,r=e.total;e.lengthComputable&&(a=Math.ceil(n/r*i)),t.uploadPercent=Math.max(a,t.uploadPercent),t.setProgress(t.uploadPercent)},!1),e},upload:function(i,t){var a=this,n=a.getFileStack().length,r=new FormData,o=a.previewInitId+"-"+i,s=e("#"+o),d=s.find(".kv-file-upload"),c=s.find(".kv-file-remove"),p=s.find(".file-upload-indicator"),f=a.fileActionSettings;if(a.formdata=r,0!=n&&!d.hasClass("disabled")){var u=arguments.length>2,v=function(e,i){p.html(f[e]),p.attr("title",f[i])},g=function(){if(u&&0!=n&&!(a.uploadPercent>=100)){a.uploadCount++;var e=80+Math.ceil(20*a.uploadCount/n);a.uploadPercent=Math.max(e,a.uploadPercent),a.setProgress(a.uploadPercent),a.initPreviewDeletes()}},h=function(){d.removeAttr("disabled"),c.removeAttr("disabled"),s.removeClass("file-uploading")};r.append(a.uploadFileAttr,t[i]),r.append("file_id",i),a.uploadExtra(r),a.ajaxRequests.push(e.ajax({xhr:function(){var i=e.ajaxSettings.xhr();return a.initXhr(i,80)},url:a.uploadUrl,type:"POST",dataType:"json",data:r,cache:!1,processData:!1,contentType:!1,beforeSend:function(e){var t=a.getOutData(e);v("indicatorLoading","indicatorLoadingTitle"),l(s,"file-uploading"),d.attr("disabled",!0),c.attr("disabled",!0),u||a.lock(),a.raise("filepreupload",[t,o,i])},success:function(e,t,n){var r=a.getOutData(n,e);setTimeout(function(){"undefined"==typeof e.error?(v("indicatorSuccess","indicatorSuccessTitle"),d.hide(),c.hide(),a.filestack[i]=void 0,a.raise("fileuploaded",[r,o,i])):(v("indicatorError","indicatorErrorTitle"),a.showUploadError(e.error,r,o,i))},100)},complete:function(){setTimeout(function(){g(),h()},100),u||a.unlock()},error:function(e,n,r){v("indicatorError","indicatorErrorTitle");var l=a.getOutData(e);if(u){var s=t[i].name;a.showUploadError("<b>"+s+"</b>: "+r,l,o,i)}else a.showUploadError(r,l,o,i)}}))}},uploadBatch:function(){var i=this,t=i.filestack,a=t.length,n=new FormData;if(i.formdata=n,0!=a){var r=i.fileActionSettings,o=function(t,a,n){var l=e("#"+i.previewInitId+"-"+t).find(".file-upload-indicator");l.html(r[a]),l.attr("title",r[n])},s=function(t){var a=e("#"+i.previewInitId+"-"+t),n=a.find(".kv-file-upload"),r=a.find(".kv-file-delete");a.removeClass("file-uploading"),n.removeAttr("disabled"),r.removeAttr("disabled")},d=function(){e.each(t,function(e){i.filestack[e]=void 0}),i.clearFileInput()};e.each(t,function(e){void 0!==t[e]&&n.append(i.uploadFileAttr,t[e])}),i.uploadExtra(n),i.ajaxRequests.push(e.ajax({xhr:function(){var t=e.ajaxSettings.xhr();return i.initXhr(t,98)},url:i.uploadUrl,type:"POST",dataType:"json",data:n,cache:!1,processData:!1,contentType:!1,beforeSend:function(t){i.lock();var a=i.getOutData(t);i.showPreview&&(i.$preview.find(".file-preview-frame").each(function(){var i=e(this),t=i.find(".kv-file-upload"),a=i.find(".kv-file-remove");l(i,"file-uploading"),t.attr("disabled",!0),a.attr("disabled",!0)}),i.raise("filebatchpreupload",[a]))},success:function(t,a,n){var r=i.getOutData(n,t),l=h(t.errorkeys)?[]:t.errorkeys;"undefined"==typeof t.error||h(t.error)?(i.raise("filebatchuploadsuccess",[r]),d(),i.showPreview?(i.$preview.find(".kv-file-upload").hide(),i.$preview.find(".kv-file-remove").hide(),i.$preview.find(".file-preview-frame").each(function(){var i=e(this),t=i.attr("data-fileindex");o(t,"indicatorSuccess","indicatorSuccessTitle"),s(t)})):i.reset()):(i.$preview.find(".file-preview-frame").each(function(){var t=e(this),a=t.attr("data-fileindex");return s(a),0==l.length?void o(a,"indicatorError","indicatorErrorTitle"):void(e.inArray(a,l)?o(a,"indicatorError","indicatorErrorTitle"):(t.find(".kv-file-upload").hide(),t.find(".kv-file-remove").hide(),o(a,"indicatorSuccess","indicatorSuccessTitle"),i.filestack[a]=void 0))}),i.showUploadError(t.error,r,null,null,"filebatchuploaderror"))},complete:function(){i.setProgress(100),i.unlock(),i.raise("filebatchuploadcomplete",[i.filestack,i.getExtraData()]),i.clearFileInput()},error:function(e,t,n){var r=i.getOutData(e);i.showUploadError(n,r,null,null,"filebatchuploaderror"),i.uploadFileCount=a-1,i.$preview.find(".file-preview-frame").removeClass("file-uploading"),i.$preview.find(".file-preview-frame kv-file-upload").removeAttr("disabled"),i.$preview.find(".file-preview-frame kv-file-delete").removeAttr("disabled")}}))}},hideFileIcon:function(){this.overwriteInitial&&this.$captionContainer.find(".kv-caption-icon").hide()},showFileIcon:function(){this.$captionContainer.find(".kv-caption-icon").show()},resetErrors:function(e){var i=this,t=i.$errorContainer;i.isError=!1,i.$container.removeClass("has-error"),t.html(""),e?t.fadeOut("slow"):t.hide()},showUploadError:function(e,i,t,a){var n=this,r=n.$errorContainer,o=arguments.length>4?arguments[4]:"fileuploaderror";return 0==r.find("ul").length?r.html('<ul class="text-left"><li>'+e+"</li></ul>"):r.find("ul").append("<li>"+e+"</li>"),r.fadeIn(800),n.raise(o,[i,t,a,n.reader]),l(n.$container,"has-error"),!0},showError:function(e,i,t,a){var n=this,r=n.$errorContainer,o=arguments.length>4?arguments[4]:"fileerror",s=arguments.length>5?arguments[5]:{};return r.html(e),r.fadeIn(800),n.raise(o,[i,t,a,n.reader,s]),n.isUploadable||n.clearFileInput(),l(n.$container,"has-error"),n.$btnUpload.attr("disabled",!0),!0},errorHandler:function(e,i){var t=this;switch(e.target.error.code){case e.target.error.NOT_FOUND_ERR:t.addError(t.msgFileNotFound.replace(/\{name\}/g,i));break;case e.target.error.NOT_READABLE_ERR:t.addError(t.msgFileNotReadable.replace(/\{name\}/g,i));break;case e.target.error.ABORT_ERR:t.addError(t.msgFilePreviewAborted.replace(/\{name\}/g,i));break;default:t.addError(t.msgFilePreviewError.replace(/\{name\}/g,i))}},parseFileType:function(e){for(var i,t,a=0;a<f.length;a++)if(cat=f[a],i=w(cat,self.fileTypeSettings)?self.fileTypeSettings[cat]:g[cat],t=i(e.type,e.name)?cat:"",""!=t)return t;return"other"},previewDefault:function(i,t){var a=this;if(a.showPreview){var n=x.createObjectURL(i),r=e("#"+t),l=a.previewSettings.other,o=a.isUploadable?a.renderFileFooter(i.name,l.width):a.renderFileFooter(i.name,l.width,!1),s=a.getPreviewTemplate("other"),d=t.slice(t.lastIndexOf("-")+1),c="";if(arguments.length>2){{e(a.msgValidationError)}c=" btn disabled",o+='<div class="file-other-error text-danger"><i class="glyphicon glyphicon-exclamation-sign"></i></div>'}a.$preview.append("\n"+s.replace(/\{previewId\}/g,t).replace(/\{frameClass\}/g,c).replace(/\{fileindex\}/g,d).replace(/\{caption\}/g,a.slug(i.name)).replace(/\{width\}/g,l.width).replace(/\{height\}/g,l.height).replace(/\{type\}/g,i.type).replace(/\{data\}/g,n).replace(/\{footer\}/g,o)),r.on("load",function(){x.revokeObjectURL(r.attr("data"))})}},previewFile:function(e,i,t,a){var n=this;if(n.showPreview){var a,r,l=n.parseFileType(e),o=n.slug(e.name),s=n.allowedPreviewTypes,d=n.allowedPreviewMimeTypes,c=(e.type,w(l,n.previewTemplates)?n.previewTemplates[l]:u[l]),p=w(l,n.previewSettings)?n.previewSettings[l]:v[l],f=parseInt(n.wrapTextLength),g=n.wrapIndicator,m=n.$preview,b=s.indexOf(l)>=0,$=h(d)||!h(d)&&w(e.type,d),T=n.renderFileFooter(o,p.width),k=t.slice(t.lastIndexOf("-")+1);if(b&&$){if("text"==l){var E=y(i.target.result);if(x.revokeObjectURL(a),E.length>f){var F="text-"+C(),P=.75*window.innerHeight,I=n.getLayoutTemplate("modal").replace(/\{id\}/g,F).replace(/\{title\}/g,o).replace(/\{height\}/g,P).replace(/\{body\}/g,E);g=g.replace(/\{title\}/g,o).replace(/\{dialog\}/g,"$('#"+F+"').modal('show')"),E=E.substring(0,f-1)+g}r=c.replace(/\{previewId\}/g,t).replace(/\{caption\}/g,o).replace(/\{frameClass\}/g,"").replace(/\{type\}/g,e.type).replace(/\{width\}/g,p.width).replace(/\{height\}/g,p.height).replace(/\{data\}/g,E).replace(/\{footer\}/g,T).replace(/\{fileindex\}/g,k)+I}else r=c.replace(/\{previewId\}/g,t).replace(/\{caption\}/g,o).replace(/\{frameClass\}/g,"").replace(/\{type\}/g,e.type).replace(/\{data\}/g,a).replace(/\{width\}/g,p.width).replace(/\{height\}/g,p.height).replace(/\{footer\}/g,T).replace(/\{fileindex\}/g,k);m.append("\n"+r),n.autoSizeImage(t)}else n.previewDefault(e,t)}},slugDefault:function(e){return h(e)?"":e.split(/(\\|\/)/g).pop().replace(/[^\w-.\\\/ ]+/g,"")},getFileStack:function(){var e=this;return e.filestack.filter(function(e){return void 0!=e})},readFiles:function(e){function i(g){if(h(a.attr("multiple"))&&(p=1),g>=p)return l.removeClass("loading"),void o.html("");var w,C,y,$,T,k=v+g,E=c+"-"+k,F=e[g],P=t.slug(F.name),I=(F.size?F.size:0)/1e3,D=x.createObjectURL(F),S=0,U=t.allowedFileTypes,j=h(U)?"":U.join(", "),A=t.allowedFileExtensions,L=h(A)?"":A.join(", "),R=h(A)?"":new RegExp("\\.("+A.join("|")+")$","i");if(I=I.toFixed(2),t.maxFileSize>0&&I>t.maxFileSize)return y=t.msgSizeTooLarge.replace(/\{name\}/g,P).replace(/\{size\}/g,I).replace(/\{maxSize\}/g,t.maxFileSize),void(t.isError=b(y,F,E,g));if(!h(U)&&m(U)){for(C=0;C<U.length;C++)$=U[C],w=f[$],T=void 0!==w&&w(F.type,P),S+=h(T)?0:T.length;if(0==S)return y=t.msgInvalidFileType.replace(/\{name\}/g,P).replace(/\{types\}/g,j),void(t.isError=b(y,F,E,g))}return 0!=S||h(A)||!m(A)||h(R)||(T=P.match(R),S+=h(T)?0:T.length,0!=S)?t.showPreview?(n.length>0&&"undefined"!=typeof FileReader?(o.html(s.replace(/\{index\}/g,g+1).replace(/\{files\}/g,p)),l.addClass("loading"),r.onerror=function(e){t.errorHandler(e,P)},r.onload=function(e){t.previewFile(F,e,E,D),t.initFileActions()},r.onloadend=function(){var e=d.replace(/\{index\}/g,g+1).replace(/\{files\}/g,p).replace(/\{percent\}/g,50).replace(/\{name\}/g,P);setTimeout(function(){o.html(e),x.revokeObjectURL(D)},100),setTimeout(function(){i(g+1),t.updateFileDetails(p)},100),t.raise("fileloaded",[F,E,g,r])},r.onprogress=function(e){if(e.lengthComputable){var i=parseInt(e.loaded/e.total*100,10),t=d.replace(/\{index\}/g,g+1).replace(/\{files\}/g,p).replace(/\{percent\}/g,i).replace(/\{name\}/g,P);setTimeout(function(){o.html(t)},100)}},u(F.type,P)?r.readAsText(F,t.textEncoding):r.readAsArrayBuffer(F)):(t.previewDefault(F,E),setTimeout(function(){i(g+1),t.updateFileDetails(p)},100),t.raise("fileloaded",[F,E,g,r])),void t.filestack.push(F)):(t.filestack.push(F),setTimeout(i(g+1),100),void t.raise("fileloaded",[F,E,g,r])):(y=t.msgInvalidFileExtension.replace(/\{name\}/g,P).replace(/\{extensions\}/g,L),void(t.isError=b(y,F,E,g)))
}this.reader=new FileReader;var t=this,a=t.$element,n=t.$preview,r=t.reader,l=t.$previewContainer,o=t.$previewStatus,s=t.msgLoading,d=t.msgProgress,c=(t.msgSelected,t.previewFileType,parseInt(t.wrapTextLength),t.wrapIndicator,t.previewInitId),p=e.length,f=t.fileTypeSettings,u=w("text",f)?f.text:g.text,v=t.filestack.length,b=function(i,a,n,r){t.previewDefault(a,n,!0);var l=t.getOutData({},{},e);return t.isUploadable?t.showUploadError(i,l,n,r):t.showError(i,a,n,r)};i(0),t.updateFileDetails(p,!1)},updateFileDetails:function(e){var i=this,t=i.msgSelected,a=i.$element,n=i.getFileStack(),r=a.val()||n.length&&n[0].name||"",l=i.slug(r),o=i.isUploadable?n.length:e;e=i.initialPreviewCount+o,log=o>1?t.replace(/\{n\}/g,e):l,i.isError?(i.$previewContainer.removeClass("loading"),i.$previewStatus.html(""),i.$captionContainer.find(".kv-caption-icon").hide(),log=i.msgValidationError):i.showFileIcon(),i.setCaption(log),i.$container.removeClass("file-input-new file-input-ajax-new"),1==arguments.length&&i.raise("fileselect",[e,l])},change:function(e){var i,t=this,a=t.$element,n=(t.slug(a.val()),0),r=t.$preview,l=arguments.length>1,o=l?e.originalEvent.dataTransfer.files:a.get(0).files,s=(t.msgSelected,h(o)?1:o.length+t.initialPreviewCount,t.filestack.length),d=t.isUploadable&&0!=s,c=h(a.attr("multiple")),p=function(e,i,a,n){var r=t.getOutData({},{},o);return t.isUploadable?t.showUploadError(e,r,a,n):t.showError(e,i,a,n)};if(t.resetUpload(),t.hideFileIcon(),t.$container.find(".file-drop-zone ."+t.dropZoneTitleClass).remove(),i=l?o:void 0===e.target.files?e.target&&e.target.value?[{name:e.target.value.replace(/^.+\\/,"")}]:[]:e.target.files,h(i)||0===i.length)return d||t.clear(!1),void t.raise("fileselectnone");t.resetErrors(),(!d||c&&s>0)&&(r.html(t.overwriteInitial?"":t.initialPreviewContent),c&&s>0&&(t.filestack=[]));var n=t.isUploadable?t.getFileStack().length+i.length:i.length;if(t.maxFileCount>0&&n>t.maxFileCount){var f=t.msgFilesTooMany.replace(/\{m\}/g,t.maxFileCount).replace(/\{n\}/g,n);return t.isError=p(f,null,null,null),t.$captionContainer.find(".kv-caption-icon").hide(),t.$caption.html(t.msgValidationError),t.setEllipsis(),void t.$container.removeClass("file-input-new file-input-ajax-new")}t.isIE9?t.updateFileDetails(1):t.readFiles(o),t.reader=null},autoSizeImage:function(e){var i=this,t=i.$preview,a=t.find("#"+e),n=a.find("img");n.length&&n.on("load",function(){var r=a.width(),l=t.width();r>l&&(n.css("width","100%"),a.css("width","97%"));var o=n.closest(".file-preview-frame").find(".file-caption-name");o.length&&(o.width(n.width()),o.attr("title",o.text())),i.raise("fileimageloaded",e)})},setCaption:function(i){var t=this,a=e("<div>"+i+"</div>").text(),n=t.getLayoutTemplate("icon"),r=n+a;0!=t.$caption.length&&(t.$caption.html(r),t.$caption.attr("title",a),t.$captionContainer.find(".file-caption-ellipsis").attr("title",a),t.setEllipsis())},initBrowse:function(e){var i=this;i.$btnFile=e.find(".btn-file"),i.$btnFile.append(i.$element)},createContainer:function(){var i=this,t=e(document.createElement("span")).attr({"class":"file-input file-input-new"}).html(i.renderMain());return i.$element.before(t),i.initBrowse(t),t},refreshContainer:function(){var e=this,i=e.$container;i.before(e.$element),i.html(e.renderMain()),e.initBrowse(i)},renderMain:function(){var e=this,i=e.isUploadable&&e.dropZoneEnabled?" file-drop-zone":"",t=e.showPreview?e.getLayoutTemplate("preview").replace(/\{class\}/g,e.previewClass).replace(/\{dropClass\}/g,i):"",a=e.isDisabled?e.captionClass+" file-caption-disabled":e.captionClass,n=e.captionTemplate.replace(/\{class\}/g,a+" kv-fileinput-caption");return e.mainTemplate.replace(/\{class\}/g,e.mainClass).replace(/\{preview\}/g,t).replace(/\{caption\}/g,n).replace(/\{upload\}/g,e.renderUpload()).replace(/\{remove\}/g,e.renderRemove()).replace(/\{cancel\}/g,e.renderCancel()).replace(/\{browse\}/g,e.renderBrowse())},renderBrowse:function(){var e=this,i=e.browseClass+" btn-file",t="";return e.isDisabled&&(t=" disabled "),'<div class="'+i+'"'+t+"> "+e.browseIcon+e.browseLabel+" </div>"},renderRemove:function(){var e=this,i=e.removeClass+" fileinput-remove fileinput-remove-button",t="";return e.showRemove?(e.isDisabled&&(t=" disabled "),'<button type="button" title="'+e.removeTitle+'" class="'+i+'"'+t+">"+e.removeIcon+e.removeLabel+"</button>"):""},renderCancel:function(){var e=this,i=e.cancelClass+" fileinput-cancel fileinput-cancel-button";return e.showCancel?'<button type="button" title="'+e.cancelTitle+'" class="hide '+i+'">'+e.cancelIcon+e.cancelLabel+"</button>":""},renderUpload:function(){var e=this,i=e.uploadClass+" kv-fileinput-upload fileinput-upload-button",t="",a="";return e.showUpload?(e.isDisabled&&(a=" disabled "),t=!e.isUploadable||e.isDisabled?'<button type="submit" title="'+e.uploadTitle+'"class="'+i+'"'+a+">"+e.uploadIcon+e.uploadLabel+"</button>":'<a href="'+e.uploadUrl+'" title="'+e.uploadTitle+'" class="'+i+'"'+a+">"+e.uploadIcon+e.uploadLabel+"</a>"):""}},e.fn.fileinput=function(i){if(a()||t(9)){var n=Array.apply(null,arguments);return n.shift(),this.each(function(){var t=e(this),a=t.data("fileinput"),r="object"==typeof i&&i;a||t.data("fileinput",a=new $(this,e.extend({},e.fn.fileinput.defaults,r,e(this).data()))),"string"==typeof i&&a[i].apply(a,n)})}},e.fn.fileinput.defaults={showCaption:!0,showPreview:!0,showRemove:!0,showUpload:!0,showCancel:!0,mainClass:"",previewClass:"",captionClass:"",mainTemplate:null,initialCaption:"",initialPreview:"",initialPreviewCount:0,initialPreviewDelimiter:"*$$*",initialPreviewConfig:[],initialPreviewShowDelete:!0,overwriteInitial:!0,layoutTemplates:p,previewTemplates:u,allowedPreviewTypes:f,allowedPreviewMimeTypes:null,allowedFileTypes:null,allowedFileExtensions:null,previewSettings:v,fileTypeSettings:g,browseLabel:"Browse &hellip;",browseIcon:'<i class="glyphicon glyphicon-folder-open"></i> &nbsp;',browseClass:"btn btn-primary",removeLabel:"Remove",removeTitle:"Clear selected files",removeIcon:'<i class="glyphicon glyphicon-trash"></i> ',removeClass:"btn btn-default",cancelLabel:"Cancel",cancelTitle:"Abort ongoing upload",cancelIcon:'<i class="glyphicon glyphicon-ban-circle"></i> ',cancelClass:"btn btn-default",uploadLabel:"Upload",uploadTitle:"Upload selected files",uploadIcon:'<i class="glyphicon glyphicon-upload"></i> ',uploadClass:"btn btn-default",uploadUrl:null,uploadExtraData:[],uploadAsync:!0,maxFileSize:0,maxFileCount:0,msgSizeTooLarge:'File "{name}" (<b>{size} KB</b>) exceeds maximum allowed upload size of <b>{maxSize} KB</b>. Please retry your upload!',msgFilesTooMany:"Number of files selected for upload <b>({n})</b> exceeds maximum allowed limit of <b>{m}</b>. Please retry your upload!",msgFileNotFound:'File "{name}" not found!',msgFileNotReadable:'File "{name}" is not readable.',msgFilePreviewAborted:'File preview aborted for "{name}".',msgFilePreviewError:'An error occurred while reading the file "{name}".',msgInvalidFileType:'Invalid type for file "{name}". Only "{types}" files are supported.',msgInvalidFileExtension:'Invalid extension for file "{name}". Only "{extensions}" files are supported.',msgValidationError:'<span class="text-danger"><i class="glyphicon glyphicon-exclamation-sign"></i> File Upload Error</span>',msgErrorClass:"file-error-message",msgLoading:"Loading  file {index} of {files} &hellip;",msgProgress:"Loading file {index} of {files} - {name} - {percent}% completed.",msgSelected:"{n} files selected",previewFileType:"image",wrapTextLength:250,wrapIndicator:' <span class="wrap-indicator" title="{title}" onclick="{dialog}">[&hellip;]</span>',elCaptionContainer:null,elCaptionText:null,elPreviewContainer:null,elPreviewImage:null,elPreviewStatus:null,elErrorContainer:null,slugCallback:null,dropZoneEnabled:!0,dropZoneTitle:"Drag & drop files here &hellip;",dropZoneTitleClass:"file-drop-zone-title",fileActionSettings:{},otherActionButtons:"",textEncoding:"UTF-8"},e.fn.fileinput.Constructor=$,e(document).ready(function(){var i=e("input.file[type=file]"),t=null!=i.attr("type")?i.length:0;t>0&&i.fileinput()})}(window.jQuery);