<?php

class Pickup {
	public $PickupID, $PickupTicket, $Customer, $PickupDate, $Items, $PickupNotes, $Packages, $Salesman, $AccountNumber;
	public $RequestedBy, $Void, $VoidID, $VoidDate, $VoidReason, $VoidUser,$Loaded, $Via;
	public $PackageDetails;
	public function __construct($PickupID) {
		$query = "SELECT * FROM PICKUP_HEAD WHERE PickupID = $PickupID";
		global $con;
		
		$result = mysqli_query($con, $query);
		$row = mysqli_fetch_array($result);
		
		$this->PickupID = $row['PickupID'];
		$this->PickupTicket = $row['PickupTicket'];
		$this->Loaded = $row['Loaded'];
		$this->AccountNumber = $row['AccountNumber'];
		$this->Customer = new Customer($row['AccountNumber']);
		$this->PickupDate = $row['PickupDate'];
		$this->PickupNotes = $row['PickupNotes'];
		$this->Packages = $row['Packages'];
		$this->Salesman = new Salesman($row['Salesman']);
		$this->RequestedBy	= $row['RequestedBy'];
		$this->Via	= $row['Via'];
		//$this->Loaded = false;
		$this->Void = $row['Void'];
		if($row['Void']){
			$query = "SELECT * FROM PICKUP_VOID WHERE PickupID = " . $row['PickupID'];
			$result = mysqli_query($con, $query);
			$row2 = mysqli_fetch_array($result);
			$this->VoidID = $row2['ID'];
			$this->VoidReason = $row2['Reason'];
			$this->VoidDate = $row2['VoidDate'];
			$this->VoidUser = $row2['User'];
		}
		$this->Items = array();
		$query = "SELECT id FROM PICKUP_DETAIL WHERE PickupID = $PickupID";
		$result = mysqli_query($con, $query);
		while($row = mysqli_fetch_array($result)){
			$item = new PickupItem($row['id']);
			array_push($this->Items, $item);
			unset($item);
		}
		
		$this->PackageDetails = array();
		$query = "SELECT * FROM PICKUP_RECEIVE_PACKAGE WHERE PickupID = $PickupID";
		$result = mysqli_query($con, $query);
		while($row = mysqli_fetch_array($result)){
			$package = new StdClass();
			$package->Received = true;
			$package->ReceiveDate = date("m/d/Y h:m a", strtotime($row['ReceiveDate']));
			$package->Receiver = $row['User'];
			$this->PackageDetails[$row['PackageNumber']] = $package;
		}
		
		for($i = 1; $i <= $this->Packages; $i++){
			
			if(!array_key_exists($i, $this->PackageDetails)){
				
				$package = new StdClass();
				$package->Received = false;
				$this->PackageDetails[$i] = $package;
			}
		}
		
		
	}
	public function Void($reason){
		global $con;
		$reason = mysqli_real_escape_string($con,$reason);
		if(trim($reason) == ""){
			die("Invalid Reason");
		}
		/*
		$query = "UPDATE PAYMENT_HEAD SET CashAmount = 0, CheckAmount = 0, ProcessDate = NOW(), Processed = 1, Void = TRUE WHERE id = " . $this->PaymentID . ";";
		$query .= "UPDATE PAYMENT_DETAIL SET InvoiceNumber = CONCAT(InvoiceNumber,'V'), PartialPayment = 0, SubtotalAmount = 0, DiscountAmount = 0, TaxAmount = 0, PaymentAmount = 0, Reference = '' WHERE PaymentID = " . $this->PaymentID . ";";
		$query .= "UPDATE PAYMENT_CREDIT SET CreditNumber = CONCAT(CreditNumber,'V'), Subtotal = 0, Discount = 0, Tax = 0, Total = 0, Reference = '' WHERE PaymentID = " . $this->PaymentID . ";";
		$query .= "INSERT PAYMENT_VOID (PaymentID, Reason, User, VoidDate) VALUES (" . $this->PaymentID . ", '$reason', '" . $_SESSION['Username'] . "', NOW());";
		*/
		$reasonText = "THIS PICKUP REQUEST WAS VOIDED BECAUSE OF THE FOLLOWING REASON:" . $reason;
		$query = "UPDATE PICKUP_HEAD SET ToPickup = NOW(), ToPickupUser = '" . $_SESSION['Username'] . "', AtWarehouse = NOW(), AtWarehouseUser = '" . $_SESSION['Username'] . "', PickupStatus = 'VOID', PickupStatusUser = '" . $_SESSION['Username'] . "', PickupStatusNotes = '$reasonText', Void = TRUE WHERE PickupID = " . $this->PickupID . ";";
		$query .= "INSERT PICKUP_VOID (PickupID, Reason, User, VoidDate) VALUES (" . $this->PickupID . ", '$reason', '" . $_SESSION['Username'] . "', NOW());";
		
		
		if(!mysqli_multi_query($con, $query)){
			$data['result'] = false;
			$data['error'] = mysqli_error($con);
			$data['sql'] = $query;
			echo json_encode($data);
		}else{
			$data['result'] = "true";
			echo json_encode($data);
		}
		//echo $query;
		event_log($_SESSION['Username'],"PICKUP VOID", "Pickup Void \n\Pickup ID: " . $this->PickupID . " \nCustomer: " . $this->Customer->AccountNumber . " - " . $this->Customer->Name . "\nUser: " . $_SESSION['User'] . "\nReason: " . $reason);
	}
	public function GetVoidDetails(){
		global $con;
		$data['Pickup'] = $this->PickupID;
		$data['VoidDate'] = $this->VoidDate;
		$data['VoidReason'] = $this->VoidReason;
		$data['VoidUser'] = $this->VoidUser;
		//var_dump($this);
		echo json_encode($data);
	}
}

class PickupItem {
	public $Line, $SKU, $Description, $InvoiceNumber, $OrderID, $Reason, $Qty, $ReasonText, $WarrantyReason, $WarrantyReasonText;
	public function __construct($id) {
		$query = "SELECT PICKUP_DETAIL.*, CONCAT(CONCAT(INVENTORY.Description, ' '),INVENTORY.Notes) AS Description FROM PICKUP_DETAIL, INVENTORY WHERE `id` = $id AND PICKUP_DETAIL.SKU = INVENTORY.SKU AND PICKUP_DETAIL.LINE = INVENTORY.LINE";
		global $con;
		$result = mysqli_query($con, $query);
		$row = mysqli_fetch_array($result);
		$this->Line = $row['Line'];
		$this->SKU = $row['SKU'];
		$this->Description = $row['Description'];
		$this->OrderID = $row['OrderID'];
		$this->InvoiceNumber = $row['InvoiceNumber'];
		$this->Reason = $row['Reason'];
		$this->Qty = $row['Qty'];
		$this->ReasonText = getReasonText($row['Reason']);
		$this->WarrantyReason = $row['WarrantyReason'];
		$this->WarrantyReasonText = getWarrantyReasonText($row['WarrantyReason']);
		
	}	
}

?>