<?php

//initilize the page



?>
<!-- ==========================CONTENT STARTS HERE ========================== -->
<!-- MAIN PANEL -->
<div id="main" role="main">
	<?php
		//configure ribbon (breadcrumbs) array("name"=>"url"), leave url empty if no url
		//$breadcrumbs["New Crumb"] => "http://url.com"
		//include("inc/ribbon.php");
	?>

	<!-- MAIN CONTENT -->
	<div id="content">

		<div class="row">
			<div class="col-xs-12 col-sm-7 col-md-7 col-lg-4">
				<h1 class="page-title"><i class="fa-fw fa fa-home"></i> Application Catalog <span></span></h1>
			</div>
		</div>
		<div class="row">
			<div class="col-md-12">
				<div class="well">
					<h4>Search</h4>
					<div class="form-inline">
						<div class="form-group">
						  <label for="yearSelect">Year</label>
						  <select id="yearSelect" class="form-control">
							
						  </select>
						</div>
						<div class="form-group">
						  <label for="makeSelect">Make</label>
						  <select id="makeSelect" class="form-control">
							<option>--Select Year--</option>
						  </select>
						</div>
						<div class="form-group">
						  <label for="modelSelect">Model</label>
						  <select readonly id="modelSelect" class="form-control">
							<option>--Select Make--</option>
						  </select>
						</div>
						<div class="form-group">
						  <label for="submodelSelect">Submodel</label>
						  <select readonly id="submodelSelect" class="form-control">
							<option>--Select Model--</option>
						  </select>
						</div>
						<div class="form-group">
						  <label for="engineSelect">Engine</label>
						  <select readonly id="engineSelect" class="form-control">
							<option>--Select Submodel--</option>
						  </select>
						</div>
						<button type="button" id="searchCatalogButton" class="btn btn-primary">Search</button>
					  </div>
				</div>
			</div>
		</div>
<?php

	
		
		
?>
		<div id="catalogResultDiv" class="row" style="display: none;">
			<div class="col-md-12">
				<div class="well">
					<h4>Search Results</h4><h6 id="catalogResultQuery"></h6>
					<table id="catalogResultTable" class="table table-condensed table-striped table-hover" style="vertical-align: middle;">
						<thead>
							<tr>
								<td style="width: 10%;">Image</td>
								<td style="width: 20%;">Part Number</td>
								<td style="width: 40%;">Description</td>
								<td style="width: 40%;">Attributes</td>
								<td style="width: 10%;">Qty</td>
								<td style="width: 10%;">Price</td>
								<td style="width: 10%;"></td>
							</tr>
						</thead>
						<tbody id="catalogResultTbody">
						</tbody>
					</table>
				</div>
			</div>
		</div>

	</div>
	<!-- END MAIN CONTENT -->

</div>
<!-- END MAIN PANEL -->

<!-- ==========================CONTENT ENDS HERE ========================== -->

<!-- PAGE FOOTER -->
<?php

?>
<!-- END PAGE FOOTER -->

<?php 
	//include required scripts
	
?>

<!-- PAGE RELATED PLUGIN(S) 
<script src="..."></script>-->

<script>
	$(document).ready(function(){
		loadSelectField("year");
		
	});
	$('#yearSelect').on('change', function(){
		loadSelectField('make');
		clearAndDisableSelect('#modelSelect', "--Select Make--");
		clearAndDisableSelect('#submodelSelect', "--Select Model--");
		clearAndDisableSelect('#engineSelect', "--Select Submodel--");
	});
	
	$('#makeSelect').on('change', function(){
		loadSelectField('model');
		clearAndDisableSelect('#submodelSelect', "--Select Model--");
		clearAndDisableSelect('#engineSelect', "--Select Submodel--");
	});
	$('#modelSelect').on('change', function(){
		loadSelectField('submodel');
		clearAndDisableSelect('#engineSelect', "--Select Submodel--");
	});
	$('#submodelSelect').on('change', function(){
		loadSelectField('engine');
	});
	$('#engineSelect').on('change', function(){
		
		//alert('done');
	});
	$('#searchCatalogButton').on('click', function(){
		var year, make, model, submodel, engine;
		year = $('#yearSelect').val();
		make = $('#makeSelect').val();
		model = $('#modelSelect').val();
		submodel = $('#submodelSelect').val();
		engine = $('#engineSelect').val();
		$.post("ajax_appcatalog.php",
			   {
					"f"		: "getParts",
					"year"	: year,
					"make"	: make,
					"model"	: model,
					"submodel" : submodel,
					"engine": engine
				})
			.done(function(data){
				data = JSON.parse(data);
				$('#catalogResultDiv').show();
				$('#catalogResultTbody').html('');
				var strQueryTitle = year + " " + make + " " + model;
				if(submodel == "%"){
					strQueryTitle = strQueryTitle + " " + engine;
				}else{
					strQueryTitle = strQueryTitle + " " + submodel + " " + engine;
				}
				$('#catalogResultQuery').text(strQueryTitle);
				for(var i = 0; i< data.length; i++){
					if(data[i].Image){
						var imageTD = $("<td/>").html($('<a/>').attr('href', data[i].MediumImage).addClass('fancybox').html($('<img/>').attr('src', data[i].SmallImage).css("width", "50px")));	
					}else{
						var imageTD = $("<td/>").html($('<img/>').attr('src', 'img/no_image_available.png').css("width", "50px"));
						
					}
					//var imageTD = $("<td/>").html($('<img/>').attr('src', 'img/no_image_available.png').css("width", "50px"));
					var part_numberTD =
						$("<td/>").html("<a href=\"#\" onclick=\"getBuyersGuide($(this).text());\">" + data[i].PartNumber + "</a>");
								
					var descriptionTD = $("<td/>").text(data[i].PartType);
					var attributesTD = $("<td/>").html(data[i].Attributes);
					var qtyTD = $("<td/>").text(data[i].Qty);
					var priceTD = $("<td/>").text(data[i].Price);
					var addtocartTD = $("<td/>").html(
													  "<button onclick=\"askQty('" + data[i].PartNumber +  "', '" + data[i].Qty + "')\" class=\"btn btn-success\">Add</button>");
					var row = $('<tr/>').append(imageTD, part_numberTD, descriptionTD, attributesTD, qtyTD, priceTD, addtocartTD);
					$('#catalogResultTbody').append(row);
				}
			});
		
	});
	function clearAndDisableSelect(id, placeholder = "--Select more data--"){
		$(id).html('');
		$(id).trigger('change');
		$(id).prop('readonly', true);
		$(id).append($('<option/>').text(placeholder).val('-1'));
	}
	function loadSelectField(field){
		if(field == "year")	{
			$.post('ajax_appcatalog.php', { "f": "getYears" })
			.done(function(data){
				data = JSON.parse(data);
					
				for(var i = 0; i < data.length; i++){
					//alert(data[i]);
					$('#yearSelect').append($('<option/>').val(data[i]).text(data[i]));	
				}
				loadSelectField("make");
				$('#yearSelect').focus();
			});
		}
		if(field == "make") {
			if($('#yearSelect').val() !== "-1"){
				$.post('ajax_appcatalog.php', { "f": "getMakes", "year" : $('#yearSelect').val() })
				.done(function(data){
					data = JSON.parse(data);
					$('#makeSelect').html('');
					$('#makeSelect').append($('<option/>').val("-1").text('--Select Make--'));
					for(var i = 0; i < data.length; i++){
						//alert(data[i]);
						$('#makeSelect').append($('<option/>').val(data[i]).text(data[i]));	
					}
					$('#makeSelect').focus();
				});
			}
		}
		if(field == "model") {
			if($('#yearSelect').val() !== "-1" && $('#makeSelect').val() !== "-1"){
				$.post('ajax_appcatalog.php',
					   {
							"f"		: "getModels",
							"year" 	: $('#yearSelect').val(),
							"make" 	: $('#makeSelect').val()
						})
				.done(function(data){
					data = JSON.parse(data);
					$('#modelSelect').html('');
					
					$('#modelSelect').attr('readonly', false);
					$('#modelSelect').append($('<option/>').val("-1").text('--Select Model--'));
					for(var i = 0; i < data.length; i++){
						//alert(data[i]);
						$('#modelSelect').append($('<option/>').val(data[i]).text(data[i]));	
					}
					$('#modelSelect').focus();
				});
			}
		}
		if(field == "submodel") {
			if($('#yearSelect').val() !== "-1" && $('#makeSelect').val() !== "-1" && $('#modelSelect').val() !== "-1"){
				$.post('ajax_appcatalog.php',
					   {
							"f"		: "getSubmodels",
							"year" 	: $('#yearSelect').val(),
							"make" 	: $('#makeSelect').val(),
							"model"	: $('#modelSelect').val()
						})
				.done(function(data){
					data = JSON.parse(data);
					$('#submodelSelect').html('');
					$('#submodelSelect').attr('readonly', false);
					$('#submodelSelect').append($('<option/>').val("-1").text('--Select Submodel--'));
					for(var i = 0; i < data.length; i++){
						//alert(data[i]);
						var text = data[i];
						var value = data[i];
						if(text === ""){
							text = "All";
							value = "%";
						}
						if(data.length == 1){
							$('#submodelSelect').append($('<option/>').val(value).text(text).attr('selected', true));	
						}else{
							$('#submodelSelect').append($('<option/>').val(value).text(text));		
						}
						
					}
					$('#submodelSelect').focus();
					if(data.length == 1){
						$('#submodelSelect').trigger('change');
					}
				});
			}
		}
		if(field == "engine") {
			if($('#yearSelect').val() !== "-1" && $('#makeSelect').val() !== "-1" && $('#modelSelect').val() !== "-1" && $('#submodelSelect').val() !== "-1"){
				$.post('ajax_appcatalog.php',
					   {
							"f"		: "getEngines",
							"year" 	: $('#yearSelect').val(),
							"make" 	: $('#makeSelect').val(),
							"model"	: $('#modelSelect').val(),
							"submodel"	: $('#submodelSelect').val()
						})
				.done(function(data){
					data = JSON.parse(data);
					$('#engineSelect').html('');
					$('#engineSelect').attr('readonly', false);
					for(var i = 0; i < data.length; i++){
						//alert(data[i]);
						$('#engineSelect').append($('<option/>').val(data[i]).text(data[i]));	
					}
					$('#engineSelect').focus();
					if(data.length == 1){
						$('#searchCatalogButton').trigger('click');
					}
				});
			}
		}
		
	}
</script>

<?php

?>