<!-- Update MODAL -->

<div class="modal fade" id="WebUpdate">
    <div class="modal-dialog modal-md">
        <div class="modal-content">
            <div class="modal-header">

                <h4 class="modal-title">EliT Order System- Update</h4>
            </div>
            <div class="modal-body">
                <div class="progress" width="20">
                    <div class="progress-bar progress-bar-striped active" id="updateProgress" role="progressbar"
                         aria-valuenow="45" aria-valuemin="0" aria-valuemax="100" style="width: 100%">
                        <h4 class="modal-title" id="myModalLabel"><p id="updatePB"></p>%</h4>
                    </div>
                </div>
                <div style="display: none;" id="updateConfirmationSuccess" class="center">
                    <h3>UPDATE COMPLETE</h3>
                    <p>Gracias por su paciencia. Esta pagina se refrescará automaticamente en 2 segundos.</p>

                </div>
                <div style="display: none;" id="updateConfirmationFail" class="center">
                    <h3>UPDATE FAILED</h3>
                    <p>Hubo un error al intentar obtener la informacion de actualizacion del servidor. Por favor intente
                        mas tarde. Esta pagina se refrescará automaticamente en 2 segundos.</p>

                </div>
            </div>
            <div class="modal-footer">

            </div>
        </div><!-- /.modal-content -->
    </div><!-- /.modal-dialog -->
</div><!-- /.modal -->
<script>
    $('#WebUpdate').on('shown.bs.modal', function () {
        startUpdate();
    });
    var myInterval;

    function startUpdate() {
        $.get('functions.php?action=setUpdateData', function (data) {
            if (data == "true") {
                myInterval = setInterval(function () {
                    myTimer();
                }, 10);

            }

        }).fail(function () {
            $('#updateConfirmationFail').show();
        });

        var count = 0;

        function myTimer() {
            if (count < 100) {
                $('.progress').css('width', count + "%");
                count += 0.05;
                document.getElementById("updatePB").innerHTML = Math.round(count) + "%";
                // code to do when loading
            } else if (count > 99) {
                clearInterval(myInterval);
                // code to do after loading
                $('#updateConfirmationSuccess').show();
                setTimeout(function () {
                    location.reload();
                }, 2000);

            }
        }
    }
    <?php
    if ($_SESSION['isCustomer']) {
        $query = "SELECT * FROM CUSTOMER_UPDATE WHERE AccountNumber LIKE '" . $_SESSION['AccountNumber'] . "'";
    } else {
        $query = "SELECT * FROM CUSTOMER_UPDATE WHERE AccountNumber LIKE '" . $_SESSION['SalesmanID'] . "'";
    }

    $result = mysqli_query($con, $query);
    if(mysqli_num_rows($result) < 1){
    ?>
    $('ul.nav.navbar-nav.navbar-right > li:nth-child(4) > ul').append($('<li/>').append($('<a/>').html('<span class="glyphicon glyphicon-download-alt" aria-hidden="true"></span>' + ' UPDATE').attr('href', '#').attr('onclick', "$('#WebUpdate').modal('show')")));
    <?php
    }else{
    ?>
    $(document).ready(function () {
        $('#updateIndicator').show();
    });
    <?php


    }

    ?>

</script>
<!-- END UPDATE MODAL -->

<!-- Customer Information MODAL -->
<?php
if(isset($_SESSION['isCustomer'])){
$customer = new Customer($_SESSION['setCustomer']);
//var_dump($_SESSION);

?>
<div class="modal fade" id="CustomerInformationModal">
    <div class="modal-dialog modal-md">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span>
                </button>
                <h4 class="modal-title" id="CustomerInformationModalTitle"><?= $customer->Name ?></h4>
            </div>
            <div class="modal-body">
                <div class="row">

                    <span><strong>Contact: </strong></span><input name="CustomerInformationModalContact"
                                                                  class="form-control"
                                                                  value="<?= $customer->Contact ?>"><br>

                    <span><strong>	Contact Phone: </strong></span>
                    <div class="input-group">
                        <input type="text" class="form-control" id="CustomerInformationModalContactPhone" name="CustomerInformationModalContactPhone" value="<?= $customer->ContactPhone?$customer->ContactPhone:$customer->Phone ?>" placeholder="Phone">
                        <span class="input-group-btn">
                            <a id="CustomerInformationModalCallButton" href="tel:<?= str_ireplace(["-"," ","(",")"],"",$customer->ContactPhone?$customer->ContactPhone:$customer->Phone) ?>" class="btn btn-default" type="button">Call</a>
                        </span>
                    </div><!-- /input-group -->

                    <br>


                    <span><strong>	Email: </strong></span> <input name="CustomerInformationModalEmail"
                                                                     class="form-control"
                                                                     value="<?= $customer->Email ?>"><br>

                    <br>

                    <span><strong>Main Phone: </strong></span> <?= $customer->Phone . " " . ($customer->PhoneExt ? ("Ext. " . $customer->PhoneExt) : "") ?>
                    <br>
                    <br>
                    <span><strong>Create Backorders: </strong></span> <input name="CustomerInformationCreateBackorder"
                                                                             style="width: ;"
                                                                             type="checkbox" <?= $customer->CreateBackorder ? "checked" : "" ?>/>
                    <br>
                    <?php
                    if ($customer->SupplierID) {
                        ?>
                        <span><strong>Our Supplier ID: </strong></span> <?= $customer->SupplierID ?><br>
                        <br>
                    <?php }
                    ?>
                    <div class="form-inline">
                        <div style="border: none">
                            <label for="CustomerInformationStateTaxID1" style="font-weight: bold;">State Tax ID:</label>
                            <input class="form-control" type="text" name="CustomerInformationStateTaxID1"
                                   style="width: 125px;" value="<?= $customer->TaxID1 ?>"/>
                            <input class="form-control" type="date" name="CustomerInformationStateTax1Expiration"
                                   style="width: 175px;" value="<?= $customer->TaxIDExpiration1 ?>"/>

                        </div>

                        <hr>
                        <div style="border: none">
                            <label for="CustomerInformationStateTaxID2" style="font-weight: bold;">Municipal Tax
                                ID:</label>
                            <input class="form-control" name="CustomerInformationStateTaxID2" style="width: 125px;"
                                   value="<?= $customer->TaxID2 ?>"/>
                            <input class="form-control" type="date" name="CustomerInformationStateTax2Expiration"
                                   style="width: 175px;" value="<?= $customer->TaxIDExpiration2 ?>"/>
                            <input name="CustomerInformationStateTax2Exempt" style="width: ;"
                                   type="checkbox" <?= $customer->TaxExempt2 ? "checked" : "" ?> /> Exempt Mun Tax
                        </div>
                        <br>
                        <span><strong>Account Terms: </strong></span>
                            <select name="CustomerInformationAccountTerms" class="form-control">
                                <option <?= $customer->Terms == "0" ? "selected" : "" ?> value="0">COD</option>
                                <option <?= $customer->Terms == "7" ? "selected" : "" ?> value="7">7 days</option>
                                <option <?= $customer->Terms == "30" ? "selected" : "" ?> value="30">30 days</option>
                            </select>
                        <br>
						<?= $customer->Terms == "0" ? "COD" : ($customer->Terms . " days") ?>
                        <br>
                        <button onclick="saveTaxInfo();" type="button" class="float-right pull-right btn btn-primary">
                            Save
                        </button>


                        <br>


                    </div>
                </div>
                <div class="row">
                    <div class="col-xs-6">
                        <h5><strong>Shipping Address</strong></h5>
                        <?= $customer->ShipToAddress1 ?><br>
                        <?= $customer->ShipToAddress2 ?><br>
                        <?= $customer->ShipToCity ?>, <?= $customer->ShipToState ?> <?= $customer->ShipToZip ?><br>
                        <a target="CustomerMap" href="https://www.google.com/maps/search/?api=1&query=<?php
                        $mapsQuery = $customer->Name . " ";
                        $mapsQuery .= $customer->ShipToCity . ", " . $customer->ShipToState;
                        echo urlencode($mapsQuery);
                        ?>">Google Maps by Name</a><br>
                        <a target="CustomerMap" href="https://www.google.com/maps/search/?api=1&query=<?php
                        $mapsQuery = $customer->Name . ", ";
                        $mapsQuery .= $customer->ShipToAddress1 . " " . $customer->ShipToAddress2;
                        $mapsQuery .= $customer->ShipToCity . ", " . $customer->ShipToState;
                        echo urlencode($mapsQuery);
                        ?>">Google Maps by Address</a><br>

                    </div>
                    <div class="col-xs-6">
                        <h5><strong>Billing Address</strong></h5>
                        <?= $customer->Address1 ?><br>
                        <?= $customer->Address2 ?><br>
                        <?= $customer->City ?> <?= $customer->State ?>, <?= $customer->ZipCode ?><br>
                    </div>
                </div>
                <button onclick="sendMerchantCertificate('<?= $customer->AccountNumber ?>');" type="button" class="float-left pull-left btn btn-primary">
                    Send Merchant Certificate Via Email
                </button>
                <br>
            </div>
            <div class="modal-footer">

            </div>
        </div><!-- /.modal-content -->
    </div><!-- /.modal-dialog -->
</div><!-- /.modal -->
<script type="text/javascript">
    $("#CustomerInformationModalContactPhone").on('keyup', function (){
        let phone = $('#CustomerInformationModalContactPhone').val();
        phone = phone.replaceAll("-","").replaceAll(" ", "").replace("(","").replace(")","")
        $('#CustomerInformationModalCallButton').attr('href', "tel:" + phone)
    })
    function sendMerchantCertificate(AccountNumber){
        if(confirm("Are you sure you want to send the Merchant Certificate?")) {
            $.post("functions.php", {
                action: "sendMerchantCertificate",
                AccountNumber: AccountNumber
            }, function (data){
                alert(data);
            })
        }
    }
    function saveTaxInfo() {
        $.post("mod.php?p=mycustomers&a=functions&f=saveTaxInfo", {
            "AccountNumber": "<?= $customer->AccountNumber ?>",
            "Contact": $("[name=CustomerInformationModalContact]").val(),
            "ContactPhone": $("[name=CustomerInformationModalContactPhone]").val(),
            "Email": $("[name=CustomerInformationModalEmail]").val(),
            "TaxID1": $("[name=CustomerInformationStateTaxID1]").val(),
            "Tax1Expiration": $("[name=CustomerInformationStateTax1Expiration]").val(),
            "TaxID2": $("[name=CustomerInformationStateTaxID2]").val(),
            "Tax2Expiration": $("[name=CustomerInformationStateTax2Expiration]").val(),
            "Tax2Exempt": $("[name=CustomerInformationStateTax2Exempt]").prop("checked"),
            "CreateBackorder": $("[name=CustomerInformationCreateBackorder]").prop("checked"),
            "AccountTerms": $("[name=CustomerInformationAccountTerms]").val(),

        }, function (data) {

            console.log(data)

            if (data) {
                $("#CustomerInformationModalTitle").append(
                    $("<h4/>").text("Information Saved")
                );
                location.reload();
            }
        });
    }
</script>

<!-- END Customer Information MODAL -->
<?php
}
?>

<!-- Start Barcode MODAL -->
<div id="barcodeModal" class="modal fade" tabindex="-1" role="dialog">
    <div class="modal-dialog modal-sm" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span>
                </button>
                <h4 id="barcodeModalTitle" class="modal-title"></h4>
            </div>
            <div id="barcodeModalBody" class="modal-body">
                <center>
                    <div id="barcodeModalContent"></div>
                </center>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
            </div>
        </div><!-- /.modal-content -->
    </div><!-- /.modal-dialog -->
</div><!-- /.modal -->

<script type="text/javascript">
    function openBarcode(title, data) {
        $('#barcodeModalTitle').html(title);
        $('#barcodeModalContent').html();
        generateBarcode(data, "#barcodeModalContent");
        $('#barcodeModalContent').append(data);
        //$('#barcodeModalContent').html();
        $('#barcodeModal').modal('toggle');
    }


</script>

<script src="/js/jquery-barcode.min.js"></script>
<script>
    function generateBarcode(bcValue, selector) {
        var value = bcValue;
        var btype = "code128";
        var renderer = "bmp";

        var quietZone = false;
        var settings = {
            output: renderer,
            bgColor: "#FFFFFF",
            color: "#000000",
            barWidth: "2",
            barHeight: "50",
            moduleSize: null,
            //  posX: $("#posX").val(),
            //posY: $("#posY").val(),
            //addQuietZone: $("#quietZoneSize").val()
        };

        $(selector).barcode(value, btype, settings);

    }

</script>
<!-- END Barcode MODAL -->


<!-- CATALOG MODAL -->

<script type="text/javascript">
    function showCatalog() {
        $('#catalogModal').modal('toggle');
    }

    var CatalogCategory = [];

</script>
<div class="modal fade" id="catalogModal">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">

                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span>
                </button>
                <!-- Nav tabs -->
                <!--
        <ul class="nav nav-tabs fixedHeader" role="tablist">

        <?php
                $query = "SELECT * FROM CATALOG_CATEGORY WHERE Active = 1 ORDER BY SortOrder, `Name` ASC";
                $result = mysqli_query($con, $query);
                $count = 0;
                if(!isset($language)){
                    $language = $_SESSION['Language'];
                }
                while ($row = mysqli_fetch_array($result)) {
                    $categoryName = $row['Name'];
                    if ($language == "EN") {
                        $categoryName = $row['NameEN'];
                    }
                    ?>
         <script type="text/javascript">

         var category = [];
         category['ID'] = "<?= $row['CatalogID'] ?>";
         category['Name'] = "<?= $categoryName ?>";
         CatalogCategory.push(category);
         </script>
          <li role="presentation" class="<?= ($count == 0) ? "active" : "" ?>"><a onclick="fillCatalog('<?= $row['CatalogID'] ?>')" href="#catalog-<?= $row['CatalogID'] ?>" aria-controls="1" role="tab" data-toggle="tab"><?= $categoryName ?></a></li>
          <?php
                    $count++;
                }
                ?>
        </ul>
				-->
                <h3>Illustrated Catalog</h3>
                <label for="selectCatalogCategory">Select Catalog Category</label>
                <select class="form-control" id="selectCatalogCategory"
                        onchange="fillCatalog($('#selectCatalogCategory').val());$(this.options[this.selectedIndex]).tab('show');">
                    <?php
                    $query = "SELECT * FROM CATALOG_CATEGORY WHERE Active = 1 ORDER BY SortOrder, `Name` ASC";
                    $result = mysqli_query($con, $query);
                    $count = 0;
                    while ($row = mysqli_fetch_array($result)) {
                        $categoryName = $row['Name'];
                        if ($language == "EN") {
                            $categoryName = $row['NameEN'];
                        }
                        ?>
                        <script type="text/javascript">

                            var category = [];
                            category['ID'] = "<?= $row['CatalogID'] ?>";
                            category['Name'] = "<?= addslashes($categoryName) ?>";
                            CatalogCategory.push(category);
                        </script>
                        <option href="#catalog-<?= $row['CatalogID'] ?>" aria-controls="1" data-toggle="tab"
                                class="<?= ($count == 0) ? "selected" : "" ?>" value="<?= $row['CatalogID'] ?>">
                            <?= $categoryName ?>
                        </option>
                        <?php
                        $count++;
                    }
                    ?>
                </select>
            </div>
            <div class="modal-body active" id="catalog-body">
                <div>

                    <!-- Tab panes -->
                    <div class="tab-content">
                        <?php
                        $query = "SELECT * FROM CATALOG_CATEGORY ORDER BY SortOrder,`Name` ASC";
                        $result = mysqli_query($con, $query);
                        $count = 0;
                        while ($row = mysqli_fetch_array($result)) {

                            ?>
                            <div role="tabpanel" class="tab-pane <?= ($count == 0) ? "active" : "" ?>"
                                 id="catalog-<?= $row['CatalogID'] ?>"></div>
                            <?php
                            $count++;
                        }
                        ?>
                    </div>

                </div>
            </div>
            <!-- Scroll to top button -->


            <a href="#" class="scrollToTop"><br/><br/><br/><br/>Scroll to Top</a>
            <script type="text/javascript">
                $(document).ready(function () {

                    //Check to see if the window is top if not then display button
                    $("#catalogModal").scroll(function () {
                        var position = ($(this).scrollTop() + 70);
                        $('.scrollToTop').css('top', position + "px");
                        if ($(this).scrollTop() > 100) {
                            $('.scrollToTop').fadeIn();
                        } else {
                            $('.scrollToTop').fadeOut();
                        }
                    });

                    //Click event to scroll to top
                    $('.scrollToTop').click(function () {
                        $('#catalogModal').animate({scrollTop: 0}, 800);
                        return false;
                    });

                });

            </script>
            <style>
                .scrollToTop {
                    width: 100px;
                    height: 130px;
                    padding: 10px;
                    text-align: center;
                    background: whiteSmoke;
                    font-weight: bold;
                    color: #444;
                    text-decoration: none;
                    position: fixed;
                    top: 75px;
                    right: -110px;
                    display: none;
                    background: url('img/up-arrow-icon.png') no-repeat 20px 20px;
                }

                .scrollToTop:hover {
                    text-decoration: none;
                }
            </style>
            <!-- End Scroll to top button -->
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
            </div>
        </div><!-- /.modal-content -->
    </div><!-- /.modal-dialog -->
</div><!-- /.modal -->

<!-- END CATALOG MODAL -->


<!-- ALTAS MODAL -->

<script type="text/javascript">
    var AltasTabs = [];
</script>
<div class="modal fade" id="altasModal">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-body">

                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span>
                </button>
                <!-- Nav tabs -->

                <ul class="nav nav-tabs fixedHeader" role="tablist">

                    <?php
                    $query = "SELECT PurchaseOrderID, `Name`, `ConfirmedDate` FROM PURCHASE_ORDER_HEADER JOIN VENDOR USING(VendorID) WHERE Confirmed = 1 AND Received = 0 AND Void = 0";
                    $result = mysqli_query($con, $query);
                    $count = 0;
                    while ($row = mysqli_fetch_array($result)) {
                        $tabName = $row['Name'];


                        ?>
                        <script type="text/javascript">

                            var tab = {};
                            tab['ID'] = "<?= $row['PurchaseOrderID'] ?>";
                            tab['Name'] = "<?= $tabName ?>";
                            AltasTabs.push(tab);
                        </script>
                        <li role="presentation" class="<?= ($count == 0) ? "active" : "" ?>"><a
                                    style="text-align: center;" onclick="fillAltas('<?= $row['PurchaseOrderID'] ?>')"
                                    href="#altas-<?= $row['PurchaseOrderID'] ?>" aria-controls="1" role="tab"
                                    data-toggle="tab"><?= $tabName ?>
                                <br/><i><?= date("m/d/Y", strtotime($row['ConfirmedDate'])) ?></i></a></li>
                        <?php
                        $count++;
                    }
                    ?>
                </ul>
            </div>
            <div class="modal-body active" id="altas-body">
                <div>

                    <!-- Tab panes -->
                    <div class="tab-content">
                        <?php
                        $query = "SELECT PurchaseOrderID, `Name`, `ConfirmedDate` FROM PURCHASE_ORDER_HEADER JOIN VENDOR USING(VendorID) WHERE Confirmed = 1 AND Received = 0 AND Void = 0";
                        $result = mysqli_query($con, $query);
                        $count = 0;
                        while ($row = mysqli_fetch_array($result)) {

                            ?>
                            <div role="tabpanel" class="tab-pane <?= ($count == 0) ? "active" : "" ?>"
                                 id="altas-<?= $row['PurchaseOrderID'] ?>"></div>
                            <?php
                            $count++;
                        }
                        ?>
                    </div>

                </div>
            </div>
            <!-- Scroll to top button -->

            <style>
                @media (min-width: 268px) {
                    .modal-xl {
                        width: 90%;
                        max-width: 1200px;
                    }
                }

                .scrollToTop {
                    width: 100px;
                    height: 130px;
                    padding: 10px;
                    text-align: center;
                    background: whiteSmoke;
                    font-weight: bold;
                    color: #444;
                    text-decoration: none;
                    position: fixed;
                    top: 75px;
                    right: -110px;
                    display: none;
                    background: url('img/up-arrow-icon.png') no-repeat 20px 20px;
                }

                .scrollToTop:hover {
                    text-decoration: none;
                }
            </style>
            <a href="#" class="scrollToTop"><br/><br/><br/><br/>Scroll to Top</a>
            <script type="text/javascript">
                $(document).ready(function () {

                    //Check to see if the window is top if not then display button
                    $("#altasModal").scroll(function () {
                        var position = ($(this).scrollTop() + 70);
                        $('.scrollToTop').css('top', position + "px");
                        if ($(this).scrollTop() > 100) {
                            $('.scrollToTop').fadeIn();
                        } else {
                            $('.scrollToTop').fadeOut();
                        }
                    });

                    //Click event to scroll to top
                    $('.scrollToTop').click(function () {
                        $('#altasModal').animate({scrollTop: 0}, 800);
                        return false;
                    });

                });

            </script>
            <!-- End Scroll to top button -->
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
            </div>
        </div><!-- /.modal-content -->
    </div><!-- /.modal-dialog -->
</div><!-- /.modal -->

<!-- END ALTAS MODAL -->


<!-- NEW ALTAS MODAL -->

<script type="text/javascript">
    var NewAltasTabs = [];
</script>
<div class="modal fade" id="newAltasModal">
    <div class="modal-dialog modal-xl">
        <div class="modal-content">
            <div class="modal-header" style="background: #f7f7f7;">

                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span>
                </button>
                <!-- Nav tabs -->

                <center><h3>Altas</h3><h4 id="newAltasSubtitle"></h4></center>

            </div>
            <div class="modal-body" id="">
                <div class="container">
                    <div class="col-md-3">


                        <?php
                        //$query = "SELECT * FROM ALTAS_HEAD WHERE `Active` = 1 ORDER BY STR_TO_DATE(`DateLine` , '%m-%d-%Y') ASC";
                        $query = "SELECT * FROM ALTAS_HEAD WHERE `Active` = 1 ORDER BY Name ASC";
                        $result = mysqli_query($con, $query);
                        $count = 0;
                        while ($row = mysqli_fetch_array($result)) {
                            $tabName = $row['Name'];
                            if ($_SESSION['isCustomer']) {
                                if ($customer->Language == "EN") {
                                    $tabName = $row['NameEN'];
                                }
                            } else {
                                if ($salesman->Language == "EN") {
                                    $tabName = $row['NameEN'];
                                }
                            }

                            ?>
                            <script type="text/javascript">

                                var tab = {};
                                tab['ID'] = "<?= $row['ID'] ?>";
                                tab['Name'] = "<?= $tabName ?>";
                                NewAltasTabs.push(tab);
                            </script>
                            <a class="btn btn-primary newPromoButtons" data-date="<i><?= $row['DateLine'] ?></i>"
                               onclick="fillNewAltas('<?= $row['ID'] ?>', this)" style="width: 100%;"><?= $tabName ?>
                                <br/></a><br>

                            <?php
                            $count++;
                        }
                        ?>

                    </div>
                    <div class="col-md-9" id="newAltasBody">


                    </div>
                </div>
                <div>

                    <!-- Tab panes -->

                </div>
            </div>
            <!-- Scroll to top button -->

            <style>
                .scrollToTop {
                    width: 100px;
                    height: 130px;
                    padding: 10px;
                    text-align: center;
                    background: whiteSmoke;
                    font-weight: bold;
                    color: #444;
                    text-decoration: none;
                    position: fixed;
                    top: 75px;
                    right: -110px;
                    display: none;
                    background: url('img/up-arrow-icon.png') no-repeat 20px 20px;
                }

                .scrollToTop:hover {
                    text-decoration: none;
                }
            </style>
            <a href="#" class="scrollToTop"><br/><br/><br/><br/>Scroll to Top</a>
            <script type="text/javascript">
                function openNewAltas() {
                    $("#newAltasModal").modal('toggle');
                }

                $(document).ready(function () {

                    //Check to see if the window is top if not then display button
                    $("#newAltasModal").scroll(function () {
                        var position = ($(this).scrollTop() + 70);
                        $('.scrollToTop').css('top', position + "px");
                        if ($(this).scrollTop() > 100) {
                            $('.scrollToTop').fadeIn();
                        } else {
                            $('.scrollToTop').fadeOut();
                        }
                    });

                    //Click event to scroll to top
                    $('.scrollToTop').click(function () {
                        $('#newAltasModal').animate({scrollTop: 0}, 800);
                        return false;
                    });

                });

            </script>
            <!-- End Scroll to top button -->
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
            </div>
        </div><!-- /.modal-content -->
    </div><!-- /.modal-dialog -->
</div><!-- /.modal -->

<!-- END new ALTAS MODAL -->

<!-- SPECIALS MODAL -->

<script type="text/javascript">

</script>
<div class="modal fade" id="specialsModal">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-body">

                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span>
                </button>
                <!-- Nav tabs -->
                <center><h4>On Sale!</h4></center>
            </div>
            <div class="modal-body active" id="specials-body">

            </div>
            <!-- Scroll to top button -->

            <style>
                .scrollToTop {
                    width: 100px;
                    height: 130px;
                    padding: 10px;
                    text-align: center;
                    background: whiteSmoke;
                    font-weight: bold;
                    color: #444;
                    text-decoration: none;
                    position: fixed;
                    top: 75px;
                    right: -110px;
                    display: none;
                    background: url('img/up-arrow-icon.png') no-repeat 20px 20px;
                }

                .scrollToTop:hover {
                    text-decoration: none;
                }
            </style>
            <a href="#" class="scrollToTop"><br/><br/><br/><br/>Scroll to Top</a>
            <script type="text/javascript">
                $(document).ready(function () {

                    //Check to see if the window is top if not then display button
                    $("#specialsModal").scroll(function () {
                        var position = ($(this).scrollTop() + 70)
                        $('.scrollToTop').css('top', position + "px");
                        if ($(this).scrollTop() > 100) {
                            $('.scrollToTop').fadeIn();
                        } else {
                            $('.scrollToTop').fadeOut();
                        }
                    });

                    //Click event to scroll to top
                    $('.scrollToTop').click(function () {
                        $('#specialsModal').animate({scrollTop: 0}, 800);
                        return false;
                    });

                });

            </script>
            <!-- End Scroll to top button -->
            <div class="modal-footer">
                <center>
		  <span>
			**These are the final price, no other discounts will be applied.**<br>
			***While the item lasts - There will not be "BACK ORDERS" with special pricing***
		  </span>
                </center>
                <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
            </div>
        </div><!-- /.modal-content -->
    </div><!-- /.modal-dialog -->
</div><!-- /.modal -->

<!-- END SPECIALS MODAL -->


<!-- NEW PROMO GROUP MODAL -->

<script type="text/javascript">
    //var AltasTabs = new Array();
</script>
<div class="modal fade" id="promoLineModal">
    <div class="modal-dialog modal-xl">
        <div class="modal-content">
            <div class="modal-header" style="background: #f7f7f7;">

                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span>
                </button>
                <!-- Nav tabs -->
                <br>
                <center><h2></h2></center>

            </div>
            <div class="modal-body" id="">
                <div class="container">
                    <div class="col-md-3">
                        <?php
                        $query = "SELECT `Group`, `Name` FROM INVENTORY JOIN `GROUP` ON(INVENTORY.Group = GROUP.Code) WHERE `Line` LIKE 'KOR' AND Qty > 0 GROUP BY `Group` order by `Name`";
                        $result = mysqli_query($con, $query);
                        while ($row = mysqli_fetch_array($result)) {


                            ?>
                            <a class="btn btn-primary newPromoButtons" onclick="fillPromoGroup('<?= $row['Group'] ?>')"
                               style="width: 100%;"><?= $row['Name'] ?></a><br>
                            <?php
                        }
                        ?>
                    </div>
                    <div class="col-md-9" id="promoGroupPartList">


                    </div>
                </div>
                <div>

                    <!-- Tab panes -->

                </div>
            </div>
            <!-- Scroll to top button -->

            <style>
                .scrollToTop {
                    width: 100px;
                    height: 130px;
                    padding: 10px;
                    text-align: center;
                    background: whiteSmoke;
                    font-weight: bold;
                    color: #444;
                    text-decoration: none;
                    position: fixed;
                    top: 75px;
                    right: -110px;
                    display: none;
                    background: url('img/up-arrow-icon.png') no-repeat 20px 20px;
                }

                .scrollToTop:hover {
                    text-decoration: none;
                }
            </style>
            <a href="#" class="scrollToTop"><br/><br/><br/><br/>Scroll to Top</a>
            <script type="text/javascript">
                function openNewPromoModal() {

                    $('#promoLineModal').modal('toggle');
                }

                $(document).ready(function () {

                    //Check to see if the window is top if not then display button
                    $("#promoLineModal").scroll(function () {
                        var position = ($(this).scrollTop() + 70);
                        $('.scrollToTop').css('top', position + "px");
                        if ($(this).scrollTop() > 100) {
                            $('.scrollToTop').fadeIn();
                        } else {
                            $('.scrollToTop').fadeOut();
                        }
                    });

                    //Click event to scroll to top
                    $('.scrollToTop').click(function () {
                        $('#promoLineModal').animate({scrollTop: 0}, 800);
                        return false;
                    });

                });

            </script>
            <!-- End Scroll to top button -->
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
            </div>
        </div><!-- /.modal-content -->
    </div><!-- /.modal-dialog -->
</div><!-- /.modal -->

<!-- END new PROMO MODAL -->


<!-- PASSWORD CHANGE MODAL -->
<div class="modal fade" id="passwordChange" tabindex="-1" role="dialog" aria-labelledby="PasswordChange"
     aria-hidden="true">
    <div class="modal-dialog modal-sm">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
                <h4 class="modal-title" id="passwordChangeTitle">Change Password</h4>
            </div>
            <form style="margin: 10px;">
                <label class="form-label">Old Password</label>
                <input type="password" name="oldPassword" class="form-control">
                <label class="form-label">New Password</label>
                <input type="password" name="newPassword1" class="form-control">
                <label class="form-label">Confirm Password</label>
                <input type="password" name="newPassword2" class="form-control">

                <br><br>
                <div class="from-group">
                    <a onclick="changePassword()" class="btn btn-success">Save</a>
                    <a onclick="$('#passwordChange').modal('hide');" class="btn btn-danger">Cancel</a>
                </div>
            </form>

        </div>
    </div>
</div>
<!-- END PASSWORD CHANGE MODAL -->
<!-- QTY BOX MODAL -->
<div id="qtyBox" class="modal fade">
    <div class="modal-dialog modal-sm">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span>
                </button>
                <h4 class="modal-title">Enter Quantity</h4>
                <h5 id="qtyBoxTitle"></h5>
            </div>
            <div class="modal-body">
                <input type="number" id="qtyBoxInput" class="form-control" name="Qty" placeholder="Qty">
                <input type="hidden" name="Index" value=""/>
                <input type="hidden" name="Update" value=""/>
                <input type="hidden" name="Group" value=""/>
                <input type="hidden" name="Line" value=""/>
                <input type="hidden" name="SKU" value=""/>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                <button id="addButton" type="button" class="btn btn-primary">Add</button>
            </div>
        </div><!-- /.modal-content -->
    </div><!-- /.modal-dialog -->
</div><!-- /.modal -->
<!-- END QTY BOX MODAL -->

<!-- QUICK ENTRY MODAL -->
<div id="quickOrderModal" class="modal fade">
    <div class="modal-dialog modal-sm">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span>
                </button>
                <h4 class="modal-title">Quick Order</h4>
                <h5 id="quickOrderModalTitle"></h5>
            </div>
            <div class="modal-body">
                <input type="number" id="quickOrderUPC" class="form-control" name="quickOrderUPC" placeholder="UPC">
                <br>
                <input type="number" id="quickOrderQty" class="form-control" name="quickOrderQty" placeholder="Qty">
                <br>
                <div class="row">
                    <div class="col-md-12">
                        <div id="quickOrderStatus" class="alert" role="alert"></div>


                    </div>

                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>

            </div>
        </div><!-- /.modal-content -->
    </div><!-- /.modal-dialog -->
</div><!-- /.modal -->
<script>
    $('#quickOrderModal').on('shown.bs.modal', function(){
        //console.log('shown');
        $('#quickOrderUPC').focus();
        $('#quickOrderStatus').html("");
        $('#quickOrderStatus').hide();
        //$('#quickOrderModal').modal()
    })
    $('#quickOrderModal').on('hidden.bs.modal', function(){
        //console.log('shown');
        location.reload();
        //$('#quickOrderModal').modal()
    })
    $('#quickOrderUPC').on('keyup',function(e){
        if(e.keyCode == "13" ||e.keyCode == "0"){
            $('#quickOrderQty').focus();
        }
    });
    $('#quickOrderQty').on('change',function(e){
        quickAddToCart();
    })
    $('#quickOrderQty').on('keyup',function(e){
        if(e.keyCode == "13" ||e.keyCode == "0"){
            //quickAddToCart();
        }
    });
    function quickAddToCart(){
        let upc, qty;
        upc = $('#quickOrderUPC').val();
        qty = $('#quickOrderQty').val()
        clearQuickEntryAlertBox();
        $('#quickOrderStatus').html("Submitting Data...");
        $('#quickOrderStatus').addClass('alert-info');
        $('#quickOrderStatus').show();
        $.post('functions.php', {
            action: "quickItemEntry",
            upc: upc,
            qty: qty
        }, function(data){
            data = JSON.parse(data);
            if(data.Result){
                let updateText = "";
                if(data.InCart){
                    updateText =  "<br>Updated Qty to " + qty + " from " + data.InCart + " of item " + data.Item.SKU;
                }else{
                    updateText = "<br>Added " + qty + " of " + data.Item.SKU + " - " + data.Item.Description
                }
                clearQuickEntryAlertBox();
                $('#quickOrderStatus').html("Success! " + updateText + ".<br><h5>Total Cart: " + moneyFormat(data.CartTotal) + "</h5>");
                $('#quickOrderStatus').addClass('alert-success');
                $('#quickOrderStatus').show();
                console.log(data);
            }else{
                //alert("failed");
                clearQuickEntryAlertBox();
                $('#quickOrderStatus').html("Error, SKU or UPC not found!");
                $('#quickOrderStatus').addClass('alert-danger');
                $('#quickOrderStatus').show();
                console.log(data);
            }
        });
        setTimeout( function(){
            $('#quickOrderUPC').val('');
            $('#quickOrderQty').val('');
            $('#quickOrderUPC').focus();
        }, 500);
    }

    function clearQuickEntryAlertBox(){
        $('#quickOrderStatus').html('');
        $('#quickOrderStatus').removeClass('alert-info');
        $('#quickOrderStatus').removeClass('alert-success');
        $('#quickOrderStatus').removeClass('alert-danger');
    }
</script>
<!-- END  QUICK ENTRY MODAL -->


<!-- Product Details MODAL -->

<div class="modal fade" id="ProductDetailsModal">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span>
                </button>
                <h4 class="modal-title">Product Details - <span id="skuProductDetails"></span></h4><br/>

            </div>
            <div class="modal-body">
                <div role="tabpanel">

                    <!-- Nav tabs -->
                    <ul class="nav nav-tabs" role="tablist">
                        <li role="presentation" class="active"><a href="#images" aria-controls="images" id="imagesTab"
                                                                  role="tab" data-toggle="tab">Image</a></li>
                        <li role="presentation"><a href="#details" aria-controls="details" id="detailsTab" role="tab"
                                                   data-toggle="tab">Attributes</a></li>

                    </ul>

                    <!-- Tab panes -->
                    <div class="tab-content">
                        <div role="tabpanel" class="tab-pane centered active" id="images">
                            <img src="" style="max-width: 100%;" id="imageProductDetails"/>
                        </div>
                        <div role="tabpanel" class="tab-pane" id="details">
                            <table class="table table-condensed table-striped table-responsive">
                                <thead>
                                <th>Attribute</th>
                                <th>Value</th>
                                </thead>
                                <tbody id="detailsTable">

                                </tbody>

                            </table>

                        </div>
                    </div>

                </div>
            </div>
            <div class="modal-footer">

                <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
            </div>
        </div><!-- /.modal-content -->
    </div><!-- /.modal-dialog -->
</div><!-- /.modal -->
<script type="text/javascript">
    function getProductDetails(Line, SKU) {
        $.get('functions.php?action=getProductDetails&line=' + Line + "&sku=" + SKU, function (data) {
            clearProductDetails();
            data = JSON.parse(data);
            $('#skuProductDetails').text(data.SKU);
            for (var i = 0; i < data.Attributes.length; i++) {
                $('#detailsTable').append("<tr><td>" + data.Attributes[i].Name + "</td><td>" + data.Attributes[i].Value + "</td></tr>");
            }

            $('#imageProductDetails').attr('src', data.ImageURL);
            $('#ProductDetailsModal').modal('toggle');
        });


    }

    function clearProductDetails() {
        $('#skuProductDetails').text('');
        $('#detailsTable').html('');
        $('#imageProductDetails').attr('src', '');
    }
</script>
<!-- END Product Details MODAL -->


<!-- Generic DATE SELECT -->
<div class="modal fade" id="genericSelectDate" tabindex="-1" role="dialog" aria-labelledby="myModalLabel"
     aria-hidden="true">
    <div class="modal-dialog modal-sm">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span>
                </button>
                <h4 class="modal-title">Select Date</h4>
            </div>
            <div class="modal-body">
                <form>
                    <div class="form-group">
                        <label for="fromDate">From Date:</label>
                        <input class="form-control" type="date" name="genericSelectDateFrom" id="genericSelectDateFrom"
                               value="<?= date("Y-m-01") ?>"/>
                    </div>
                    <div class="form-group">
                        <label for="fromDate">To Date:</label>
                        <input class="form-control" type="date" name="genericSelectDateTo" id="genericSelectDateTo"
                               value="<?= date("Y-m-d") ?>"/>
                    </div>
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                <button type="button" id="genericSelectDateGo" class="btn btn-primary">Go</button>
            </div>
        </div>
    </div>
</div>
<script type="text/javascript">
    function orderHistoryDateSelect() {
        $('#genericSelectDate').modal();
        $('#genericSelectDateGo').unbind("click");
        $('#genericSelectDateGo').on('click', function () {
            var fromDate = $('#genericSelectDateFrom').val();
            var toDate = $('#genericSelectDateTo').val();
            var url = "orderhistory.php?from=" + fromDate + "&to=" + toDate;
            window.location = url;
        });
    }

    function estimateHistoryDateSelect() {
        $('#genericSelectDate').modal();
        $('#genericSelectDateGo').unbind("click");
        $('#genericSelectDateGo').on('click', function () {
            var fromDate = $('#genericSelectDateFrom').val();
            var toDate = $('#genericSelectDateTo').val();
            var url = "mod.php?p=estimate&a=history&from=" + fromDate + "&to=" + toDate;
            window.location = url;
        });
    }
    function reconciliationHistoryDateSelect() {
        $('#genericSelectDate').modal();
        $('#genericSelectDateGo').unbind("click");
        $('#genericSelectDateGo').on('click', function () {
            var fromDate = $('#genericSelectDateFrom').val();
            var toDate = $('#genericSelectDateTo').val();
            var url = "mod.php?p=payment&a=salesmanreconciliationhistory&fromDate=" + fromDate + "&toDate=" + toDate;
            window.location = url;
        });
    }
    function invoiceHistoryDateSelect() {
        $('#genericSelectDate').modal();
        $('#genericSelectDateGo').unbind("click");
        $('#genericSelectDateGo').on('click', function () {
            var fromDate = $('#genericSelectDateFrom').val();
            var toDate = $('#genericSelectDateTo').val();
            var url = "mod.php?p=invoice&a=salespersonhistory&from=" + fromDate + "&to=" + toDate;
            window.location = url;
        });
    }
    function customerInvoiceHistoryDateSelect() {
        $('#genericSelectDate').modal();
        $('#genericSelectDateGo').unbind("click");
        $('#genericSelectDateGo').on('click', function () {
            var fromDate = $('#genericSelectDateFrom').val();
            var toDate = $('#genericSelectDateTo').val();
            var url = "mod.php?p=invoice&a=customerhistory&from=" + fromDate + "&to=" + toDate;
            window.location = url;
        });
    }

</script>
<!-- END Generic HISTOY DATE SELECT -->

<?php
if (!$isCustomer) {


    ?>

    <!-- PRICE PLAN SET MODAL -->
    <div class="modal fade" id="pricePlanModal" tabindex="-1" role="dialog" aria-labelledby="pricePlanModal"
         aria-hidden="true">
        <div class="modal-dialog modal-sm">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
                    <h4 class="modal-title" id="pricePlanModalTitle">Select Customer</h4>
                </div>
                <div class="modal-body">
                    <select class="form-control combobox" id="pricePlanCustomerSelect">
                        <option></option>
                        <?php
                        if ($salesman->ID == "25" || $salesman->ID == "99") {
                            $query = "SELECT * FROM CUSTOMER, PRICE_PLAN_CALC WHERE CUSTOMER.AccountNumber = PRICE_PLAN_CALC.AccountNumber";
                        } else {
                            $query = "SELECT * FROM CUSTOMER, PRICE_PLAN_CALC WHERE CUSTOMER.AccountNumber = PRICE_PLAN_CALC.AccountNumber AND Salesman LIKE '" . $salesman->ID . "'";
                        }
                        $result = mysqli_query($con, $query);
                        while ($row = mysqli_fetch_array($result)) {
                            ?>
                            <option value="<?= $row['AccountNumber'] ?>"><?= $row['AccountNumber'] . " - " . $row['Name'] ?></option>
                            <?php
                        }
                        ?>
                    </select>
                </div>
                <div class="modal-footer">
                    <a onclick="setPricePlanMode(null);" class="btn btn-danger">Reset</a>
                    <a onclick="setPricePlanMode($('#pricePlanCustomerSelect').val());" class="btn btn-success">Set
                        Price Plan</a>
                    <br/>
                </div>

            </div>
        </div>
    </div>
    <!-- END PRICE PLAN SET MODAL -->

    <!-- SET TRUCK MODE MODAL -->
    <div class="modal fade" id="truckModeWarehouseModal" tabindex="-1" role="dialog"
         aria-labelledby="truckModeWarehouseModal" aria-hidden="true">
        <div class="modal-dialog modal-sm">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
                    <h4 class="modal-title" id="truckModeModalTitle">Select Truck</h4>
                </div>
                <div class="modal-body">
                    <select class="form-control combobox" id="truckModeWarehouseSelect">
                        <option></option>
                        <?php

                        $warehouses = getWarehouses("T");
                        foreach ($warehouses->Data as $warehouse) {
                            ?>
                            <option value="<?= $warehouse['WarehouseID'] ?>"><?= $warehouse['WarehouseName'] ?></option>
                            <?php
                        }
                        ?>
                    </select>
                    <?php

                    ?>
                </div>
                <div class="modal-footer">
                    <a onclick="setTruckMode(null);" class="btn btn-danger">Reset</a>
                    <a onclick="setTruckMode($('#truckModeWarehouseSelect').val());" class="btn btn-success">Set Truck
                        Mode</a>
                    <br/>
                    **Setting up Truck Mode will remove from your cart the items not available in the truck selected.
                </div>

            </div>
        </div>
    </div>
    <script type="text/javascript">
        function setTruckMode(warehouseID) {
            $.get("functions.php",
                {
                    "action": "setTruckMode",
                    "f": "set",
                    "wid": warehouseID
                }, function (data) {
                    if (data == "true") {
                        location.reload();
                    }

                });
        }
    </script>
    <!-- END SET TRUCK MODE MODAL -->
    <?php
}
?>
<?php

include("./modules.modals.php");
?>
<script type="text/javascript">

    var Line = [];
    var Group = [];
    var SKU = [];
    var OnOrder = [];
    var Items = [];
    var modal = $("#qtyBox");

    function closeQtyModal() {
        if ($("#specialsModal").data('bs.modal') !== undefined) {
            if ($("#specialsModal").data('bs.modal').isShown) {
                setTimeout(function () {
                    $('body').addClass('modal-open');
                }, 450);
            }
        }

        if ($("#catalogModal").data('bs.modal') === undefined && $("#altasModal").data('bs.modal') === undefined) {
            //$('[name=sku]').select();
        } else {
            if ($("#catalogModal").data('bs.modal') === undefined && $("#altasModal").data('bs.modal') !== undefined) {
                if ($("#altasModal").data('bs.modal').isShown) {
                    setTimeout(function () {
                        $('body').addClass('modal-open');
                    }, 450);
                }
            } else if ($("#catalogModal").data('bs.modal') !== undefined && $("#altasModal").data('bs.modal') === undefined) {
                if ($("#catalogModal").data('bs.modal').isShown) {
                    setTimeout(function () {
                        $('body').addClass('modal-open');
                    }, 450);
                }
            } else {
               // $('[name=sku]').select();
            }
        }
        if (typeof $("#newAltasModal").data('bs.modal') != "undefined") {
            if ($("#newAltasModal").data('bs.modal').isShown === true) {
                setTimeout(function () {
                    $('body').addClass('modal-open');
                }, 450);
            }
        }

        modal.modal('hide');
    }


    $("#qtyBoxInput").keydown(function (e) {

        if (e.which == 13) {
            e.preventDefault();
            addQtyToCart();
        }
    });
    modal.on('shown.bs.modal', function () {
        $('[name=Qty]').focus();

        $('#addButton').removeAttr('disabled');

    });
    $("#addButton").unbind("click");
    $("#addButton").on('click', function () {
        addQtyToCart();
    });

    function addQtyToCart() {
        $('#addButton').attr('disabled', true);
        closeQtyModal();
        var qty = $("[name=Qty]").val();
        if (qty === "") {
            qty = 0;
        }
        qty = parseInt(qty);
        qty = Math.abs(qty);

        var request = $.get("functions.php", {
            action: "addToCart",
            Group: $("[name=Group]").val(),
            Line: $("[name=Line]").val(),
            SKU: $("[name=SKU]").val(),
            Qty: qty,
            OnOrder: $("[name=Update]").val()
        })
            .done(function (data) {
                console.log(data);
                if (data == "false") {
                    console.log(data);
                    //location.reload();
                }
                var index = $("[name=Index]").val();
                OnOrder[index] = qty;
                if (qty > 0) {
                    $("[name=Update]").val("true");
                    $("#" + index + "AddButton").text("Update");
                    $("#" + index + "AddButton").removeClass("btn-success");
                    $("#" + index + "AddButton").addClass("btn-warning");
                } else {
                    $("[name=Update]").val("false");
                    $("#" + index + "AddButton").text("Add");
                    $("#" + index + "AddButton").addClass("btn-success");
                    $("#" + index + "AddButton").removeClass("btn-warning");
                }
                $("#cartTotal").text(moneyFormat(data));
                $("#cartTotal2").text(moneyFormat(data));
                if ($("#catalogModal").data('bs.modal') === undefined) {
                    //$('[name=sku]').select();
                } else {
                    if ($("#catalogModal").data('bs.modal').isShown) {
                        setTimeout(function () {
                            $("#catalogModal").modal();
                        }, 250);
                    } else if ($("#altasModal").data('bs.modal').isShown) {
                        setTimeout(function () {
                            $("#altasModal").modal();
                        }, 250);
                    } else if ($("#specialsModal").data('bs.modal').isShown) {
                        setTimeout(function () {
                            $("#specialsModal").modal();
                        }, 250);
                    } else {
                        //$('[name=sku]').select();
                    }
                }
            });

        request.fail(function (e) {
            modal.modal('toggle');
            alert("There was an error, please check your internet connection " + e);
        });
    }

    function setPricePlanMode(accountNumber) {
        if (accountNumber === null || accountNumber === "") {
            $.get('functions.php?action=setPricePlanMode&ppAction=reset', function (data) {
                location.reload(true);
            });
        } else {
            $.get('functions.php?action=setPricePlanMode&ppAction=set&accountNumber=' + accountNumber, function (data) {
                location.reload(true);
            });
        }
    }

    function changePassword() {
        var oldPass = $('[name=oldPassword]').val();
        var newPass1 = $('[name=newPassword1]').val();
        var newPass2 = $('[name=newPassword2]').val();
        if (newPass1 != newPass2) {
            alert("Error! Passwords does not match!");
            return;
        } else {
            if (checkPwd(newPass1) == "too_short") {
                alert("Error! The password is too short!");
                return;
            }
            if (checkPwd(newPass1) == "too_long") {
                alert("Error! The password is too long!");
                return;
            }
            if (checkPwd(newPass1) == "bad_char") {
                alert("Error! The password has an invalid character!");
                return;
            }
            if (checkPwd(newPass1) == "ok") {
                $.get('functions.php?action=changePassword&old=' + oldPass + '&new=' + newPass1, function (e) {


                    if (e == "success") {
                        alert("Password changed!");
                        jQuery('#passwordChange').modal('hide');
                    } else {
                        alert("Error occurred, check your old password");
                    }
                });
            }
        }
    }

    function checkPwd(str) {
        if (str.length < 4) {
            return ("too_short");
        } else if (str.length > 20) {
            return ("too_long");
        } else if (str.search(/[^a-zA-Z0-9\!\@\#\$\%\^\&\*\(\)\_\+]/) != -1) {
            return ("bad_char");
        }
        return ("ok");
    }

    function clearPasswordForm() {
        $('[name=oldPassword]').val("");
        $('[name=newPassword1]').val("");
        $('[name=newPassword2]').val("");
        $('#passwordChange').modal('show');
    }

    var isCatalogLoaded = {};
    var catalogModal = $("#catalogModal");
    catalogModal.on('shown.bs.modal', function (e) {
        fillCatalog(CatalogCategory[0].ID);
    });


    function fillCatalog(category) {
        category = parseInt(category);
        if (!isCatalogLoaded[category]) {
            $('#catalog-' + category).html("");
            $.get('functions.php?action=getCatalogData&cid=' + category, function (data) {
                isCatalogLoaded[category] = true;
                data = JSON.parse(data);
                number = SKU.length;
                for (var i = 0; i < data.length; i++) {
                    var item = data[i];
                    var addButtonText = "Add";
                    var addButtonStyle = "success";
                    SKU[number] = item.SKU;
                    Items[number] = item;
                    Line[number] = item.Line;
                    Group[number] = item.Group;
                    if (item.OnOrder === null) {
                        OnOrder[number] = "";
                        addButtonText = "Add";
                        addButtonStyle = "success";
                    } else {
                        OnOrder[number] = item.OnOrder;
                        addButtonText = "Update";
                        addButtonStyle = "warning";
                    }


                    var color = "";
                    if (i % 2 === 0) {
                        color = "FFFFFF";
                    } else {
                        color = "EEEEEE";
                    }
                    var qtyColor = "";
                    if (item.Discontinued == "1") {
                        qtyColor = "style='color:red;' ";
                    }
                    <?php
                    if($customer->AccountNumber == "10033"){
                    ?>
                    if (item.Qty < 0) {
                        item.Qty = "0";
                    }
                    <?php
                    }else{
                    ?>
                    if (item.Qty > 50 && <?= $isCustomer ? "true" : "false" ?>) {
                        item.Qty = "50+";
                    } else if (item.Qty < 0) {
                        item.Qty = "0";
                    }
                    <?php
                    }
                    ?>
                    var onthewayString = "";
                    if (item.ConfirmedQty > 0) {
                        onthewayString = "<img src=\"img/ontheway.jpg\" style=\"width: 40px;\">:" + item.ConfirmedQty;
                    } else {
                        onthewayString = "";
                    }
                    var committedQtyString = "";
                    if (item.CommittedQty > 0) {
                        committedQtyString = "<br>Committed: <b>" + item.CommittedQty + "</b>";
                    } else {
                        committedQtyString = "";
                    }
                    var backorderQtyString = "";
                    if (item.BackorderedQty > 0) {
                        backorderQtyString = "<br>Backordered: <b>" + item.BackorderedQty + "</b>";
                    } else {
                        backorderQtyString = "";
                    }
                    var html = "<div class=\"col-xs-12 col-sm-6  col-lg-4\" style=\"max-height: 300px; padding-bottom: 10px; background-color: #" + color + "\"><h5 style=\"height: 2em;  text-overflow:ellipsis; white-space: nowrap;  overflow: hidden;\">" + item.Description + "</h4><p style=\"height: 150px; text-align: center; vertical-align: middle;\"><a href=\"" + item.Image + "\" data-lightbox=\"" + item.Line + "-" + item.SKU + "\" data-title=\"" + item.Description + "\"><img style=\"max-width:100%; max-height:100%; text-align: center;\" src=\"" + item.Image + "\" /></a></p><p style=\"width: 60%; float: left;\">SKU: <b>" + item.SKU + "<br/><b><span>" + onthewayString + committedQtyString + backorderQtyString + "</p><p style=\"width: 40%; float: right;\">Quantity: <b " + qtyColor + ">" + item.Qty + "</b> <br />Price: <b>" + item.Price + "</b></p><p><a style=\" width: 80px; float: right;\" onclick=\"askQty(" + number + ")\" id=\"" + number + "AddButton\" class=\"btn btn-" + addButtonStyle + "\" href=\"#\" role=\"button\">" + addButtonText + "</a></p></div> ";
                    console.log(html);
                    $('#catalog-' + category).append(html);
                    number++;
                }
            });
        }
    }

    var isNewAltasLoaded = {};
    var newAltasModal = $("#newAltasModal");
    newAltasModal.on('shown.bs.modal', function (e) {
        fillNewAltas(NewAltasTabs[0].ID, $('#newAltasModal a')[0]);
    });


    function fillNewAltas(AltaID, element) {
        $('#newAltasSubtitle').html('');
        if (typeof element !== "undefined") {
            $('#newAltasSubtitle').html($(element).html() + $(element).data('date'));
            //alert($(element).text());
        }
        if (true) {
            $('#newAltasBody').html("");
            $.get('functions.php?action=getAltasData&id=' + AltaID, function (data) {
                isNewAltasLoaded[AltaID] = true;
                data = JSON.parse(data);
                number = SKU.length;
                var html = "<table class=\"table\">"
                    + "<thead>"
                    + "<tr>"
                    + "      <th style=\"width: 5%\">Line<br>Group</th>"
                    + "      <th style=\"width: 75%\">Item</th>"
                    + "      <th style=\"width: 5%\">QTY</th>"
                    + "      <th style=\"width: 5%\">Price</th>"
                    + "      <th style=\"width: 15%\">Order</th>"
                    + "	</tr>"
                    + "</thead>"
                    + "<tbody>";

                for (var i = 0; i < data.length; i++) {
                    var item = data[i];
                    var addButtonText = "Add";
                    var addButtonStyle = "success";
                    SKU[number] = item.SKU;
                    Items[number] = item;
                    Line[number] = item.Line;
                    Group[number] = item.Group;
                    if (item.OnOrder == null) {
                        OnOrder[number] = "";
                        addButtonText = "Add";
                        addButtonStyle = "success";
                    } else {
                        OnOrder[number] = item.OnOrder;
                        addButtonText = "Update";
                        addButtonStyle = "warning";
                    }


                    if (item.Qty > 50) {
                        item.Qty = "50+";
                    }
                    var imageSnippet = "";

                    if (item.Image != false) {
                        imageSnippet = "<a href=\"" + item.Image + "\" data-lightbox=\"" + item.Line + "-" + item.SKU + "\" data-title=\"" + item.Description + "\"><img style=\"width: 28px;\" src=\"img/icon-camera-32.png\" /></a>";
                    }
                    if (item.Interchange.trim() != "") {
                        item.Interchange = " (" + item.Interchange + ")";
                    }
                    html += "<tr>"
                        + "   <td>"
                        + "   		<span class=\"itemInfo\">" + item.Line + "</span>"
                        + "   		<span class=\"itemInfo\">" + item.Group + "</span>"
                        + "   </td>"
                        + "   <td>"
                        + "   		<span class=\"itemInfo\"><b>" + item.SKU + "</b>" + item.Interchange + imageSnippet + "</span><br>"
                        + "   		<span class=\"itemInfo\">" + item.Description + " " + item.Notes + "</span>"
                        + "   		<span class=\"itemInfo\"></span>"
                        + "   </td>"
                        + "   <td>" + item.Qty + "</td>"
                        + "   <td>" + item.Price + "</td>"
                        + "   <td>"
                        + "   		<button id=\"" + number + "AddButton\" class=\"btn btn-" + addButtonStyle + "\" onclick=\"askQty(" + number + ")\" type=\"button\">" + addButtonText + "</button>"
                        + "   </td>"
                        + " </tr>";

                    number++;
                }
                html += "</tbody>"
                    + "</table>";
                $('#newAltasBody').append(html);
            });
        }
        $('#newAltasModal').animate({scrollTop: 0}, 200);
    }

    var isAltasLoaded = {};
    var altasModal = $("#altasModal");
    altasModal.on('shown.bs.modal', function (e) {
        fillAltas(AltasTabs[0].ID);
    });

    function fillAltas(AltaID) {
        if (!isAltasLoaded[AltaID]) {
            $('#altas-' + AltaID).html("");
            $.get('functions.php?action=getAltasData&id=' + AltaID, function (data) {
                isAltasLoaded[AltaID] = true;
                data = JSON.parse(data);
                number = SKU.length;
                var html = "<table class=\"table\">"
                    + "<thead>"
                    + "<tr>"
                    + "      <th style=\"width: 5%\">Line<br>Group</th>"
                    + "      <th style=\"width: 75%\">Item</th>"
                    + "      <th style=\"width: 5%\">Transit</th>"
                    + "      <th style=\"width: 5%\" class=\"hidden-xs\">On Hand</th>"
                    + "      <th style=\"width: 5%\">Price</th>"
                    + "      <th style=\"width: 15%\">Order</th>"
                    + "	</tr>"
                    + "</thead>"
                    + "<tbody>";

                for (var i = 0; i < data.length; i++) {
                    var item = data[i];
                    var addButtonText = "Add";
                    var addButtonStyle = "success";
                    SKU[number] = item.SKU;
                    Items[number] = item;
                    Line[number] = item.Line;
                    Group[number] = item.Group;
                    if (item.OnOrder == null) {
                        OnOrder[number] = "";
                        addButtonText = "Add";
                        addButtonStyle = "success";
                    } else {
                        OnOrder[number] = item.OnOrder;
                        addButtonText = "Update";
                        addButtonStyle = "warning";
                    }


                    if (item.Qty > 50) {
                        item.Qty = "50+";
                    }
                    var imageSnippet = "";

                    if (item.Image != false) {
                        imageSnippet = "<a href=\"" + item.Image + "\" data-lightbox=\"" + item.Line + "-" + item.SKU + "\" data-title=\"" + item.Description + "\"><img style=\"width: 28px;\" src=\"img/icon-camera-32.png\" /></a>";
                    }
                    if (item.Interchange.trim() != "") {
                        item.Interchange = " (" + item.Interchange + ")";
                    }
                    html += "<tr>"
                        + "   <td>"
                        + "   		<span class=\"itemInfo\">" + item.Line + "</span>"
                        + "   		<span class=\"itemInfo\">" + item.Group + "</span>"
                        + "   </td>"
                        + "   <td>"
                        + "   		<span class=\"itemInfo\"><b>" + item.SKU + "</b>" + item.Interchange + imageSnippet + "</span><br>"
                        + "   		<span class=\"itemInfo\">" + item.Description + " " + item.Notes + "</span>"
                        + "   		<span class=\"itemInfo\"></span>"
                        + "   </td>"
                        + "   <td>" + item.ConfirmedQty + "</td>"
                        + "   <td  class=\"hidden-xs\">" + item.Qty + "</td>"
                        + "   <td>" + item.Price + "</td>"
                        + "   <td>"
                        + "   		<button id=\"" + number + "AddButton\" class=\"btn btn-" + addButtonStyle + "\" onclick=\"askQty(" + number + ")\" type=\"button\">" + addButtonText + "</button>"
                        + "   </td>"
                        + " </tr>";

                    number++;
                }
                html += "</tbody>"
                    + "</table>";
                $('#altas-' + AltaID).append(html);
            });
        }
    }

    function launchPromoModal() {
        javascript:$('#promoLineModal').modal('toggle');
    }

    function fillPromoGroup(Group) {
        if (true) {
            $('#promoGroupPartList').html("");
            $.get('functions.php?action=getPromoGroupData&group=' + Group, function (data) {
                data = JSON.parse(data);
                number = SKU.length;
                var html = "<table class=\"table\">"
                    + "<thead>"
                    + "<tr>"
                    + "      <th style=\"width: 5%\">Line<br>Group</th>"
                    + "      <th style=\"width: 75%\">Item</th>"
                    + "      <th style=\"width: 5%\">QTY</th>"
                    + "      <th style=\"width: 5%\">Price</th>"
                    + "      <th style=\"width: 15%\">Order</th>"
                    + "	</tr>"
                    + "</thead>"
                    + "<tbody>";

                for (var i = 0; i < data.length; i++) {
                    var item = data[i];
                    var addButtonText = "Add";
                    var addButtonStyle = "success";

                    window.Group[number] = item.Group;
                    Items[number] = item;
                    SKU[number] = item.SKU;
                    Line[number] = item.Line;

                    if (item.OnOrder == null) {
                        OnOrder[number] = "";
                        addButtonText = "Add";
                        addButtonStyle = "success";
                    } else {
                        OnOrder[number] = item.OnOrder;
                        addButtonText = "Update";
                        addButtonStyle = "warning";
                    }


                    if (item.Qty > 50) {
                        item.Qty = "50+";
                    }
                    var imageSnippet = "";

                    if (item.Image != false) {
                        imageSnippet = "<a href=\"" + item.Image + "\" data-lightbox=\"" + item.Line + "-" + item.SKU + "\" data-title=\"" + item.Description + "\"><img style=\"width: 28px;\" src=\"img/icon-camera-32.png\" /></a>";
                    }
                    if (item.Interchange.trim() != "") {
                        item.Interchange = " (" + item.Interchange + ")";
                    }
                    html += "<tr>"
                        + "   <td>"
                        + "   		<span class=\"itemInfo\">" + item.Line + "</span>"
                        + "   		<span class=\"itemInfo\">" + item.Group + "</span>"
                        + "   </td>"
                        + "   <td>"
                        + "   		<span class=\"itemInfo\"><b>" + item.SKU + "</b>" + item.Interchange + imageSnippet + "</span><br>"
                        + "   		<span class=\"itemInfo\">" + item.Description + " " + item.Notes + "</span>"
                        + "   		<span class=\"itemInfo\"></span>"
                        + "   </td>"
                        + "   <td>" + item.Qty + "</td>"
                        + "   <td>" + item.Price + "</td>"
                        + "   <td>"
                        + "   		<button id=\"" + number + "AddButton\" class=\"btn btn-" + addButtonStyle + "\" onclick=\"askQty(" + number + ")\" type=\"button\">" + addButtonText + "</button>"
                        + "   </td>"
                        + " </tr>";

                    number++;
                }
                html += "</tbody>"
                    + "</table>";
                $('#promoGroupPartList').append(html);
                $('#promoLineModal').animate({scrollTop: 0}, 800);
            });
        }
    }

    var isSpecialsLoaded = false;
    var specialsModal = $("#specialsModal");
    specialsModal.on('shown.bs.modal', function (e) {
        fillSpecials();
    });

    function fillSpecials() {
        if (!isSpecialsLoaded) {
            $('#specials-body').html("");
            $.get('functions.php?action=getSpecialsData', function (data) {
                isSpecialsLoaded = true;
                data = JSON.parse(data);
                number = SKU.length;
                var html = "<table class=\"table\">"
                    + "<thead>"
                    + "<tr>"
                    + "      <th style=\"width: 5%\">Line<br>Group</th>"
                    + "      <th style=\"width: 75%\">Item</th>"
                    + "      <th style=\"width: 5%\">QTY</th>"
                    + "      <th style=\"width: 5%\">Price</th>"
                    + "      <th style=\"width: 15%\">Order</th>"
                    + "	</tr>"
                    + "</thead>"
                    + "<tbody>";

                for (var i = 0; i < data.length; i++) {
                    var item = data[i];
                    var addButtonText = "Add";
                    var addButtonStyle = "success";
                    SKU[number] = item.SKU;
                    Line[number] = item.Line;
                    Group[number] = item.Group;
                    Items[number] = item;
                    if (item.OnOrder == null) {
                        OnOrder[number] = "";
                        addButtonText = "Add";
                        addButtonStyle = "success";
                    } else {
                        OnOrder[number] = item.OnOrder;
                        addButtonText = "Update";
                        addButtonStyle = "warning";
                    }
                    if (item.Image != false) {
                        imageSnippet = "<a href=\"" + item.Image + "\" data-lightbox=\"" + item.Line + "-" + item.SKU + "\" data-title=\"" + item.Description + "\"><img style=\"width: 28px;\" src=\"img/icon-camera-32.png\" /></a>";
                    }

                    if (item.Qty > 50) {
                        item.Qty = "50+";
                    }
                    if (item.Interchange.trim() != "") {
                        item.Interchange = " (" + item.Interchange + ")";
                    }
                    html += "<tr>"
                        + "   <td>"
                        + "   		<span class=\"itemInfo\">" + item.Line + "</span>"
                        + "   		<span class=\"itemInfo\">" + item.Group + "</span>"
                        + "   </td>"
                        + "   <td>"
                        + "   		<span class=\"itemInfo\"><b>" + item.SKU + "</b>" + item.Interchange + imageSnippet + "</span><br>"
                        + "   		<span class=\"itemInfo\">" + item.Description + " " + item.Notes + "</span>"
                        + "   		<span class=\"itemInfo\"></span>"
                        + "   </td>"
                        + "   <td>" + item.Qty + "</td>"
                        + "   <td><s>" + item.RegularPrice + "</s><br /><span style=\"color: red;\">" + item.Price + "</span></td>"
                        + "   <td>"
                        + "   		<button id=\"" + number + "AddButton\" class=\"btn btn-" + addButtonStyle + "\" onclick=\"askQty(" + number + ")\" type=\"button\">" + addButtonText + "</button>"
                        + "   </td>"
                        + " </tr>";

                    number++;
                }
                html += "</tbody>"
                    + "</table>";
                $('#specials-body').append(html);
            });
        }
    }

    function askQty(number) {
        var Update;
        if (OnOrder[number] == "") {
            Update = false;
        } else {
            Update = true;
        }
        if(parseInt(Items[number].Qty)+Items[number].ConfirmedQty < 1){
            alert("This item is out of stock.");
        }else{
            $("#qtyBoxTitle").text(Line[number] + " - " + SKU[number]);
            $("[name=Index]").val(number);
            $("[name=Qty]").val(OnOrder[number]);
            $("[name=Group]").val(Group[number]);
            $("[name=Line]").val(Line[number]);
            $("[name=SKU]").val(SKU[number]);
            $("[name=Update]").val(Update);
            $("#qtyBox").modal();
        }

    }

</script>
<?php
if ($isCustomer) {


    $query = "SELECT id FROM DELIVERY_ZONE_CITY WHERE City = '" . $customer->City . "' AND (Zone = 1 OR Zone = 2 OR Zone = 5) GROUP BY City";
    $result = mysqli_query($con, $query);
    $num = mysqli_num_rows($result);
    if ($num && $_REQUEST['splash'] == "true") {

    }
    ?>

    <link rel="stylesheet" href="/css/flipclock.css">
    <style>
        .sameday-clock {
            zoom: 0.5;
            z-index: 9999999999999;
            position: absolute;
            bottom: 10px;
            right: -1000px;

        }

        .clock-label {
            css z-index: 9999999999999;
            position: absolute;
            bottom: 100px;
            right: 20px;

        }
    </style>
    <div class="clock-label"></div>
    <div class="sameday-clock"></div>


    <script src="/js/flipclock.min.js"></script>
    <script>
        $(document).ready(function () {
            //console.log(($(window).width()*-1-500) + "px");
            $('.sameday-clock').css("right", $(window).width() * -2 + 500 + "px");


        });
    </script>
    <?php
}


?>


<!-- PAY NOW MODAL -->

<div class="modal fade" tabindex="-1" id="PayNowModal" role="dialog">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span>
                </button>
                <h4 class="modal-title">Pay Now - <b><i>Coming Soon</i></b></h4>
            </div>
            <div class="modal-body">

                <span>Pronto estará disponible la habilidad para pagar al instante utilizando su metodo de pago favorito. Además, clientes con cuentas a credito podr&aacute; realizar pagos a la cuenta directamente desde la plataforma Web.</span>
                <br>

                <p>Escoja su metodo de pago</p>
                <li><input type="radio" name="paymentMedia" value="cc"> Credit / Debit Card <b><i>Coming Soon</i></b>
                </li>
                <li><input type="radio" name="paymentMedia" value="ck"> Check <b><i>Coming Soon</i></b></li>
                <li><input type="radio" name="paymentMedia" value="ath"> ATH Movil <b><i>Coming Soon</i></b></li>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal">Go Back</button>
                <!-- <button type="button" class="btn btn-primary">Save</button>-->
            </div>
        </div><!-- /.modal-content -->
    </div><!-- /.modal-dialog -->
</div><!-- /.modal -->

<!-- SET CUSTOMER -->

<div class="modal fade" tabindex="-1" id="RequiredSetCustomerModal" data-backdrop="static" data-keyboard="false"
     role="dialog">
    <div class="modal-dialog modal-md" role="document">
        <div class="modal-content">
            <div class="modal-header">

                <h4 class="modal-title">Please select a Customer to Continue</h4>
            </div>

            <div class="modal-body">

                <select class="combobox form-control" name="ac" id="RequiredSetCustomerAccountNumber">
                    <option></option>
                    <?php
                    $chooseSalesmanID = $salesman->ID;
                    if ($salesman->is_manager) {
                        $chooseSalesmanID = "%";
                    }
                    $query = "SELECT AccountNumber, Name, ShipToCity, SUM(Balance) Balance FROM CUSTOMER LEFT JOIN ACCOUNTS_RECEIVABLE_AGING_DELIVERY_CACHE USING(AccountNumber) WHERE (CUSTOMER.Salesman LIKE '" . $chooseSalesmanID . "' OR CUSTOMER.AccountNumber = '00000-00' OR CUSTOMER.AccountNumber = '00000-01') AND Active = 1 GROUP BY AccountNumber ORDER BY CUSTOMER.Name, ShipToCity";
                    $result = mysqli_query($con, $query);
                    while ($row = mysqli_fetch_array($result)) {

                        $queryDaysSinceLastOrder = "SELECT AccountNumber, MIN(DATEDIFF(NOW(),IF(Delivered,DeliveryDate,InvoiceDate))) Days FROM INVOICE_HEAD JOIN INVOICE_DETAIL USING(InvoiceID) WHERE Line =\"MPT\" AND `Status` = 1 AND Void = 0 AND AccountNumber = '" . $row['AccountNumber'] . "' GROUP BY AccountNumber;";
                        $resultDaysSinceLastOrder = mysqli_query($con, $queryDaysSinceLastOrder);
                        $numDaysSinceLastOrder = mysqli_num_rows($resultDaysSinceLastOrder);
                        $daysSinceLastOrder = -1;
                        if ($numDaysSinceLastOrder) {
                            $rowDaysSinceLastOrder = mysqli_fetch_array($resultDaysSinceLastOrder);
                            $daysSinceLastOrder = $rowDaysSinceLastOrder['Days'];
                        }
                        if($daysSinceLastOrder == -1){
                            $daysSinceLastOrder = "Nunca - ";
                        }else{
                            $daysSinceLastOrder = "(" . $daysSinceLastOrder . " Days) - ";
                        }

                        ?>
                        <option class="danger" value="<?= $row['AccountNumber'] ?>"><?= ($row['Balance']>.01?"💰 ":"") . ($daysSinceLastOrder . $row['AccountNumber']) . " - " . $row['Name'] . " - " . $row['ShipToCity'] . ($row['Balance']>.01?(" - " . moneyFormat($row['Balance'])):"")?></option>
                        <?php
                    }

                    ?>

                </select>
                <br>


            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-primary" onclick="$('#RequiredSetCustomerAccountNumber').val('00000-00'); setRequiredCustomer();">New Customer</button>
                <button type="button" style="display: none;" id="RequiredSetCustomerModalCloseButton"
                        class="btn btn-danger" onclick="$('#RequiredSetCustomerModal').modal('hide')">Close
                </button>
                <button type="button" class="btn btn-primary" onclick="setRequiredCustomer();">Select</button>
            </div>
        </div><!-- /.modal-content -->
    </div><!-- /.modal-dialog -->
</div><!-- /.modal -->
<script type="text/javascript">
    function setRequiredCustomer(param) {
        if (param == undefined) {
            param = $('#RequiredSetCustomerAccountNumber').val();
        }
        if (param == -1 || param == "-1" || param == "") {
            $.get('functions.php?action=clearSetCustomer', function (data) {
                data = JSON.parse(data);
                if (data.result) {
                    location.reload();
                } else {
                    alert("ERROR");
                }


            });
        } else {
            $.get('functions.php?action=setCustomer&id=' + param, function (data) {
                data = JSON.parse(data);
                if (data.result) {
                    location.reload();
                } else {
                    alert("ERROR");
                }
            });
        }

    }

</script>

<!-- END SET CUSTOMER -->
<!-- DELIVERY MODAL -->
<div class="modal fade" id="deliveryModal" tabindex="-1" role="dialog" aria-labelledby="deliveryModal">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span>
                </button>
                <h4 class="modal-title" id="deliveryModalTitle">Deliver Invoices</h4>
            </div>
            <div class="modal-body">
                <table class="table table-condensed">
                    <thead>
                    <tr>
                        <th>ID<br>Customer</th>
                        <th></th>
                        <th>Select</th>
                    </tr>
                    </thead>
                    <tbody>
                    <?php
                    $salesperson = $_SESSION['SalesmanID'];
                    if ($salesperson == "CC" || $salesperson == "JC" || $salesperson == "ES" || $salesperson == "25") {
                        $salesperson = "%";
                    }
                    $query = "SELECT InvoiceID, ShipToName, PackageCount, InvoiceDate, DATEDIFF( NOW(),InvoiceDate) DaysInvoiced, DELIVERY_RECORD.DeliveryUser FROM INVOICE_HEAD JOIN DELIVERY_RECORD USING(InvoiceID) WHERE Status = 1 AND Delivered = 0 AND (Subtotal+Tax1Total+Tax2Total) > 0 AND DELIVERY_RECORD.DeliveryUser LIKE '$salesperson' UNION
SELECT CONCAT(\"A\", AssignmentID) InvoiceID, ShipToName, 0, AssignmentDate InvoiceDate, DATEDIFF( NOW(),AssignmentDate) DaysInvoiced, DeliveryUser FROM ASSIGNMENT_HEAD WHERE DeliveryUser LIKE '$salesperson' AND Completed = 0
UNION
SELECT CONCAT(\"P\", PickupID) InvoiceID,CUSTOMER.Name AS ShipToName, Packages, PICKUP_HEAD.PickupDate as InvoiceDate, DATEDIFF( NOW(),PICKUP_HEAD.PickupDate) DaysInvoiced, DR.DeliveryUser FROM PICKUP_HEAD JOIN CUSTOMER USING(AccountNumber) JOIN DELIVERY_RECORD DR on CONCAT(\"P\",PICKUP_HEAD.PickupID) = DR.InvoiceID WHERE (DR.DeliveryUser LIKE '$salesperson') AND DropoffDate IS NULL
 ORDER BY InvoiceID";
                  //  echo $query;
                    $result = mysqli_query($con, $query);

                    while ($row = mysqli_fetch_array($result)) {
                        $salesmanName = new Salesman($row['DeliveryUser']);
                        ?>
                        <tr>
                            <td><b><?= $row['InvoiceID'] ?></b><br><?= $row['ShipToName'] ?>
                                <?php
                                if ($salesperson == "%") {
                                    echo "<br><b>Driver:</b> " . $salesmanName->FullName;
                                }
                                ?>
                            </td>
                            <td><b>Boxes: </b><?= $row['PackageCount'] ?><br><b>Days: </b><?= $row['DaysInvoiced'] ?>
                            </td>
                            <td><input class="form-control" type="checkbox"
                                       name="DeliverInvoice-<?= $row['InvoiceID'] ?>" value="<?= $row['InvoiceID'] ?>"/>
                            </td>
                        </tr>
                        <?php
                    }
                    ?>
                    </tbody>
                </table>

            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                <button type="button" id="deliveryModalSubmit" class="btn btn-primary">Submit</button>
            </div>
        </div>
    </div>
    <script type="text/javascript">
        $('#deliveryModalSubmit').on("click", function () {
            if (confirm('Are you sure you want to set all these invoices as delivered')) {
                var invoices = $('[name^=DeliverInvoice-]');
                var arrInvoice = [];
                for (var i = 0; i < invoices.length; i++) {
                    if ($(invoices[i]).prop('checked')) {
                        var invoice = $(invoices[i]).attr('value');
                        arrInvoice.push(invoice);
                    }
                }
                $.post("mod.php?p=invoice&a=functions&f=setInvoicesAsDelivered",
                    {
                        "invoiceList": arrInvoice
                    }
                    , function (data) {

                        if (data == "true") {
                            location.reload();
                        } else {
                            alert(data);
                        }
                    });

            }

        })
    </script>
</div>

<!-- END DELIVERY MODAL -->

<!-- START View Document MODAL -->
<div class="modal" id="ViewDocumentModal">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span>
                </button>
                <h4 class="modal-title" id="EditOrderTitle">View Scanned Documents</h4>
            </div>
            <div class="modal-body" id="ViewDocumentBody">


            </div>
            <div class="modal-footer">
                <button type="button" id="sendScannedInvoice" class="btn btn-default">Send Scanned Invoice to Customer</button>
                <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>

            </div>
        </div><!-- /.modal-content -->
    </div><!-- /.modal-dialog -->
</div><!-- /.modal -->
<!-- Modal -->
<script type="text/javascript">
    function viewInvoiceDocument(invoiceID) {
        $('#sendScannedInvoice').hide();
        $("#ViewDocumentBody").html('');
        $('#sendScannedInvoice').unbind('click');
        $('#sendScannedInvoice').on('click', function (){
            $.post('mod.php', {
                p: "invoice",
                a: "functions",
                f: "sendInvoiceToCustomer",
                invoice: invoiceID
            }, function(data){
                data = JSON.parse(data);
                if(data.Result){
                    alert(data.Message);
                }else{
                    console.log(data);
                    alert(data.Message);
                }

            })
        });
        $.get("mod.php?p=invoice&a=functions&f=getDocuments", {invoiceID: invoiceID}, function (data) {
            console.log(data);
            var dataLength = data.length;
            for (var i = 0; i < dataLength; i++) {
                if(data[i].DocumentType == "Invoice"){
                    $('#sendScannedInvoice').show();
                }
                var elem = $("<img/>").attr('src', "<?= $root ?>" + data[i].DocumentPath).css("width", "100%");
                console.log(elem);
                $("#ViewDocumentBody").append(elem);
            }
            $('#ViewDocumentModal').modal('show');
        });

    }
</script>
<!-- END View Document MODAL -->